/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.restrictions;

import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.RestrictionEntry;
import android.os.Bundle;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Map;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.restrictions.Restrictable;
import org.mozilla.gecko.restrictions.RestrictedProfileConfiguration;
import org.mozilla.gecko.restrictions.RestrictionCache;

@TargetApi(value=18)
public class RestrictionProvider
extends BroadcastReceiver {
    public void onReceive(final Context context, final Intent intent) {
        if (AppConstants.Versions.preJBMR2) {
            return;
        }
        final BroadcastReceiver.PendingResult pendingResult = this.goAsync();
        new Thread(){

            @Override
            public void run() {
                Bundle bundle = intent.getBundleExtra("android.intent.extra.restrictions_bundle");
                RestrictionCache.migrateRestrictionsIfNeeded(bundle);
                Bundle bundle2 = new Bundle();
                ArrayList arrayList = RestrictionProvider.this.initRestrictions(context, bundle);
                bundle2.putParcelableArrayList("android.intent.extra.restrictions_list", arrayList);
                pendingResult.setResult(-1, null, bundle2);
                pendingResult.finish();
            }
        }.start();
    }

    private ArrayList<RestrictionEntry> initRestrictions(Context context, Bundle bundle) {
        ArrayList<RestrictionEntry> arrayList = new ArrayList<RestrictionEntry>();
        Map<Restrictable, Boolean> map = RestrictedProfileConfiguration.getConfiguration();
        for (Restrictable restrictable : map.keySet()) {
            if (RestrictedProfileConfiguration.shouldHide(restrictable)) continue;
            RestrictionEntry restrictionEntry = this.createRestrictionEntryWithDefaultValue(context, restrictable, bundle.getBoolean(restrictable.name, map.get((Object)restrictable).booleanValue()));
            arrayList.add(restrictionEntry);
        }
        return arrayList;
    }

    private RestrictionEntry createRestrictionEntryWithDefaultValue(Context context, Restrictable restrictable, boolean bl) {
        RestrictionEntry restrictionEntry = new RestrictionEntry(restrictable.name, bl);
        restrictionEntry.setTitle(restrictable.getTitle(context));
        String string2 = restrictable.getDescription(context);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            restrictionEntry.setDescription(string2);
        }
        return restrictionEntry;
    }
}

