/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.tabqueue;

import android.app.IntentService;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.database.Cursor;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.NotificationManagerCompat;
import android.util.Log;
import org.mozilla.gecko.BrowserLocaleManager;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.R;
import org.mozilla.gecko.db.BrowserContract;

public class TabReceivedService
extends IntentService {
    private static final String LOGTAG = "Gecko" + TabReceivedService.class.getSimpleName();
    private static final String PREF_NOTIFICATION_ID = "tab_received_notification_id";
    private static final int MAX_NOTIFICATION_COUNT = 1000;

    public TabReceivedService() {
        super(LOGTAG);
        this.setIntentRedelivery(true);
    }

    protected void onHandleIntent(Intent intent) {
        Resources resources = this.getResources();
        BrowserLocaleManager.getInstance().correctLocale((Context)this, resources, resources.getConfiguration());
        String string2 = intent.getDataString();
        if (string2 == null) {
            Log.d((String)LOGTAG, (String)"Received null uri \u2013 ignoring");
            return;
        }
        Intent intent2 = new Intent("android.intent.action.VIEW", intent.getData());
        intent2.putExtra("skip_tab_queue", true);
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)this, (int)0, (Intent)intent2, (int)0);
        String string3 = this.getNotificationTitle(intent.getStringExtra("org.mozilla.gecko.extra.CLIENT_ID"));
        NotificationCompat.Builder builder = new NotificationCompat.Builder((Context)this);
        builder.setSmallIcon(R.drawable.flat_icon);
        builder.setContentTitle((CharSequence)string3);
        builder.setWhen(System.currentTimeMillis());
        builder.setAutoCancel(true);
        builder.setContentText((CharSequence)string2);
        builder.setContentIntent(pendingIntent);
        SharedPreferences sharedPreferences = GeckoSharedPrefs.forApp((Context)this);
        int n = this.getNextNotificationId(sharedPreferences.getInt(PREF_NOTIFICATION_ID, 0));
        NotificationManagerCompat notificationManagerCompat = NotificationManagerCompat.from((Context)this);
        notificationManagerCompat.notify(n, builder.build());
        sharedPreferences.edit().putInt(PREF_NOTIFICATION_ID, n).apply();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private String getNotificationTitle(@Nullable String string2) {
        if (string2 == null) {
            Log.w((String)LOGTAG, (String)"Received null guid, using brand name.");
            return "Nightly";
        }
        try (Cursor cursor = this.getContentResolver().query(BrowserContract.Clients.CONTENT_URI, new String[]{"name"}, "guid=?", new String[]{string2}, null);){
            if (cursor != null && cursor.moveToFirst()) {
                String string3 = cursor.getString(cursor.getColumnIndex("name"));
                return string3;
            }
            Log.w((String)LOGTAG, (String)"Device not found, using brand name.");
            String string4 = "Nightly";
            return string4;
        }
    }

    private int getNextNotificationId(int n) {
        if (n > 1000) {
            return 0;
        }
        return n + 1;
    }
}

