/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.telemetry;

import android.content.Context;
import android.os.Build;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import java.util.Locale;
import org.mozilla.gecko.Locales;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.telemetry.TelemetryPing;
import org.mozilla.gecko.util.Experiments;
import org.mozilla.gecko.util.StringUtils;

public class TelemetryPingGenerator {
    private static final String SERVER_INITIAL_PATH = "submit/telemetry";

    private static String getTelemetryServerURL(String string2, String string3, String string4) {
        return string3 + '/' + SERVER_INITIAL_PATH + '/' + string2 + '/' + string4 + '/' + "Fennec" + '/' + "48.0a1" + '/' + "nightly" + '/' + "20160413030239";
    }

    public static TelemetryPing createCorePing(Context context, String string2, String string3, String string4, int n, long l, @Nullable String string5) {
        String string6 = TelemetryPingGenerator.getTelemetryServerURL(string2, string4, "core");
        ExtendedJSONObject extendedJSONObject = TelemetryPingGenerator.createCorePingPayload(context, string3, n, l, string5);
        return new TelemetryPing(string6, extendedJSONObject);
    }

    private static ExtendedJSONObject createCorePingPayload(Context context, String string2, int n, long l, @Nullable String string3) {
        ExtendedJSONObject extendedJSONObject = new ExtendedJSONObject();
        extendedJSONObject.put("v", 3);
        extendedJSONObject.put("os", "Android");
        String string4 = StringUtils.safeSubstring((String)Build.MANUFACTURER, (int)0, (int)12) + '-' + StringUtils.safeSubstring((String)Build.MODEL, (int)0, (int)19);
        extendedJSONObject.put("arch", "x86");
        extendedJSONObject.put("clientId", string2);
        extendedJSONObject.put("defaultSearch", TextUtils.isEmpty((CharSequence)string3) ? null : string3);
        extendedJSONObject.put("device", string4);
        extendedJSONObject.put("locale", Locales.getLanguageTag((Locale)Locale.getDefault()));
        extendedJSONObject.put("osversion", Integer.toString(Build.VERSION.SDK_INT));
        extendedJSONObject.put("seq", n);
        extendedJSONObject.putArray("experiments", Experiments.getActiveExperiments(context));
        Long l2 = l < 0L ? null : Long.valueOf(l);
        extendedJSONObject.put("profileDate", l2.longValue());
        return extendedJSONObject;
    }
}

