/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.text;

import android.annotation.TargetApi;
import android.graphics.Rect;
import android.view.ActionMode;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import java.util.List;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.text.FloatingToolbarTextSelection;
import org.mozilla.gecko.text.TextAction;

@TargetApi(value=23)
public class FloatingActionModeCallback
extends ActionMode.Callback2 {
    private FloatingToolbarTextSelection textSelection;
    private List<TextAction> actions;

    public FloatingActionModeCallback(FloatingToolbarTextSelection floatingToolbarTextSelection, List<TextAction> list) {
        this.textSelection = floatingToolbarTextSelection;
        this.actions = list;
    }

    public void updateActions(List<TextAction> list) {
        this.actions = list;
    }

    public boolean onCreateActionMode(ActionMode actionMode, Menu menu2) {
        return true;
    }

    public boolean onPrepareActionMode(ActionMode actionMode, Menu menu2) {
        menu2.clear();
        for (int i = 0; i < this.actions.size(); ++i) {
            TextAction textAction = this.actions.get(i);
            menu2.add(0, i, textAction.getFloatingOrder(), (CharSequence)textAction.getLabel());
        }
        return true;
    }

    public boolean onActionItemClicked(ActionMode actionMode, MenuItem menuItem) {
        TextAction textAction = this.actions.get(menuItem.getItemId());
        GeckoAppShell.notifyObservers("TextSelection:Action", textAction.getId());
        return true;
    }

    public void onDestroyActionMode(ActionMode actionMode) {
    }

    public void onGetContentRect(ActionMode actionMode, View view, Rect rect) {
        Rect rect2 = this.textSelection.contentRect;
        if (rect2 != null) {
            rect.set(rect2);
        }
    }
}

