/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.toolbar;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.R;
import org.mozilla.gecko.gfx.BitmapUtils;
import org.mozilla.gecko.util.EventCallback;
import org.mozilla.gecko.util.NativeEventListener;
import org.mozilla.gecko.util.NativeJSObject;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.widget.GeckoPopupMenu;

public class PageActionLayout
extends LinearLayout
implements NativeEventListener,
View.OnClickListener,
View.OnLongClickListener {
    private static final String MENU_BUTTON_KEY = "MENU_BUTTON_KEY";
    private static final int DEFAULT_PAGE_ACTIONS_SHOWN = 2;
    private final Context mContext;
    private final LinearLayout mLayout;
    private final List<PageAction> mPageActionList;
    private GeckoPopupMenu mPageActionsMenu;
    private int mMaxVisiblePageActions;

    public PageActionLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mContext = context;
        this.mLayout = this;
        this.mPageActionList = new ArrayList<PageAction>();
        this.setNumberShown(2);
        this.refreshPageActionIcons();
        EventDispatcher.getInstance().registerGeckoThreadListener(this, "PageActions:Add", "PageActions:Remove");
    }

    private void setNumberShown(int n) {
        ThreadUtils.assertOnUiThread();
        this.mMaxVisiblePageActions = n;
        for (int i = 0; i < n; ++i) {
            if (this.getChildCount() - 1 >= i) continue;
            this.mLayout.addView((View)this.createImageButton());
        }
    }

    public void onDestroy() {
        EventDispatcher.getInstance().unregisterGeckoThreadListener(this, "PageActions:Add", "PageActions:Remove");
    }

    public void handleMessage(final String string2, NativeJSObject nativeJSObject, EventCallback eventCallback) {
        final Bundle bundle = nativeJSObject.toBundle();
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                PageActionLayout.this.handleUiMessage(string2, bundle);
            }
        });
    }

    private void handleUiMessage(String string2, Bundle bundle) {
        ThreadUtils.assertOnUiThread();
        if (string2.equals("PageActions:Add")) {
            String string3 = bundle.getString("id");
            String string4 = bundle.getString("title");
            String string5 = bundle.getString("icon");
            boolean bl = bundle.getBoolean("important");
            this.addPageAction(string3, string4, string5, new OnPageActionClickListeners(){

                @Override
                public void onClick(String string2) {
                    GeckoAppShell.notifyObservers("PageActions:Clicked", string2);
                }

                @Override
                public boolean onLongClick(String string2) {
                    GeckoAppShell.notifyObservers("PageActions:LongClicked", string2);
                    return true;
                }
            }, bl);
        } else if (string2.equals("PageActions:Remove")) {
            String string6 = bundle.getString("id");
            this.removePageAction(string6);
        }
    }

    private void addPageAction(String string2, String string3, String string4, OnPageActionClickListeners onPageActionClickListeners, boolean bl) {
        int n;
        ThreadUtils.assertOnUiThread();
        final PageAction pageAction = new PageAction(string2, string3, null, onPageActionClickListeners, bl);
        for (n = this.mPageActionList.size(); n > 0 && this.mPageActionList.get(n - 1).isImportant(); --n) {
        }
        this.mPageActionList.add(n, pageAction);
        BitmapUtils.getDrawable(this.mContext, string4, new BitmapUtils.BitmapLoader(){

            @Override
            public void onBitmapFound(Drawable drawable2) {
                if (PageActionLayout.this.mPageActionList.contains(pageAction)) {
                    pageAction.setDrawable(drawable2);
                    PageActionLayout.this.refreshPageActionIcons();
                }
            }
        });
    }

    private void removePageAction(String string2) {
        ThreadUtils.assertOnUiThread();
        Iterator<PageAction> iterator = this.mPageActionList.iterator();
        while (iterator.hasNext()) {
            PageAction pageAction = iterator.next();
            if (!pageAction.getID().equals(string2)) continue;
            iterator.remove();
            this.refreshPageActionIcons();
            return;
        }
    }

    private ImageButton createImageButton() {
        ThreadUtils.assertOnUiThread();
        int n = this.mContext.getResources().getDimensionPixelSize(R.dimen.page_action_button_width);
        ImageButton imageButton = new ImageButton(this.mContext, null, R.style.UrlBar_ImageButton);
        imageButton.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(n, -1));
        imageButton.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        imageButton.setOnClickListener((View.OnClickListener)this);
        imageButton.setOnLongClickListener((View.OnLongClickListener)this);
        return imageButton;
    }

    public void onClick(View view) {
        String string2 = (String)view.getTag();
        if (string2 != null) {
            if (string2.equals(MENU_BUTTON_KEY)) {
                this.showMenu(view, this.mPageActionList.size() - this.mMaxVisiblePageActions + 1);
            } else {
                this.getPageActionWithId(string2).onClick();
            }
        }
    }

    public boolean onLongClick(View view) {
        String string2 = (String)view.getTag();
        if (string2.equals(MENU_BUTTON_KEY)) {
            this.showMenu(view, this.mPageActionList.size() - this.mMaxVisiblePageActions + 1);
            return true;
        }
        return this.getPageActionWithId(string2).onLongClick();
    }

    private void setActionForView(ImageButton imageButton, PageAction pageAction) {
        ThreadUtils.assertOnUiThread();
        if (pageAction == null) {
            imageButton.setTag(null);
            imageButton.setImageDrawable(null);
            imageButton.setVisibility(8);
            imageButton.setContentDescription(null);
            return;
        }
        imageButton.setTag((Object)pageAction.getID());
        imageButton.setImageDrawable(pageAction.getDrawable());
        imageButton.setVisibility(0);
        imageButton.setContentDescription((CharSequence)pageAction.getTitle());
    }

    private void refreshPageActionIcons() {
        ThreadUtils.assertOnUiThread();
        Resources resources = this.mContext.getResources();
        for (int i = 0; i < this.getChildCount(); ++i) {
            ImageButton imageButton = (ImageButton)this.getChildAt(i);
            PageAction pageAction = this.getPageActionForViewAt(i);
            if (i == this.getChildCount() - 1 && this.mPageActionList.size() > this.mMaxVisiblePageActions) {
                imageButton.setTag((Object)MENU_BUTTON_KEY);
                imageButton.setImageDrawable(resources.getDrawable(R.drawable.icon_pageaction));
                imageButton.setVisibility(pageAction != null ? 0 : 8);
                imageButton.setContentDescription((CharSequence)resources.getString(R.string.page_action_dropmarker_description));
                continue;
            }
            this.setActionForView(imageButton, pageAction);
        }
    }

    private PageAction getPageActionForViewAt(int n) {
        ThreadUtils.assertOnUiThread();
        int n2 = this.getChildCount() - 1 - n;
        if (this.mPageActionList.size() > n2) {
            int n3 = Math.min(this.mPageActionList.size(), this.getChildCount());
            return this.mPageActionList.get(this.mPageActionList.size() - n3 + n2);
        }
        return null;
    }

    private PageAction getPageActionWithId(String string2) {
        ThreadUtils.assertOnUiThread();
        for (PageAction pageAction : this.mPageActionList) {
            if (!pageAction.getID().equals(string2)) continue;
            return pageAction;
        }
        return null;
    }

    private void showMenu(View view, int n) {
        ThreadUtils.assertOnUiThread();
        if (this.mPageActionsMenu == null) {
            this.mPageActionsMenu = new GeckoPopupMenu(view.getContext(), view);
            this.mPageActionsMenu.inflate(0);
            this.mPageActionsMenu.setOnMenuItemClickListener(new GeckoPopupMenu.OnMenuItemClickListener(){

                @Override
                public boolean onMenuItemClick(MenuItem menuItem) {
                    int n = menuItem.getItemId();
                    for (int i = 0; i < PageActionLayout.this.mPageActionList.size(); ++i) {
                        PageAction pageAction = (PageAction)PageActionLayout.this.mPageActionList.get(i);
                        if (pageAction.key() != n) continue;
                        pageAction.onClick();
                        return true;
                    }
                    return false;
                }
            });
        }
        Menu menu2 = this.mPageActionsMenu.getMenu();
        menu2.clear();
        for (int i = 0; i < this.mPageActionList.size() && i < n; ++i) {
            PageAction pageAction = this.mPageActionList.get(i);
            MenuItem menuItem = menu2.add(0, pageAction.key(), 0, (CharSequence)pageAction.getTitle());
            menuItem.setIcon(pageAction.getDrawable());
        }
        this.mPageActionsMenu.show();
    }

    private static class PageAction {
        private final OnPageActionClickListeners mOnPageActionClickListeners;
        private Drawable mDrawable;
        private final String mTitle;
        private final String mId;
        private final int key;
        private final boolean mImportant;

        public PageAction(String string2, String string3, Drawable drawable2, OnPageActionClickListeners onPageActionClickListeners, boolean bl) {
            this.mId = string2;
            this.mTitle = string3;
            this.mDrawable = drawable2;
            this.mOnPageActionClickListeners = onPageActionClickListeners;
            this.mImportant = bl;
            this.key = UUID.fromString(this.mId.subSequence(1, this.mId.length() - 2).toString()).hashCode();
        }

        public Drawable getDrawable() {
            return this.mDrawable;
        }

        public void setDrawable(Drawable drawable2) {
            this.mDrawable = drawable2;
        }

        public String getTitle() {
            return this.mTitle;
        }

        public String getID() {
            return this.mId;
        }

        public int key() {
            return this.key;
        }

        public boolean isImportant() {
            return this.mImportant;
        }

        public void onClick() {
            if (this.mOnPageActionClickListeners != null) {
                this.mOnPageActionClickListeners.onClick(this.mId);
            }
        }

        public boolean onLongClick() {
            if (this.mOnPageActionClickListeners != null) {
                return this.mOnPageActionClickListeners.onLongClick(this.mId);
            }
            return false;
        }
    }

    private static interface OnPageActionClickListeners {
        public void onClick(String var1);

        public boolean onLongClick(String var1);
    }
}

