/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.PopupWindow;
import org.mozilla.gecko.R;
import org.mozilla.gecko.util.HardwareUtils;
import org.mozilla.gecko.widget.RoundedCornerLayout;

public abstract class AnchoredPopup
extends PopupWindow {
    private View mAnchor;
    private OnVisibilityChangeListener onVisibilityChangeListener;
    protected RoundedCornerLayout mContent;
    protected boolean mInflated;
    protected final Context mContext;

    public AnchoredPopup(Context context) {
        super(context);
        this.mContext = context;
        this.setAnimationStyle(R.style.PopupAnimation);
    }

    protected void init() {
        this.setBackgroundDrawable((Drawable)new BitmapDrawable(this.mContext.getResources()));
        this.setOutsideTouchable(true);
        int n = (int)this.mContext.getResources().getDimension(R.dimen.doorhanger_width);
        this.setWindowLayoutMode(0, -2);
        this.setWidth(n);
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.mContext);
        View view = layoutInflater.inflate(R.layout.anchored_popup, null);
        this.setContentView(view);
        this.mContent = (RoundedCornerLayout)view.findViewById(R.id.content);
        this.mInflated = true;
    }

    public void setAnchor(View view) {
        this.mAnchor = view;
    }

    public void setOnVisibilityChangeListener(OnVisibilityChangeListener onVisibilityChangeListener) {
        this.onVisibilityChangeListener = onVisibilityChangeListener;
    }

    public void show() {
        boolean bl;
        if (!this.mInflated) {
            throw new IllegalStateException("ArrowPopup#init() must be called before ArrowPopup#show()");
        }
        if (this.onVisibilityChangeListener != null) {
            this.onVisibilityChangeListener.onDoorHangerShow();
        }
        int[] nArray = new int[2];
        if (this.mAnchor != null) {
            this.mAnchor.getLocationInWindow(nArray);
        }
        int n = this.mContext.getResources().getDimensionPixelOffset(R.dimen.doorhanger_offsetY);
        View view = ((Activity)this.mContext).getWindow().getDecorView();
        boolean bl2 = bl = this.mAnchor != null && nArray[1] > 0;
        if (HardwareUtils.isTablet()) {
            if (bl) {
                this.showAsDropDown(this.mAnchor, 0, 0);
            } else {
                int n2 = this.mContext.getResources().getDimensionPixelOffset(R.dimen.doorhanger_offsetX);
                this.showAtLocation(view, 51, n2, n);
            }
        } else {
            View view2 = bl ? this.mAnchor : view;
            this.showAtLocation(view2, 49, 0, n);
        }
    }

    public void dismiss() {
        super.dismiss();
        if (this.onVisibilityChangeListener != null) {
            this.onVisibilityChangeListener.onDoorHangerHide();
        }
    }

    public static interface OnVisibilityChangeListener {
        public void onDoorHangerShow();

        public void onDoorHangerHide();
    }
}

