/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Request;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;

abstract class Action<T> {
    final Picasso picasso;
    final Request data;
    final WeakReference<T> target;
    final boolean skipCache;
    final boolean noFade;
    final int errorResId;
    final Drawable errorDrawable;
    final String key;
    boolean cancelled;

    Action(Picasso picasso, T t, Request request, boolean bl, boolean bl2, int n, Drawable drawable, String string) {
        this.picasso = picasso;
        this.data = request;
        this.target = new RequestWeakReference<Object>(this, t, picasso.referenceQueue);
        this.skipCache = bl;
        this.noFade = bl2;
        this.errorResId = n;
        this.errorDrawable = drawable;
        this.key = string;
    }

    abstract void complete(Bitmap var1, Picasso.LoadedFrom var2);

    abstract void error();

    void cancel() {
        this.cancelled = true;
    }

    Request getData() {
        return this.data;
    }

    T getTarget() {
        return this.target.get();
    }

    String getKey() {
        return this.key;
    }

    boolean isCancelled() {
        return this.cancelled;
    }

    Picasso getPicasso() {
        return this.picasso;
    }

    static class RequestWeakReference<T>
    extends WeakReference<T> {
        final Action action;

        public RequestWeakReference(Action action, T t, ReferenceQueue<? super T> referenceQueue) {
            super(t, referenceQueue);
            this.action = action;
        }
    }
}

