/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.authenticator;

import android.accounts.AbstractAccountAuthenticator;
import android.accounts.Account;
import android.accounts.AccountAuthenticatorResponse;
import android.accounts.AccountManager;
import android.accounts.NetworkErrorException;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.fxa.FxAccountClient;
import org.mozilla.gecko.background.fxa.FxAccountClient20;
import org.mozilla.gecko.background.fxa.FxAccountUtils;
import org.mozilla.gecko.background.fxa.oauth.FxAccountAbstractClient;
import org.mozilla.gecko.background.fxa.oauth.FxAccountAbstractClientException;
import org.mozilla.gecko.background.fxa.oauth.FxAccountOAuthClient10;
import org.mozilla.gecko.browserid.BrowserIDKeyPair;
import org.mozilla.gecko.browserid.JSONWebTokenUtils;
import org.mozilla.gecko.fxa.authenticator.AccountPickler;
import org.mozilla.gecko.fxa.authenticator.AndroidFxAccount;
import org.mozilla.gecko.fxa.login.FxAccountLoginStateMachine;
import org.mozilla.gecko.fxa.login.FxAccountLoginTransition;
import org.mozilla.gecko.fxa.login.Married;
import org.mozilla.gecko.fxa.login.State;
import org.mozilla.gecko.fxa.login.StateFactory;
import org.mozilla.gecko.fxa.sync.FxAccountNotificationManager;
import org.mozilla.gecko.fxa.sync.FxAccountSyncAdapter;
import org.mozilla.gecko.util.ThreadUtils;

public class FxAccountAuthenticator
extends AbstractAccountAuthenticator {
    public static final String LOG_TAG = FxAccountAuthenticator.class.getSimpleName();
    public static final int UNKNOWN_ERROR_CODE = 999;
    protected final Context context;
    protected final AccountManager accountManager;

    public FxAccountAuthenticator(Context context) {
        super(context);
        this.context = context;
        this.accountManager = AccountManager.get((Context)context);
    }

    public Bundle addAccount(AccountAuthenticatorResponse accountAuthenticatorResponse, String string2, String string3, String[] stringArray, Bundle bundle) throws NetworkErrorException {
        Logger.debug(LOG_TAG, "addAccount");
        AndroidFxAccount.invalidateCaches();
        Bundle bundle2 = new Bundle();
        if (!"org.mozilla.fennec_fxaccount".equals(string2)) {
            bundle2.putInt("errorCode", -1);
            bundle2.putString("errorMessage", "Not adding unknown account type.");
            return bundle2;
        }
        Intent intent = new Intent("org.mozilla.fennec.ACTION_FXA_GET_STARTED");
        bundle2.putParcelable("intent", (Parcelable)intent);
        return bundle2;
    }

    public Bundle confirmCredentials(AccountAuthenticatorResponse accountAuthenticatorResponse, Account account, Bundle bundle) throws NetworkErrorException {
        Logger.debug(LOG_TAG, "confirmCredentials");
        return null;
    }

    public Bundle editProperties(AccountAuthenticatorResponse accountAuthenticatorResponse, String string2) {
        Logger.debug(LOG_TAG, "editProperties");
        return null;
    }

    protected void getOAuthToken(AccountAuthenticatorResponse accountAuthenticatorResponse, AndroidFxAccount androidFxAccount, final String string2) throws NetworkErrorException {
        String string3;
        Logger.info(LOG_TAG, "Fetching oauth token with scope: " + string2);
        final Responder responder = new Responder(accountAuthenticatorResponse, androidFxAccount);
        final String string4 = androidFxAccount.getOAuthServerURI();
        try {
            string3 = FxAccountUtils.getAudienceForURL(string4);
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Got exception fetching oauth token.", exception);
            responder.fail(exception);
            return;
        }
        FxAccountLoginStateMachine fxAccountLoginStateMachine = new FxAccountLoginStateMachine();
        fxAccountLoginStateMachine.advance(androidFxAccount.getState(), State.StateLabel.Married, new FxADefaultLoginStateMachineDelegate(this.context, androidFxAccount){

            @Override
            public void handleNotMarried(State state) {
                String string22 = "Cannot fetch oauth token from state: " + (Object)((Object)state.getStateLabel());
                Logger.warn(LOG_TAG, string22);
                responder.fail(new RuntimeException(string22));
            }

            @Override
            public void handleMarried(final Married married) {
                String string22;
                try {
                    string22 = married.generateAssertion(string3, "127.0.0.1");
                    if (FxAccountUtils.LOG_PERSONAL_INFORMATION) {
                        JSONWebTokenUtils.dumpAssertion(string22);
                    }
                }
                catch (Exception exception) {
                    Logger.warn(LOG_TAG, "Got exception fetching oauth token.", exception);
                    responder.fail(exception);
                    return;
                }
                FxAccountOAuthClient10 fxAccountOAuthClient10 = new FxAccountOAuthClient10(string4, this.executor);
                Logger.debug(LOG_TAG, "OAuth fetch for scope: " + string2);
                fxAccountOAuthClient10.authorization("3332a18d142636cb", string22, null, string2, new FxAccountAbstractClient.RequestDelegate<FxAccountOAuthClient10.AuthorizationResponse>(){

                    @Override
                    public void handleSuccess(FxAccountOAuthClient10.AuthorizationResponse authorizationResponse) {
                        Logger.debug(LOG_TAG, "OAuth success.");
                        FxAccountUtils.pii(LOG_TAG, "Fetched oauth token: " + authorizationResponse.access_token);
                        responder.succeed(authorizationResponse.access_token);
                    }

                    @Override
                    public void handleFailure(FxAccountAbstractClientException.FxAccountAbstractClientRemoteException fxAccountAbstractClientRemoteException) {
                        Logger.error(LOG_TAG, "OAuth failure.", fxAccountAbstractClientRemoteException);
                        if (fxAccountAbstractClientRemoteException.isInvalidAuthentication()) {
                            fxAccount.setState(married.makeCohabitingState());
                        }
                        responder.fail(fxAccountAbstractClientRemoteException);
                    }

                    @Override
                    public void handleError(Exception exception) {
                        Logger.error(LOG_TAG, "OAuth error.", exception);
                        responder.fail(exception);
                    }
                });
            }
        });
    }

    public Bundle getAuthToken(AccountAuthenticatorResponse accountAuthenticatorResponse, Account account, String string2, Bundle bundle) throws NetworkErrorException {
        Logger.debug(LOG_TAG, "getAuthToken: " + string2);
        String string3 = AccountManager.get((Context)this.context).peekAuthToken(account, string2);
        if (string3 != null && !string3.isEmpty()) {
            Logger.info(LOG_TAG, "Return cached token.");
            Bundle bundle2 = new Bundle();
            bundle2.putString("authAccount", account.name);
            bundle2.putString("accountType", account.type);
            bundle2.putString("authtoken", string3);
            return bundle2;
        }
        if (string2 != null && string2.startsWith("oauth::")) {
            String string4 = string2.substring("oauth::".length());
            AndroidFxAccount androidFxAccount = new AndroidFxAccount(this.context, account);
            try {
                androidFxAccount.acquireSharedAccountStateLock(LOG_TAG);
            }
            catch (InterruptedException interruptedException) {
                Logger.warn(LOG_TAG, "Could not acquire account state lock; return error bundle.");
                Bundle bundle3 = new Bundle();
                bundle3.putInt("errorCode", 1);
                bundle3.putString("errorMessage", "Could not acquire account state lock.");
                return bundle3;
            }
            this.getOAuthToken(accountAuthenticatorResponse, androidFxAccount, string4);
            return null;
        }
        Logger.warn(LOG_TAG, "Returning error bundle for getAuthToken with unknown token type.");
        Bundle bundle4 = new Bundle();
        bundle4.putInt("errorCode", 2);
        bundle4.putString("errorMessage", "Unknown token type: " + string2);
        return bundle4;
    }

    public String getAuthTokenLabel(String string2) {
        Logger.debug(LOG_TAG, "getAuthTokenLabel");
        return null;
    }

    public Bundle hasFeatures(AccountAuthenticatorResponse accountAuthenticatorResponse, Account account, String[] stringArray) throws NetworkErrorException {
        Logger.debug(LOG_TAG, "hasFeatures");
        return null;
    }

    public Bundle updateCredentials(AccountAuthenticatorResponse accountAuthenticatorResponse, Account account, String string2, Bundle bundle) throws NetworkErrorException {
        Logger.debug(LOG_TAG, "updateCredentials");
        return null;
    }

    public Bundle getAccountRemovalAllowed(AccountAuthenticatorResponse accountAuthenticatorResponse, Account account) throws NetworkErrorException {
        Bundle bundle = super.getAccountRemovalAllowed(accountAuthenticatorResponse, account);
        if (bundle == null || !bundle.containsKey("booleanResult") || bundle.containsKey("intent")) {
            return bundle;
        }
        boolean bl = bundle.getBoolean("booleanResult");
        if (!bl) {
            return bundle;
        }
        AndroidFxAccount androidFxAccount = new AndroidFxAccount(this.context, account);
        ThreadUtils.assertNotOnUiThread();
        Logger.info(LOG_TAG, "Firefox account named " + account.name + " being removed; " + "deleting saved pickle file '" + "fxa.account.json" + "'.");
        this.deletePickle();
        Intent intent = androidFxAccount.makeDeletedAccountIntent();
        Logger.info(LOG_TAG, "Account named " + account.name + " being removed; " + "broadcasting secure intent " + intent.getAction() + ".");
        this.context.sendBroadcast(intent, "org.mozilla.fennec_fxaccount.permission.PER_ACCOUNT_TYPE");
        return bundle;
    }

    private void deletePickle() {
        try {
            AccountPickler.deletePickle(this.context, "fxa.account.json");
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Got exception deleting saved pickle file; ignoring.", exception);
        }
    }

    public static abstract class FxADefaultLoginStateMachineDelegate
    implements FxAccountLoginStateMachine.LoginStateMachineDelegate {
        protected final Context context;
        protected final AndroidFxAccount fxAccount;
        protected final Executor executor;
        protected final FxAccountClient client;

        public FxADefaultLoginStateMachineDelegate(Context context, AndroidFxAccount androidFxAccount) {
            this.context = context;
            this.fxAccount = androidFxAccount;
            this.executor = Executors.newSingleThreadExecutor();
            this.client = new FxAccountClient20(androidFxAccount.getAccountServerURI(), this.executor);
        }

        @Override
        public FxAccountClient getClient() {
            return this.client;
        }

        @Override
        public long getCertificateDurationInMilliseconds() {
            return 43200000L;
        }

        @Override
        public long getAssertionDurationInMilliseconds() {
            return 900000L;
        }

        @Override
        public BrowserIDKeyPair generateKeyPair() throws NoSuchAlgorithmException {
            return StateFactory.generateKeyPair();
        }

        @Override
        public void handleTransition(FxAccountLoginTransition.Transition transition, State state) {
            Logger.info(LOG_TAG, "handleTransition: " + transition + " to " + (Object)((Object)state.getStateLabel()));
        }

        public abstract void handleNotMarried(State var1);

        public abstract void handleMarried(Married var1);

        @Override
        public void handleFinal(State state) {
            Logger.info(LOG_TAG, "handleFinal: in " + (Object)((Object)state.getStateLabel()));
            this.fxAccount.setState(state);
            FxAccountNotificationManager fxAccountNotificationManager = new FxAccountNotificationManager(FxAccountSyncAdapter.NOTIFICATION_ID);
            fxAccountNotificationManager.update(this.context, this.fxAccount);
            if (state.getStateLabel() != State.StateLabel.Married) {
                this.handleNotMarried(state);
                return;
            }
            this.handleMarried((Married)state);
        }
    }

    protected static class Responder {
        final AccountAuthenticatorResponse response;
        final AndroidFxAccount fxAccount;

        public Responder(AccountAuthenticatorResponse accountAuthenticatorResponse, AndroidFxAccount androidFxAccount) {
            this.response = accountAuthenticatorResponse;
            this.fxAccount = androidFxAccount;
        }

        public void fail(Exception exception) {
            Logger.warn(LOG_TAG, "Responding with error!", exception);
            this.fxAccount.releaseSharedAccountStateLock();
            Bundle bundle = new Bundle();
            bundle.putInt("errorCode", 999);
            bundle.putString("errorMessage", exception.toString());
            this.response.onResult(bundle);
        }

        public void succeed(String string2) {
            Logger.info(LOG_TAG, "Responding with success!");
            this.fxAccount.releaseSharedAccountStateLock();
            Bundle bundle = new Bundle();
            bundle.putString("authAccount", this.fxAccount.account.name);
            bundle.putString("accountType", this.fxAccount.account.type);
            bundle.putString("authtoken", string2);
            this.response.onResult(bundle);
        }
    }
}

