/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.sync;

import android.accounts.Account;
import android.content.AbstractThreadedSyncAdapter;
import android.content.ContentProviderClient;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.SyncResult;
import android.os.Bundle;
import android.os.SystemClock;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.common.telemetry.TelemetryWrapper;
import org.mozilla.gecko.background.fxa.FxAccountUtils;
import org.mozilla.gecko.background.fxa.SkewHandler;
import org.mozilla.gecko.fxa.FirefoxAccounts;
import org.mozilla.gecko.fxa.authenticator.AccountPickler;
import org.mozilla.gecko.fxa.authenticator.AndroidFxAccount;
import org.mozilla.gecko.fxa.authenticator.FxADefaultLoginStateMachineDelegate;
import org.mozilla.gecko.fxa.login.FxAccountLoginStateMachine;
import org.mozilla.gecko.fxa.login.Married;
import org.mozilla.gecko.fxa.login.State;
import org.mozilla.gecko.fxa.sync.FxAccountNotificationManager;
import org.mozilla.gecko.fxa.sync.FxAccountSchedulePolicy;
import org.mozilla.gecko.fxa.sync.FxAccountSyncDelegate;
import org.mozilla.gecko.fxa.sync.SchedulePolicy;
import org.mozilla.gecko.sync.BackoffHandler;
import org.mozilla.gecko.sync.GlobalSession;
import org.mozilla.gecko.sync.PrefsBackoffHandler;
import org.mozilla.gecko.sync.SharedPreferencesClientsDataDelegate;
import org.mozilla.gecko.sync.SyncConfiguration;
import org.mozilla.gecko.sync.ThreadPool;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.crypto.KeyBundle;
import org.mozilla.gecko.sync.delegates.GlobalSessionCallback;
import org.mozilla.gecko.sync.net.HawkAuthHeaderProvider;
import org.mozilla.gecko.sync.stage.GlobalSyncStage;
import org.mozilla.gecko.tokenserver.TokenServerClient;
import org.mozilla.gecko.tokenserver.TokenServerClientDelegate;
import org.mozilla.gecko.tokenserver.TokenServerException;
import org.mozilla.gecko.tokenserver.TokenServerToken;

public class FxAccountSyncAdapter
extends AbstractThreadedSyncAdapter {
    private static final String LOG_TAG = FxAccountSyncAdapter.class.getSimpleName();
    public static final int NOTIFICATION_ID = LOG_TAG.hashCode();
    private static final String PREF_BACKOFF_STORAGE_HOST = "backoffStorageHost";
    private static final int MINIMUM_SYNC_DELAY_MILLIS = 15000;
    private volatile long lastSyncRealtimeMillis;
    protected final ExecutorService executor = Executors.newSingleThreadExecutor();
    protected final FxAccountNotificationManager notificationManager = new FxAccountNotificationManager(NOTIFICATION_ID);

    public FxAccountSyncAdapter(Context context, boolean bl) {
        super(context, bl);
    }

    private boolean shouldPerformSync(BackoffHandler backoffHandler, String string2, Bundle bundle) {
        long l = backoffHandler.delayMilliseconds();
        if (l <= 0L) {
            return true;
        }
        if (bundle == null) {
            return false;
        }
        boolean bl = bundle.getBoolean("ignore_backoff", false);
        if (bl) {
            Logger.info(LOG_TAG, "Forced sync (" + string2 + "): overruling remaining backoff of " + l + "ms.");
        } else {
            Logger.info(LOG_TAG, "Not syncing (" + string2 + "): must wait another " + l + "ms.");
        }
        return bl;
    }

    protected void syncWithAssertion(String string2, String string3, URI uRI, final BackoffHandler backoffHandler, final SharedPreferences sharedPreferences, final KeyBundle keyBundle, String string4, final SessionCallback sessionCallback, final Bundle bundle, final AndroidFxAccount androidFxAccount) {
        TokenServerClientDelegate tokenServerClientDelegate = new TokenServerClientDelegate(){
            private boolean didReceiveBackoff = false;

            @Override
            public String getUserAgent() {
                return "Firefox-Android-FxAccounts/48.0a1 (Firefox)";
            }

            @Override
            public void handleSuccess(TokenServerToken tokenServerToken) {
                boolean bl;
                URI uRI;
                FxAccountUtils.pii(LOG_TAG, "Got token! uid is " + tokenServerToken.uid + " and endpoint is " + tokenServerToken.endpoint + ".");
                androidFxAccount.releaseSharedAccountStateLock();
                if (!this.didReceiveBackoff) {
                    backoffHandler.setEarliestNextRequest(0L);
                }
                try {
                    uRI = new URI(tokenServerToken.endpoint);
                }
                catch (URISyntaxException uRISyntaxException) {
                    this.handleError(uRISyntaxException);
                    return;
                }
                String string2 = uRI.getHost();
                PrefsBackoffHandler prefsBackoffHandler = new PrefsBackoffHandler(sharedPreferences, "sync.storage");
                sessionCallback.setBackoffHandler(prefsBackoffHandler);
                String string3 = sharedPreferences.getString(FxAccountSyncAdapter.PREF_BACKOFF_STORAGE_HOST, null);
                boolean bl2 = bl = string3 != null && string3.equalsIgnoreCase(string2);
                if (bl) {
                    Logger.debug(LOG_TAG, "Storage host is unchanged.");
                    if (!FxAccountSyncAdapter.this.shouldPerformSync(prefsBackoffHandler, "storage", bundle)) {
                        Logger.info(LOG_TAG, "Not syncing: storage server requested backoff.");
                        sessionCallback.handleAborted(null, "Storage backoff");
                        return;
                    }
                } else {
                    Logger.debug(LOG_TAG, "Received new storage host.");
                }
                prefsBackoffHandler.setEarliestNextRequest(0L);
                GlobalSession globalSession = null;
                try {
                    SharedPreferencesClientsDataDelegate sharedPreferencesClientsDataDelegate = new SharedPreferencesClientsDataDelegate(sharedPreferences, FxAccountSyncAdapter.this.getContext());
                    if (FxAccountUtils.LOG_PERSONAL_INFORMATION) {
                        FxAccountUtils.pii(LOG_TAG, "Client device name is: '" + sharedPreferencesClientsDataDelegate.getClientName() + "'.");
                        FxAccountUtils.pii(LOG_TAG, "Client device data last modified: " + sharedPreferencesClientsDataDelegate.getLastModifiedTimestamp());
                    }
                    SkewHandler skewHandler = SkewHandler.getSkewHandlerForHostname(string2);
                    long l = skewHandler.getSkewInSeconds();
                    HawkAuthHeaderProvider hawkAuthHeaderProvider = new HawkAuthHeaderProvider(tokenServerToken.id, tokenServerToken.key.getBytes("UTF-8"), false, l);
                    Context context = FxAccountSyncAdapter.this.getContext();
                    SyncConfiguration syncConfiguration = new SyncConfiguration(tokenServerToken.uid, hawkAuthHeaderProvider, sharedPreferences, keyBundle);
                    Set<String> set = SyncConfiguration.validEngineNames();
                    syncConfiguration.stagesToSync = Utils.getStagesToSyncFromBundle(set, bundle);
                    syncConfiguration.setClusterURL(uRI);
                    globalSession = new GlobalSession(syncConfiguration, sessionCallback, context, sharedPreferencesClientsDataDelegate);
                    globalSession.start();
                }
                catch (Exception exception) {
                    sessionCallback.handleError(globalSession, exception);
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleFailure(TokenServerException tokenServerException) {
                Logger.error(LOG_TAG, "Failed to get token.", tokenServerException);
                try {
                    State state = androidFxAccount.getState();
                    if (state.getStateLabel() == State.StateLabel.Married) {
                        Married married = (Married)state;
                        androidFxAccount.setState(married.makeCohabitingState());
                    }
                }
                finally {
                    androidFxAccount.releaseSharedAccountStateLock();
                }
                sessionCallback.handleError(null, tokenServerException);
            }

            @Override
            public void handleError(Exception exception) {
                Logger.error(LOG_TAG, "Failed to get token.", exception);
                androidFxAccount.releaseSharedAccountStateLock();
                sessionCallback.handleError(null, exception);
            }

            @Override
            public void handleBackoff(int n) {
                Logger.info(LOG_TAG, "Token server requesting backoff of " + n + "s. Backoff handler: " + backoffHandler);
                this.didReceiveBackoff = true;
                backoffHandler.setEarliestNextRequest(this.delay(n * 1000));
            }

            private long delay(long l) {
                return System.currentTimeMillis() + l;
            }
        };
        TokenServerClient tokenServerClient = new TokenServerClient(uRI, this.executor);
        tokenServerClient.getTokenFromBrowserIDAssertion(string3, true, string4, tokenServerClientDelegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPerformSync(Account account, final Bundle bundle, String string2, ContentProviderClient contentProviderClient, SyncResult syncResult) {
        Logger.setThreadLogTag("FxAccounts");
        Logger.resetLogging();
        Context context = this.getContext();
        final AndroidFxAccount androidFxAccount = new AndroidFxAccount(context, account);
        Logger.info(LOG_TAG, "Syncing FxAccount account named like " + Utils.obfuscateEmail(account.name) + " for authority " + string2 + " with instance " + (Object)((Object)this) + ".");
        Logger.info(LOG_TAG, "Account last synced at: " + androidFxAccount.getLastSyncedTimestamp());
        if (FxAccountUtils.LOG_PERSONAL_INFORMATION) {
            androidFxAccount.dump();
        }
        FirefoxAccounts.logSyncOptions(bundle);
        if (this.lastSyncRealtimeMillis > 0L && this.lastSyncRealtimeMillis + 15000L > SystemClock.elapsedRealtime() && !bundle.getBoolean("ignore_backoff", false)) {
            Logger.info(LOG_TAG, "Not syncing FxAccount " + Utils.obfuscateEmail(account.name) + ": minimum interval not met.");
            TelemetryWrapper.addToHistogram("FENNEC_SYNC_NUMBER_OF_SYNCS_FAILED_BACKOFF", 1);
            return;
        }
        ThreadPool.run(new Runnable(){

            @Override
            public void run() {
                try {
                    AccountPickler.pickle(androidFxAccount, "fxa.account.json");
                }
                catch (Exception exception) {
                    Logger.warn(LOG_TAG, "Got exception pickling current account details; ignoring.", exception);
                }
            }
        });
        LinkedBlockingQueue<FxAccountSyncDelegate.Result> linkedBlockingQueue = new LinkedBlockingQueue<FxAccountSyncDelegate.Result>(1);
        Set<String> set = SyncConfiguration.validEngineNames();
        Collection<String> collection = Utils.getStagesToSyncFromBundle(set, bundle);
        final SyncDelegate syncDelegate = new SyncDelegate(linkedBlockingQueue, syncResult, androidFxAccount, collection);
        try {
            State state;
            boolean bl;
            final SharedPreferences sharedPreferences = androidFxAccount.getSyncPrefs();
            PrefsBackoffHandler prefsBackoffHandler = new PrefsBackoffHandler(sharedPreferences, "background");
            PrefsBackoffHandler prefsBackoffHandler2 = new PrefsBackoffHandler(sharedPreferences, "rate");
            boolean bl2 = bl = bundle != null && (bundle.getBoolean("upload", false) || bundle.getBoolean("ignore_backoff", false));
            if (!bl && !this.shouldPerformSync(prefsBackoffHandler, "background", bundle)) {
                syncDelegate.rejectSync();
                return;
            }
            if (!this.shouldPerformSync(prefsBackoffHandler2, "rate", bundle)) {
                syncDelegate.postponeSync(prefsBackoffHandler2.delayMilliseconds());
                return;
            }
            final FxAccountSchedulePolicy fxAccountSchedulePolicy = new FxAccountSchedulePolicy(context, androidFxAccount);
            fxAccountSchedulePolicy.configureBackoffMillisBeforeSyncing(prefsBackoffHandler2, prefsBackoffHandler);
            String string3 = androidFxAccount.getTokenServerURI();
            final URI uRI = new URI(string3);
            final String string4 = FxAccountUtils.getAudienceForURL(string3);
            try {
                androidFxAccount.acquireSharedAccountStateLock(LOG_TAG);
            }
            catch (InterruptedException interruptedException) {
                syncDelegate.handleError(interruptedException);
                androidFxAccount.releaseSharedAccountStateLock();
                return;
            }
            try {
                state = androidFxAccount.getState();
            }
            catch (Exception exception) {
                androidFxAccount.releaseSharedAccountStateLock();
                syncDelegate.handleError(exception);
                androidFxAccount.releaseSharedAccountStateLock();
                return;
            }
            TelemetryWrapper.addToHistogram("FENNEC_SYNC_NUMBER_OF_SYNCS_STARTED", 1);
            FxAccountLoginStateMachine fxAccountLoginStateMachine = new FxAccountLoginStateMachine();
            fxAccountLoginStateMachine.advance(state, State.StateLabel.Married, new FxADefaultLoginStateMachineDelegate(context, androidFxAccount){

                @Override
                public void handleNotMarried(State state) {
                    Logger.info(LOG_TAG, "handleNotMarried: in " + (Object)((Object)state.getStateLabel()));
                    fxAccountSchedulePolicy.onHandleFinal(state.getNeededAction());
                    syncDelegate.handleCannotSync(state);
                }

                private boolean shouldRequestToken(BackoffHandler backoffHandler, Bundle bundle2) {
                    return FxAccountSyncAdapter.this.shouldPerformSync(backoffHandler, "token", bundle2);
                }

                @Override
                public void handleMarried(Married married) {
                    fxAccountSchedulePolicy.onHandleFinal(married.getNeededAction());
                    Logger.info(LOG_TAG, "handleMarried: in " + (Object)((Object)married.getStateLabel()));
                    try {
                        String string2 = married.generateAssertion(string4, "127.0.0.1");
                        PrefsBackoffHandler prefsBackoffHandler = new PrefsBackoffHandler(sharedPreferences, "token");
                        if (!this.shouldRequestToken(prefsBackoffHandler, bundle)) {
                            Logger.info(LOG_TAG, "Not syncing (token server).");
                            syncDelegate.postponeSync(prefsBackoffHandler.delayMilliseconds());
                            return;
                        }
                        SessionCallback sessionCallback = new SessionCallback(syncDelegate, fxAccountSchedulePolicy);
                        KeyBundle keyBundle = married.getSyncKeyBundle();
                        String string3 = married.getClientState();
                        FxAccountSyncAdapter.this.syncWithAssertion(string4, string2, uRI, prefsBackoffHandler, sharedPreferences, keyBundle, string3, sessionCallback, bundle, this.fxAccount);
                        Logger.info(LOG_TAG, "Fetching profile avatar information.");
                        this.fxAccount.fetchProfileJSON();
                    }
                    catch (Exception exception) {
                        syncDelegate.handleError(exception);
                        return;
                    }
                }
            });
            linkedBlockingQueue.take();
        }
        catch (Exception exception) {
            Logger.error(LOG_TAG, "Got error syncing.", exception);
            syncDelegate.handleError(exception);
        }
        finally {
            androidFxAccount.releaseSharedAccountStateLock();
        }
        Logger.info(LOG_TAG, "Syncing done.");
        this.lastSyncRealtimeMillis = SystemClock.elapsedRealtime();
    }

    protected static class SessionCallback
    implements GlobalSessionCallback {
        protected final SyncDelegate syncDelegate;
        protected final SchedulePolicy schedulePolicy;
        protected volatile BackoffHandler storageBackoffHandler;

        public SessionCallback(SyncDelegate syncDelegate, SchedulePolicy schedulePolicy) {
            this.syncDelegate = syncDelegate;
            this.schedulePolicy = schedulePolicy;
        }

        public void setBackoffHandler(BackoffHandler backoffHandler) {
            this.storageBackoffHandler = backoffHandler;
        }

        @Override
        public boolean shouldBackOffStorage() {
            return this.storageBackoffHandler.delayMilliseconds() > 0L;
        }

        @Override
        public void requestBackoff(long l) {
            this.schedulePolicy.configureBackoffMillisOnBackoff(this.storageBackoffHandler, l, true);
        }

        @Override
        public void informUpgradeRequiredResponse(GlobalSession globalSession) {
            this.schedulePolicy.onUpgradeRequired();
        }

        @Override
        public void informUnauthorizedResponse(GlobalSession globalSession, URI uRI) {
            this.schedulePolicy.onUnauthorized();
        }

        @Override
        public void informMigrated(GlobalSession globalSession) {
            Logger.error(LOG_TAG, "Firefox Account informMigrated called, but it's not yet possible to migrate.  Ignoring even though something is terribly wrong.");
        }

        @Override
        public void handleStageCompleted(GlobalSyncStage.Stage stage, GlobalSession globalSession) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleSuccess(GlobalSession globalSession) {
            Logger.info(LOG_TAG, "Global session succeeded.");
            try {
                int n = globalSession.getClientsDelegate().getClientsCount();
                Logger.debug(LOG_TAG, "" + n + " other client(s).");
                this.schedulePolicy.onSuccessfulSync(n);
            }
            finally {
                this.syncDelegate.handleSuccess();
            }
        }

        @Override
        public void handleError(GlobalSession globalSession, Exception exception) {
            Logger.warn(LOG_TAG, "Global session failed.");
            this.syncDelegate.handleError(exception);
        }

        @Override
        public void handleAborted(GlobalSession globalSession, String string2) {
            Logger.warn(LOG_TAG, "Global session aborted: " + string2);
            this.syncDelegate.handleError(null);
        }
    }

    protected static class SyncDelegate
    extends FxAccountSyncDelegate {
        protected final Collection<String> stageNamesToSync;

        @Override
        public void handleSuccess() {
            Logger.info(LOG_TAG, "Sync succeeded.");
            super.handleSuccess();
            TelemetryWrapper.addToHistogram("FENNEC_SYNC_NUMBER_OF_SYNCS_COMPLETED", 1);
        }

        @Override
        public void handleError(Exception exception) {
            Logger.error(LOG_TAG, "Got exception syncing.", exception);
            super.handleError(exception);
            TelemetryWrapper.addToHistogram("FENNEC_SYNC_NUMBER_OF_SYNCS_FAILED", 1);
        }

        @Override
        public void handleCannotSync(State state) {
            Logger.warn(LOG_TAG, "Cannot sync from state: " + (Object)((Object)state.getStateLabel()));
            super.handleCannotSync(state);
        }

        @Override
        public void postponeSync(long l) {
            if (l <= 0L) {
                Logger.debug(LOG_TAG, "Asked to postpone sync, but zero delay.");
            }
            super.postponeSync(l);
        }

        @Override
        public void rejectSync() {
            super.rejectSync();
        }

        public SyncDelegate(BlockingQueue<FxAccountSyncDelegate.Result> blockingQueue, SyncResult syncResult, AndroidFxAccount androidFxAccount, Collection<String> collection) {
            super(blockingQueue, syncResult);
            this.stageNamesToSync = Collections.unmodifiableCollection(collection);
        }

        public Collection<String> getStageNamesToSync() {
            return this.stageNamesToSync;
        }
    }
}

