/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.util.ActivityResultHandler;
import org.mozilla.gecko.util.ActivityResultHandlerMap;

public class ActivityHandlerHelper {
    private static final String LOGTAG = "GeckoActivityHandlerHelper";
    private static final ActivityResultHandlerMap mActivityResultHandlerMap = new ActivityResultHandlerMap();

    private static int makeRequestCode(ActivityResultHandler activityResultHandler) {
        return mActivityResultHandlerMap.put(activityResultHandler);
    }

    public static void startIntent(Intent intent, ActivityResultHandler activityResultHandler) {
        ActivityHandlerHelper.startIntentForActivity(GeckoAppShell.getGeckoInterface().getActivity(), intent, activityResultHandler);
    }

    public static boolean startIntentAndCatch(String string2, Context context, Intent intent) {
        try {
            context.startActivity(intent);
            return true;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            Log.w((String)string2, (String)"Activity not found.", (Throwable)activityNotFoundException);
            return false;
        }
        catch (SecurityException securityException) {
            Log.w((String)string2, (String)"Forbidden to launch activity.", (Throwable)securityException);
            return false;
        }
    }

    public static void startIntentForActivity(Activity activity, Intent intent, ActivityResultHandler activityResultHandler) {
        activity.startActivityForResult(intent, mActivityResultHandlerMap.put(activityResultHandler));
    }

    public static boolean handleActivityResult(int n, int n2, Intent intent) {
        ActivityResultHandler activityResultHandler = mActivityResultHandlerMap.getAndRemove(n);
        if (activityResultHandler != null) {
            activityResultHandler.onActivityResult(n2, intent);
            return true;
        }
        return false;
    }
}

