/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.PopupWindow;
import java.util.HashSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.widget.AnchoredPopup;
import org.mozilla.gecko.widget.DoorHanger;
import org.mozilla.gecko.widget.DoorhangerConfig;

public class DoorHangerPopup
extends AnchoredPopup
implements GeckoEventListener,
Tabs.OnTabsChangedListener,
PopupWindow.OnDismissListener,
DoorHanger.OnButtonClickListener {
    private static final String LOGTAG = "GeckoDoorHangerPopup";
    private final HashSet<DoorHanger> mDoorHangers = new HashSet();
    private boolean mDisabled;

    public DoorHangerPopup(Context context) {
        super(context);
        EventDispatcher.getInstance().registerGeckoThreadListener(this, "Doorhanger:Add", "Doorhanger:Remove");
        Tabs.registerOnTabsChangedListener(this);
        this.setOnDismissListener(this);
    }

    void destroy() {
        EventDispatcher.getInstance().unregisterGeckoThreadListener(this, "Doorhanger:Add", "Doorhanger:Remove");
        Tabs.unregisterOnTabsChangedListener(this);
    }

    void disable() {
        this.mDisabled = true;
        this.updatePopup();
    }

    void enable() {
        this.mDisabled = false;
        this.updatePopup();
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        try {
            if (string2.equals("Doorhanger:Add")) {
                final DoorhangerConfig doorhangerConfig = this.makeConfigFromJSON(jSONObject);
                ThreadUtils.postToUiThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        DoorHangerPopup.this.addDoorHanger(doorhangerConfig);
                    }
                });
            } else if (string2.equals("Doorhanger:Remove")) {
                final int n = jSONObject.getInt("tabID");
                final String string3 = jSONObject.getString("value");
                ThreadUtils.postToUiThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        DoorHanger doorHanger = DoorHangerPopup.this.getDoorHanger(n, string3);
                        if (doorHanger == null) {
                            return;
                        }
                        DoorHangerPopup.this.removeDoorHanger(doorHanger);
                        DoorHangerPopup.this.updatePopup();
                    }
                });
            }
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)("Exception handling message \"" + string2 + "\":"), (Throwable)exception);
        }
    }

    private DoorhangerConfig makeConfigFromJSON(JSONObject jSONObject) throws JSONException {
        int n = jSONObject.getInt("tabID");
        String string2 = jSONObject.getString("value");
        String string3 = jSONObject.optString("category");
        DoorHanger.Type type = DoorHanger.Type.DEFAULT;
        if (DoorHanger.Type.LOGIN.toString().equals(string3)) {
            type = DoorHanger.Type.LOGIN;
        } else if (DoorHanger.Type.GEOLOCATION.toString().equals(string3)) {
            type = DoorHanger.Type.GEOLOCATION;
        } else if (DoorHanger.Type.DESKTOPNOTIFICATION2.toString().equals(string3)) {
            type = DoorHanger.Type.DESKTOPNOTIFICATION2;
        } else if (DoorHanger.Type.WEBRTC.toString().equals(string3)) {
            type = DoorHanger.Type.WEBRTC;
        }
        DoorhangerConfig doorhangerConfig = new DoorhangerConfig(n, string2, type, this);
        doorhangerConfig.setMessage(jSONObject.getString("message"));
        doorhangerConfig.setOptions(jSONObject.getJSONObject("options"));
        JSONArray jSONArray = jSONObject.getJSONArray("buttons");
        int n2 = jSONArray.length();
        if (n2 > 2) {
            Log.e((String)LOGTAG, (String)"Doorhanger can have a maximum of two buttons!");
            n2 = 2;
        }
        for (int i = 0; i < n2; ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            boolean bl = jSONObject2.optBoolean("positive", false);
            doorhangerConfig.setButton(jSONObject2.getString("label"), jSONObject2.getInt("callback"), bl);
        }
        return doorhangerConfig;
    }

    @Override
    public void onTabChanged(Tab tab, Tabs.TabEvents tabEvents, Object object) {
        switch (tabEvents) {
            case CLOSED: {
                this.removeTabDoorHangers(tab.getId(), true);
                break;
            }
            case LOCATION_CHANGE: {
                if (!this.isShowing() || !object.equals(tab.getURL())) {
                    this.removeTabDoorHangers(tab.getId(), false);
                }
                if (!Tabs.getInstance().isSelectedTab(tab)) break;
                this.updatePopup();
                break;
            }
            case SELECTED: {
                this.updatePopup();
            }
        }
    }

    void addDoorHanger(DoorhangerConfig doorhangerConfig) {
        int n = doorhangerConfig.getTabId();
        if (Tabs.getInstance().getTab(n) == null) {
            return;
        }
        DoorHanger doorHanger = this.getDoorHanger(n, doorhangerConfig.getId());
        if (doorHanger != null) {
            this.removeDoorHanger(doorHanger);
        }
        if (!this.mInflated) {
            this.init();
        }
        DoorHanger doorHanger2 = DoorHanger.Get(this.mContext, doorhangerConfig);
        this.mDoorHangers.add(doorHanger2);
        this.mContent.addView((View)doorHanger2);
        if (n == Tabs.getInstance().getSelectedTab().getId()) {
            this.updatePopup();
        }
    }

    @Override
    public void onButtonClick(JSONObject jSONObject, DoorHanger doorHanger) {
        GeckoAppShell.notifyObservers("Doorhanger:Reply", jSONObject.toString());
        this.removeDoorHanger(doorHanger);
        this.updatePopup();
    }

    DoorHanger getDoorHanger(int n, String string2) {
        for (DoorHanger doorHanger : this.mDoorHangers) {
            if (doorHanger.getTabId() != n || !doorHanger.getIdentifier().equals(string2)) continue;
            return doorHanger;
        }
        return null;
    }

    void removeDoorHanger(DoorHanger doorHanger) {
        this.mDoorHangers.remove((Object)doorHanger);
        this.mContent.removeView((View)doorHanger);
    }

    void removeTabDoorHangers(int n, boolean bl) {
        HashSet<DoorHanger> hashSet = new HashSet<DoorHanger>();
        for (DoorHanger doorHanger : this.mDoorHangers) {
            if (doorHanger.getTabId() != n || !bl && (bl || !doorHanger.shouldRemove(this.isShowing()))) continue;
            hashSet.add(doorHanger);
        }
        for (DoorHanger doorHanger : hashSet) {
            this.removeDoorHanger(doorHanger);
        }
    }

    void updatePopup() {
        Tab tab = Tabs.getInstance().getSelectedTab();
        if (tab == null || this.mDoorHangers.size() == 0 || !this.mInflated || this.mDisabled) {
            this.dismiss();
            return;
        }
        int n = tab.getId();
        boolean bl = false;
        DoorHanger doorHanger = null;
        for (DoorHanger doorHanger2 : this.mDoorHangers) {
            if (doorHanger2.getTabId() == n) {
                doorHanger2.setVisibility(0);
                bl = true;
                if (doorHanger == null) {
                    doorHanger = doorHanger2;
                    continue;
                }
                doorHanger2.hideTitle();
                continue;
            }
            doorHanger2.setVisibility(8);
        }
        if (!bl) {
            this.dismiss();
            return;
        }
        this.showDividers();
        if (this.isShowing()) {
            this.show();
            return;
        }
        String string2 = tab.getBaseDomain();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            doorHanger.hideTitle();
        } else {
            doorHanger.showTitle(tab.getFavicon(), string2);
        }
        if (AppConstants.Versions.feature14Plus) {
            this.setFocusable(true);
        }
        this.show();
    }

    private void showDividers() {
        int n = this.mContent.getChildCount();
        DoorHanger doorHanger = null;
        for (int i = 0; i < n; ++i) {
            DoorHanger doorHanger2 = (DoorHanger)this.mContent.getChildAt(i);
            doorHanger2.showDivider();
            if (doorHanger2.getVisibility() != 0) continue;
            doorHanger = doorHanger2;
        }
        if (doorHanger != null) {
            doorHanger.hideDivider();
        }
    }

    public void onDismiss() {
        int n = Tabs.getInstance().getSelectedTab().getId();
        this.removeTabDoorHangers(n, true);
    }

    @Override
    public void dismiss() {
        this.setFocusable(false);
        super.dismiss();
    }
}

