/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.annotation.RobocopTarget;
import org.mozilla.gecko.util.BundleEventListener;
import org.mozilla.gecko.util.EventCallback;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.NativeEventListener;
import org.mozilla.gecko.util.NativeJSContainer;
import org.mozilla.gecko.util.NativeJSObject;
import org.mozilla.gecko.util.ThreadUtils;

@RobocopTarget
public final class EventDispatcher {
    private static final String LOGTAG = "GeckoEventDispatcher";
    private static final String GUID = "__guid__";
    private static final String STATUS_ERROR = "error";
    private static final String STATUS_SUCCESS = "success";
    private static final EventDispatcher INSTANCE = new EventDispatcher();
    private static final int DEFAULT_GECKO_NATIVE_EVENTS_COUNT = 0;
    private static final int DEFAULT_GECKO_JSON_EVENTS_COUNT = 256;
    private static final int DEFAULT_UI_EVENTS_COUNT = 0;
    private static final int DEFAULT_BACKGROUND_EVENTS_COUNT = 0;
    private final Map<String, List<NativeEventListener>> mGeckoThreadNativeListeners = new HashMap<String, List<NativeEventListener>>(0);
    private final Map<String, List<GeckoEventListener>> mGeckoThreadJSONListeners = new HashMap<String, List<GeckoEventListener>>(256);
    private final Map<String, List<BundleEventListener>> mUiThreadListeners = new HashMap<String, List<BundleEventListener>>(0);
    private final Map<String, List<BundleEventListener>> mBackgroundThreadListeners = new HashMap<String, List<BundleEventListener>>(0);

    public static EventDispatcher getInstance() {
        return INSTANCE;
    }

    private EventDispatcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void registerListener(Class<?> clazz, Map<String, List<T>> map, T t, String[] stringArray) {
        try {
            Map<String, List<T>> map2 = map;
            synchronized (map2) {
                for (String string : stringArray) {
                    List list = map.get(string);
                    if (list == null) {
                        Class<?> clazz2 = clazz;
                        list = (List)clazz2.newInstance();
                        map.put(string, list);
                    }
                    if (list.contains(t)) {
                        throw new IllegalStateException("Already registered " + string);
                    }
                    list.add(t);
                }
            }
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            throw new IllegalArgumentException("Invalid new list type", reflectiveOperationException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNotRegisteredElsewhere(Map<String, ?> map, String[] stringArray) {
        for (Map map2 : Arrays.asList(this.mGeckoThreadNativeListeners, this.mGeckoThreadJSONListeners, this.mUiThreadListeners, this.mBackgroundThreadListeners)) {
            if (map2 == map) continue;
            Map map3 = map2;
            synchronized (map3) {
                for (String string : stringArray) {
                    if (map2.get(string) == null) continue;
                    throw new IllegalStateException("Already registered " + string + " under a different type");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void unregisterListener(Map<String, List<T>> map, T t, String[] stringArray) {
        Map<String, List<T>> map2 = map;
        synchronized (map2) {
            for (String string : stringArray) {
                List<T> list = map.get(string);
                if (list != null && list.remove(t)) continue;
                throw new IllegalArgumentException(string + " was not registered");
            }
        }
    }

    public void registerGeckoThreadListener(NativeEventListener nativeEventListener, String ... stringArray) {
        this.checkNotRegisteredElsewhere(this.mGeckoThreadNativeListeners, stringArray);
        this.registerListener(CopyOnWriteArrayList.class, this.mGeckoThreadNativeListeners, nativeEventListener, stringArray);
    }

    @Deprecated
    public void registerGeckoThreadListener(GeckoEventListener geckoEventListener, String ... stringArray) {
        this.checkNotRegisteredElsewhere(this.mGeckoThreadJSONListeners, stringArray);
        this.registerListener(CopyOnWriteArrayList.class, this.mGeckoThreadJSONListeners, geckoEventListener, stringArray);
    }

    public void registerUiThreadListener(BundleEventListener bundleEventListener, String ... stringArray) {
        this.checkNotRegisteredElsewhere(this.mUiThreadListeners, stringArray);
        this.registerListener(ArrayList.class, this.mUiThreadListeners, bundleEventListener, stringArray);
    }

    public void registerBackgroundThreadListener(BundleEventListener bundleEventListener, String ... stringArray) {
        this.checkNotRegisteredElsewhere(this.mBackgroundThreadListeners, stringArray);
        this.registerListener(ArrayList.class, this.mBackgroundThreadListeners, bundleEventListener, stringArray);
    }

    public void unregisterGeckoThreadListener(NativeEventListener nativeEventListener, String ... stringArray) {
        this.unregisterListener(this.mGeckoThreadNativeListeners, nativeEventListener, stringArray);
    }

    @Deprecated
    public void unregisterGeckoThreadListener(GeckoEventListener geckoEventListener, String ... stringArray) {
        this.unregisterListener(this.mGeckoThreadJSONListeners, geckoEventListener, stringArray);
    }

    public void unregisterUiThreadListener(BundleEventListener bundleEventListener, String ... stringArray) {
        this.unregisterListener(this.mUiThreadListeners, bundleEventListener, stringArray);
    }

    public void unregisterBackgroundThreadListener(BundleEventListener bundleEventListener, String ... stringArray) {
        this.unregisterListener(this.mBackgroundThreadListeners, bundleEventListener, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchEvent(NativeJSContainer nativeJSContainer) {
        List<NativeEventListener> list;
        String string = nativeJSContainer.optString("type", null);
        if (string == null) {
            Log.e((String)LOGTAG, (String)"JSON message must have a type property");
            return;
        }
        Object object = this.mGeckoThreadNativeListeners;
        synchronized (object) {
            list = this.mGeckoThreadNativeListeners.get(string);
        }
        object = nativeJSContainer.optString(GUID, null);
        GeckoEventCallback geckoEventCallback = null;
        if (object != null) {
            geckoEventCallback = new GeckoEventCallback((String)object, string);
        }
        if (list != null) {
            if (list.isEmpty()) {
                Log.w((String)LOGTAG, (String)("No listeners for " + string));
                if (geckoEventCallback != null) {
                    geckoEventCallback.sendError("No listeners for request");
                }
            }
            try {
                for (NativeEventListener nativeEventListener : list) {
                    nativeEventListener.handleMessage(string, (NativeJSObject)nativeJSContainer, (EventCallback)geckoEventCallback);
                }
            }
            catch (NativeJSObject.InvalidPropertyException invalidPropertyException) {
                Log.e((String)LOGTAG, (String)("Exception occurred while handling " + string), (Throwable)invalidPropertyException);
            }
            return;
        }
        if (this.dispatchToThread(string, (NativeJSObject)nativeJSContainer, geckoEventCallback, this.mUiThreadListeners, ThreadUtils.getUiHandler()) || this.dispatchToThread(string, (NativeJSObject)nativeJSContainer, geckoEventCallback, this.mBackgroundThreadListeners, ThreadUtils.getBackgroundHandler())) {
            return;
        }
        try {
            this.dispatchEvent(new JSONObject(nativeJSContainer.toString()), geckoEventCallback);
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"Cannot parse JSON", (Throwable)jSONException);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            Log.e((String)LOGTAG, (String)"Cannot convert message to JSON", (Throwable)unsupportedOperationException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dispatchToThread(final String string, NativeJSObject nativeJSObject, final EventCallback eventCallback, Map<String, List<BundleEventListener>> map, Handler handler) {
        Map<String, List<BundleEventListener>> map2 = map;
        synchronized (map2) {
            Bundle bundle;
            List<BundleEventListener> list = map.get(string);
            if (list == null) {
                return false;
            }
            if (list.isEmpty()) {
                Log.w((String)LOGTAG, (String)("No listeners for " + string));
                if (eventCallback != null) {
                    eventCallback.sendError((Object)"No listeners for request");
                }
                return true;
            }
            try {
                bundle = nativeJSObject.toBundle();
            }
            catch (NativeJSObject.InvalidPropertyException invalidPropertyException) {
                Log.e((String)LOGTAG, (String)("Exception occurred while handling " + string), (Throwable)invalidPropertyException);
                return true;
            }
            for (final BundleEventListener bundleEventListener : list) {
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        bundleEventListener.handleMessage(string, bundle, eventCallback);
                    }
                });
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchEvent(JSONObject jSONObject, EventCallback eventCallback) {
        try {
            List<GeckoEventListener> list;
            String string = jSONObject.getString("type");
            Map<String, List<GeckoEventListener>> map = this.mGeckoThreadJSONListeners;
            synchronized (map) {
                list = this.mGeckoThreadJSONListeners.get(string);
            }
            if (list == null || list.isEmpty()) {
                Log.w((String)LOGTAG, (String)("No listeners for " + string));
                if (eventCallback != null) {
                    eventCallback.sendError((Object)"No listeners for request");
                }
                return;
            }
            for (GeckoEventListener geckoEventListener : list) {
                geckoEventListener.handleMessage(string, jSONObject);
            }
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)("handleGeckoMessage throws " + (Object)((Object)jSONException)), (Throwable)jSONException);
        }
    }

    @Deprecated
    @RobocopTarget
    public static void sendResponse(JSONObject jSONObject, Object object) {
        EventDispatcher.sendResponseHelper(STATUS_SUCCESS, jSONObject, object);
    }

    @Deprecated
    public static void sendError(JSONObject jSONObject, Object object) {
        EventDispatcher.sendResponseHelper(STATUS_ERROR, jSONObject, object);
    }

    @Deprecated
    private static void sendResponseHelper(String string, JSONObject jSONObject, Object object) {
        try {
            String string2 = jSONObject.getString("type") + ":Response";
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put(GUID, (Object)jSONObject.getString(GUID));
            jSONObject2.put("status", (Object)string);
            jSONObject2.put("response", object);
            if (ThreadUtils.isOnGeckoThread()) {
                GeckoAppShell.syncNotifyObservers(string2, jSONObject2.toString());
            } else {
                GeckoAppShell.notifyObservers(string2, jSONObject2.toString());
            }
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"Unable to send response", (Throwable)jSONException);
        }
    }

    private static class GeckoEventCallback
    implements EventCallback {
        private final String guid;
        private final String type;
        private boolean sent;

        public GeckoEventCallback(String string, String string2) {
            this.guid = string;
            this.type = string2;
        }

        public void sendSuccess(Object object) {
            this.sendResponse(EventDispatcher.STATUS_SUCCESS, object);
        }

        public void sendError(Object object) {
            this.sendResponse(EventDispatcher.STATUS_ERROR, object);
        }

        private void sendResponse(String string, Object object) {
            if (this.sent) {
                throw new IllegalStateException("Callback has already been executed for type=" + this.type + ", guid=" + this.guid);
            }
            this.sent = true;
            try {
                String string2 = this.type + ":Response";
                JSONObject jSONObject = new JSONObject();
                jSONObject.put(EventDispatcher.GUID, (Object)this.guid);
                jSONObject.put("status", (Object)string);
                jSONObject.put("response", object);
                if (ThreadUtils.isOnGeckoThread()) {
                    GeckoAppShell.syncNotifyObservers(string2, jSONObject.toString());
                } else {
                    GeckoAppShell.notifyObservers(string2, jSONObject.toString());
                }
            }
            catch (JSONException jSONException) {
                Log.e((String)EventDispatcher.LOGTAG, (String)("Unable to send response for: " + this.type), (Throwable)jSONException);
            }
        }
    }
}

