/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.ActivityManager;
import android.content.Context;
import android.graphics.Rect;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityNodeProvider;
import com.googlecode.eyesfree.braille.selfbraille.SelfBrailleClient;
import com.googlecode.eyesfree.braille.selfbraille.WriteData;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.gfx.LayerView;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.util.UIAsyncTask;

public class GeckoAccessibility {
    private static final String LOGTAG = "GeckoAccessibility";
    private static final int VIRTUAL_ENTRY_POINT_BEFORE = 1;
    private static final int VIRTUAL_CURSOR_POSITION = 2;
    private static final int VIRTUAL_ENTRY_POINT_AFTER = 3;
    private static boolean sEnabled;
    private static JSONObject sHoverEnter;
    private static AccessibilityNodeInfo sVirtualCursorNode;
    private static int sCurrentNode;
    private static final int BRAILLE_CLICK_BASE_INDEX = -275000000;
    private static SelfBrailleClient sSelfBrailleClient;
    private static final HashSet<String> sServiceWhitelist;

    public static void updateAccessibilitySettings(final Context context) {
        new UIAsyncTask.WithoutParams<Void>(ThreadUtils.getBackgroundHandler()){

            public Void doInBackground() {
                JSONObject jSONObject = new JSONObject();
                sEnabled = false;
                AccessibilityManager accessibilityManager = (AccessibilityManager)context.getSystemService("accessibility");
                if (accessibilityManager.isEnabled()) {
                    ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
                    List list = activityManager.getRunningServices(Integer.MAX_VALUE);
                    for (ActivityManager.RunningServiceInfo runningServiceInfo : list) {
                        sEnabled = sServiceWhitelist.contains(runningServiceInfo.service.getClassName());
                        if (!sEnabled) continue;
                        break;
                    }
                    if (AppConstants.Versions.feature16Plus && sEnabled && sSelfBrailleClient == null) {
                        sSelfBrailleClient = new SelfBrailleClient(GeckoAppShell.getContext(), false);
                    }
                }
                try {
                    jSONObject.put("enabled", sEnabled);
                }
                catch (Exception exception) {
                    Log.e((String)GeckoAccessibility.LOGTAG, (String)"Error building JSON arguments for Accessibility:Settings:", (Throwable)exception);
                }
                GeckoAppShell.notifyObservers("Accessibility:Settings", jSONObject.toString());
                return null;
            }

            public void onPostExecute(Void void_) {
                GeckoAppShell.GeckoInterface geckoInterface = GeckoAppShell.getGeckoInterface();
                if (geckoInterface == null) {
                    return;
                }
                geckoInterface.setAccessibilityEnabled(sEnabled);
            }
        }.execute();
    }

    private static void populateEventFromJSON(AccessibilityEvent accessibilityEvent, JSONObject jSONObject) {
        JSONArray jSONArray = jSONObject.optJSONArray("text");
        if (jSONArray != null) {
            for (int i = 0; i < jSONArray.length(); ++i) {
                accessibilityEvent.getText().add(jSONArray.optString(i));
            }
        }
        accessibilityEvent.setContentDescription((CharSequence)jSONObject.optString("description"));
        accessibilityEvent.setEnabled(jSONObject.optBoolean("enabled", true));
        accessibilityEvent.setChecked(jSONObject.optBoolean("checked"));
        accessibilityEvent.setPassword(jSONObject.optBoolean("password"));
        accessibilityEvent.setAddedCount(jSONObject.optInt("addedCount", -1));
        accessibilityEvent.setRemovedCount(jSONObject.optInt("removedCount", -1));
        accessibilityEvent.setFromIndex(jSONObject.optInt("fromIndex", -1));
        accessibilityEvent.setItemCount(jSONObject.optInt("itemCount", -1));
        accessibilityEvent.setCurrentItemIndex(jSONObject.optInt("currentItemIndex", -1));
        accessibilityEvent.setBeforeText((CharSequence)jSONObject.optString("beforeText"));
        if (AppConstants.Versions.feature14Plus) {
            accessibilityEvent.setToIndex(jSONObject.optInt("toIndex", -1));
            accessibilityEvent.setScrollable(jSONObject.optBoolean("scrollable"));
            accessibilityEvent.setScrollX(jSONObject.optInt("scrollX", -1));
            accessibilityEvent.setScrollY(jSONObject.optInt("scrollY", -1));
        }
        if (AppConstants.Versions.feature15Plus) {
            accessibilityEvent.setMaxScrollX(jSONObject.optInt("maxScrollX", -1));
            accessibilityEvent.setMaxScrollY(jSONObject.optInt("maxScrollY", -1));
        }
    }

    private static void sendDirectAccessibilityEvent(int n, JSONObject jSONObject) {
        AccessibilityEvent accessibilityEvent = AccessibilityEvent.obtain((int)n);
        accessibilityEvent.setClassName((CharSequence)GeckoAccessibility.class.getName());
        accessibilityEvent.setPackageName((CharSequence)GeckoAppShell.getContext().getPackageName());
        GeckoAccessibility.populateEventFromJSON(accessibilityEvent, jSONObject);
        AccessibilityManager accessibilityManager = (AccessibilityManager)GeckoAppShell.getContext().getSystemService("accessibility");
        try {
            accessibilityManager.sendAccessibilityEvent(accessibilityEvent);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static boolean isEnabled() {
        return sEnabled;
    }

    public static void sendAccessibilityEvent(JSONObject jSONObject) {
        if (!sEnabled) {
            return;
        }
        int n = jSONObject.optInt("eventType", -1);
        if (n < 0) {
            Log.e((String)LOGTAG, (String)"No accessibility event type provided");
            return;
        }
        GeckoAccessibility.sendAccessibilityEvent(jSONObject, n);
    }

    public static void sendAccessibilityEvent(final JSONObject jSONObject, final int n) {
        if (!sEnabled) {
            return;
        }
        String string2 = jSONObject.optString("exitView");
        sCurrentNode = string2.equals("moveNext") ? 3 : (string2.equals("movePrevious") ? 1 : 2);
        if (AppConstants.Versions.preJB) {
            ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    GeckoAccessibility.sendDirectAccessibilityEvent(n, jSONObject);
                }
            });
        } else {
            JSONObject jSONObject2;
            final LayerView layerView = GeckoAppShell.getLayerView();
            if (layerView == null) {
                return;
            }
            if (sVirtualCursorNode == null) {
                sVirtualCursorNode = AccessibilityNodeInfo.obtain((View)layerView, (int)2);
            }
            sVirtualCursorNode.setEnabled(jSONObject.optBoolean("enabled", true));
            sVirtualCursorNode.setClickable(jSONObject.optBoolean("clickable"));
            sVirtualCursorNode.setCheckable(jSONObject.optBoolean("checkable"));
            sVirtualCursorNode.setChecked(jSONObject.optBoolean("checked"));
            sVirtualCursorNode.setPassword(jSONObject.optBoolean("password"));
            JSONArray jSONArray = jSONObject.optJSONArray("text");
            StringBuilder stringBuilder = new StringBuilder();
            if (jSONArray != null && jSONArray.length() > 0) {
                stringBuilder.append(jSONArray.optString(0));
                for (int i = 1; i < jSONArray.length(); ++i) {
                    stringBuilder.append(" ").append(jSONArray.optString(i));
                }
                sVirtualCursorNode.setText((CharSequence)stringBuilder.toString());
            }
            sVirtualCursorNode.setContentDescription((CharSequence)jSONObject.optString("description"));
            JSONObject jSONObject3 = jSONObject.optJSONObject("bounds");
            if (jSONObject3 != null) {
                jSONObject2 = new Rect(jSONObject3.optInt("left"), jSONObject3.optInt("top"), jSONObject3.optInt("right"), jSONObject3.optInt("bottom"));
                sVirtualCursorNode.setBoundsInParent((Rect)jSONObject2);
                int[] nArray = new int[2];
                layerView.getLocationOnScreen(nArray);
                Rect rect = new Rect((Rect)jSONObject2);
                rect.offset(nArray[0], nArray[1]);
                sVirtualCursorNode.setBoundsInScreen(rect);
            }
            if ((jSONObject2 = jSONObject.optJSONObject("brailleOutput")) != null) {
                GeckoAccessibility.sendBrailleText((View)layerView, jSONObject2.optString("text"), jSONObject2.optInt("selectionStart"), jSONObject2.optInt("selectionEnd"));
            }
            if (n == 128) {
                sHoverEnter = jSONObject;
            }
            ThreadUtils.postToUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    AccessibilityEvent accessibilityEvent = AccessibilityEvent.obtain((int)n);
                    accessibilityEvent.setPackageName((CharSequence)GeckoAppShell.getContext().getPackageName());
                    accessibilityEvent.setClassName((CharSequence)GeckoAccessibility.class.getName());
                    if (n == 16384 || n == 4096) {
                        accessibilityEvent.setSource((View)layerView, -1);
                    } else {
                        accessibilityEvent.setSource((View)layerView, 2);
                    }
                    GeckoAccessibility.populateEventFromJSON(accessibilityEvent, jSONObject);
                    layerView.requestSendAccessibilityEvent((View)layerView, accessibilityEvent);
                }
            });
        }
    }

    private static void sendBrailleText(View view, String string2, int n, int n2) {
        AccessibilityNodeInfo accessibilityNodeInfo = AccessibilityNodeInfo.obtain((View)view, (int)2);
        WriteData writeData = WriteData.forInfo(accessibilityNodeInfo);
        writeData.setText(string2);
        writeData.setSelectionStart(n);
        writeData.setSelectionEnd(n2);
        sSelfBrailleClient.write(writeData);
    }

    public static void setDelegate(LayerView layerView) {
        if (AppConstants.Versions.feature16Plus) {
            layerView.setAccessibilityDelegate(new GeckoAccessibilityDelegate());
            layerView.setImportantForAccessibility(1);
        }
    }

    public static void setAccessibilityStateChangeListener(final Context context) {
        if (AppConstants.Versions.feature14Plus) {
            AccessibilityManager accessibilityManager = (AccessibilityManager)context.getSystemService("accessibility");
            accessibilityManager.addAccessibilityStateChangeListener(new AccessibilityManager.AccessibilityStateChangeListener(){

                public void onAccessibilityStateChanged(boolean bl) {
                    GeckoAccessibility.updateAccessibilitySettings(context);
                }
            });
        }
    }

    public static void onLayerViewFocusChanged(LayerView layerView, boolean bl) {
        if (sEnabled) {
            GeckoAppShell.notifyObservers("Accessibility:Focus", bl ? "true" : "false");
        }
    }

    static {
        sServiceWhitelist = new HashSet<String>(Arrays.asList("com.google.android.marvin.talkback.TalkBackService", "com.mot.readout.ScreenReader", "info.spielproject.spiel.SpielService", "es.codefactory.android.app.ma.MAAccessibilityService"));
    }

    public static class GeckoAccessibilityDelegate
    extends View.AccessibilityDelegate {
        AccessibilityNodeProvider mAccessibilityNodeProvider;

        public AccessibilityNodeProvider getAccessibilityNodeProvider(final View view) {
            if (this.mAccessibilityNodeProvider == null) {
                this.mAccessibilityNodeProvider = new AccessibilityNodeProvider(){

                    public AccessibilityNodeInfo createAccessibilityNodeInfo(int n) {
                        AccessibilityNodeInfo accessibilityNodeInfo = n == 2 && sVirtualCursorNode != null ? AccessibilityNodeInfo.obtain((AccessibilityNodeInfo)sVirtualCursorNode) : AccessibilityNodeInfo.obtain((View)view, (int)n);
                        switch (n) {
                            case -1: {
                                GeckoAccessibilityDelegate.this.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfo);
                                accessibilityNodeInfo.addChild(view, 1);
                                accessibilityNodeInfo.addChild(view, 2);
                                accessibilityNodeInfo.addChild(view, 3);
                                break;
                            }
                            default: {
                                accessibilityNodeInfo.setParent(view);
                                accessibilityNodeInfo.setSource(view, n);
                                accessibilityNodeInfo.setVisibleToUser(view.isShown());
                                accessibilityNodeInfo.setPackageName((CharSequence)GeckoAppShell.getContext().getPackageName());
                                accessibilityNodeInfo.setClassName((CharSequence)view.getClass().getName());
                                accessibilityNodeInfo.setEnabled(true);
                                accessibilityNodeInfo.addAction(128);
                                accessibilityNodeInfo.addAction(64);
                                accessibilityNodeInfo.addAction(16);
                                accessibilityNodeInfo.addAction(32);
                                accessibilityNodeInfo.addAction(512);
                                accessibilityNodeInfo.addAction(256);
                                accessibilityNodeInfo.addAction(8192);
                                accessibilityNodeInfo.addAction(4096);
                                accessibilityNodeInfo.addAction(1024);
                                accessibilityNodeInfo.addAction(2048);
                                accessibilityNodeInfo.setMovementGranularities(15);
                            }
                        }
                        return accessibilityNodeInfo;
                    }

                    public boolean performAction(int n, int n2, Bundle bundle) {
                        if (n2 == 64) {
                            if (n == 2 && sHoverEnter != null) {
                                GeckoAccessibility.sendAccessibilityEvent(sHoverEnter, 32768);
                            } else {
                                GeckoAppShell.notifyObservers("Accessibility:Focus", "true");
                            }
                            return true;
                        }
                        if (n2 == 16 && n == 2) {
                            GeckoAppShell.notifyObservers("Accessibility:ActivateObject", null);
                            return true;
                        }
                        if (n2 == 32 && n == 2) {
                            GeckoAppShell.notifyObservers("Accessibility:LongPress", null);
                            return true;
                        }
                        if (n2 == 4096 && n == 2) {
                            GeckoAppShell.notifyObservers("Accessibility:ScrollForward", null);
                            return true;
                        }
                        if (n2 == 8192 && n == 2) {
                            GeckoAppShell.notifyObservers("Accessibility:ScrollBackward", null);
                            return true;
                        }
                        if (n2 == 1024 && n == 2) {
                            String string2 = "";
                            if (bundle != null) {
                                string2 = bundle.getString("ACTION_ARGUMENT_HTML_ELEMENT_STRING");
                            }
                            GeckoAppShell.notifyObservers("Accessibility:NextObject", string2);
                            return true;
                        }
                        if (n2 == 2048 && n == 2) {
                            String string3 = "";
                            if (bundle != null) {
                                string3 = bundle.getString("ACTION_ARGUMENT_HTML_ELEMENT_STRING");
                            }
                            GeckoAppShell.notifyObservers("Accessibility:PreviousObject", string3);
                            return true;
                        }
                        if (n2 == 256 && n == 2) {
                            int n3 = bundle.getInt("ACTION_ARGUMENT_MOVEMENT_GRANULARITY_INT");
                            if (n3 <= -275000000) {
                                int n4 = -275000000 - n3;
                                JSONObject jSONObject = new JSONObject();
                                try {
                                    jSONObject.put("keyIndex", n4);
                                }
                                catch (JSONException jSONException) {
                                    return true;
                                }
                                GeckoAppShell.notifyObservers("Accessibility:ActivateObject", jSONObject.toString());
                            } else if (n3 > 0) {
                                JSONObject jSONObject = new JSONObject();
                                try {
                                    jSONObject.put("direction", (Object)"Next");
                                    jSONObject.put("granularity", n3);
                                }
                                catch (JSONException jSONException) {
                                    return true;
                                }
                                GeckoAppShell.notifyObservers("Accessibility:MoveByGranularity", jSONObject.toString());
                            }
                            return true;
                        }
                        if (n2 == 512 && n == 2) {
                            JSONObject jSONObject = new JSONObject();
                            int n5 = bundle.getInt("ACTION_ARGUMENT_MOVEMENT_GRANULARITY_INT");
                            try {
                                jSONObject.put("direction", (Object)"Previous");
                                jSONObject.put("granularity", n5);
                            }
                            catch (JSONException jSONException) {
                                return true;
                            }
                            if (n5 > 0) {
                                GeckoAppShell.notifyObservers("Accessibility:MoveByGranularity", jSONObject.toString());
                            }
                            return true;
                        }
                        return view.performAccessibilityAction(n2, bundle);
                    }
                };
            }
            return this.mAccessibilityNodeProvider;
        }
    }
}

