/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.ComponentName;
import android.content.Intent;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import org.mozilla.gecko.ANRReporter;
import org.mozilla.gecko.GeckoActivityStatus;
import org.mozilla.gecko.GeckoApplication;
import org.mozilla.gecko.MemoryMonitor;

public class GeckoActivity
extends AppCompatActivity
implements GeckoActivityStatus {
    private boolean mGeckoActivityOpened;

    public void onLocaleReady(String string2) {
    }

    public void onPause() {
        super.onPause();
        if (this.getApplication() instanceof GeckoApplication) {
            ((GeckoApplication)this.getApplication()).onActivityPause(this);
        }
    }

    public void onResume() {
        super.onResume();
        if (this.getApplication() instanceof GeckoApplication) {
            ((GeckoApplication)this.getApplication()).onActivityResume(this);
            this.mGeckoActivityOpened = false;
        }
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        ANRReporter.register(this.getApplicationContext());
    }

    public void onDestroy() {
        ANRReporter.unregister();
        super.onDestroy();
    }

    public void startActivity(Intent intent) {
        this.mGeckoActivityOpened = GeckoActivity.checkIfGeckoActivity(intent);
        super.startActivity(intent);
    }

    public void startActivityForResult(Intent intent, int n) {
        this.mGeckoActivityOpened = GeckoActivity.checkIfGeckoActivity(intent);
        super.startActivityForResult(intent, n);
    }

    private static boolean checkIfGeckoActivity(Intent intent) {
        ComponentName componentName = intent.getComponent();
        return componentName != null && "org.mozilla.fennec".equals(componentName.getPackageName());
    }

    @Override
    public boolean isGeckoActivityOpened() {
        return this.mGeckoActivityOpened;
    }

    public boolean isApplicationInBackground() {
        return ((GeckoApplication)this.getApplication()).isApplicationInBackground();
    }

    public void onLowMemory() {
        MemoryMonitor.getInstance().onLowMemory();
        super.onLowMemory();
    }

    public void onTrimMemory(int n) {
        MemoryMonitor.getInstance().onTrimMemory(n);
        super.onTrimMemory(n);
    }
}

