/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.os.Handler;
import android.os.Looper;
import android.text.Editable;
import android.text.InputFilter;
import android.text.NoCopySpan;
import android.text.Selection;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.CharacterStyle;
import android.util.Log;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.View;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import org.json.JSONObject;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoEditableClient;
import org.mozilla.gecko.GeckoEditableListener;
import org.mozilla.gecko.GeckoInputConnection;
import org.mozilla.gecko.GeckoView;
import org.mozilla.gecko.InputConnectionListener;
import org.mozilla.gecko.annotation.WrapForJNI;
import org.mozilla.gecko.mozglue.JNIObject;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.ThreadUtils;

final class GeckoEditable
extends JNIObject
implements InvocationHandler,
Editable,
GeckoEditableClient,
GeckoEditableListener,
GeckoEventListener {
    private static final boolean DEBUG = false;
    private static final String LOGTAG = "GeckoEditable";
    private InputFilter[] mFilters;
    private final SpannableStringBuilder mText;
    private final Editable mProxy;
    private final ActionQueue mActionQueue = new ActionQueue();
    private Handler mIcRunHandler;
    private Handler mIcPostHandler;
    GeckoEditableListener mListener;
    GeckoView mView;
    boolean mInBatchMode;
    boolean mNeedCompositionUpdate;
    private boolean mFocused;
    private boolean mGeckoFocused;
    private boolean mIgnoreSelectionChange;
    private volatile boolean mSuppressCompositions;
    private volatile boolean mSuppressKeyUp;
    private static final int IME_RANGE_CARETPOSITION = 1;
    private static final int IME_RANGE_RAWINPUT = 2;
    private static final int IME_RANGE_SELECTEDRAWTEXT = 3;
    private static final int IME_RANGE_CONVERTEDTEXT = 4;
    private static final int IME_RANGE_SELECTEDCONVERTEDTEXT = 5;
    private static final int IME_RANGE_LINE_NONE = 0;
    private static final int IME_RANGE_LINE_DOTTED = 1;
    private static final int IME_RANGE_LINE_DASHED = 2;
    private static final int IME_RANGE_LINE_SOLID = 3;
    private static final int IME_RANGE_LINE_DOUBLE = 4;
    private static final int IME_RANGE_LINE_WAVY = 5;
    private static final int IME_RANGE_UNDERLINE = 1;
    private static final int IME_RANGE_FORECOLOR = 2;
    private static final int IME_RANGE_BACKCOLOR = 4;
    private static final int IME_RANGE_LINECOLOR = 8;

    @WrapForJNI
    private native void onKeyEvent(int var1, int var2, int var3, int var4, long var5, int var7, int var8, int var9, int var10, int var11, boolean var12, KeyEvent var13);

    private void onKeyEvent(KeyEvent keyEvent, int n, int n2, boolean bl) {
        int n3 = keyEvent.getMetaState() | n2;
        int n4 = n3 & 0xFFF88FCD;
        int n5 = keyEvent.getUnicodeChar(n3);
        int n6 = n5 >= 32 ? n5 : (n4 != n3 ? keyEvent.getUnicodeChar(n4) : 0);
        this.onKeyEvent(n, keyEvent.getKeyCode(), keyEvent.getScanCode(), n3, keyEvent.getEventTime(), n5, keyEvent.getUnicodeChar(0), n6, keyEvent.getRepeatCount(), keyEvent.getFlags(), bl, keyEvent);
    }

    @WrapForJNI
    private native void onImeSynchronize();

    @WrapForJNI
    private native void onImeAcknowledgeFocus();

    @WrapForJNI
    private native void onImeReplaceText(int var1, int var2, String var3);

    @WrapForJNI
    private native void onImeAddCompositionRange(int var1, int var2, int var3, int var4, int var5, boolean var6, int var7, int var8, int var9);

    @WrapForJNI
    private native void onImeUpdateComposition(int var1, int var2);

    @WrapForJNI
    GeckoEditable(GeckoView geckoView) {
        this.mText = new SpannableStringBuilder();
        Class[] classArray = new Class[]{Editable.class};
        this.mProxy = (Editable)Proxy.newProxyInstance(Editable.class.getClassLoader(), classArray, (InvocationHandler)this);
        this.mIcRunHandler = this.mIcPostHandler = ThreadUtils.getUiHandler();
        this.onViewChange(geckoView);
    }

    @WrapForJNI
    protected native void disposeNative();

    @WrapForJNI
    void onViewChange(final GeckoView geckoView) {
        final GeckoEditableListener geckoEditableListener = geckoView != null ? GeckoInputConnection.create((View)geckoView, this) : null;
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (geckoEditableListener != null) {
                    GeckoEditable.this.mActionQueue.syncWithGecko();
                    GeckoEditable.this.mListener = geckoEditableListener;
                } else {
                    GeckoEditable.this.mListener = null;
                    GeckoEditable.this.disposeNative();
                }
            }
        };
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (GeckoEditable.this.mView != null) {
                    GeckoEditable.this.mView.setInputConnectionListener(null);
                }
                if (geckoView != null) {
                    geckoView.setInputConnectionListener((InputConnectionListener)((Object)geckoEditableListener));
                }
                GeckoEditable.this.mView = geckoView;
                GeckoEditable.this.mIcPostHandler.post(runnable);
            }
        });
    }

    private boolean onIcThread() {
        return this.mIcRunHandler.getLooper() == Looper.myLooper();
    }

    private void assertOnIcThread() {
        ThreadUtils.assertOnThread((Thread)this.mIcRunHandler.getLooper().getThread(), (ThreadUtils.AssertBehavior)ThreadUtils.AssertBehavior.THROW);
    }

    private void geckoPostToIc(Runnable runnable) {
        this.mIcPostHandler.post(runnable);
    }

    private Object getField(Object object, String string2, Object object2) {
        try {
            return object.getClass().getField(string2).get(object);
        }
        catch (Exception exception) {
            return object2;
        }
    }

    private boolean icMaybeSendComposition(CharSequence charSequence, boolean bl, boolean bl2) {
        int n = Selection.getSelectionStart((CharSequence)charSequence);
        int n2 = Selection.getSelectionEnd((CharSequence)charSequence);
        if (charSequence instanceof Spanned) {
            Spanned spanned = (Spanned)charSequence;
            Object[] objectArray = spanned.getSpans(0, spanned.length(), Object.class);
            boolean bl3 = false;
            int n3 = bl ? 0 : Integer.MAX_VALUE;
            int n4 = bl ? spanned.length() : 0;
            for (Object object : objectArray) {
                if ((spanned.getSpanFlags(object) & 0x100) == 0) continue;
                if (!bl) {
                    n3 = Math.min(n3, spanned.getSpanStart(object));
                    n4 = Math.max(n4, spanned.getSpanEnd(object));
                }
                bl3 = true;
            }
            if (bl && (n < 0 || n2 < 0)) {
                n = n4;
                n2 = n4;
            }
            if (bl3) {
                this.icSendComposition(spanned, n, n2, n3, n4);
                if (bl2) {
                    this.mActionQueue.offer(Action.newUpdateComposition(n3, n4));
                }
                return true;
            }
        }
        if (bl2) {
            this.mActionQueue.offer(Action.newUpdateComposition(n, n2));
        }
        return false;
    }

    private void icSendComposition(Spanned spanned, int n, int n2, int n3, int n4) {
        int n5;
        if (n2 >= n3 && n2 <= n4) {
            this.onImeAddCompositionRange(n2 - n3, n2 - n3, 1, 0, 0, false, 0, 0, 0);
        }
        int n6 = n3;
        TextPaint textPaint = new TextPaint();
        TextPaint textPaint2 = new TextPaint();
        textPaint2.setColor(0);
        do {
            int n7;
            int n8 = 0;
            int n9 = 0;
            boolean bl = false;
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            n5 = spanned.nextSpanTransition(n6, n4, Object.class);
            if (n > n6 && n < n5) {
                n5 = n;
            } else if (n2 > n6 && n2 < n5) {
                n5 = n2;
            }
            CharacterStyle[] characterStyleArray = (CharacterStyle[])spanned.getSpans(n6, n5, CharacterStyle.class);
            if (characterStyleArray.length == 0) {
                n7 = n == n6 && n2 == n5 ? 3 : 2;
            } else {
                n7 = n == n6 && n2 == n5 ? 5 : 4;
                textPaint.set(textPaint2);
                for (CharacterStyle characterStyle : characterStyleArray) {
                    characterStyle.updateDrawState(textPaint);
                }
                int n13 = 0;
                float f = 0.0f;
                if (AppConstants.Versions.feature14Plus) {
                    n13 = (Integer)this.getField(textPaint, "underlineColor", 0);
                    f = ((Float)this.getField(textPaint, "underlineThickness", Float.valueOf(0.0f))).floatValue();
                }
                if (n13 != 0) {
                    n8 |= 9;
                    n12 = n13;
                    if (f <= 0.5f) {
                        n9 = 1;
                    } else {
                        n9 = 3;
                        if (f >= 2.0f) {
                            bl = true;
                        }
                    }
                } else if (textPaint.isUnderlineText()) {
                    n8 |= 1;
                    n9 = 3;
                }
                if (textPaint.getColor() != 0) {
                    n8 |= 2;
                    n10 = textPaint.getColor();
                }
                if (textPaint.bgColor != 0) {
                    n8 |= 4;
                    n11 = textPaint.bgColor;
                }
            }
            this.onImeAddCompositionRange(n6 - n3, n5 - n3, n7, n8, n9, bl, n10, n11, n12);
        } while ((n6 = n5) < n4);
    }

    @Override
    public void sendKeyEvent(KeyEvent keyEvent, int n, int n2) {
        if (this.mNeedCompositionUpdate) {
            this.icUpdateComposition();
        }
        this.onKeyEvent(keyEvent, n, n2, false);
        this.mActionQueue.offer(new Action(0));
    }

    @Override
    public Editable getEditable() {
        if (!this.onIcThread()) {
            return null;
        }
        if (this.mListener == null) {
            return null;
        }
        return this.mProxy;
    }

    @Override
    public void setBatchMode(boolean bl) {
        if (!this.onIcThread()) {
            return;
        }
        if (!bl && this.mNeedCompositionUpdate) {
            this.icUpdateComposition();
        }
        this.mInBatchMode = bl;
    }

    private void icUpdateComposition() {
        this.mNeedCompositionUpdate = false;
        this.mActionQueue.syncWithGecko();
        this.icMaybeSendComposition((CharSequence)this.mText, false, true);
    }

    private void geckoScheduleCompositionUpdate() {
        this.geckoPostToIc(new Runnable(){

            @Override
            public void run() {
                if (GeckoEditable.this.mInBatchMode || !GeckoEditable.this.mNeedCompositionUpdate) {
                    return;
                }
                if (!GeckoEditable.this.mActionQueue.isEmpty()) {
                    GeckoEditable.this.mIcPostHandler.postDelayed((Runnable)this, 10L);
                    return;
                }
                GeckoEditable.this.icUpdateComposition();
            }
        });
    }

    @Override
    public void setSuppressKeyUp(boolean bl) {
        this.mSuppressKeyUp = bl;
    }

    @Override
    public Handler setInputConnectionHandler(Handler handler) {
        if (handler == this.mIcPostHandler || !this.mFocused) {
            return this.mIcPostHandler;
        }
        this.mActionQueue.offer(Action.newSetHandler(handler));
        this.mActionQueue.syncWithGecko();
        return handler;
    }

    @Override
    public void postToInputConnection(Runnable runnable) {
        this.mIcPostHandler.post(runnable);
    }

    private void geckoSetIcHandler(final Handler handler) {
        this.geckoPostToIc(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Handler handler2 = handler;
                synchronized (handler2) {
                    GeckoEditable.this.mIcRunHandler = handler;
                    handler.notify();
                }
            }
        });
        this.mIcPostHandler = handler;
        this.geckoPostToIc(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Handler handler2 = handler;
                synchronized (handler2) {
                    while (GeckoEditable.this.mIcRunHandler != handler) {
                        try {
                            handler.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        });
    }

    private void geckoActionReply() {
        Action action = this.mActionQueue.peek();
        if (action == null) {
            throw new IllegalStateException("empty actions queue");
        }
        switch (action.mType) {
            case 2: {
                this.mText.setSpan(action.mSpanObject, action.mStart, action.mEnd, action.mSpanFlags);
                break;
            }
            case 3: {
                this.mText.removeSpan(action.mSpanObject);
                break;
            }
            case 5: {
                this.geckoSetIcHandler(action.mHandler);
            }
        }
        if (action.mUpdateComposition) {
            this.geckoScheduleCompositionUpdate();
        }
    }

    private void notifyCommitComposition() {
    }

    private void notifyCancelComposition() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WrapForJNI
    public void notifyIME(final int n) {
        if (n == -1) {
            try {
                if (this.mGeckoFocused) {
                    this.geckoActionReply();
                }
            }
            finally {
                this.mActionQueue.poll();
            }
            return;
        }
        if (n == 8) {
            this.notifyCommitComposition();
            return;
        }
        if (n == 9) {
            this.notifyCancelComposition();
            return;
        }
        this.geckoPostToIc(new Runnable(){

            @Override
            public void run() {
                if (n == 1) {
                    GeckoEditable.this.mFocused = true;
                    GeckoEditable.this.mActionQueue.offer(new Action(4));
                }
                GeckoEditable.this.mActionQueue.syncWithGecko();
                if (GeckoEditable.this.mListener != null) {
                    GeckoEditable.this.mListener.notifyIME(n);
                }
                if (n == 2) {
                    GeckoEditable.this.mFocused = false;
                }
            }
        });
        if (n == 2 && this.mGeckoFocused) {
            this.mGeckoFocused = false;
            this.mSuppressCompositions = false;
            EventDispatcher.getInstance().unregisterGeckoThreadListener(this, "TextSelection:DraggingHandle");
        } else if (n == 1) {
            this.mGeckoFocused = true;
            this.mSuppressCompositions = false;
            EventDispatcher.getInstance().registerGeckoThreadListener(this, "TextSelection:DraggingHandle");
        }
    }

    @Override
    @WrapForJNI
    public void notifyIMEContext(final int n, final String string2, final String string3, final String string4) {
        this.geckoPostToIc(new Runnable(){

            @Override
            public void run() {
                if (GeckoEditable.this.mListener == null) {
                    return;
                }
                GeckoEditable.this.mListener.notifyIMEContext(n, string2, string3, string4);
            }
        });
    }

    @Override
    @WrapForJNI
    public void onSelectionChange(int n, int n2) {
        if (n < 0 || n > this.mText.length() || n2 < 0 || n2 > this.mText.length()) {
            Log.e((String)LOGTAG, (String)("invalid selection notification range: " + n + " to " + n2 + ", length: " + this.mText.length()));
            throw new IllegalArgumentException("invalid selection notification range");
        }
        if (this.mIgnoreSelectionChange) {
            n = Selection.getSelectionStart((CharSequence)this.mText);
            n2 = Selection.getSelectionEnd((CharSequence)this.mText);
            this.mIgnoreSelectionChange = false;
        } else {
            Selection.setSelection((Spannable)this.mText, (int)n, (int)n2);
        }
        final int n3 = n;
        final int n4 = n2;
        this.geckoPostToIc(new Runnable(){

            @Override
            public void run() {
                if (GeckoEditable.this.mListener == null) {
                    return;
                }
                GeckoEditable.this.mListener.onSelectionChange(n3, n4);
            }
        });
    }

    private void geckoReplaceText(int n, int n2, CharSequence charSequence) {
        this.mText.replace(n, n2, charSequence);
    }

    private boolean geckoIsSameText(int n, int n2, CharSequence charSequence) {
        return n2 - n == charSequence.length() && TextUtils.regionMatches((CharSequence)this.mText, (int)n, (CharSequence)charSequence, (int)0, (int)(n2 - n));
    }

    @Override
    @WrapForJNI
    public void onTextChange(final CharSequence charSequence, final int n, int n2, int n3) {
        int n4;
        if (n < 0 || n > n2) {
            Log.e((String)LOGTAG, (String)("invalid text notification range: " + n + " to " + n2));
            throw new IllegalArgumentException("invalid text notification range");
        }
        int n5 = n4 = n2 > this.mText.length() ? this.mText.length() : n2;
        if (n2 <= this.mText.length() && n3 != n + charSequence.length()) {
            Log.e((String)LOGTAG, (String)("newEnd does not match text: " + n3 + " vs " + (n + charSequence.length())));
            throw new IllegalArgumentException("newEnd does not match text");
        }
        final int n6 = n + charSequence.length();
        Action action = this.mActionQueue.peek();
        if (action != null && action.mType == 4) {
            this.mText.replace(0, this.mText.length(), charSequence);
        } else if (action != null && action.mType == 1 && n <= action.mStart && n4 >= action.mEnd && n6 >= action.mStart + action.mSequence.length()) {
            int n7 = action.mStart - n;
            int n8 = TextUtils.indexOf((CharSequence)charSequence, (CharSequence)action.mSequence, (int)n7);
            if (n8 < 0 && n7 >= action.mSequence.length()) {
                n8 = charSequence.toString().lastIndexOf(action.mSequence.toString(), n7);
            }
            if (n8 < 0) {
                this.geckoReplaceText(n, n4, charSequence);
                this.mIgnoreSelectionChange = false;
            } else if (n8 == 0 && charSequence.length() == action.mSequence.length()) {
                this.geckoReplaceText(n, n4, action.mSequence);
                this.mIgnoreSelectionChange = true;
            } else {
                this.geckoReplaceText(n, action.mStart, charSequence.subSequence(0, n8));
                int n9 = n8 + n;
                this.geckoReplaceText(n9, n9 + action.mEnd - action.mStart, action.mSequence);
                int n10 = n9 + action.mSequence.length();
                this.geckoReplaceText(n10, n10 + n4 - action.mEnd, charSequence.subSequence(n10 - n, charSequence.length()));
            }
        } else {
            if (this.geckoIsSameText(n, n4, charSequence)) {
                this.mIgnoreSelectionChange = this.mIgnoreSelectionChange || action != null && action.mType == 6;
                return;
            }
            this.geckoReplaceText(n, n4, charSequence);
        }
        this.geckoPostToIc(new Runnable(){

            @Override
            public void run() {
                if (GeckoEditable.this.mListener == null) {
                    return;
                }
                GeckoEditable.this.mListener.onTextChange(charSequence, n, n4, n6);
            }
        });
    }

    @Override
    @WrapForJNI
    public void onDefaultKeyEvent(final KeyEvent keyEvent) {
        this.geckoPostToIc(new Runnable(){

            @Override
            public void run() {
                if (GeckoEditable.this.mListener == null) {
                    return;
                }
                GeckoEditable.this.mListener.onDefaultKeyEvent(keyEvent);
            }
        });
    }

    static String getConstantName(Class<?> clazz, String string2, Object object) {
        for (Field field : clazz.getDeclaredFields()) {
            try {
                if (!field.getName().startsWith(string2) || !field.get(null).equals(object)) continue;
                return field.getName();
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return String.valueOf(object);
    }

    static StringBuilder debugAppend(StringBuilder stringBuilder, Object object) {
        if (object == null) {
            stringBuilder.append("null");
        } else if (object instanceof GeckoEditable) {
            stringBuilder.append(LOGTAG);
        } else if (Proxy.isProxyClass(object.getClass())) {
            GeckoEditable.debugAppend(stringBuilder, Proxy.getInvocationHandler(object));
        } else if (object instanceof CharSequence) {
            stringBuilder.append('\"').append(object.toString().replace('\n', '\u21b2')).append('\"');
        } else if (object.getClass().isArray()) {
            stringBuilder.append(object.getClass().getComponentType().getSimpleName()).append('[').append(Array.getLength(object)).append(']');
        } else {
            stringBuilder.append(object);
        }
        return stringBuilder;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Object object2;
        GeckoEditable geckoEditable;
        Class<?> clazz = method.getDeclaringClass();
        if (clazz == Editable.class || clazz == Appendable.class || clazz == Spannable.class) {
            geckoEditable = this;
        } else {
            this.mActionQueue.syncWithGecko();
            geckoEditable = this.mText;
        }
        try {
            object2 = method.invoke((Object)geckoEditable, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (!(invocationTargetException.getCause() instanceof IndexOutOfBoundsException)) {
                throw invocationTargetException;
            }
            Log.w((String)LOGTAG, (String)("Exception in GeckoEditable." + method.getName()), (Throwable)invocationTargetException.getCause());
            Class<?> clazz2 = method.getReturnType();
            object2 = clazz2 == Character.TYPE ? Character.valueOf('\u0000') : (clazz2 == Integer.TYPE ? Integer.valueOf(0) : (clazz2 == String.class ? "" : null));
        }
        return object2;
    }

    public void removeSpan(Object object) {
        if (object == Selection.SELECTION_START || object == Selection.SELECTION_END) {
            Log.w((String)LOGTAG, (String)"selection removed with removeSpan()");
        }
        boolean bl = !this.mNeedCompositionUpdate && object instanceof NoCopySpan;
        this.mActionQueue.offer(Action.newRemoveSpan(object, bl));
        this.mNeedCompositionUpdate |= bl;
    }

    public void setSpan(Object object, int n, int n2, int n3) {
        boolean bl = !this.mNeedCompositionUpdate && (n3 & 0x200) == 0 && ((n3 & 0x100) != 0 || object == Selection.SELECTION_START || object == Selection.SELECTION_END);
        this.mActionQueue.offer(Action.newSetSpan(object, n, n2, n3, bl));
        this.mNeedCompositionUpdate |= bl;
    }

    public Editable append(CharSequence charSequence) {
        return this.replace(this.mProxy.length(), this.mProxy.length(), charSequence, 0, charSequence.length());
    }

    public Editable append(CharSequence charSequence, int n, int n2) {
        return this.replace(this.mProxy.length(), this.mProxy.length(), charSequence, n, n2);
    }

    public Editable append(char c) {
        return this.replace(this.mProxy.length(), this.mProxy.length(), String.valueOf(c), 0, 1);
    }

    public InputFilter[] getFilters() {
        return this.mFilters;
    }

    public void setFilters(InputFilter[] inputFilterArray) {
        this.mFilters = inputFilterArray;
    }

    public void clearSpans() {
        Log.w((String)LOGTAG, (String)"selection cleared with clearSpans()");
        this.mText.clearSpans();
    }

    public Editable replace(int n, int n2, CharSequence charSequence, int n3, int n4) {
        CharSequence charSequence2 = charSequence;
        if (n3 < 0 || n3 > n4 || n4 > charSequence2.length()) {
            Log.e((String)LOGTAG, (String)("invalid replace offsets: " + n3 + " to " + n4 + ", length: " + charSequence2.length()));
            throw new IllegalArgumentException("invalid replace offsets");
        }
        if (n3 != 0 || n4 != charSequence2.length()) {
            charSequence2 = charSequence2.subSequence(n3, n4);
        }
        if (this.mFilters != null) {
            for (int i = 0; i < this.mFilters.length; ++i) {
                CharSequence charSequence3 = this.mFilters[i].filter(charSequence2, 0, charSequence2.length(), (Spanned)this.mProxy, n, n2);
                if (charSequence3 == null) continue;
                charSequence2 = charSequence3;
            }
        }
        if (charSequence2 == charSequence) {
            charSequence2 = new SpannableString(charSequence);
        }
        this.mActionQueue.offer(Action.newReplaceText(charSequence2, Math.min(n, n2), Math.max(n, n2)));
        return this.mProxy;
    }

    public void clear() {
        this.replace(0, this.mProxy.length(), "", 0, 0);
    }

    public Editable delete(int n, int n2) {
        return this.replace(n, n2, "", 0, 0);
    }

    public Editable insert(int n, CharSequence charSequence, int n2, int n3) {
        return this.replace(n, n, charSequence, n2, n3);
    }

    public Editable insert(int n, CharSequence charSequence) {
        return this.replace(n, n, charSequence, 0, charSequence.length());
    }

    public Editable replace(int n, int n2, CharSequence charSequence) {
        return this.replace(n, n2, charSequence, 0, charSequence.length());
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        throw new UnsupportedOperationException("method must be called through mProxy");
    }

    public int getSpanEnd(Object object) {
        throw new UnsupportedOperationException("method must be called through mProxy");
    }

    public int getSpanFlags(Object object) {
        throw new UnsupportedOperationException("method must be called through mProxy");
    }

    public int getSpanStart(Object object) {
        throw new UnsupportedOperationException("method must be called through mProxy");
    }

    public <T> T[] getSpans(int n, int n2, Class<T> clazz) {
        throw new UnsupportedOperationException("method must be called through mProxy");
    }

    public int nextSpanTransition(int n, int n2, Class clazz) {
        throw new UnsupportedOperationException("method must be called through mProxy");
    }

    public char charAt(int n) {
        throw new UnsupportedOperationException("method must be called through mProxy");
    }

    public int length() {
        throw new UnsupportedOperationException("method must be called through mProxy");
    }

    public CharSequence subSequence(int n, int n2) {
        throw new UnsupportedOperationException("method must be called through mProxy");
    }

    public String toString() {
        throw new UnsupportedOperationException("method must be called through mProxy");
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        if (!"TextSelection:DraggingHandle".equals(string2)) {
            return;
        }
        this.mSuppressCompositions = jSONObject.optBoolean("dragging", false);
    }

    private final class ActionQueue {
        private final ConcurrentLinkedQueue<Action> mActions = new ConcurrentLinkedQueue();
        private final Semaphore mActionsActive = new Semaphore(1);
        private KeyCharacterMap mKeyMap;

        ActionQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void offer(Action action) {
            if (GeckoEditable.this.mListener == null) {
                return;
            }
            if (this.mActions.isEmpty()) {
                this.mActionsActive.acquireUninterruptibly();
                this.mActions.offer(action);
            } else {
                ActionQueue actionQueue = this;
                synchronized (actionQueue) {
                    this.mActionsActive.tryAcquire();
                    this.mActions.offer(action);
                }
            }
            switch (action.mType) {
                case 0: 
                case 2: 
                case 3: 
                case 5: {
                    GeckoEditable.this.onImeSynchronize();
                    break;
                }
                case 1: {
                    if (GeckoEditable.this.icMaybeSendComposition(action.mSequence, true, false)) {
                        GeckoEditable.this.mNeedCompositionUpdate = false;
                    } else {
                        this.sendCharKeyEvents(action);
                    }
                    GeckoEditable.this.onImeReplaceText(action.mStart, action.mEnd, action.mSequence.toString());
                    break;
                }
                case 4: {
                    GeckoEditable.this.onImeAcknowledgeFocus();
                    break;
                }
                case 6: {
                    GeckoEditable.this.onImeUpdateComposition(action.mStart, action.mEnd);
                    break;
                }
                default: {
                    throw new IllegalStateException("Action not processed");
                }
            }
        }

        private KeyEvent[] synthesizeKeyEvents(CharSequence charSequence) {
            try {
                if (this.mKeyMap == null) {
                    this.mKeyMap = KeyCharacterMap.load((int)-1);
                }
            }
            catch (Exception exception) {
                return null;
            }
            KeyEvent[] keyEventArray = this.mKeyMap.getEvents(charSequence.toString().toCharArray());
            if (keyEventArray == null || keyEventArray.length == 0) {
                return null;
            }
            return keyEventArray;
        }

        private void sendCharKeyEvents(Action action) {
            if (action.mSequence.length() != 1 || action.mSequence instanceof Spannable && ((Spannable)action.mSequence).nextSpanTransition(-1, Integer.MAX_VALUE, null) < Integer.MAX_VALUE) {
                return;
            }
            KeyEvent[] keyEventArray = this.synthesizeKeyEvents(action.mSequence);
            if (keyEventArray == null) {
                return;
            }
            for (KeyEvent keyEvent : keyEventArray) {
                if (KeyEvent.isModifierKey((int)keyEvent.getKeyCode()) || keyEvent.getAction() == 1 && GeckoEditable.this.mSuppressKeyUp) continue;
                GeckoEditable.this.onKeyEvent(keyEvent, keyEvent.getAction(), 0, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void poll() {
            if (this.mActions.poll() == null) {
                throw new IllegalStateException("empty actions queue");
            }
            ActionQueue actionQueue = this;
            synchronized (actionQueue) {
                if (this.mActions.isEmpty()) {
                    this.mActionsActive.release();
                }
            }
        }

        Action peek() {
            return this.mActions.peek();
        }

        void syncWithGecko() {
            if (GeckoEditable.this.mFocused && !this.mActions.isEmpty()) {
                this.mActionsActive.acquireUninterruptibly();
                this.mActionsActive.release();
            }
        }

        boolean isEmpty() {
            return this.mActions.isEmpty();
        }
    }

    private static final class Action {
        static final int TYPE_EVENT = 0;
        static final int TYPE_REPLACE_TEXT = 1;
        static final int TYPE_SET_SPAN = 2;
        static final int TYPE_REMOVE_SPAN = 3;
        static final int TYPE_ACKNOWLEDGE_FOCUS = 4;
        static final int TYPE_SET_HANDLER = 5;
        static final int TYPE_UPDATE_COMPOSITION = 6;
        final int mType;
        boolean mUpdateComposition;
        int mStart;
        int mEnd;
        CharSequence mSequence;
        Object mSpanObject;
        int mSpanFlags;
        Handler mHandler;

        Action(int n) {
            this.mType = n;
        }

        static Action newReplaceText(CharSequence charSequence, int n, int n2) {
            if (n < 0 || n > n2) {
                Log.e((String)GeckoEditable.LOGTAG, (String)("invalid replace text offsets: " + n + " to " + n2));
                throw new IllegalArgumentException("invalid replace text offsets");
            }
            Action action = new Action(1);
            action.mSequence = charSequence;
            action.mStart = n;
            action.mEnd = n2;
            return action;
        }

        static Action newSetSpan(Object object, int n, int n2, int n3, boolean bl) {
            if (n < 0 || n > n2) {
                Log.e((String)GeckoEditable.LOGTAG, (String)("invalid span offsets: " + n + " to " + n2));
                throw new IllegalArgumentException("invalid span offsets");
            }
            Action action = new Action(2);
            action.mSpanObject = object;
            action.mStart = n;
            action.mEnd = n2;
            action.mSpanFlags = n3;
            action.mUpdateComposition = bl;
            return action;
        }

        static Action newRemoveSpan(Object object, boolean bl) {
            Action action = new Action(3);
            action.mSpanObject = object;
            action.mUpdateComposition = bl;
            return action;
        }

        static Action newSetHandler(Handler handler) {
            Action action = new Action(5);
            action.mHandler = handler;
            return action;
        }

        static Action newUpdateComposition(int n, int n2) {
            Action action = new Action(6);
            action.mStart = n;
            action.mEnd = n2;
            return action;
        }
    }
}

