/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.InsetDrawable;
import android.support.design.R;
import android.support.design.widget.Snackbar;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.widget.TextView;
import java.lang.ref.WeakReference;
import org.mozilla.gecko.GeckoApp;
import org.mozilla.gecko.R;
import org.mozilla.gecko.util.EventCallback;
import org.mozilla.gecko.util.NativeJSObject;

public class SnackbarHelper {
    private static final Object currentSnackbarLock = new Object();
    private static WeakReference<Snackbar> currentSnackbar = new WeakReference<Object>(null);

    public static void showSnackbar(Activity activity, String string2, int n) {
        SnackbarHelper.showSnackbarWithAction(activity, string2, n, null, null);
    }

    public static void showSnackbar(Activity activity, NativeJSObject nativeJSObject, EventCallback eventCallback) {
        String string2 = nativeJSObject.getString("message");
        int n = nativeJSObject.getInt("duration");
        NativeJSObject nativeJSObject2 = nativeJSObject.optObject("action", null);
        SnackbarHelper.showSnackbarWithAction(activity, string2, n, nativeJSObject2 != null ? nativeJSObject2.optString("label", null) : null, new SnackbarEventCallback(eventCallback));
    }

    public static void showSnackbarWithAction(Activity activity, String string2, int n, String string3, SnackbarCallback snackbarCallback) {
        SnackbarHelper.showSnackbarWithActionAndColors(activity, string2, n, string3, snackbarCallback, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showSnackbarWithActionAndColors(Activity activity, String string2, int n, String string3, SnackbarCallback snackbarCallback, Drawable drawable2, Integer n2, Integer n3) {
        View view = SnackbarHelper.findBestParentView(activity);
        Snackbar snackbar = Snackbar.make((View)view, (CharSequence)string2, (int)n);
        if (snackbarCallback != null && !TextUtils.isEmpty((CharSequence)string3)) {
            snackbar.setAction((CharSequence)string3, (View.OnClickListener)snackbarCallback);
            if (n3 == null) {
                ContextCompat.getColor((Context)activity, (int)R.color.fennec_ui_orange);
            } else {
                snackbar.setActionTextColor(n3.intValue());
            }
            snackbar.setCallback((Snackbar.Callback)snackbarCallback);
        }
        if (drawable2 != null) {
            int n4 = (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)activity.getResources().getDisplayMetrics());
            InsetDrawable insetDrawable = new InsetDrawable(drawable2, 0, 0, n4, 0);
            insetDrawable.setBounds(0, 0, n4 + drawable2.getIntrinsicWidth(), drawable2.getIntrinsicHeight());
            TextView textView = (TextView)snackbar.getView().findViewById(R.id.snackbar_text);
            textView.setCompoundDrawables((Drawable)insetDrawable, null, null, null);
        }
        if (n2 != null) {
            snackbar.getView().setBackgroundColor(n2.intValue());
        }
        snackbar.show();
        Object object = currentSnackbarLock;
        synchronized (object) {
            currentSnackbar = new WeakReference<Snackbar>(snackbar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dismissCurrentSnackbar() {
        Object object = currentSnackbarLock;
        synchronized (object) {
            Snackbar snackbar = (Snackbar)currentSnackbar.get();
            if (snackbar != null && snackbar.isShown()) {
                snackbar.dismiss();
            }
        }
    }

    private static View findBestParentView(Activity activity) {
        View view;
        if (activity instanceof GeckoApp && (view = activity.findViewById(R.id.root_layout)) != null) {
            return view;
        }
        return activity.findViewById(0x1020002);
    }

    private static class SnackbarEventCallback
    extends SnackbarCallback {
        private EventCallback callback;

        public SnackbarEventCallback(EventCallback eventCallback) {
            this.callback = eventCallback;
        }

        public synchronized void onClick(View view) {
            if (this.callback == null) {
                return;
            }
            this.callback.sendSuccess(null);
            this.callback = null;
        }

        public synchronized void onDismissed(Snackbar snackbar, int n) {
            if (this.callback == null || n == 1) {
                return;
            }
            this.callback.sendError(null);
            this.callback = null;
        }
    }

    public static abstract class SnackbarCallback
    extends Snackbar.Callback
    implements View.OnClickListener {
    }
}

