/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.dlc;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.v4.net.ConnectivityManagerCompat;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.zip.GZIPInputStream;
import org.mozilla.gecko.dlc.BaseAction;
import org.mozilla.gecko.dlc.catalog.DownloadContent;
import org.mozilla.gecko.dlc.catalog.DownloadContentCatalog;
import org.mozilla.gecko.util.IOUtils;

public class DownloadAction
extends BaseAction {
    private static final String LOGTAG = "DLCDownloadAction";
    private static final String CACHE_DIRECTORY = "downloadContent";
    private static final String CDN_BASE_URL = "https://mobile.cdn.mozilla.net/";
    private Callback callback;

    public DownloadAction(Callback callback) {
        this.callback = callback;
    }

    @Override
    public void perform(Context context, DownloadContentCatalog downloadContentCatalog) {
        Log.d((String)LOGTAG, (String)"Downloading content..");
        if (!this.isConnectedToNetwork(context)) {
            Log.d((String)LOGTAG, (String)"No connected network available. Postponing download.");
            return;
        }
        if (this.isActiveNetworkMetered(context)) {
            Log.d((String)LOGTAG, (String)"Network is metered. Postponing download.");
            return;
        }
        for (DownloadContent downloadContent : downloadContentCatalog.getScheduledDownloads()) {
            Log.d((String)LOGTAG, (String)("Downloading: " + downloadContent));
            File file = null;
            try {
                File file2 = this.getDestinationFile(context, downloadContent);
                if (file2.exists() && this.verify(file2, downloadContent.getChecksum())) {
                    Log.d((String)LOGTAG, (String)"Content already exists and is up-to-date.");
                    downloadContentCatalog.markAsDownloaded(downloadContent);
                    continue;
                }
                file = this.createTemporaryFile(context, downloadContent);
                if (!this.hasEnoughDiskSpace(downloadContent, file2, file)) {
                    Log.d((String)LOGTAG, (String)"Not enough disk space to save content. Skipping download.");
                    continue;
                }
                String string2 = this.createDownloadURL(downloadContent);
                if (!file.exists() || file.length() < downloadContent.getSize()) {
                    this.download(string2, file);
                }
                if (!this.verify(file, downloadContent.getDownloadChecksum())) {
                    Log.w((String)LOGTAG, (String)("Wrong checksum after download, content=" + downloadContent.getId()));
                    file.delete();
                    continue;
                }
                if (!downloadContent.isAssetArchive()) {
                    Log.e((String)LOGTAG, (String)("Downloaded content is not of type 'asset-archive': " + downloadContent.getType()));
                    file.delete();
                    continue;
                }
                this.extract(file, file2, downloadContent.getChecksum());
                downloadContentCatalog.markAsDownloaded(downloadContent);
                Log.d((String)LOGTAG, (String)("Successfully downloaded: " + downloadContent));
                if (this.callback != null) {
                    this.callback.onContentDownloaded(downloadContent);
                }
                if (file == null || !file.exists()) continue;
                file.delete();
            }
            catch (BaseAction.RecoverableDownloadContentException recoverableDownloadContentException) {
                Log.w((String)LOGTAG, (String)("Downloading content failed (Recoverable): " + downloadContent), (Throwable)recoverableDownloadContentException);
                if (!recoverableDownloadContentException.shouldBeCountedAsFailure()) continue;
                downloadContentCatalog.rememberFailure(downloadContent, recoverableDownloadContentException.getErrorType());
            }
            catch (BaseAction.UnrecoverableDownloadContentException unrecoverableDownloadContentException) {
                Log.w((String)LOGTAG, (String)("Downloading content failed (Unrecoverable): " + downloadContent), (Throwable)unrecoverableDownloadContentException);
                downloadContentCatalog.markAsPermanentlyFailed(downloadContent);
                if (file == null || !file.exists()) continue;
                file.delete();
            }
        }
        Log.v((String)LOGTAG, (String)"Done");
    }

    protected void download(String string2, File file) throws BaseAction.RecoverableDownloadContentException, BaseAction.UnrecoverableDownloadContentException {
        BufferedInputStream bufferedInputStream = null;
        OutputStream outputStream = null;
        HttpURLConnection httpURLConnection = null;
        try {
            int n;
            long l;
            httpURLConnection = this.buildHttpURLConnection(string2);
            long l2 = l = file.exists() ? file.length() : 0L;
            if (l > 0L) {
                httpURLConnection.setRequestProperty("Range", "bytes=" + l + "-");
            }
            if ((n = httpURLConnection.getResponseCode()) != 200 && n != 206) {
                if (n >= 500) {
                    throw new BaseAction.RecoverableDownloadContentException(3, "(Recoverable) Download failed. Status code: " + n);
                }
                if (n >= 400) {
                    throw new BaseAction.UnrecoverableDownloadContentException("(Unrecoverable) Download failed. Status code: " + n);
                }
                throw new BaseAction.UnrecoverableDownloadContentException("(Unrecoverable) Download failed. Status code: " + n);
            }
            bufferedInputStream = new BufferedInputStream(httpURLConnection.getInputStream());
            outputStream = this.openFile(file, n == 206);
            IOUtils.copy((InputStream)bufferedInputStream, (OutputStream)outputStream);
            ((InputStream)bufferedInputStream).close();
            outputStream.close();
        }
        catch (IOException iOException) {
            try {
                throw new BaseAction.RecoverableDownloadContentException(4, (Throwable)iOException);
            }
            catch (Throwable throwable) {
                IOUtils.safeStreamClose(bufferedInputStream);
                IOUtils.safeStreamClose(outputStream);
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
                throw throwable;
            }
        }
        IOUtils.safeStreamClose((Closeable)bufferedInputStream);
        IOUtils.safeStreamClose((Closeable)outputStream);
        if (httpURLConnection != null) {
            httpURLConnection.disconnect();
        }
    }

    protected OutputStream openFile(File file, boolean bl) throws FileNotFoundException {
        return new BufferedOutputStream(new FileOutputStream(file, bl));
    }

    protected void extract(File file, File file2, String string2) throws BaseAction.UnrecoverableDownloadContentException, BaseAction.RecoverableDownloadContentException {
        File file3;
        BufferedOutputStream bufferedOutputStream;
        GZIPInputStream gZIPInputStream;
        block9: {
            gZIPInputStream = null;
            bufferedOutputStream = null;
            file3 = null;
            File file4 = file2.getParentFile();
            if (!file4.exists() && !file4.mkdirs()) {
                throw new IOException("Destination directory does not exist and cannot be created");
            }
            file3 = new File(file4, file2.getName() + ".tmp");
            gZIPInputStream = new GZIPInputStream(new BufferedInputStream(new FileInputStream(file)));
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file3));
            IOUtils.copy((InputStream)gZIPInputStream, (OutputStream)bufferedOutputStream);
            ((InputStream)gZIPInputStream).close();
            ((OutputStream)bufferedOutputStream).close();
            if (this.verify(file3, string2)) break block9;
            Log.w((String)LOGTAG, (String)"Checksum of extracted file does not match.");
            IOUtils.safeStreamClose((Closeable)gZIPInputStream);
            IOUtils.safeStreamClose((Closeable)bufferedOutputStream);
            if (file3 != null && file3.exists()) {
                file3.delete();
            }
            return;
        }
        try {
            this.move(file3, file2);
        }
        catch (IOException iOException) {
            try {
                throw new BaseAction.RecoverableDownloadContentException(2, (Throwable)iOException);
            }
            catch (Throwable throwable) {
                IOUtils.safeStreamClose(gZIPInputStream);
                IOUtils.safeStreamClose(bufferedOutputStream);
                if (file3 != null && file3.exists()) {
                    file3.delete();
                }
                throw throwable;
            }
        }
        IOUtils.safeStreamClose((Closeable)gZIPInputStream);
        IOUtils.safeStreamClose((Closeable)bufferedOutputStream);
        if (file3 != null && file3.exists()) {
            file3.delete();
        }
    }

    protected boolean isConnectedToNetwork(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected();
    }

    protected boolean isActiveNetworkMetered(Context context) {
        return ConnectivityManagerCompat.isActiveNetworkMetered((ConnectivityManager)((ConnectivityManager)context.getSystemService("connectivity")));
    }

    protected String createDownloadURL(DownloadContent downloadContent) {
        String string2 = downloadContent.getLocation();
        return CDN_BASE_URL + downloadContent.getLocation();
    }

    protected File createTemporaryFile(Context context, DownloadContent downloadContent) throws BaseAction.RecoverableDownloadContentException {
        File file = new File(context.getCacheDir(), CACHE_DIRECTORY);
        if (!file.exists() && !file.mkdirs()) {
            throw new BaseAction.RecoverableDownloadContentException(2, "Could not create cache directory: " + file);
        }
        return new File(file, downloadContent.getDownloadChecksum() + "-" + downloadContent.getId());
    }

    protected void move(File file, File file2) throws BaseAction.RecoverableDownloadContentException, BaseAction.UnrecoverableDownloadContentException {
        if (!file.renameTo(file2)) {
            Log.d((String)LOGTAG, (String)"Could not move temporary file to destination. Trying to copy..");
            this.copy(file, file2);
            file.delete();
        }
    }

    protected void copy(File file, File file2) throws BaseAction.RecoverableDownloadContentException, BaseAction.UnrecoverableDownloadContentException {
        BufferedInputStream bufferedInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            File file3 = file2.getParentFile();
            if (!file3.exists() && !file3.mkdirs()) {
                throw new IOException("Destination directory does not exist and cannot be created");
            }
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            IOUtils.copy((InputStream)bufferedInputStream, (OutputStream)bufferedOutputStream);
            ((InputStream)bufferedInputStream).close();
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (IOException iOException) {
            try {
                throw new BaseAction.RecoverableDownloadContentException(2, (Throwable)iOException);
            }
            catch (Throwable throwable) {
                IOUtils.safeStreamClose(bufferedInputStream);
                IOUtils.safeStreamClose(bufferedOutputStream);
                throw throwable;
            }
        }
        IOUtils.safeStreamClose((Closeable)bufferedInputStream);
        IOUtils.safeStreamClose((Closeable)bufferedOutputStream);
    }

    protected boolean hasEnoughDiskSpace(DownloadContent downloadContent, File file, File file2) {
        File file3 = file2.getParentFile();
        if (file3.getUsableSpace() < downloadContent.getSize()) {
            return false;
        }
        File file4 = file.getParentFile();
        return file4.getUsableSpace() >= downloadContent.getSize() * 2L;
    }

    public static interface Callback {
        public void onContentDownloaded(DownloadContent var1);
    }
}

