/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.dlc.catalog;

import android.text.TextUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.dlc.catalog.DownloadContent;

public class DownloadContentBuilder {
    private static final String LOCAL_KEY_ID = "id";
    private static final String LOCAL_KEY_LOCATION = "location";
    private static final String LOCAL_KEY_FILENAME = "filename";
    private static final String LOCAL_KEY_CHECKSUM = "checksum";
    private static final String LOCAL_KEY_DOWNLOAD_CHECKSUM = "download_checksum";
    private static final String LOCAL_KEY_LAST_MODIFIED = "last_modified";
    private static final String LOCAL_KEY_TYPE = "type";
    private static final String LOCAL_KEY_KIND = "kind";
    private static final String LOCAL_KEY_SIZE = "size";
    private static final String LOCAL_KEY_STATE = "state";
    private static final String LOCAL_KEY_FAILURES = "failures";
    private static final String LOCAL_KEY_LAST_FAILURE_TYPE = "last_failure_type";
    private static final String LOCAL_KEY_PATTERN_APP_ID = "pattern_app_id";
    private static final String LOCAL_KEY_PATTERN_ANDROID_API = "pattern_android_api";
    private static final String LOCAL_KEY_PATTERN_APP_VERSION = "pattern_app_version";
    private static final String KINTO_KEY_ID = "id";
    private static final String KINTO_KEY_ATTACHMENT = "attachment";
    private static final String KINTO_KEY_ORIGINAL = "original";
    private static final String KINTO_KEY_LOCATION = "location";
    private static final String KINTO_KEY_FILENAME = "filename";
    private static final String KINTO_KEY_HASH = "hash";
    private static final String KINTO_KEY_LAST_MODIFIED = "last_modified";
    private static final String KINTO_KEY_TYPE = "type";
    private static final String KINTO_KEY_KIND = "kind";
    private static final String KINTO_KEY_SIZE = "size";
    private static final String KINTO_KEY_MATCH = "match";
    private static final String KINTO_KEY_APP_ID = "appId";
    private static final String KINTO_KEY_ANDROID_API = "androidApi";
    private static final String KINTO_KEY_APP_VERSION = "appVersion";
    private String id;
    private String location;
    private String filename;
    private String checksum;
    private String downloadChecksum;
    private long lastModified;
    private String type;
    private String kind;
    private long size;
    private int state;
    private int failures;
    private int lastFailureType;
    private String appVersionPattern;
    private String androidApiPattern;
    private String appIdPattern;

    public static DownloadContentBuilder buildUpon(DownloadContent downloadContent) {
        DownloadContentBuilder downloadContentBuilder = new DownloadContentBuilder();
        downloadContentBuilder.id = downloadContent.getId();
        downloadContentBuilder.location = downloadContent.getLocation();
        downloadContentBuilder.filename = downloadContent.getFilename();
        downloadContentBuilder.checksum = downloadContent.getChecksum();
        downloadContentBuilder.downloadChecksum = downloadContent.getDownloadChecksum();
        downloadContentBuilder.lastModified = downloadContent.getLastModified();
        downloadContentBuilder.type = downloadContent.getType();
        downloadContentBuilder.kind = downloadContent.getKind();
        downloadContentBuilder.size = downloadContent.getSize();
        downloadContentBuilder.state = downloadContent.getState();
        downloadContentBuilder.failures = downloadContent.getFailures();
        downloadContentBuilder.lastFailureType = downloadContent.getLastFailureType();
        return downloadContentBuilder;
    }

    public static DownloadContent fromJSON(JSONObject jSONObject) throws JSONException {
        return new DownloadContentBuilder().setId(jSONObject.getString("id")).setLocation(jSONObject.getString("location")).setFilename(jSONObject.getString("filename")).setChecksum(jSONObject.getString(LOCAL_KEY_CHECKSUM)).setDownloadChecksum(jSONObject.getString(LOCAL_KEY_DOWNLOAD_CHECKSUM)).setLastModified(jSONObject.getLong("last_modified")).setType(jSONObject.getString("type")).setKind(jSONObject.getString("kind")).setSize(jSONObject.getLong("size")).setState(jSONObject.getInt(LOCAL_KEY_STATE)).setFailures(jSONObject.optInt(LOCAL_KEY_FAILURES), jSONObject.optInt(LOCAL_KEY_LAST_FAILURE_TYPE)).setAppVersionPattern(jSONObject.optString(LOCAL_KEY_PATTERN_APP_VERSION)).setAppIdPattern(jSONObject.optString(LOCAL_KEY_PATTERN_APP_ID)).setAndroidApiPattern(jSONObject.optString(LOCAL_KEY_PATTERN_ANDROID_API)).build();
    }

    public static JSONObject toJSON(DownloadContent downloadContent) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("id", (Object)downloadContent.getId());
        jSONObject.put("location", (Object)downloadContent.getLocation());
        jSONObject.put("filename", (Object)downloadContent.getFilename());
        jSONObject.put(LOCAL_KEY_CHECKSUM, (Object)downloadContent.getChecksum());
        jSONObject.put(LOCAL_KEY_DOWNLOAD_CHECKSUM, (Object)downloadContent.getDownloadChecksum());
        jSONObject.put("last_modified", downloadContent.getLastModified());
        jSONObject.put("type", (Object)downloadContent.getType());
        jSONObject.put("kind", (Object)downloadContent.getKind());
        jSONObject.put("size", downloadContent.getSize());
        jSONObject.put(LOCAL_KEY_STATE, downloadContent.getState());
        jSONObject.put(LOCAL_KEY_PATTERN_APP_VERSION, (Object)downloadContent.getAppVersionPattern());
        jSONObject.put(LOCAL_KEY_PATTERN_APP_ID, (Object)downloadContent.getAppIdPattern());
        jSONObject.put(LOCAL_KEY_PATTERN_ANDROID_API, (Object)downloadContent.getAndroidApiPattern());
        int n = downloadContent.getFailures();
        if (n > 0) {
            jSONObject.put(LOCAL_KEY_FAILURES, n);
            jSONObject.put(LOCAL_KEY_LAST_FAILURE_TYPE, downloadContent.getLastFailureType());
        }
        return jSONObject;
    }

    public DownloadContent build() {
        DownloadContent downloadContent = new DownloadContent(this.id, this.location, this.filename, this.checksum, this.downloadChecksum, this.lastModified, this.type, this.kind, this.size, this.failures, this.lastFailureType, this.appVersionPattern, this.androidApiPattern, this.appIdPattern);
        downloadContent.setState(this.state);
        return downloadContent;
    }

    public DownloadContentBuilder setId(String string2) {
        this.id = string2;
        return this;
    }

    public DownloadContentBuilder setLocation(String string2) {
        this.location = string2;
        return this;
    }

    public DownloadContentBuilder setFilename(String string2) {
        this.filename = string2;
        return this;
    }

    public DownloadContentBuilder setChecksum(String string2) {
        this.checksum = string2;
        return this;
    }

    public DownloadContentBuilder setDownloadChecksum(String string2) {
        this.downloadChecksum = string2;
        return this;
    }

    public DownloadContentBuilder setLastModified(long l) {
        this.lastModified = l;
        return this;
    }

    public DownloadContentBuilder setType(String string2) {
        this.type = string2;
        return this;
    }

    public DownloadContentBuilder setKind(String string2) {
        this.kind = string2;
        return this;
    }

    public DownloadContentBuilder setSize(long l) {
        this.size = l;
        return this;
    }

    public DownloadContentBuilder setState(int n) {
        this.state = n;
        return this;
    }

    DownloadContentBuilder setFailures(int n, int n2) {
        this.failures = n;
        this.lastFailureType = n2;
        return this;
    }

    public DownloadContentBuilder setAppVersionPattern(String string2) {
        this.appVersionPattern = string2;
        return this;
    }

    public DownloadContentBuilder setAndroidApiPattern(String string2) {
        this.androidApiPattern = string2;
        return this;
    }

    public DownloadContentBuilder setAppIdPattern(String string2) {
        this.appIdPattern = string2;
        return this;
    }

    public DownloadContentBuilder updateFromKinto(JSONObject jSONObject) throws JSONException {
        String string2 = jSONObject.getString("id");
        if (TextUtils.isEmpty((CharSequence)this.id)) {
            this.id = string2;
        } else if (!this.id.equals(string2)) {
            throw new JSONException(String.format("Record ids do not match: Expected=%s, Actual=%s", this.id, string2));
        }
        this.setType(jSONObject.getString("type"));
        this.setKind(jSONObject.getString("kind"));
        this.setLastModified(jSONObject.getLong("last_modified"));
        JSONObject jSONObject2 = jSONObject.getJSONObject(KINTO_KEY_ORIGINAL);
        this.setFilename(jSONObject2.getString("filename"));
        this.setChecksum(jSONObject2.getString(KINTO_KEY_HASH));
        this.setSize(jSONObject2.getLong("size"));
        JSONObject jSONObject3 = jSONObject.getJSONObject(KINTO_KEY_ATTACHMENT);
        this.setLocation(jSONObject3.getString("location"));
        this.setDownloadChecksum(jSONObject3.getString(KINTO_KEY_HASH));
        JSONObject jSONObject4 = jSONObject.optJSONObject(KINTO_KEY_MATCH);
        if (jSONObject4 != null) {
            this.setAndroidApiPattern(jSONObject4.optString(KINTO_KEY_ANDROID_API));
            this.setAppIdPattern(jSONObject4.optString(KINTO_KEY_APP_ID));
            this.setAppVersionPattern(jSONObject4.optString(KINTO_KEY_APP_VERSION));
        }
        return this;
    }
}

