/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.favicons;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mozilla.gecko.AboutPages;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.favicons.LoadFaviconTask;
import org.mozilla.gecko.favicons.OnFaviconLoadedListener;
import org.mozilla.gecko.favicons.cache.FaviconCache;
import org.mozilla.gecko.util.GeckoJarReader;
import org.mozilla.gecko.util.NonEvictingLruCache;
import org.mozilla.gecko.util.ThreadUtils;

public class Favicons {
    private static final String LOGTAG = "GeckoFavicons";
    private static final String BUILT_IN_FAVICON_URL = "about:favicon";
    private static final String BUILT_IN_SEARCH_URL = "about:search";
    public static final int FAVICON_CACHE_SIZE_BYTES = 524288;
    public static final int NUM_PAGE_URL_MAPPINGS_TO_STORE = 128;
    public static final int NOT_LOADING = 0;
    public static final int LOADED = 1;
    public static Bitmap defaultFavicon;
    public static int defaultFaviconSize;
    public static int largestFaviconSize;
    public static int browserToolbarFaviconSize;
    public static final AtomicBoolean isInitialized;
    public static final ExecutorService longRunningExecutor;
    private static final SparseArray<LoadFaviconTask> loadTasks;
    private static final NonEvictingLruCache<String, String> pageURLMappings;
    private static final HashSet<String> sDecodableMimeTypes;
    private static final HashSet<String> sContainerMimeTypes;
    private static FaviconCache faviconsCache;

    public static String getFaviconURLForPageURLFromCache(String string2) {
        return (String)pageURLMappings.get((Object)string2);
    }

    public static void putFaviconURLForPageURLInCache(String string2, String string3) {
        pageURLMappings.put((Object)string2, (Object)string3);
    }

    public static int selectBestSizeFromList(List<Integer> list, int n) {
        Collections.sort(list);
        for (int n2 : list) {
            if (n2 < n) continue;
            return n2;
        }
        if (list.size() > 0) {
            return list.get(list.size() - 1);
        }
        return -1;
    }

    static int dispatchResult(final String string2, final String string3, final Bitmap bitmap, final OnFaviconLoadedListener onFaviconLoadedListener) {
        if (onFaviconLoadedListener == null) {
            return 0;
        }
        if (ThreadUtils.isOnUiThread()) {
            onFaviconLoadedListener.onFaviconLoaded(string2, string3, bitmap);
            return 1;
        }
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                onFaviconLoadedListener.onFaviconLoaded(string2, string3, bitmap);
            }
        });
        return 0;
    }

    public static int getSizedFavicon(Context context, String string2, String string3, int n, int n2, OnFaviconLoadedListener onFaviconLoadedListener) {
        String string4 = string3;
        if (string4 == null) {
            string4 = (String)pageURLMappings.get((Object)string2);
        }
        if (string4 == null) {
            string4 = Favicons.guessDefaultFaviconURL(string2);
        }
        if (string4 == null) {
            return Favicons.dispatchResult(string2, null, defaultFavicon, onFaviconLoadedListener);
        }
        Bitmap bitmap = Favicons.getSizedFaviconFromCache(string4, n);
        if (bitmap != null) {
            return Favicons.dispatchResult(string2, string4, bitmap, onFaviconLoadedListener);
        }
        if (faviconsCache.isFailedFavicon(string4)) {
            return Favicons.dispatchResult(string2, string4, defaultFavicon, onFaviconLoadedListener);
        }
        return Favicons.loadUncachedFavicon(context, string2, string3, n2, n, onFaviconLoadedListener);
    }

    public static Bitmap getSizedFaviconFromCache(String string2, int n) {
        return faviconsCache.getFaviconForDimensions(string2, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSizedFaviconForPageFromLocal(Context context, String string2, int n, OnFaviconLoadedListener onFaviconLoadedListener) {
        Object object;
        String string3 = (String)pageURLMappings.get((Object)string2);
        if (string3 != null) {
            if (faviconsCache.isFailedFavicon(string3)) {
                return Favicons.dispatchResult(string2, string3, null, onFaviconLoadedListener);
            }
            object = Favicons.getSizedFaviconFromCache(string3, n);
            if (object != null) {
                return Favicons.dispatchResult(string2, string3, (Bitmap)object, onFaviconLoadedListener);
            }
        }
        object = new LoadFaviconTask(context, string2, string3, 0, onFaviconLoadedListener, n, true);
        int n2 = ((LoadFaviconTask)object).getId();
        SparseArray<LoadFaviconTask> sparseArray = loadTasks;
        synchronized (sparseArray) {
            loadTasks.put(n2, object);
        }
        ((LoadFaviconTask)object).execute();
        return n2;
    }

    public static int getSizedFaviconForPageFromLocal(Context context, String string2, OnFaviconLoadedListener onFaviconLoadedListener) {
        return Favicons.getSizedFaviconForPageFromLocal(context, string2, defaultFaviconSize, onFaviconLoadedListener);
    }

    public static String getFaviconURLForPageURL(BrowserDB browserDB, ContentResolver contentResolver, String string2) {
        String string3;
        Tab tab = Tabs.getInstance().getFirstTabForUrl(string2);
        if (tab != null && (string3 = tab.getFaviconURL()) != null) {
            return string3;
        }
        string3 = browserDB.getFaviconURLFromPageURL(contentResolver, string2);
        if (string3 != null) {
            return string3;
        }
        return Favicons.guessDefaultFaviconURL(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int loadUncachedFavicon(Context context, String string2, String string3, int n, int n2, OnFaviconLoadedListener onFaviconLoadedListener) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            Favicons.dispatchResult(null, null, null, onFaviconLoadedListener);
            return 0;
        }
        LoadFaviconTask loadFaviconTask = new LoadFaviconTask(context, string2, string3, n, onFaviconLoadedListener, n2, false);
        int n3 = loadFaviconTask.getId();
        SparseArray<LoadFaviconTask> sparseArray = loadTasks;
        synchronized (sparseArray) {
            loadTasks.put(n3, (Object)loadFaviconTask);
        }
        loadFaviconTask.execute();
        return n3;
    }

    public static void putFaviconInMemCache(String string2, Bitmap bitmap) {
        faviconsCache.putSingleFavicon(string2, bitmap);
    }

    public static void putFaviconsInMemCache(String string2, Iterator<Bitmap> iterator, boolean bl) {
        faviconsCache.putFavicons(string2, iterator, bl);
    }

    public static void putFaviconsInMemCache(String string2, Iterator<Bitmap> iterator) {
        Favicons.putFaviconsInMemCache(string2, iterator, false);
    }

    public static void clearMemCache() {
        faviconsCache.evictAll();
        pageURLMappings.evictAll();
    }

    public static void putFaviconInFailedCache(String string2) {
        faviconsCache.putFailed(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean cancelFaviconLoad(int n) {
        if (n == 0) {
            return false;
        }
        SparseArray<LoadFaviconTask> sparseArray = loadTasks;
        synchronized (sparseArray) {
            if (loadTasks.indexOfKey(n) < 0) {
                return false;
            }
            Log.v((String)LOGTAG, (String)("Cancelling favicon load " + n + "."));
            LoadFaviconTask loadFaviconTask = (LoadFaviconTask)loadTasks.get(n);
            return loadFaviconTask.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close() {
        Log.d((String)LOGTAG, (String)"Closing Favicons database");
        longRunningExecutor.shutdown();
        SparseArray<LoadFaviconTask> sparseArray = loadTasks;
        synchronized (sparseArray) {
            int n = loadTasks.size();
            for (int i = 0; i < n; ++i) {
                Favicons.cancelFaviconLoad(loadTasks.keyAt(i));
            }
            loadTasks.clear();
        }
    }

    public static int getFaviconColor(String string2) {
        return faviconsCache.getDominantColor(string2);
    }

    public static void initializeWithContext(Context context) throws IllegalStateException {
        if (!isInitialized.compareAndSet(false, true)) {
            return;
        }
        Resources resources = context.getResources();
        Drawable drawable2 = resources.getDrawable(R.drawable.toolbar_favicon_default);
        if (!(drawable2 instanceof BitmapDrawable)) {
            throw new IllegalStateException("toolbar_favicon_default wasn't a bitmap resource!");
        }
        defaultFavicon = ((BitmapDrawable)drawable2).getBitmap();
        defaultFaviconSize = resources.getDimensionPixelSize(R.dimen.favicon_bg);
        largestFaviconSize = resources.getDimensionPixelSize(R.dimen.favicon_largest_interesting_size);
        browserToolbarFaviconSize = resources.getDimensionPixelSize(R.dimen.browser_toolbar_favicon_size);
        faviconsCache = new FaviconCache(524288, largestFaviconSize);
        for (String string2 : AboutPages.getDefaultIconPages()) {
            pageURLMappings.putWithoutEviction((Object)string2, (Object)BUILT_IN_FAVICON_URL);
        }
        List<Bitmap> list = Arrays.asList(Favicons.loadBrandingBitmap(context, "favicon64.png"), Favicons.loadBrandingBitmap(context, "favicon32.png"));
        Favicons.putFaviconsInMemCache(BUILT_IN_FAVICON_URL, list.iterator(), true);
        pageURLMappings.putWithoutEviction((Object)"about:home", (Object)BUILT_IN_SEARCH_URL);
        List<Bitmap> list2 = Collections.singletonList(BitmapFactory.decodeResource((Resources)resources, (int)R.drawable.search_icon_inactive));
        Favicons.putFaviconsInMemCache(BUILT_IN_SEARCH_URL, list2.iterator(), true);
    }

    private static String getBrandingBitmapPath(Context context, String string2) {
        return GeckoJarReader.getJarURL((Context)context, (String)("chrome/chrome/content/branding/" + string2));
    }

    private static Bitmap loadBrandingBitmap(Context context, String string2) {
        Bitmap bitmap = GeckoJarReader.getBitmap((Context)context, (Resources)context.getResources(), (String)Favicons.getBrandingBitmapPath(context, string2));
        if (bitmap == null) {
            throw new IllegalStateException("Bitmap " + string2 + " missing from JAR!");
        }
        return bitmap;
    }

    public static String guessDefaultFaviconURL(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        if (AboutPages.isAboutPage(string2) || string2.startsWith("jar:")) {
            return string2;
        }
        try {
            Uri uri = Uri.parse((String)string2);
            Uri.Builder builder = new Uri.Builder();
            builder.scheme(uri.getScheme()).authority(uri.getAuthority()).appendPath("favicon.ico");
            return builder.build().toString();
        }
        catch (Exception exception) {
            Log.d((String)LOGTAG, (String)"Exception getting default favicon URL");
            return null;
        }
    }

    public static boolean canDecodeType(String string2) {
        return "".equals(string2) || sDecodableMimeTypes.contains(string2);
    }

    public static boolean isContainerType(String string2) {
        return sDecodableMimeTypes.contains(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLoadTask(int n) {
        SparseArray<LoadFaviconTask> sparseArray = loadTasks;
        synchronized (sparseArray) {
            loadTasks.delete(n);
        }
    }

    static boolean isFailedFavicon(String string2) {
        return faviconsCache.isFailedFavicon(string2);
    }

    public static void getPreferredSizeFaviconForPage(Context context, String string2, String string3, OnFaviconLoadedListener onFaviconLoadedListener) {
        int n = GeckoAppShell.getPreferredIconSize();
        Favicons.loadUncachedFavicon(context, string2, string3, 2, n, onFaviconLoadedListener);
    }

    public static void getPreferredIconForHomeScreenShortcut(Context context, String string2, OnFaviconLoadedListener onFaviconLoadedListener) {
        ThreadUtils.assertOnBackgroundThread();
        BrowserDB browserDB = GeckoProfile.get(context).getDB();
        ContentResolver contentResolver = context.getContentResolver();
        Map<String, Map<String, Object>> map = browserDB.getURLMetadata().getForURLs(contentResolver, Collections.singletonList(string2), Collections.singletonList("touchIcon"));
        Map<String, Object> map2 = map.get(string2);
        String string3 = null;
        if (map2 != null) {
            string3 = (String)map2.get("touchIcon");
        }
        Favicons.getPreferredSizeFaviconForPage(context, string2, string3, onFaviconLoadedListener);
    }

    static {
        isInitialized = new AtomicBoolean(false);
        longRunningExecutor = Executors.newSingleThreadExecutor();
        loadTasks = new SparseArray();
        pageURLMappings = new NonEvictingLruCache(128);
        sDecodableMimeTypes = new HashSet();
        sContainerMimeTypes = new HashSet();
        sContainerMimeTypes.add("image/vnd.microsoft.icon");
        sContainerMimeTypes.add("image/ico");
        sContainerMimeTypes.add("image/icon");
        sContainerMimeTypes.add("image/x-icon");
        sContainerMimeTypes.add("text/ico");
        sContainerMimeTypes.add("application/ico");
        sDecodableMimeTypes.addAll(sContainerMimeTypes);
        sDecodableMimeTypes.add("image/png");
        sDecodableMimeTypes.add("application/png");
        sDecodableMimeTypes.add("application/x-png");
        sDecodableMimeTypes.add("image/gif");
        sDecodableMimeTypes.add("image/jpeg");
        sDecodableMimeTypes.add("image/jpg");
        sDecodableMimeTypes.add("image/pipeg");
        sDecodableMimeTypes.add("image/vnd.swiftview-jpeg");
        sDecodableMimeTypes.add("application/jpg");
        sDecodableMimeTypes.add("application/x-jpg");
        sDecodableMimeTypes.add("application/bmp");
        sDecodableMimeTypes.add("application/x-bmp");
        sDecodableMimeTypes.add("application/x-win-bitmap");
        sDecodableMimeTypes.add("image/bmp");
        sDecodableMimeTypes.add("image/x-bmp");
        sDecodableMimeTypes.add("image/x-bitmap");
        sDecodableMimeTypes.add("image/x-xbitmap");
        sDecodableMimeTypes.add("image/x-win-bitmap");
        sDecodableMimeTypes.add("image/x-windows-bitmap");
        sDecodableMimeTypes.add("image/x-ms-bitmap");
        sDecodableMimeTypes.add("image/x-ms-bmp");
        sDecodableMimeTypes.add("image/ms-bmp");
    }
}

