/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.feeds.action;

import android.app.Notification;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.NotificationManagerCompat;
import android.support.v4.content.ContextCompat;
import android.text.format.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.json.JSONException;
import org.mozilla.gecko.BrowserApp;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.db.UrlAnnotations;
import org.mozilla.gecko.feeds.FeedFetcher;
import org.mozilla.gecko.feeds.FeedService;
import org.mozilla.gecko.feeds.action.FeedAction;
import org.mozilla.gecko.feeds.parser.Feed;
import org.mozilla.gecko.feeds.subscriptions.FeedSubscription;
import org.mozilla.gecko.preferences.GeckoPreferences;
import org.mozilla.gecko.util.StringUtils;

public class CheckForUpdatesAction
extends FeedAction {
    public static final String EXTRA_CONTENT_NOTIFICATION = "content-notification";
    private static final String LOGTAG = "FeedCheckAction";
    private Context context;

    public CheckForUpdatesAction(Context context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform(BrowserDB browserDB, Intent intent) {
        UrlAnnotations urlAnnotations = browserDB.getUrlAnnotations();
        ContentResolver contentResolver = this.context.getContentResolver();
        ArrayList<Feed> arrayList = new ArrayList<Feed>();
        this.log("Checking feeds for updates..");
        Cursor cursor = urlAnnotations.getFeedSubscriptions(contentResolver);
        if (cursor == null) {
            return;
        }
        try {
            while (cursor.moveToNext()) {
                FeedSubscription feedSubscription = FeedSubscription.fromCursor(cursor);
                FeedFetcher.FeedResponse feedResponse = this.checkFeedForUpdates(feedSubscription);
                if (feedResponse == null) continue;
                arrayList.add(feedResponse.feed);
                urlAnnotations.updateFeedSubscription(contentResolver, feedSubscription);
            }
        }
        catch (JSONException jSONException) {
            this.log("Could not deserialize subscription", jSONException);
        }
        finally {
            cursor.close();
        }
        this.showNotification(arrayList);
    }

    private FeedFetcher.FeedResponse checkFeedForUpdates(FeedSubscription feedSubscription) {
        this.log("Checking feed: " + feedSubscription.getFeedTitle());
        FeedFetcher.FeedResponse feedResponse = this.fetchFeed(feedSubscription);
        if (feedResponse == null) {
            return null;
        }
        if (feedSubscription.hasBeenUpdated(feedResponse)) {
            this.log("* Feed has changed. New item: " + feedResponse.feed.getLastItem().getTitle());
            feedSubscription.update(feedResponse);
            return feedResponse;
        }
        return null;
    }

    private void showNotification(List<Feed> list) {
        int n = list.size();
        if (n == 0) {
            return;
        }
        if (n == 1) {
            this.showNotificationForSingleUpdate(list.get(0));
        } else {
            this.showNotificationForMultipleUpdates(list);
        }
        Telemetry.startUISession(TelemetryContract.Session.EXPERIMENT, FeedService.getEnabledExperiment(this.context));
        Telemetry.sendUIEvent(TelemetryContract.Event.SHOW, TelemetryContract.Method.NOTIFICATION, "content_update");
        Telemetry.stopUISession(TelemetryContract.Session.EXPERIMENT, FeedService.getEnabledExperiment(this.context));
    }

    private void showNotificationForSingleUpdate(Feed feed) {
        String string2 = DateFormat.getMediumDateFormat((Context)this.context).format(new Date(feed.getLastItem().getTimestamp()));
        NotificationCompat.BigTextStyle bigTextStyle = new NotificationCompat.BigTextStyle().bigText((CharSequence)feed.getLastItem().getTitle()).setBigContentTitle((CharSequence)feed.getTitle()).setSummaryText((CharSequence)this.context.getString(R.string.content_notification_updated_on, new Object[]{string2}));
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setComponent(new ComponentName(this.context, BrowserApp.class));
        intent.setData(Uri.parse((String)feed.getLastItem().getURL()));
        intent.putExtra(EXTRA_CONTENT_NOTIFICATION, true);
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)this.context, (int)0, (Intent)intent, (int)0);
        Notification notification = new NotificationCompat.Builder(this.context).setSmallIcon(R.drawable.ic_status_logo).setContentTitle((CharSequence)feed.getTitle()).setContentText((CharSequence)feed.getLastItem().getTitle()).setStyle((NotificationCompat.Style)bigTextStyle).setColor(ContextCompat.getColor((Context)this.context, (int)R.color.fennec_ui_orange)).setContentIntent(pendingIntent).setAutoCancel(true).addAction(this.createNotificationSettingsAction()).build();
        NotificationManagerCompat.from((Context)this.context).notify(R.id.websiteContentNotification, notification);
    }

    private void showNotificationForMultipleUpdates(List<Feed> list) {
        String string2;
        Feed feed2;
        ArrayList<String> arrayList = new ArrayList<String>();
        NotificationCompat.InboxStyle inboxStyle = new NotificationCompat.InboxStyle();
        for (Feed feed2 : list) {
            string2 = feed2.getLastItem().getURL();
            inboxStyle.addLine((CharSequence)StringUtils.stripScheme((String)string2, (int)1));
            arrayList.add(string2);
        }
        inboxStyle.setSummaryText((CharSequence)this.context.getString(R.string.content_notification_summary));
        Intent intent = new Intent(this.context, BrowserApp.class);
        intent.setAction("org.mozilla.fennec.action.VIEW_MULTIPLE");
        intent.putStringArrayListExtra("urls", arrayList);
        intent.putExtra(EXTRA_CONTENT_NOTIFICATION, true);
        feed2 = PendingIntent.getActivity((Context)this.context, (int)0, (Intent)intent, (int)0);
        string2 = new NotificationCompat.Builder(this.context).setSmallIcon(R.drawable.ic_status_logo).setContentTitle((CharSequence)this.context.getString(R.string.content_notification_title_plural, new Object[]{list.size()})).setContentText((CharSequence)this.context.getString(R.string.content_notification_summary)).setStyle((NotificationCompat.Style)inboxStyle).setColor(ContextCompat.getColor((Context)this.context, (int)R.color.fennec_ui_orange)).setContentIntent((PendingIntent)feed2).setAutoCancel(true).setNumber(list.size()).addAction(this.createNotificationSettingsAction()).build();
        NotificationManagerCompat.from((Context)this.context).notify(R.id.websiteContentNotification, (Notification)string2);
    }

    private NotificationCompat.Action createNotificationSettingsAction() {
        Intent intent = new Intent("org.mozilla.gecko.SETTINGS");
        intent.setClassName("org.mozilla.fennec", "org.mozilla.gecko.BrowserApp");
        intent.putExtra(EXTRA_CONTENT_NOTIFICATION, true);
        GeckoPreferences.setResourceToOpen(intent, "preferences_notifications");
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)this.context, (int)0, (Intent)intent, (int)0x8000000);
        return new NotificationCompat.Action(R.drawable.firefox_settings_alert, (CharSequence)this.context.getString(R.string.content_notification_action_settings), pendingIntent);
    }

    private FeedFetcher.FeedResponse fetchFeed(FeedSubscription feedSubscription) {
        return FeedFetcher.fetchAndParseFeedIfModified(feedSubscription.getFeedUrl(), feedSubscription.getETag(), feedSubscription.getLastModified());
    }

    @Override
    public boolean requiresNetwork() {
        return true;
    }

    @Override
    public boolean requiresPreferenceEnabled() {
        return true;
    }
}

