/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.database.Cursor;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.R;
import org.mozilla.gecko.db.RemoteClient;
import org.mozilla.gecko.db.RemoteTab;
import org.mozilla.gecko.home.CombinedHistoryItem;
import org.mozilla.gecko.home.CombinedHistoryPanel;
import org.mozilla.gecko.home.HomeContextMenuInfo;
import org.mozilla.gecko.home.RemoteTabsExpandableListState;

public class CombinedHistoryAdapter
extends RecyclerView.Adapter<CombinedHistoryItem> {
    private static final String LOGTAG = "GeckoCombinedHistAdapt";
    private List<RemoteClient> remoteClients = Collections.emptyList();
    private List<RemoteTab> clientChildren;
    private int remoteClientIndexOfParent = -1;
    private Cursor historyCursor;
    protected static RemoteTabsExpandableListState sState;
    protected final List<RemoteClient> hiddenClients = new ArrayList<RemoteClient>();
    private final SparseArray<CombinedHistoryPanel.SectionHeader> sectionHeaders;
    private final Context context;

    public CombinedHistoryAdapter(Context context, int n) {
        this.context = context;
        this.sectionHeaders = new SparseArray();
        if (sState == null) {
            sState = new RemoteTabsExpandableListState(GeckoSharedPrefs.forProfile(context));
        }
        this.remoteClientIndexOfParent = n;
    }

    public void setClients(List<RemoteClient> list) {
        this.hiddenClients.clear();
        this.remoteClients.clear();
        Iterator<RemoteClient> iterator = list.iterator();
        while (iterator.hasNext()) {
            RemoteClient remoteClient = iterator.next();
            if (!sState.isClientHidden(remoteClient.guid)) continue;
            this.hiddenClients.add(remoteClient);
            iterator.remove();
        }
        this.remoteClients = list;
        if (!this.hiddenClients.isEmpty()) {
            this.remoteClients.add(null);
        }
        this.notifyItemRangeChanged(0, this.remoteClients.size());
    }

    public void setHistory(Cursor cursor) {
        this.historyCursor = cursor;
        CombinedHistoryAdapter.populateSectionHeaders(this.historyCursor, this.sectionHeaders);
        this.notifyDataSetChanged();
    }

    public void removeItem(int n) {
        ItemType itemType = this.getItemTypeForPosition(n);
        switch (itemType) {
            case CLIENT: {
                boolean bl = !this.hiddenClients.isEmpty();
                RemoteClient remoteClient = this.remoteClients.remove(this.transformAdapterPositionForDataStructure(ItemType.CLIENT, n));
                this.notifyItemRemoved(n);
                sState.setClientHidden(remoteClient.guid, true);
                this.hiddenClients.add(remoteClient);
                if (!bl) {
                    this.remoteClients.add(null);
                    break;
                }
                this.notifyItemChanged(this.remoteClients.size() - 1);
                break;
            }
            case HISTORY: {
                this.notifyItemRemoved(n);
            }
        }
    }

    public void unhideClients(List<RemoteClient> list) {
        if (list.size() == 0) {
            return;
        }
        for (RemoteClient remoteClient : list) {
            sState.setClientHidden(remoteClient.guid, false);
            this.hiddenClients.remove(remoteClient);
        }
        int n = this.remoteClients.size() - 1;
        this.remoteClients.addAll(n, list);
        this.notifyItemRangeInserted(n, list.size());
        if (this.hiddenClients.isEmpty()) {
            this.remoteClients.remove(this.remoteClients.size() - 1);
        } else {
            this.notifyItemChanged(this.remoteClients.size() - 1);
        }
    }

    public List<RemoteClient> getHiddenClients() {
        return this.hiddenClients;
    }

    public JSONArray getCurrentChildTabs() {
        if (this.clientChildren != null) {
            JSONArray jSONArray = new JSONArray();
            for (int i = 1; i < this.clientChildren.size(); ++i) {
                jSONArray.put((Object)this.clientChildren.get((int)i).url);
            }
            return jSONArray;
        }
        return null;
    }

    public int getParentIndex() {
        return this.remoteClientIndexOfParent;
    }

    private boolean isInChildView() {
        return this.remoteClientIndexOfParent != -1;
    }

    public void showChildView(int n) {
        if (this.clientChildren == null) {
            this.clientChildren = new ArrayList<RemoteTab>();
        }
        this.clientChildren.add(null);
        this.remoteClientIndexOfParent = this.transformAdapterPositionForDataStructure(ItemType.CLIENT, n);
        this.clientChildren.addAll(this.remoteClients.get((int)this.remoteClientIndexOfParent).tabs);
        this.notifyDataSetChanged();
    }

    public boolean exitChildView() {
        if (!this.isInChildView()) {
            return false;
        }
        this.remoteClientIndexOfParent = -1;
        this.clientChildren.clear();
        this.notifyDataSetChanged();
        return true;
    }

    private ItemType getItemTypeForPosition(int n) {
        return ItemType.viewTypeToItemType(this.getItemViewType(n));
    }

    private int transformAdapterPositionForDataStructure(ItemType itemType, int n) {
        if (itemType == ItemType.CLIENT) {
            return n;
        }
        if (itemType == ItemType.SECTION_HEADER) {
            return n - this.remoteClients.size();
        }
        if (itemType == ItemType.HISTORY) {
            return n - this.remoteClients.size() - this.getHeadersBefore(n);
        }
        return n;
    }

    public HomeContextMenuInfo makeContextMenuInfoFromPosition(View view, int n) {
        ItemType itemType = this.getItemTypeForPosition(n);
        switch (itemType) {
            case CHILD: {
                HomeContextMenuInfo homeContextMenuInfo = new HomeContextMenuInfo(view, n, -1L);
                return CombinedHistoryPanel.populateChildInfoFromTab(homeContextMenuInfo, this.clientChildren.get(n));
            }
            case HISTORY: {
                HomeContextMenuInfo homeContextMenuInfo = new HomeContextMenuInfo(view, n, -1L);
                this.historyCursor.moveToPosition(this.transformAdapterPositionForDataStructure(ItemType.HISTORY, n));
                return CombinedHistoryPanel.populateHistoryInfoFromCursor(homeContextMenuInfo, this.historyCursor);
            }
            case CLIENT: {
                int n2 = this.transformAdapterPositionForDataStructure(ItemType.CLIENT, n);
                CombinedHistoryPanel.RemoteTabsClientContextMenuInfo remoteTabsClientContextMenuInfo = new CombinedHistoryPanel.RemoteTabsClientContextMenuInfo(view, n, -1L, this.remoteClients.get(n2));
                return remoteTabsClientContextMenuInfo;
            }
        }
        return null;
    }

    public CombinedHistoryItem onCreateViewHolder(ViewGroup viewGroup, int n) {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)viewGroup.getContext());
        ItemType itemType = ItemType.viewTypeToItemType(n);
        switch (itemType) {
            case CLIENT: {
                View view = layoutInflater.inflate(R.layout.home_remote_tabs_group, viewGroup, false);
                return new CombinedHistoryItem.ClientItem(view);
            }
            case HIDDEN_DEVICES: {
                View view = layoutInflater.inflate(R.layout.home_remote_tabs_hidden_devices, viewGroup, false);
                return new CombinedHistoryItem.BasicItem(view);
            }
            case NAVIGATION_BACK: {
                View view = layoutInflater.inflate(R.layout.home_combined_back_item, viewGroup, false);
                return new CombinedHistoryItem.HistoryItem(view);
            }
            case SECTION_HEADER: {
                View view = layoutInflater.inflate(R.layout.home_header_row, viewGroup, false);
                return new CombinedHistoryItem.BasicItem(view);
            }
            case HISTORY: 
            case CHILD: {
                View view = layoutInflater.inflate(R.layout.home_item_row, viewGroup, false);
                return new CombinedHistoryItem.HistoryItem(view);
            }
        }
        throw new IllegalArgumentException("Unexpected Home Panel item type");
    }

    public int getItemViewType(int n) {
        if (this.isInChildView()) {
            if (n == 0) {
                return ItemType.itemTypeToViewType(ItemType.NAVIGATION_BACK);
            }
            return ItemType.itemTypeToViewType(ItemType.CHILD);
        }
        int n2 = this.remoteClients.size();
        if (n < n2) {
            if (!this.hiddenClients.isEmpty() && n == n2 - 1) {
                return ItemType.itemTypeToViewType(ItemType.HIDDEN_DEVICES);
            }
            return ItemType.itemTypeToViewType(ItemType.CLIENT);
        }
        int n3 = this.transformAdapterPositionForDataStructure(ItemType.SECTION_HEADER, n);
        if (this.sectionHeaders.get(n3) != null) {
            return ItemType.itemTypeToViewType(ItemType.SECTION_HEADER);
        }
        return ItemType.itemTypeToViewType(ItemType.HISTORY);
    }

    public int getItemCount() {
        if (this.isInChildView()) {
            if (this.clientChildren == null) {
                this.clientChildren = new ArrayList<RemoteTab>();
                this.clientChildren.add(null);
                this.clientChildren.addAll(this.remoteClients.get((int)this.remoteClientIndexOfParent).tabs);
            }
            return this.clientChildren.size();
        }
        int n = this.historyCursor == null ? 0 : this.historyCursor.getCount();
        return this.remoteClients.size() + n + this.sectionHeaders.size();
    }

    private static void populateSectionHeaders(Cursor cursor, SparseArray<CombinedHistoryPanel.SectionHeader> sparseArray) {
        sparseArray.clear();
        if (cursor == null || !cursor.moveToFirst()) {
            return;
        }
        CombinedHistoryPanel.SectionHeader sectionHeader = null;
        do {
            int n = cursor.getPosition();
            long l = cursor.getLong(cursor.getColumnIndexOrThrow("date"));
            CombinedHistoryPanel.SectionHeader sectionHeader2 = CombinedHistoryPanel.getSectionFromTime(l);
            if (sectionHeader == sectionHeader2) continue;
            sectionHeader = sectionHeader2;
            sparseArray.append(n + sparseArray.size(), (Object)sectionHeader);
        } while (sectionHeader != CombinedHistoryPanel.SectionHeader.OLDER_THAN_SIX_MONTHS && cursor.moveToNext());
    }

    public boolean containsHistory() {
        if (this.historyCursor == null) {
            return false;
        }
        return this.historyCursor.getCount() > 0;
    }

    public void onBindViewHolder(CombinedHistoryItem combinedHistoryItem, int n) {
        ItemType itemType = this.getItemTypeForPosition(n);
        int n2 = this.transformAdapterPositionForDataStructure(itemType, n);
        switch (itemType) {
            case CLIENT: {
                CombinedHistoryItem.ClientItem clientItem = (CombinedHistoryItem.ClientItem)combinedHistoryItem;
                RemoteClient remoteClient = this.remoteClients.get(n2);
                clientItem.bind(remoteClient, this.context);
                break;
            }
            case HIDDEN_DEVICES: {
                String string2 = this.context.getResources().getString(R.string.home_remote_tabs_many_hidden_devices, new Object[]{this.hiddenClients.size()});
                ((TextView)combinedHistoryItem.itemView).setText((CharSequence)string2);
                break;
            }
            case CHILD: {
                RemoteTab remoteTab = this.clientChildren.get(n);
                ((CombinedHistoryItem.HistoryItem)combinedHistoryItem).bind(remoteTab);
                break;
            }
            case SECTION_HEADER: {
                ((TextView)combinedHistoryItem.itemView).setText((CharSequence)CombinedHistoryPanel.getSectionHeaderTitle((CombinedHistoryPanel.SectionHeader)((Object)this.sectionHeaders.get(n2))));
                break;
            }
            case HISTORY: {
                if (this.historyCursor == null || !this.historyCursor.moveToPosition(n2)) {
                    throw new IllegalStateException("Couldn't move cursor to position " + n2);
                }
                ((CombinedHistoryItem.HistoryItem)combinedHistoryItem).bind(this.historyCursor);
            }
        }
    }

    private int getHeadersBefore(int n) {
        int n2 = n - this.remoteClients.size();
        for (int i = 1; i < this.sectionHeaders.size(); ++i) {
            if (this.sectionHeaders.keyAt(i) <= n2) continue;
            return i;
        }
        return this.sectionHeaders.size();
    }

    public static enum ItemType {
        CLIENT,
        HIDDEN_DEVICES,
        SECTION_HEADER,
        HISTORY,
        NAVIGATION_BACK,
        CHILD;


        public static ItemType viewTypeToItemType(int n) {
            if (n >= ItemType.values().length) {
                Log.e((String)CombinedHistoryAdapter.LOGTAG, (String)"No corresponding ItemType!");
            }
            return ItemType.values()[n];
        }

        public static int itemTypeToViewType(ItemType itemType) {
            return itemType.ordinal();
        }
    }
}

