/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.database.Cursor;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import org.mozilla.gecko.R;
import org.mozilla.gecko.RemoteTabsExpandableListAdapter;
import org.mozilla.gecko.db.RemoteClient;
import org.mozilla.gecko.db.RemoteTab;
import org.mozilla.gecko.home.TwoLinePageRow;

public abstract class CombinedHistoryItem
extends RecyclerView.ViewHolder {
    public CombinedHistoryItem(View view) {
        super(view);
    }

    public static class ClientItem
    extends CombinedHistoryItem {
        final TextView nameView;
        final ImageView deviceTypeView;
        final TextView lastModifiedView;

        public ClientItem(View view) {
            super(view);
            this.nameView = (TextView)view.findViewById(R.id.client);
            this.deviceTypeView = (ImageView)view.findViewById(R.id.device_type);
            this.lastModifiedView = (TextView)view.findViewById(R.id.last_synced);
        }

        public void bind(RemoteClient remoteClient, Context context) {
            this.nameView.setText((CharSequence)remoteClient.name);
            this.nameView.setTextColor(ContextCompat.getColor((Context)context, (int)R.color.placeholder_active_grey));
            this.deviceTypeView.setImageResource("desktop".equals(remoteClient.deviceType) ? R.drawable.sync_desktop : R.drawable.sync_mobile);
            long l = System.currentTimeMillis();
            this.lastModifiedView.setText((CharSequence)RemoteTabsExpandableListAdapter.getLastSyncedString(context, l, remoteClient.lastModified));
        }
    }

    public static class HistoryItem
    extends CombinedHistoryItem {
        public HistoryItem(View view) {
            super(view);
        }

        public void bind(Cursor cursor) {
            TwoLinePageRow twoLinePageRow = (TwoLinePageRow)this.itemView;
            twoLinePageRow.setShowIcons(true);
            twoLinePageRow.updateFromCursor(cursor);
        }

        public void bind(RemoteTab remoteTab) {
            TwoLinePageRow twoLinePageRow = (TwoLinePageRow)this.itemView;
            twoLinePageRow.setShowIcons(true);
            twoLinePageRow.update(remoteTab.title, remoteTab.url);
        }
    }

    public static class BasicItem
    extends CombinedHistoryItem {
        public BasicItem(View view) {
            super(view);
        }
    }
}

