/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.app.AlertDialog;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Configuration;
import android.database.Cursor;
import android.os.Bundle;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.support.v7.widget.DefaultItemAnimator;
import android.support.v7.widget.RecyclerView;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.text.style.UnderlineSpan;
import android.util.Log;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.R;
import org.mozilla.gecko.RemoteClientsDialogFragment;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.db.RemoteClient;
import org.mozilla.gecko.db.RemoteTab;
import org.mozilla.gecko.home.CombinedHistoryAdapter;
import org.mozilla.gecko.home.CombinedHistoryRecyclerView;
import org.mozilla.gecko.home.HistorySectionsHelper;
import org.mozilla.gecko.home.HomeContextMenuInfo;
import org.mozilla.gecko.home.HomeFragment;
import org.mozilla.gecko.home.SimpleCursorLoader;
import org.mozilla.gecko.restrictions.Restrictable;
import org.mozilla.gecko.restrictions.Restrictions;
import org.mozilla.gecko.widget.DividerItemDecoration;

public class CombinedHistoryPanel
extends HomeFragment
implements RemoteClientsDialogFragment.RemoteClientsListener {
    private static final String LOGTAG = "GeckoCombinedHistoryPnl";
    private final int LOADER_ID_HISTORY = 0;
    private final int LOADER_ID_REMOTE = 1;
    private static final HistorySectionsHelper.SectionDateRange[] sectionDateRangeArray = new HistorySectionsHelper.SectionDateRange[SectionHeader.values().length];
    private static final String FORMAT_S1 = "%1$s";
    private static final String FORMAT_S2 = "%2$s";
    private CombinedHistoryRecyclerView mRecyclerView;
    private CombinedHistoryAdapter mAdapter;
    private CursorLoaderCallbacks mCursorLoaderCallbacks;
    private int mSavedParentIndex = -1;
    private OnPanelLevelChangeListener.PanelLevel mPanelLevel = OnPanelLevelChangeListener.PanelLevel.PARENT;
    private Button mPanelFooterButton;
    private View mEmptyView;

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return layoutInflater.inflate(R.layout.home_combined_history_panel, viewGroup, false);
    }

    public void onViewCreated(View view, Bundle bundle) {
        super.onViewCreated(view, bundle);
        this.mRecyclerView = (CombinedHistoryRecyclerView)view.findViewById(R.id.combined_recycler_view);
        this.mAdapter = new CombinedHistoryAdapter(this.getContext(), this.mSavedParentIndex);
        this.mRecyclerView.setAdapter(this.mAdapter);
        this.mRecyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
        this.mRecyclerView.addItemDecoration(new DividerItemDecoration(this.getContext()));
        this.mRecyclerView.setOnHistoryClickedListener(this.mUrlOpenListener);
        this.mRecyclerView.setOnPanelLevelChangeListener(new OnLevelChangeListener());
        this.mRecyclerView.setHiddenClientsDialogBuilder(new HiddenClientsHelper());
        this.registerForContextMenu((View)this.mRecyclerView);
        this.mPanelFooterButton = (Button)view.findViewById(R.id.clear_history_button);
        this.mPanelFooterButton.setOnClickListener((View.OnClickListener)new OnFooterButtonClickListener());
    }

    public void onActivityCreated(Bundle bundle) {
        super.onActivityCreated(bundle);
        this.mCursorLoaderCallbacks = new CursorLoaderCallbacks();
    }

    @Override
    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        if (this.isVisible()) {
            this.mSavedParentIndex = this.mAdapter.getParentIndex();
        }
    }

    @Override
    protected void load() {
        this.getLoaderManager().initLoader(0, null, (LoaderManager.LoaderCallbacks)this.mCursorLoaderCallbacks);
        this.getLoaderManager().initLoader(1, null, (LoaderManager.LoaderCallbacks)this.mCursorLoaderCallbacks);
    }

    protected static String getSectionHeaderTitle(SectionHeader sectionHeader) {
        return CombinedHistoryPanel.sectionDateRangeArray[sectionHeader.ordinal()].displayName;
    }

    protected static SectionHeader getSectionFromTime(long l) {
        for (int i = 0; i < SectionHeader.OLDER_THAN_SIX_MONTHS.ordinal(); ++i) {
            if (l <= CombinedHistoryPanel.sectionDateRangeArray[i].start) continue;
            return SectionHeader.values()[i];
        }
        return SectionHeader.OLDER_THAN_SIX_MONTHS;
    }

    private void updateButtonFromLevel(OnPanelLevelChangeListener.PanelLevel panelLevel) {
        this.mPanelLevel = panelLevel;
        switch (panelLevel) {
            case CHILD: {
                this.mPanelFooterButton.setVisibility(0);
                this.mPanelFooterButton.setText(R.string.home_open_all);
                break;
            }
            case PARENT: {
                boolean bl;
                boolean bl2 = bl = !Restrictions.isAllowed((Context)this.getActivity(), Restrictable.CLEAR_HISTORY);
                if (bl || !this.mAdapter.containsHistory()) {
                    this.mPanelFooterButton.setVisibility(8);
                    break;
                }
                this.mPanelFooterButton.setVisibility(0);
                this.mPanelFooterButton.setText(R.string.home_clear_history_button);
            }
        }
    }

    private void updateEmptyView(boolean bl) {
        if (bl) {
            if (this.mEmptyView == null) {
                ViewStub viewStub = (ViewStub)this.getView().findViewById(R.id.home_empty_view_stub);
                this.mEmptyView = viewStub.inflate();
                ImageView imageView = (ImageView)this.mEmptyView.findViewById(R.id.home_empty_image);
                imageView.setImageResource(R.drawable.icon_most_recent_empty);
                TextView textView = (TextView)this.mEmptyView.findViewById(R.id.home_empty_text);
                textView.setText(R.string.home_most_recent_empty);
                TextView textView2 = (TextView)this.mEmptyView.findViewById(R.id.home_empty_hint);
                String string2 = this.getResources().getString(R.string.home_most_recent_emptyhint);
                SpannableStringBuilder spannableStringBuilder = this.formatHintText(string2);
                if (spannableStringBuilder != null) {
                    textView2.setText((CharSequence)spannableStringBuilder);
                    textView2.setMovementMethod(LinkMovementMethod.getInstance());
                    textView2.setVisibility(0);
                }
                if (!Restrictions.isAllowed((Context)this.getActivity(), Restrictable.PRIVATE_BROWSING)) {
                    textView2.setVisibility(8);
                }
            }
            this.mEmptyView.setVisibility(0);
        } else if (this.mEmptyView != null) {
            this.mEmptyView.setVisibility(8);
        }
    }

    private SpannableStringBuilder formatHintText(String string2) {
        int n;
        int n2 = string2.indexOf(FORMAT_S1);
        if (n2 >= (n = string2.indexOf(FORMAT_S2))) {
            return null;
        }
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder((CharSequence)string2);
        ClickableSpan clickableSpan = new ClickableSpan(){

            public void onClick(View view) {
                Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.PANEL, "hint-private-browsing");
                try {
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put("type", (Object)"Menu:Open");
                    EventDispatcher.getInstance().dispatchEvent(jSONObject, null);
                }
                catch (JSONException jSONException) {
                    Log.e((String)CombinedHistoryPanel.LOGTAG, (String)"Error forming JSON for Private Browsing contextual hint", (Throwable)jSONException);
                }
            }
        };
        spannableStringBuilder.setSpan((Object)clickableSpan, 0, string2.length(), 0);
        UnderlineSpan underlineSpan = new UnderlineSpan(){

            public void updateDrawState(TextPaint textPaint) {
                textPaint.setUnderlineText(false);
            }
        };
        spannableStringBuilder.setSpan((Object)underlineSpan, 0, string2.length(), 0);
        spannableStringBuilder.setSpan((Object)new UnderlineSpan(), n2, n, 0);
        spannableStringBuilder.delete(n, n + FORMAT_S2.length());
        spannableStringBuilder.delete(n2, n2 + FORMAT_S1.length());
        return spannableStringBuilder;
    }

    @Override
    public void onCreateContextMenu(ContextMenu contextMenu, View view, ContextMenu.ContextMenuInfo contextMenuInfo) {
        if (!(contextMenuInfo instanceof RemoteTabsClientContextMenuInfo)) {
            super.onCreateContextMenu(contextMenu, view, contextMenuInfo);
            return;
        }
        MenuInflater menuInflater = new MenuInflater(view.getContext());
        menuInflater.inflate(R.menu.home_remote_tabs_client_contextmenu, (Menu)contextMenu);
        RemoteTabsClientContextMenuInfo remoteTabsClientContextMenuInfo = (RemoteTabsClientContextMenuInfo)contextMenuInfo;
        contextMenu.setHeaderTitle((CharSequence)remoteTabsClientContextMenuInfo.client.name);
    }

    @Override
    public boolean onContextItemSelected(MenuItem menuItem) {
        if (super.onContextItemSelected(menuItem)) {
            return true;
        }
        ContextMenu.ContextMenuInfo contextMenuInfo = menuItem.getMenuInfo();
        if (!(contextMenuInfo instanceof RemoteTabsClientContextMenuInfo)) {
            return false;
        }
        RemoteTabsClientContextMenuInfo remoteTabsClientContextMenuInfo = (RemoteTabsClientContextMenuInfo)contextMenuInfo;
        int n = menuItem.getItemId();
        if (n == R.id.home_remote_tabs_hide_client) {
            this.mAdapter.removeItem(remoteTabsClientContextMenuInfo.position);
            return true;
        }
        return false;
    }

    @Override
    public void onClients(List<RemoteClient> list) {
        this.mAdapter.unhideClients(list);
    }

    protected static HomeContextMenuInfo populateHistoryInfoFromCursor(HomeContextMenuInfo homeContextMenuInfo, Cursor cursor) {
        homeContextMenuInfo.url = cursor.getString(cursor.getColumnIndexOrThrow("url"));
        homeContextMenuInfo.title = cursor.getString(cursor.getColumnIndexOrThrow("title"));
        homeContextMenuInfo.historyId = cursor.getInt(cursor.getColumnIndexOrThrow("history_id"));
        homeContextMenuInfo.itemType = HomeContextMenuInfo.RemoveItemType.HISTORY;
        int n = cursor.getColumnIndexOrThrow("bookmark_id");
        homeContextMenuInfo.bookmarkId = cursor.isNull(n) ? -1 : cursor.getInt(n);
        return homeContextMenuInfo;
    }

    protected static HomeContextMenuInfo populateChildInfoFromTab(HomeContextMenuInfo homeContextMenuInfo, RemoteTab remoteTab) {
        homeContextMenuInfo.url = remoteTab.url;
        homeContextMenuInfo.title = remoteTab.title;
        return homeContextMenuInfo;
    }

    protected static class RemoteTabsClientContextMenuInfo
    extends HomeContextMenuInfo {
        protected final RemoteClient client;

        public RemoteTabsClientContextMenuInfo(View view, int n, long l, RemoteClient remoteClient) {
            super(view, n, l);
            this.client = remoteClient;
        }
    }

    protected class HiddenClientsHelper
    implements DialogBuilder<RemoteClient> {
        protected HiddenClientsHelper() {
        }

        @Override
        public void createAndShowDialog(List<RemoteClient> list) {
            RemoteClientsDialogFragment remoteClientsDialogFragment = RemoteClientsDialogFragment.newInstance(CombinedHistoryPanel.this.getResources().getString(R.string.home_remote_tabs_hidden_devices_title), CombinedHistoryPanel.this.getResources().getString(R.string.home_remote_tabs_unhide_selected_devices), RemoteClientsDialogFragment.ChoiceMode.MULTIPLE, new ArrayList<RemoteClient>(list));
            remoteClientsDialogFragment.setTargetFragment(CombinedHistoryPanel.this, 0);
            remoteClientsDialogFragment.show(CombinedHistoryPanel.this.getActivity().getSupportFragmentManager(), "show-clients");
        }
    }

    static interface DialogBuilder<E> {
        public void createAndShowDialog(List<E> var1);
    }

    private class OnFooterButtonClickListener
    implements View.OnClickListener {
        private OnFooterButtonClickListener() {
        }

        public void onClick(View view) {
            switch (CombinedHistoryPanel.this.mPanelLevel) {
                case PARENT: {
                    AlertDialog.Builder builder = new AlertDialog.Builder((Context)CombinedHistoryPanel.this.getActivity());
                    builder.setMessage(R.string.home_clear_history_confirm);
                    builder.setNegativeButton(R.string.button_cancel, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialogInterface, int n) {
                            dialogInterface.dismiss();
                        }
                    });
                    builder.setPositiveButton(R.string.button_ok, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialogInterface, int n) {
                            dialogInterface.dismiss();
                            JSONObject jSONObject = new JSONObject();
                            try {
                                jSONObject.put("history", true);
                            }
                            catch (JSONException jSONException) {
                                Log.e((String)CombinedHistoryPanel.LOGTAG, (String)"JSON error", (Throwable)jSONException);
                            }
                            GeckoAppShell.notifyObservers("Sanitize:ClearData", jSONObject.toString());
                            Telemetry.sendUIEvent(TelemetryContract.Event.SANITIZE, TelemetryContract.Method.BUTTON, "history");
                        }
                    });
                    builder.show();
                    break;
                }
                case CHILD: {
                    JSONArray jSONArray = CombinedHistoryPanel.this.mAdapter.getCurrentChildTabs();
                    if (jSONArray == null) break;
                    JSONObject jSONObject = new JSONObject();
                    try {
                        jSONObject.put("urls", (Object)jSONArray);
                        jSONObject.put("shouldNotifyTabsOpenedToJava", false);
                        GeckoAppShell.notifyObservers("Tabs:OpenMultiple", jSONObject.toString());
                        break;
                    }
                    catch (JSONException jSONException) {
                        Log.e((String)CombinedHistoryPanel.LOGTAG, (String)"Error making JSON message to open tabs");
                    }
                }
            }
        }
    }

    protected class OnLevelChangeListener
    implements OnPanelLevelChangeListener {
        protected OnLevelChangeListener() {
        }

        @Override
        public void onPanelLevelChange(OnPanelLevelChangeListener.PanelLevel panelLevel) {
            CombinedHistoryPanel.this.updateButtonFromLevel(panelLevel);
        }
    }

    private class CursorLoaderCallbacks
    implements LoaderManager.LoaderCallbacks<Cursor> {
        private BrowserDB mDB;

        private CursorLoaderCallbacks() {
        }

        public Loader<Cursor> onCreateLoader(int n, Bundle bundle) {
            if (this.mDB == null) {
                this.mDB = GeckoProfile.get((Context)CombinedHistoryPanel.this.getActivity()).getDB();
            }
            switch (n) {
                case 0: {
                    return new HistoryCursorLoader(CombinedHistoryPanel.this.getContext());
                }
                case 1: {
                    return new RemoteTabsCursorLoader(CombinedHistoryPanel.this.getContext());
                }
            }
            Log.e((String)CombinedHistoryPanel.LOGTAG, (String)"Unknown loader id!");
            return null;
        }

        public void onLoadFinished(Loader<Cursor> loader, Cursor cursor) {
            int n = loader.getId();
            switch (n) {
                case 0: {
                    CombinedHistoryPanel.this.mAdapter.setHistory(cursor);
                    break;
                }
                case 1: {
                    List<RemoteClient> list = this.mDB.getTabsAccessor().getClientsFromCursor(cursor);
                    CombinedHistoryPanel.this.mAdapter.setClients(list);
                }
            }
            CombinedHistoryPanel.this.updateButtonFromLevel(CombinedHistoryPanel.this.mPanelLevel);
            CombinedHistoryPanel.this.updateEmptyView(CombinedHistoryPanel.this.mAdapter.getItemCount() == 0);
        }

        public void onLoaderReset(Loader<Cursor> loader) {
            CombinedHistoryPanel.this.mAdapter.setClients(Collections.emptyList());
            CombinedHistoryPanel.this.mAdapter.setHistory(null);
        }
    }

    private static class HistoryCursorLoader
    extends SimpleCursorLoader {
        private static final int HISTORY_LIMIT = 100;
        private final BrowserDB mDB;

        public HistoryCursorLoader(Context context) {
            super(context);
            this.mDB = GeckoProfile.get(context).getDB();
        }

        @Override
        public Cursor loadCursor() {
            ContentResolver contentResolver = this.getContext().getContentResolver();
            HistorySectionsHelper.updateRecentSectionOffset(this.getContext().getResources(), sectionDateRangeArray);
            return this.mDB.getRecentHistory(contentResolver, 100);
        }
    }

    private static class RemoteTabsCursorLoader
    extends SimpleCursorLoader {
        private final GeckoProfile mProfile;

        public RemoteTabsCursorLoader(Context context) {
            super(context);
            this.mProfile = GeckoProfile.get(context);
        }

        @Override
        public Cursor loadCursor() {
            return this.mProfile.getDB().getTabsAccessor().getRemoteTabsCursor(this.getContext());
        }
    }

    public static interface OnPanelLevelChangeListener {
        public void onPanelLevelChange(PanelLevel var1);

        public static enum PanelLevel {
            PARENT,
            CHILD;

        }
    }

    public static enum SectionHeader {
        TODAY,
        YESTERDAY,
        WEEK,
        THIS_MONTH,
        MONTH_AGO,
        TWO_MONTHS_AGO,
        THREE_MONTHS_AGO,
        FOUR_MONTHS_AGO,
        FIVE_MONTHS_AGO,
        OLDER_THAN_SIX_MONTHS;

    }
}

