/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.tabs;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoApplication;
import org.mozilla.gecko.R;
import org.mozilla.gecko.tabs.TabHistoryItemRow;
import org.mozilla.gecko.tabs.TabHistoryPage;

public class TabHistoryFragment
extends Fragment
implements AdapterView.OnItemClickListener,
View.OnClickListener {
    private static final String ARG_LIST = "historyPageList";
    private static final String ARG_INDEX = "index";
    private static final String BACK_STACK_ID = "backStateId";
    private List<TabHistoryPage> historyPageList;
    private int toIndex;
    private ListView dialogList;
    private int backStackId = -1;
    private ViewGroup parent;
    private boolean dismissed;

    public static TabHistoryFragment newInstance(List<TabHistoryPage> list, int n) {
        TabHistoryFragment tabHistoryFragment = new TabHistoryFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList(ARG_LIST, (ArrayList)list);
        bundle.putInt(ARG_INDEX, n);
        tabHistoryFragment.setArguments(bundle);
        return tabHistoryFragment;
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        if (bundle != null) {
            this.backStackId = bundle.getInt(BACK_STACK_ID, -1);
        }
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        this.parent = viewGroup;
        this.parent.setVisibility(0);
        View view = layoutInflater.inflate(R.layout.tab_history_layout, viewGroup, false);
        view.setOnClickListener((View.OnClickListener)this);
        this.dialogList = (ListView)view.findViewById(R.id.tab_history_list);
        this.dialogList.setDivider(null);
        return view;
    }

    public void onActivityCreated(Bundle bundle) {
        super.onActivityCreated(bundle);
        Bundle bundle2 = this.getArguments();
        this.historyPageList = bundle2.getParcelableArrayList(ARG_LIST);
        this.toIndex = bundle2.getInt(ARG_INDEX);
        TabHistoryAdapter tabHistoryAdapter = new TabHistoryAdapter((Context)this.getActivity(), this.historyPageList);
        this.dialogList.setAdapter((ListAdapter)tabHistoryAdapter);
        this.dialogList.setOnItemClickListener((AdapterView.OnItemClickListener)this);
    }

    public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
        String string2 = String.valueOf(this.toIndex - n);
        GeckoAppShell.notifyObservers("Session:Navigate", string2);
        this.dismiss();
    }

    public void onClick(View view) {
        this.dismiss();
    }

    public void onPause() {
        super.onPause();
        this.dismiss();
    }

    public void onDestroy() {
        super.onDestroy();
        this.dismiss();
        GeckoApplication.watchReference((Context)this.getActivity(), (Object)this);
    }

    public void onSaveInstanceState(Bundle bundle) {
        if (this.backStackId >= 0) {
            bundle.putInt(BACK_STACK_ID, this.backStackId);
        }
    }

    public void show(int n, FragmentTransaction fragmentTransaction, String string2) {
        this.dismissed = false;
        fragmentTransaction.add(n, (Fragment)this, string2);
        fragmentTransaction.addToBackStack(string2);
        this.backStackId = fragmentTransaction.commit();
    }

    public void dismiss() {
        if (this.dismissed) {
            return;
        }
        this.dismissed = true;
        if (this.backStackId >= 0) {
            this.getFragmentManager().popBackStackImmediate(this.backStackId, 1);
            this.backStackId = -1;
        }
        if (this.parent != null) {
            this.parent.setVisibility(8);
        }
    }

    private static class TabHistoryAdapter
    extends ArrayAdapter<TabHistoryPage> {
        private final List<TabHistoryPage> pages;
        private final Context context;

        public TabHistoryAdapter(Context context, List<TabHistoryPage> list) {
            super(context, R.layout.tab_history_item_row, list);
            this.context = context;
            this.pages = list;
        }

        public View getView(int n, View view, ViewGroup viewGroup) {
            TabHistoryItemRow tabHistoryItemRow = (TabHistoryItemRow)view;
            if (tabHistoryItemRow == null) {
                tabHistoryItemRow = new TabHistoryItemRow(this.context, null);
            }
            tabHistoryItemRow.update(this.pages.get(n), n == 0, n == this.pages.size() - 1);
            return tabHistoryItemRow;
        }
    }
}

