/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.telemetry.pings;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.Locale;
import org.mozilla.gecko.Locales;
import org.mozilla.gecko.telemetry.pings.TelemetryPingBuilder;
import org.mozilla.gecko.util.Experiments;
import org.mozilla.gecko.util.StringUtils;

public class TelemetryCorePingBuilder
extends TelemetryPingBuilder {
    private static final String NAME = "core";
    private static final int VERSION_VALUE = 4;
    private static final String OS_VALUE = "Android";
    private static final String ARCHITECTURE = "arch";
    private static final String CLIENT_ID = "clientId";
    private static final String DEFAULT_SEARCH_ENGINE = "defaultSearch";
    private static final String DEVICE = "device";
    private static final String DISTRIBUTION_ID = "distributionId";
    private static final String EXPERIMENTS = "experiments";
    private static final String LOCALE = "locale";
    private static final String OS_ATTR = "os";
    private static final String OS_VERSION = "osversion";
    private static final String PROFILE_CREATION_DATE = "profileDate";
    private static final String SEQ = "seq";
    private static final String VERSION_ATTR = "v";

    public TelemetryCorePingBuilder(Context context, String string2) {
        super(string2);
        this.initPayloadConstants(context);
    }

    private void initPayloadConstants(Context context) {
        this.payload.put(VERSION_ATTR, 4);
        this.payload.put(OS_ATTR, OS_VALUE);
        String string2 = StringUtils.safeSubstring((String)Build.MANUFACTURER, (int)0, (int)12) + '-' + StringUtils.safeSubstring((String)Build.MODEL, (int)0, (int)19);
        this.payload.put(ARCHITECTURE, "x86");
        this.payload.put(DEVICE, string2);
        this.payload.put(LOCALE, Locales.getLanguageTag((Locale)Locale.getDefault()));
        this.payload.put(OS_VERSION, Integer.toString(Build.VERSION.SDK_INT));
        this.payload.putArray(EXPERIMENTS, Experiments.getActiveExperiments(context));
    }

    @Override
    String getDocType() {
        return NAME;
    }

    @Override
    String[] getMandatoryFields() {
        return new String[]{ARCHITECTURE, CLIENT_ID, DEFAULT_SEARCH_ENGINE, DEVICE, LOCALE, OS_ATTR, OS_VERSION, PROFILE_CREATION_DATE, SEQ, VERSION_ATTR};
    }

    public TelemetryCorePingBuilder setClientID(@NonNull String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("Expected non-null clientID");
        }
        this.payload.put(CLIENT_ID, string2);
        return this;
    }

    public TelemetryCorePingBuilder setDefaultSearchEngine(@Nullable String string2) {
        if (string2 != null && string2.isEmpty()) {
            throw new IllegalArgumentException("Received empty string. Expected identifier or null.");
        }
        this.payload.put(DEFAULT_SEARCH_ENGINE, string2);
        return this;
    }

    public TelemetryCorePingBuilder setOptDistributionID(@NonNull String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("Expected non-null distribution ID");
        }
        this.payload.put(DISTRIBUTION_ID, string2);
        return this;
    }

    public TelemetryCorePingBuilder setProfileCreationDate(@Nullable Long l) {
        if (l != null && l < 0L) {
            throw new IllegalArgumentException("Expect positive date value. Received: " + l);
        }
        this.payload.put(PROFILE_CREATION_DATE, l.longValue());
        return this;
    }

    public TelemetryCorePingBuilder setSequenceNumber(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Expected positive sequence number. Recived: " + n);
        }
        this.payload.put(SEQ, n);
        return this;
    }
}

