/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.telemetry.pings;

import java.util.Set;
import java.util.UUID;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.telemetry.pings.TelemetryPing;

abstract class TelemetryPingBuilder {
    private static final String SERVER_INITIAL_PATH = "submit/telemetry";
    private final String serverUrl;
    protected final ExtendedJSONObject payload;

    public TelemetryPingBuilder(String string2) {
        this.serverUrl = TelemetryPingBuilder.getTelemetryServerURL(this.getDocType(), string2);
        this.payload = new ExtendedJSONObject();
    }

    abstract String getDocType();

    abstract String[] getMandatoryFields();

    public TelemetryPing build() {
        this.validatePayload();
        return new TelemetryPing(this.serverUrl, this.payload);
    }

    private void validatePayload() {
        Set set = this.payload.keySet();
        for (String string2 : this.getMandatoryFields()) {
            if (set.contains(string2)) continue;
            throw new IllegalArgumentException("Builder does not contain mandatory field: " + string2);
        }
    }

    private static String getTelemetryServerURL(String string2, String string3) {
        String string4 = UUID.randomUUID().toString();
        return string3 + '/' + SERVER_INITIAL_PATH + '/' + string4 + '/' + string2 + '/' + "Fennec" + '/' + "48.0a1" + '/' + "nightly-oak" + '/' + "20160419040205";
    }
}

