/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.toolbar;

import android.content.Context;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.mozilla.gecko.AboutPages;
import org.mozilla.gecko.BrowserApp;
import org.mozilla.gecko.R;
import org.mozilla.gecko.SiteIdentity;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.animation.PropertyAnimator;
import org.mozilla.gecko.animation.ViewHelper;
import org.mozilla.gecko.reader.ReaderModeUtils;
import org.mozilla.gecko.toolbar.BrowserToolbarTabletBase;
import org.mozilla.gecko.toolbar.PageActionLayout;
import org.mozilla.gecko.toolbar.SiteIdentityPopup;
import org.mozilla.gecko.toolbar.ToolbarPrefs;
import org.mozilla.gecko.util.HardwareUtils;
import org.mozilla.gecko.util.StringUtils;
import org.mozilla.gecko.widget.themed.ThemedLinearLayout;
import org.mozilla.gecko.widget.themed.ThemedTextView;

public class ToolbarDisplayLayout
extends ThemedLinearLayout {
    private static final String LOGTAG = "GeckoToolbarDisplayLayout";
    private boolean mTrackingProtectionEnabled;
    private final BrowserApp mActivity;
    private UIMode mUiMode;
    private boolean mIsAttached;
    private final ThemedTextView mTitle;
    private final int mTitlePadding;
    private ToolbarPrefs mPrefs;
    private OnTitleChangeListener mTitleChangeListener;
    private final ImageButton mSiteSecurity;
    private final ImageButton mStop;
    private OnStopListener mStopListener;
    private final PageActionLayout mPageActionLayout;
    private final SiteIdentityPopup mSiteIdentityPopup;
    private int mSecurityImageLevel;
    private static final int LEVEL_DEFAULT_GLOBE = 0;
    private static final int LEVEL_WARNING_MINOR = 3;
    private static final int LEVEL_LOCK_DISABLED = 4;
    private static final int LEVEL_SHIELD_ENABLED = 5;
    private static final int LEVEL_SHIELD_DISABLED = 6;
    private static final int LEVEL_SEARCH_ICON = 999;
    private final ForegroundColorSpan mUrlColorSpan;
    private final ForegroundColorSpan mPrivateUrlColorSpan;
    private final ForegroundColorSpan mBlockedColorSpan;
    private final ForegroundColorSpan mDomainColorSpan;
    private final ForegroundColorSpan mPrivateDomainColorSpan;
    private final ForegroundColorSpan mCertificateOwnerColorSpan;

    public ToolbarDisplayLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setOrientation(0);
        this.mActivity = (BrowserApp)context;
        LayoutInflater.from((Context)context).inflate(R.layout.toolbar_display_layout, (ViewGroup)this);
        this.mTitle = (ThemedTextView)this.findViewById(R.id.url_bar_title);
        this.mTitlePadding = this.mTitle.getPaddingRight();
        this.mUrlColorSpan = new ForegroundColorSpan(ContextCompat.getColor((Context)context, (int)R.color.url_bar_urltext));
        this.mPrivateUrlColorSpan = new ForegroundColorSpan(ContextCompat.getColor((Context)context, (int)R.color.url_bar_urltext_private));
        this.mBlockedColorSpan = new ForegroundColorSpan(ContextCompat.getColor((Context)context, (int)R.color.url_bar_blockedtext));
        this.mDomainColorSpan = new ForegroundColorSpan(ContextCompat.getColor((Context)context, (int)R.color.url_bar_domaintext));
        this.mPrivateDomainColorSpan = new ForegroundColorSpan(ContextCompat.getColor((Context)context, (int)R.color.url_bar_domaintext_private));
        this.mCertificateOwnerColorSpan = new ForegroundColorSpan(ContextCompat.getColor((Context)context, (int)R.color.affirmative_green));
        this.mSiteSecurity = (ImageButton)this.findViewById(R.id.site_security);
        this.mSiteIdentityPopup = new SiteIdentityPopup((Context)this.mActivity);
        this.mSiteIdentityPopup.setAnchor((View)this);
        this.mSiteIdentityPopup.setOnVisibilityChangeListener(this.mActivity);
        this.mStop = (ImageButton)this.findViewById(R.id.stop);
        this.mPageActionLayout = (PageActionLayout)this.findViewById(R.id.page_action_layout);
    }

    @Override
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mIsAttached = true;
        this.mSiteSecurity.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ToolbarDisplayLayout.this.mSiteIdentityPopup.show();
            }
        });
        this.mStop.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Tab tab;
                if (ToolbarDisplayLayout.this.mStopListener != null && (tab = ToolbarDisplayLayout.this.mStopListener.onStop()) != null) {
                    ToolbarDisplayLayout.this.updateUiMode(UIMode.DISPLAY);
                }
            }
        });
    }

    @Override
    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mIsAttached = false;
    }

    public void setNextFocusDownId(int n) {
        this.mStop.setNextFocusDownId(n);
        this.mSiteSecurity.setNextFocusDownId(n);
        this.mPageActionLayout.setNextFocusDownId(n);
    }

    void setToolbarPrefs(ToolbarPrefs toolbarPrefs) {
        this.mPrefs = toolbarPrefs;
    }

    void updateFromTab(@NonNull Tab tab, EnumSet<UpdateFlags> enumSet) {
        if (!this.mIsAttached) {
            return;
        }
        if (enumSet.contains((Object)UpdateFlags.TITLE)) {
            this.updateTitle(tab);
        }
        if (enumSet.contains((Object)UpdateFlags.SITE_IDENTITY)) {
            this.updateSiteIdentity(tab);
        }
        if (enumSet.contains((Object)UpdateFlags.PROGRESS)) {
            this.updateProgress(tab);
        }
        if (enumSet.contains((Object)UpdateFlags.PRIVATE_MODE)) {
            this.mTitle.setPrivateMode(tab.isPrivate());
        }
    }

    void setTitle(CharSequence charSequence) {
        this.mTitle.setText(charSequence);
        if (this.mTitleChangeListener != null) {
            this.mTitleChangeListener.onTitleChange(charSequence);
        }
    }

    private void updateTitle(@NonNull Tab tab) {
        if (tab.isEnteringReaderMode()) {
            return;
        }
        String string2 = tab.getURL();
        if (AboutPages.isTitlelessAboutPage(string2)) {
            this.setTitle(null);
            this.setContentDescription(null);
            return;
        }
        if (tab.getErrorType() == Tab.ErrorType.BLOCKED) {
            String string3 = tab.getDisplayTitle();
            SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder((CharSequence)string3);
            spannableStringBuilder.setSpan((Object)this.mBlockedColorSpan, 0, string3.length(), 18);
            this.setTitle((CharSequence)spannableStringBuilder);
            this.setContentDescription(null);
            return;
        }
        String string4 = tab.getBaseDomain();
        String string5 = this.stripAboutReaderURL(string2);
        if (this.mPrefs.shouldTrimUrls()) {
            string5 = StringUtils.stripCommonSubdomains((String)StringUtils.stripScheme((String)string5));
        }
        this.setContentDescription(string5);
        SiteIdentity siteIdentity = tab.getSiteIdentity();
        if (siteIdentity.hasOwner()) {
            this.updateTitleFromSiteIdentity(siteIdentity);
        } else if (!HardwareUtils.isTablet() && !TextUtils.isEmpty((CharSequence)string4)) {
            this.setTitle(string4);
        } else {
            this.updateAndColorTitleFromFullURL(string5, string4, tab.isPrivate());
        }
    }

    private void updateTitleFromSiteIdentity(SiteIdentity siteIdentity) {
        String string2 = siteIdentity.hasCountry() ? String.format("%s (%s)", siteIdentity.getOwner(), siteIdentity.getCountry()) : siteIdentity.getOwner();
        SpannableString spannableString = new SpannableString((CharSequence)string2);
        spannableString.setSpan((Object)this.mCertificateOwnerColorSpan, 0, string2.length(), 33);
        this.setTitle((CharSequence)spannableString);
    }

    private void updateAndColorTitleFromFullURL(String string2, String string3, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string3)) {
            this.setTitle(string2);
            return;
        }
        int n = string2.indexOf(string3);
        if (n == -1) {
            this.setTitle(string2);
            return;
        }
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder((CharSequence)string2);
        spannableStringBuilder.setSpan((Object)(bl ? this.mPrivateUrlColorSpan : this.mUrlColorSpan), 0, string2.length(), 18);
        spannableStringBuilder.setSpan((Object)(bl ? this.mPrivateDomainColorSpan : this.mDomainColorSpan), n, n + string3.length(), 18);
        this.setTitle((CharSequence)spannableStringBuilder);
    }

    private String stripAboutReaderURL(String string2) {
        if (!AboutPages.isAboutReader(string2)) {
            return string2;
        }
        return ReaderModeUtils.getUrlFromAboutReader(string2);
    }

    private void updateSiteIdentity(@NonNull Tab tab) {
        boolean bl;
        SiteIdentity.TrackingMode trackingMode;
        SiteIdentity.MixedMode mixedMode;
        SiteIdentity.MixedMode mixedMode2;
        SiteIdentity.SecurityMode securityMode;
        SiteIdentity siteIdentity = tab.getSiteIdentity();
        this.mSiteIdentityPopup.setSiteIdentity(siteIdentity);
        if (siteIdentity == null) {
            securityMode = SiteIdentity.SecurityMode.UNKNOWN;
            mixedMode2 = SiteIdentity.MixedMode.UNKNOWN;
            mixedMode = SiteIdentity.MixedMode.UNKNOWN;
            trackingMode = SiteIdentity.TrackingMode.UNKNOWN;
            bl = false;
        } else {
            securityMode = siteIdentity.getSecurityMode();
            mixedMode2 = siteIdentity.getMixedModeActive();
            mixedMode = siteIdentity.getMixedModeDisplay();
            trackingMode = siteIdentity.getTrackingMode();
            bl = siteIdentity.loginInsecure();
        }
        int n = securityMode.ordinal();
        if (securityMode == SiteIdentity.SecurityMode.CHROMEUI) {
            n = 0;
        }
        if (AboutPages.isTitlelessAboutPage(tab.getURL())) {
            n = 999;
        } else if (bl) {
            n = 4;
        } else if (trackingMode == SiteIdentity.TrackingMode.TRACKING_CONTENT_LOADED) {
            n = 6;
        } else if (trackingMode == SiteIdentity.TrackingMode.TRACKING_CONTENT_BLOCKED) {
            n = 5;
        } else if (mixedMode2 == SiteIdentity.MixedMode.MIXED_CONTENT_LOADED) {
            n = 4;
        } else if (mixedMode == SiteIdentity.MixedMode.MIXED_CONTENT_LOADED) {
            n = 3;
        }
        if (this.mSecurityImageLevel != n) {
            this.mSecurityImageLevel = n;
            this.mSiteSecurity.setImageLevel(this.mSecurityImageLevel);
            this.updatePageActions();
        }
        this.mTrackingProtectionEnabled = trackingMode == SiteIdentity.TrackingMode.TRACKING_CONTENT_BLOCKED;
    }

    private void updateProgress(@NonNull Tab tab) {
        boolean bl = tab.getState() == 1;
        this.updateUiMode(bl ? UIMode.PROGRESS : UIMode.DISPLAY);
        if (2 == tab.getState() && this.mTrackingProtectionEnabled) {
            this.mActivity.showTrackingProtectionPromptIfApplicable();
        }
    }

    private void updateUiMode(UIMode uIMode) {
        if (this.mUiMode == uIMode) {
            return;
        }
        this.mUiMode = uIMode;
        if (this.mUiMode == UIMode.PROGRESS) {
            Log.i((String)LOGTAG, (String)("zerdatime " + SystemClock.uptimeMillis() + " - Throbber start"));
        } else {
            Log.i((String)LOGTAG, (String)("zerdatime " + SystemClock.uptimeMillis() + " - Throbber stop"));
        }
        this.updatePageActions();
    }

    private void updatePageActions() {
        boolean bl = this.mUiMode == UIMode.PROGRESS;
        this.mStop.setVisibility(bl ? 0 : 8);
        this.mPageActionLayout.setVisibility(!bl ? 0 : 8);
        this.mTitle.setPadding(0, 0, !bl ? this.mTitlePadding : 0, 0);
    }

    List<View> getFocusOrder() {
        return Arrays.asList(new View[]{this.mSiteSecurity, this.mPageActionLayout, this.mStop});
    }

    void setOnStopListener(OnStopListener onStopListener) {
        this.mStopListener = onStopListener;
    }

    void setOnTitleChangeListener(OnTitleChangeListener onTitleChangeListener) {
        this.mTitleChangeListener = onTitleChangeListener;
    }

    void updateSiteIdentityAnchor(View view) {
        this.mSiteIdentityPopup.setAnchor(view);
    }

    void prepareForwardAnimation(PropertyAnimator propertyAnimator, BrowserToolbarTabletBase.ForwardButtonAnimation forwardButtonAnimation, int n) {
        if (forwardButtonAnimation == BrowserToolbarTabletBase.ForwardButtonAnimation.HIDE) {
            propertyAnimator.attach((View)this.mTitle, PropertyAnimator.Property.TRANSLATION_X, 0.0f);
            propertyAnimator.attach((View)this.mSiteSecurity, PropertyAnimator.Property.TRANSLATION_X, 0.0f);
            ViewHelper.setTranslationX((View)this.mTitle, n);
            ViewHelper.setTranslationX((View)this.mSiteSecurity, n);
        } else {
            propertyAnimator.attach((View)this.mTitle, PropertyAnimator.Property.TRANSLATION_X, n);
            propertyAnimator.attach((View)this.mSiteSecurity, PropertyAnimator.Property.TRANSLATION_X, n);
        }
    }

    void finishForwardAnimation() {
        ViewHelper.setTranslationX((View)this.mTitle, 0.0f);
        ViewHelper.setTranslationX((View)this.mSiteSecurity, 0.0f);
    }

    void prepareStartEditingAnimation() {
        ViewHelper.setAlpha((View)this.mPageActionLayout, 0.0f);
        ViewHelper.setAlpha((View)this.mStop, 0.0f);
    }

    void prepareStopEditingAnimation(PropertyAnimator propertyAnimator) {
        propertyAnimator.attach((View)this.mPageActionLayout, PropertyAnimator.Property.ALPHA, 1.0f);
        propertyAnimator.attach((View)this.mStop, PropertyAnimator.Property.ALPHA, 1.0f);
    }

    boolean dismissSiteIdentityPopup() {
        if (this.mSiteIdentityPopup != null && this.mSiteIdentityPopup.isShowing()) {
            this.mSiteIdentityPopup.dismiss();
            return true;
        }
        return false;
    }

    void destroy() {
        this.mSiteIdentityPopup.destroy();
    }

    static interface OnTitleChangeListener {
        public void onTitleChange(CharSequence var1);
    }

    static interface OnStopListener {
        public Tab onStop();
    }

    private static enum UIMode {
        PROGRESS,
        DISPLAY;

    }

    static enum UpdateFlags {
        TITLE,
        FAVICON,
        PROGRESS,
        SITE_IDENTITY,
        PRIVATE_MODE,
        DISABLE_ANIMATIONS;

    }
}

