/*
 * Decompiled with CFR 0.152.
 */
package com.keepsafe.switchboard;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.keepsafe.switchboard.DeviceUuidFactory;
import com.keepsafe.switchboard.Preferences;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.zip.CRC32;
import org.json.JSONException;
import org.json.JSONObject;

public class SwitchBoard {
    private static final String TAG = "SwitchBoard";
    public static boolean DEBUG = true;
    private static final String IS_EXPERIMENT_ACTIVE = "isActive";
    private static final String EXPERIMENT_VALUES = "values";
    private static final String KEY_SERVER_URL = "mainServerUrl";
    private static final String KEY_CONFIG_RESULTS = "results";
    private static String uuidExtra = null;

    public static void setUUIDFromExtra(String string) {
        uuidExtra = string;
    }

    static void loadConfig(Context context, String string, @NonNull String string2) {
        String string3 = string2;
        URL uRL = SwitchBoard.buildConfigRequestUrl(context, string, string3);
        if (DEBUG) {
            Log.d((String)TAG, (String)("Request URL: " + uRL));
        }
        if (uRL == null) {
            return;
        }
        String string4 = SwitchBoard.readFromUrlGET(uRL);
        if (DEBUG) {
            Log.d((String)TAG, (String)("Result: " + string4));
        }
        if (string4 == null) {
            return;
        }
        try {
            JSONObject jSONObject = new JSONObject(string4);
            String string5 = jSONObject.getString(KEY_SERVER_URL);
            if (!string2.equals(string5)) {
                Preferences.setDynamicConfigServerUrl(context, string5);
            }
            String string6 = jSONObject.getString(KEY_CONFIG_RESULTS);
            Preferences.setDynamicConfigJson(context, string6);
        }
        catch (JSONException jSONException) {
            Log.e((String)TAG, (String)"Exception parsing server result", (Throwable)jSONException);
        }
    }

    @Nullable
    private static URL buildConfigRequestUrl(Context context, String string, String string2) {
        Object object;
        if (string == null) {
            object = new DeviceUuidFactory(context);
            string = ((DeviceUuidFactory)object).getDeviceUuid().toString();
        }
        object = Build.DEVICE;
        String string3 = Build.MANUFACTURER;
        String string4 = "unknown";
        try {
            string4 = Locale.getDefault().getISO3Language();
        }
        catch (MissingResourceException missingResourceException) {
            missingResourceException.printStackTrace();
        }
        String string5 = "unknown";
        try {
            string5 = Locale.getDefault().getISO3Country();
        }
        catch (MissingResourceException missingResourceException) {
            missingResourceException.printStackTrace();
        }
        String string6 = context.getPackageName();
        String string7 = "none";
        try {
            string7 = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
        }
        String string8 = "uuid=" + string + "&device=" + (String)object + "&lang=" + string4 + "&country=" + string5 + "&manufacturer=" + string3 + "&appId=" + string6 + "&version=" + string7;
        try {
            return new URL(string2 + "?" + string8);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }

    public static boolean isInBucket(Context context, int n, int n2) {
        int n3 = SwitchBoard.getUserBucket(context);
        return n3 >= n && n3 < n2;
    }

    public static boolean isInExperiment(Context context, String string) {
        String string2 = Preferences.getDynamicConfigJson(context);
        if (string2 == null) {
            return false;
        }
        try {
            JSONObject jSONObject = new JSONObject(string2).getJSONObject(string);
            return jSONObject != null && jSONObject.getBoolean(IS_EXPERIMENT_ACTIVE);
        }
        catch (JSONException jSONException) {
            return false;
        }
    }

    public static List<String> getActiveExperiments(Context context) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = Preferences.getDynamicConfigJson(context);
        if (string == null) {
            return arrayList;
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                JSONObject jSONObject2 = jSONObject.getJSONObject(string2);
                if (!jSONObject2.getBoolean(IS_EXPERIMENT_ACTIVE)) continue;
                arrayList.add(string2);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return arrayList;
    }

    public static boolean hasExperimentValues(Context context, String string) {
        return SwitchBoard.getExperimentValuesFromJson(context, string) != null;
    }

    public static JSONObject getExperimentValuesFromJson(Context context, String string) {
        String string2 = Preferences.getDynamicConfigJson(context);
        if (string2 == null) {
            return null;
        }
        try {
            JSONObject jSONObject = new JSONObject(string2).getJSONObject(string);
            return jSONObject.getJSONObject(EXPERIMENT_VALUES);
        }
        catch (JSONException jSONException) {
            Log.e((String)TAG, (String)"Could not create JSON object from config string", (Throwable)jSONException);
            return null;
        }
    }

    @Nullable
    private static String readFromUrlGET(URL uRL) {
        try {
            String string;
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setUseCaches(false);
            InputStream inputStream = httpURLConnection.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader, 8192);
            StringBuilder stringBuilder = new StringBuilder();
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
            }
            bufferedReader.close();
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private static int getUserBucket(Context context) {
        Object object;
        String string = uuidExtra;
        if (string == null) {
            object = new DeviceUuidFactory(context);
            string = ((DeviceUuidFactory)object).getDeviceUuid().toString();
        }
        object = new CRC32();
        object.update(string.getBytes());
        long l = ((CRC32)object).getValue();
        return (int)(l % 100L);
    }
}

