/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.execchain;

import ch.boye.httpclientandroidlib.HttpEntityEnclosingRequest;
import ch.boye.httpclientandroidlib.HttpException;
import ch.boye.httpclientandroidlib.HttpHost;
import ch.boye.httpclientandroidlib.ProtocolException;
import ch.boye.httpclientandroidlib.androidextra.HttpClientAndroidLog;
import ch.boye.httpclientandroidlib.annotation.ThreadSafe;
import ch.boye.httpclientandroidlib.auth.AuthScheme;
import ch.boye.httpclientandroidlib.auth.AuthState;
import ch.boye.httpclientandroidlib.client.RedirectException;
import ch.boye.httpclientandroidlib.client.RedirectStrategy;
import ch.boye.httpclientandroidlib.client.config.RequestConfig;
import ch.boye.httpclientandroidlib.client.methods.CloseableHttpResponse;
import ch.boye.httpclientandroidlib.client.methods.HttpExecutionAware;
import ch.boye.httpclientandroidlib.client.methods.HttpRequestWrapper;
import ch.boye.httpclientandroidlib.client.methods.HttpUriRequest;
import ch.boye.httpclientandroidlib.client.protocol.HttpClientContext;
import ch.boye.httpclientandroidlib.client.utils.URIUtils;
import ch.boye.httpclientandroidlib.conn.routing.HttpRoute;
import ch.boye.httpclientandroidlib.conn.routing.HttpRoutePlanner;
import ch.boye.httpclientandroidlib.impl.execchain.ClientExecChain;
import ch.boye.httpclientandroidlib.impl.execchain.RequestEntityProxy;
import ch.boye.httpclientandroidlib.util.Args;
import ch.boye.httpclientandroidlib.util.EntityUtils;
import java.io.IOException;
import java.net.URI;
import java.util.List;

@ThreadSafe
public class RedirectExec
implements ClientExecChain {
    public HttpClientAndroidLog log = new HttpClientAndroidLog(this.getClass());
    private final ClientExecChain requestExecutor;
    private final RedirectStrategy redirectStrategy;
    private final HttpRoutePlanner routePlanner;

    public RedirectExec(ClientExecChain clientExecChain, HttpRoutePlanner httpRoutePlanner, RedirectStrategy redirectStrategy) {
        Args.notNull(clientExecChain, "HTTP client request executor");
        Args.notNull(httpRoutePlanner, "HTTP route planner");
        Args.notNull(redirectStrategy, "HTTP redirect strategy");
        this.requestExecutor = clientExecChain;
        this.routePlanner = httpRoutePlanner;
        this.redirectStrategy = redirectStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CloseableHttpResponse execute(HttpRoute httpRoute, HttpRequestWrapper httpRequestWrapper, HttpClientContext httpClientContext, HttpExecutionAware httpExecutionAware) throws IOException, HttpException {
        RequestConfig requestConfig;
        Args.notNull(httpRoute, "HTTP route");
        Args.notNull(httpRequestWrapper, "HTTP request");
        Args.notNull(httpClientContext, "HTTP context");
        List<URI> list = httpClientContext.getRedirectLocations();
        if (list != null) {
            list.clear();
        }
        int n = (requestConfig = httpClientContext.getRequestConfig()).getMaxRedirects() > 0 ? requestConfig.getMaxRedirects() : 50;
        HttpRoute httpRoute2 = httpRoute;
        HttpRequestWrapper httpRequestWrapper2 = httpRequestWrapper;
        int n2 = 0;
        while (true) {
            CloseableHttpResponse closeableHttpResponse = this.requestExecutor.execute(httpRoute2, httpRequestWrapper2, httpClientContext, httpExecutionAware);
            try {
                HttpHost httpHost;
                Object object;
                if (!requestConfig.isRedirectsEnabled()) return closeableHttpResponse;
                if (!this.redirectStrategy.isRedirected(httpRequestWrapper2, closeableHttpResponse, httpClientContext)) return closeableHttpResponse;
                if (n2 >= n) {
                    throw new RedirectException("Maximum redirects (" + n + ") exceeded");
                }
                ++n2;
                HttpUriRequest httpUriRequest = this.redirectStrategy.getRedirect(httpRequestWrapper2, closeableHttpResponse, httpClientContext);
                if (!httpUriRequest.headerIterator().hasNext()) {
                    object = httpRequestWrapper.getOriginal();
                    httpUriRequest.setHeaders(object.getAllHeaders());
                }
                if ((httpRequestWrapper2 = HttpRequestWrapper.wrap(httpUriRequest)) instanceof HttpEntityEnclosingRequest) {
                    RequestEntityProxy.enhance((HttpEntityEnclosingRequest)((Object)httpRequestWrapper2));
                }
                if ((httpHost = URIUtils.extractHost((URI)(object = httpRequestWrapper2.getURI()))) == null) {
                    throw new ProtocolException("Redirect URI does not specify a valid host name: " + object);
                }
                if (!httpRoute2.getTargetHost().equals(httpHost)) {
                    AuthScheme authScheme;
                    AuthState authState;
                    AuthState authState2 = httpClientContext.getTargetAuthState();
                    if (authState2 != null) {
                        this.log.debug("Resetting target auth state");
                        authState2.reset();
                    }
                    if ((authState = httpClientContext.getProxyAuthState()) != null && (authScheme = authState.getAuthScheme()) != null && authScheme.isConnectionBased()) {
                        this.log.debug("Resetting proxy auth state");
                        authState.reset();
                    }
                }
                httpRoute2 = this.routePlanner.determineRoute(httpHost, httpRequestWrapper2, httpClientContext);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Redirecting to '" + object + "' via " + httpRoute2);
                }
                EntityUtils.consume(closeableHttpResponse.getEntity());
                closeableHttpResponse.close();
            }
            catch (RuntimeException runtimeException) {
                closeableHttpResponse.close();
                throw runtimeException;
            }
            catch (IOException iOException) {
                closeableHttpResponse.close();
                throw iOException;
            }
            catch (HttpException httpException) {
                try {
                    EntityUtils.consume(closeableHttpResponse.getEntity());
                    throw httpException;
                }
                catch (IOException iOException) {
                    this.log.debug("I/O error while releasing connection", iOException);
                    throw httpException;
                }
                finally {
                    closeableHttpResponse.close();
                }
            }
        }
    }
}

