/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.StrictMode;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.AppCompatActivity;
import java.lang.reflect.Method;
import java.util.Locale;
import org.mozilla.gecko.LocaleManager;

public class Locales {
    public static LocaleManager getLocaleManager() {
        try {
            Class<?> clazz = Class.forName("org.mozilla.gecko.BrowserLocaleManager");
            Method method = clazz.getMethod("getInstance", new Class[0]);
            LocaleManager localeManager = (LocaleManager)method.invoke(null, new Object[0]);
            return localeManager;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeLocale(Context context) {
        LocaleManager localeManager = Locales.getLocaleManager();
        StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
        StrictMode.allowThreadDiskWrites();
        try {
            localeManager.getAndApplyPersistedLocale(context);
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
    }

    public static String getLanguage(Locale locale) {
        String string = locale.getLanguage();
        if (string.equals("iw")) {
            return "he";
        }
        if (string.equals("in")) {
            return "id";
        }
        if (string.equals("ji")) {
            return "yi";
        }
        return string;
    }

    public static String getLanguageTag(Locale locale) {
        String string = Locales.getLanguage(locale);
        String string2 = locale.getCountry();
        if (string2.equals("")) {
            return string;
        }
        return string + "-" + string2;
    }

    public static Locale parseLocaleCode(String string) {
        int n = string.indexOf(45);
        if (n != -1 || (n = string.indexOf(95)) != -1) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            return new Locale(string2, string3);
        }
        return new Locale(string);
    }

    public static class LocaleAwareActivity
    extends Activity {
        protected void onCreate(Bundle bundle) {
            Locales.initializeLocale(this.getApplicationContext());
            super.onCreate(bundle);
        }
    }

    public static class LocaleAwareFragmentActivity
    extends FragmentActivity {
        protected void onCreate(Bundle bundle) {
            Locales.initializeLocale(this.getApplicationContext());
            super.onCreate(bundle);
        }
    }

    public static class LocaleAwareAppCompatActivity
    extends AppCompatActivity {
        protected void onCreate(Bundle bundle) {
            Locales.initializeLocale(this.getApplicationContext());
            super.onCreate(bundle);
        }
    }
}

