/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.activities;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import org.mozilla.gecko.Locales;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.fxa.activities.FxAccountAbstractActivity;
import org.mozilla.gecko.sync.setup.activities.ActivityUtils;

public class FxAccountWebFlowActivity
extends FxAccountAbstractActivity {
    protected static final String LOG_TAG = FxAccountWebFlowActivity.class.getSimpleName();
    protected static final String ABOUT_ACCOUNTS = "about:accounts";
    public static final String EXTRA_ENDPOINT = "entrypoint";
    protected static final String[] EXTRAS_TO_PASSTHROUGH = new String[]{"entrypoint"};
    private final String action;
    private final String extras;

    public FxAccountWebFlowActivity(int n, String string2) {
        this(n, string2, null);
    }

    public FxAccountWebFlowActivity(int n, String string2, String string3) {
        super(n);
        this.action = string2;
        this.extras = string3 != null ? "&" + string3 : "";
    }

    public void onCreate(Bundle bundle) {
        Logger.setThreadLogTag("FxAccounts");
        Logger.debug(LOG_TAG, "onCreate(" + bundle + ")");
        Locales.initializeLocale((Context)this.getApplicationContext());
        super.onCreate(bundle);
    }

    @Override
    protected boolean redirectIfAppropriate() {
        boolean bl = super.redirectIfAppropriate();
        if (bl) {
            return true;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ABOUT_ACCOUNTS);
        stringBuilder.append("?action=");
        stringBuilder.append(this.action);
        stringBuilder.append(this.extras);
        Intent intent = this.getIntent();
        if (intent != null) {
            for (String string2 : EXTRAS_TO_PASSTHROUGH) {
                String string3 = intent.getStringExtra(string2);
                if (string3 == null) continue;
                stringBuilder.append("&");
                stringBuilder.append(string2);
                stringBuilder.append("=");
                stringBuilder.append(string3);
            }
        }
        ActivityUtils.openURLInFennec(this.getApplicationContext(), stringBuilder.toString());
        return true;
    }

    @Override
    public void onResume() {
        super.onResume();
        this.finish();
    }
}

