/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.login;

import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.fxa.FxAccountUtils;
import org.mozilla.gecko.browserid.BrowserIDKeyPair;
import org.mozilla.gecko.browserid.DSACryptoImplementation;
import org.mozilla.gecko.browserid.RSACryptoImplementation;
import org.mozilla.gecko.fxa.login.Cohabiting;
import org.mozilla.gecko.fxa.login.Doghouse;
import org.mozilla.gecko.fxa.login.Engaged;
import org.mozilla.gecko.fxa.login.Married;
import org.mozilla.gecko.fxa.login.MigratedFromSync11;
import org.mozilla.gecko.fxa.login.Separated;
import org.mozilla.gecko.fxa.login.State;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.NonObjectJSONException;
import org.mozilla.gecko.sync.Utils;

public class StateFactory {
    private static final String LOG_TAG = StateFactory.class.getSimpleName();
    private static final int KEY_PAIR_SIZE_IN_BITS_V1 = 1024;

    public static BrowserIDKeyPair generateKeyPair() throws NoSuchAlgorithmException {
        return DSACryptoImplementation.generateKeyPair(1024);
    }

    protected static BrowserIDKeyPair keyPairFromJSONObjectV1(ExtendedJSONObject extendedJSONObject) throws InvalidKeySpecException, NoSuchAlgorithmException {
        return RSACryptoImplementation.fromJSONObject(extendedJSONObject);
    }

    protected static BrowserIDKeyPair keyPairFromJSONObjectV2(ExtendedJSONObject extendedJSONObject) throws InvalidKeySpecException, NoSuchAlgorithmException {
        return DSACryptoImplementation.fromJSONObject(extendedJSONObject);
    }

    public static State fromJSONObject(State.StateLabel stateLabel, ExtendedJSONObject extendedJSONObject) throws InvalidKeySpecException, NoSuchAlgorithmException, NonObjectJSONException {
        Long l = extendedJSONObject.getLong("version");
        if (l == null) {
            throw new IllegalStateException("version must not be null");
        }
        int n = l.intValue();
        if (n == 3) {
            return StateFactory.fromJSONObjectV3(stateLabel, extendedJSONObject);
        }
        if (n == 2) {
            return StateFactory.fromJSONObjectV2(stateLabel, extendedJSONObject);
        }
        if (n == 1) {
            State state = StateFactory.fromJSONObjectV1(stateLabel, extendedJSONObject);
            return StateFactory.migrateV1toV2(stateLabel, state);
        }
        throw new IllegalStateException("version must be in {1, 2}");
    }

    protected static State fromJSONObjectV1(State.StateLabel stateLabel, ExtendedJSONObject extendedJSONObject) throws InvalidKeySpecException, NoSuchAlgorithmException, NonObjectJSONException {
        switch (stateLabel) {
            case Engaged: {
                return new Engaged(extendedJSONObject.getString("email"), extendedJSONObject.getString("uid"), extendedJSONObject.getBoolean("verified"), Utils.hex2Byte(extendedJSONObject.getString("unwrapkB")), Utils.hex2Byte(extendedJSONObject.getString("sessionToken")), Utils.hex2Byte(extendedJSONObject.getString("keyFetchToken")));
            }
            case Cohabiting: {
                return new Cohabiting(extendedJSONObject.getString("email"), extendedJSONObject.getString("uid"), Utils.hex2Byte(extendedJSONObject.getString("sessionToken")), Utils.hex2Byte(extendedJSONObject.getString("kA")), Utils.hex2Byte(extendedJSONObject.getString("kB")), StateFactory.keyPairFromJSONObjectV1(extendedJSONObject.getObject("keyPair")));
            }
            case Married: {
                return new Married(extendedJSONObject.getString("email"), extendedJSONObject.getString("uid"), Utils.hex2Byte(extendedJSONObject.getString("sessionToken")), Utils.hex2Byte(extendedJSONObject.getString("kA")), Utils.hex2Byte(extendedJSONObject.getString("kB")), StateFactory.keyPairFromJSONObjectV1(extendedJSONObject.getObject("keyPair")), extendedJSONObject.getString("certificate"));
            }
            case Separated: {
                return new Separated(extendedJSONObject.getString("email"), extendedJSONObject.getString("uid"), extendedJSONObject.getBoolean("verified"));
            }
            case Doghouse: {
                return new Doghouse(extendedJSONObject.getString("email"), extendedJSONObject.getString("uid"), extendedJSONObject.getBoolean("verified"));
            }
        }
        throw new IllegalStateException("unrecognized state label: " + (Object)((Object)stateLabel));
    }

    protected static State fromJSONObjectV2(State.StateLabel stateLabel, ExtendedJSONObject extendedJSONObject) throws InvalidKeySpecException, NoSuchAlgorithmException, NonObjectJSONException {
        switch (stateLabel) {
            case Cohabiting: {
                return new Cohabiting(extendedJSONObject.getString("email"), extendedJSONObject.getString("uid"), Utils.hex2Byte(extendedJSONObject.getString("sessionToken")), Utils.hex2Byte(extendedJSONObject.getString("kA")), Utils.hex2Byte(extendedJSONObject.getString("kB")), StateFactory.keyPairFromJSONObjectV2(extendedJSONObject.getObject("keyPair")));
            }
            case Married: {
                return new Married(extendedJSONObject.getString("email"), extendedJSONObject.getString("uid"), Utils.hex2Byte(extendedJSONObject.getString("sessionToken")), Utils.hex2Byte(extendedJSONObject.getString("kA")), Utils.hex2Byte(extendedJSONObject.getString("kB")), StateFactory.keyPairFromJSONObjectV2(extendedJSONObject.getObject("keyPair")), extendedJSONObject.getString("certificate"));
            }
        }
        return StateFactory.fromJSONObjectV1(stateLabel, extendedJSONObject);
    }

    protected static State fromJSONObjectV3(State.StateLabel stateLabel, ExtendedJSONObject extendedJSONObject) throws InvalidKeySpecException, NoSuchAlgorithmException, NonObjectJSONException {
        switch (stateLabel) {
            case MigratedFromSync11: {
                return new MigratedFromSync11(extendedJSONObject.getString("email"), extendedJSONObject.getString("uid"), extendedJSONObject.getBoolean("verified"), extendedJSONObject.getString("password"));
            }
        }
        return StateFactory.fromJSONObjectV2(stateLabel, extendedJSONObject);
    }

    protected static void logMigration(State state, State state2) {
        if (!FxAccountUtils.LOG_PERSONAL_INFORMATION) {
            return;
        }
        try {
            FxAccountUtils.pii(LOG_TAG, "V1 persisted state is: " + state.toJSONObject().toJSONString());
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Error producing JSON representation of V1 state.", exception);
        }
        FxAccountUtils.pii(LOG_TAG, "Generated new V2 state: " + state2.toJSONObject().toJSONString());
    }

    protected static State migrateV1toV2(State.StateLabel stateLabel, State state) throws NoSuchAlgorithmException {
        if (state == null) {
            Logger.error(LOG_TAG, "Got null state in migrateV1toV2; returning null.");
            return state;
        }
        Logger.info(LOG_TAG, "Migrating V1 persisted State to V2; stateLabel: " + (Object)((Object)stateLabel));
        switch (stateLabel) {
            case Cohabiting: {
                Cohabiting cohabiting = (Cohabiting)state;
                BrowserIDKeyPair browserIDKeyPair = StateFactory.generateKeyPair();
                Cohabiting cohabiting2 = new Cohabiting(cohabiting.email, cohabiting.uid, cohabiting.sessionToken, cohabiting.kA, cohabiting.kB, browserIDKeyPair);
                StateFactory.logMigration(cohabiting, cohabiting2);
                return cohabiting2;
            }
            case Married: {
                Married married = (Married)state;
                BrowserIDKeyPair browserIDKeyPair = StateFactory.generateKeyPair();
                Cohabiting cohabiting = new Cohabiting(married.email, married.uid, married.sessionToken, married.kA, married.kB, browserIDKeyPair);
                StateFactory.logMigration(married, cohabiting);
                return cohabiting;
            }
        }
        return state;
    }
}

