/*
 * Decompiled with CFR 0.152.
 */
package com.keepsafe.switchboard;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.keepsafe.switchboard.DeviceUuidFactory;
import com.keepsafe.switchboard.Preferences;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.zip.CRC32;
import org.json.JSONException;
import org.json.JSONObject;

public class SwitchBoard {
    private static final String TAG = "SwitchBoard";
    public static boolean DEBUG = true;
    private static final String IS_EXPERIMENT_ACTIVE = "isActive";
    private static final String EXPERIMENT_VALUES = "values";
    private static final String KEY_SERVER_URL = "mainServerUrl";
    private static final String KEY_CONFIG_RESULTS = "results";

    static void loadConfig(Context context, @NonNull String string) {
        String string2 = string;
        URL uRL = SwitchBoard.buildConfigRequestUrl(context, string2);
        if (DEBUG) {
            Log.d((String)TAG, (String)("Request URL: " + uRL));
        }
        if (uRL == null) {
            return;
        }
        String string3 = SwitchBoard.readFromUrlGET(uRL);
        if (DEBUG) {
            Log.d((String)TAG, (String)("Result: " + string3));
        }
        if (string3 == null) {
            return;
        }
        try {
            JSONObject jSONObject = new JSONObject(string3);
            String string4 = jSONObject.getString(KEY_SERVER_URL);
            if (!string.equals(string4)) {
                Preferences.setDynamicConfigServerUrl(context, string4);
            }
            String string5 = jSONObject.getString(KEY_CONFIG_RESULTS);
            Preferences.setDynamicConfigJson(context, string5);
        }
        catch (JSONException jSONException) {
            Log.e((String)TAG, (String)"Exception parsing server result", (Throwable)jSONException);
        }
    }

    @Nullable
    private static URL buildConfigRequestUrl(Context context, String string) {
        DeviceUuidFactory deviceUuidFactory = new DeviceUuidFactory(context);
        String string2 = deviceUuidFactory.getDeviceUuid().toString();
        String string3 = Build.DEVICE;
        String string4 = Build.MANUFACTURER;
        String string5 = "unknown";
        try {
            string5 = Locale.getDefault().getISO3Language();
        }
        catch (MissingResourceException missingResourceException) {
            missingResourceException.printStackTrace();
        }
        String string6 = "unknown";
        try {
            string6 = Locale.getDefault().getISO3Country();
        }
        catch (MissingResourceException missingResourceException) {
            missingResourceException.printStackTrace();
        }
        String string7 = context.getPackageName();
        String string8 = "none";
        try {
            string8 = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
        }
        String string9 = "uuid=" + string2 + "&device=" + string3 + "&lang=" + string5 + "&country=" + string6 + "&manufacturer=" + string4 + "&appId=" + string7 + "&version=" + string8;
        try {
            return new URL(string + "?" + string9);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }

    public static boolean isInBucket(Context context, int n, int n2) {
        int n3 = SwitchBoard.getUserBucket(context);
        return n3 >= n && n3 < n2;
    }

    public static boolean isInExperiment(Context context, String string) {
        Boolean bl = Preferences.getOverrideValue(context, string);
        if (bl != null) {
            return bl;
        }
        String string2 = Preferences.getDynamicConfigJson(context);
        if (string2 == null) {
            return false;
        }
        try {
            JSONObject jSONObject = new JSONObject(string2).getJSONObject(string);
            return jSONObject != null && jSONObject.getBoolean(IS_EXPERIMENT_ACTIVE);
        }
        catch (JSONException jSONException) {
            return false;
        }
    }

    public static List<String> getActiveExperiments(Context context) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = Preferences.getDynamicConfigJson(context);
        if (string == null) {
            return arrayList;
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                Boolean bl = Preferences.getOverrideValue(context, string2);
                if (bl == null) {
                    JSONObject jSONObject2 = jSONObject.getJSONObject(string2);
                    bl = jSONObject2.getBoolean(IS_EXPERIMENT_ACTIVE);
                }
                if (!bl.booleanValue()) continue;
                arrayList.add(string2);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return arrayList;
    }

    public static boolean hasExperimentValues(Context context, String string) {
        return SwitchBoard.getExperimentValuesFromJson(context, string) != null;
    }

    public static JSONObject getExperimentValuesFromJson(Context context, String string) {
        String string2 = Preferences.getDynamicConfigJson(context);
        if (string2 == null) {
            return null;
        }
        try {
            JSONObject jSONObject = new JSONObject(string2).getJSONObject(string);
            return jSONObject.getJSONObject(EXPERIMENT_VALUES);
        }
        catch (JSONException jSONException) {
            Log.e((String)TAG, (String)"Could not create JSON object from config string", (Throwable)jSONException);
            return null;
        }
    }

    @Nullable
    private static String readFromUrlGET(URL uRL) {
        try {
            String string;
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setUseCaches(false);
            InputStream inputStream = httpURLConnection.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader, 8192);
            StringBuilder stringBuilder = new StringBuilder();
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
            }
            bufferedReader.close();
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private static int getUserBucket(Context context) {
        DeviceUuidFactory deviceUuidFactory = new DeviceUuidFactory(context);
        String string = deviceUuidFactory.getDeviceUuid().toString();
        CRC32 cRC32 = new CRC32();
        cRC32.update(string.getBytes());
        long l = cRC32.getValue();
        return (int)(l % 100L);
    }
}

