/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.fxa;

import ch.boye.httpclientandroidlib.HttpEntity;
import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.client.ClientProtocolException;
import ch.boye.httpclientandroidlib.client.methods.HttpRequestBase;
import ch.boye.httpclientandroidlib.impl.client.DefaultHttpClient;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.crypto.Mac;
import org.mozilla.gecko.Locales;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.fxa.FxAccount20CreateDelegate;
import org.mozilla.gecko.background.fxa.FxAccount20LoginDelegate;
import org.mozilla.gecko.background.fxa.FxAccountClient;
import org.mozilla.gecko.background.fxa.FxAccountClientException;
import org.mozilla.gecko.background.fxa.FxAccountUtils;
import org.mozilla.gecko.background.fxa.PasswordStretcher;
import org.mozilla.gecko.background.fxa.SkewHandler;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.crypto.HKDF;
import org.mozilla.gecko.sync.net.AuthHeaderProvider;
import org.mozilla.gecko.sync.net.BaseResource;
import org.mozilla.gecko.sync.net.BaseResourceDelegate;
import org.mozilla.gecko.sync.net.HawkAuthHeaderProvider;
import org.mozilla.gecko.sync.net.Resource;
import org.mozilla.gecko.sync.net.SyncResponse;
import org.mozilla.gecko.sync.net.SyncStorageResponse;

public class FxAccountClient20
implements FxAccountClient {
    protected static final String LOG_TAG = FxAccountClient20.class.getSimpleName();
    protected static final String ACCEPT_HEADER = "application/json;charset=utf-8";
    public static final String JSON_KEY_EMAIL = "email";
    public static final String JSON_KEY_KEYFETCHTOKEN = "keyFetchToken";
    public static final String JSON_KEY_SESSIONTOKEN = "sessionToken";
    public static final String JSON_KEY_UID = "uid";
    public static final String JSON_KEY_VERIFIED = "verified";
    public static final String JSON_KEY_ERROR = "error";
    public static final String JSON_KEY_MESSAGE = "message";
    public static final String JSON_KEY_INFO = "info";
    public static final String JSON_KEY_CODE = "code";
    public static final String JSON_KEY_ERRNO = "errno";
    protected static final String[] requiredErrorStringFields = new String[]{"error", "message", "info"};
    protected static final String[] requiredErrorLongFields = new String[]{"code", "errno"};
    protected final String serverURI;
    protected final Executor executor;
    protected static final String[] LOGIN_RESPONSE_REQUIRED_STRING_FIELDS = new String[]{"uid", "sessionToken"};
    protected static final String[] LOGIN_RESPONSE_REQUIRED_STRING_FIELDS_KEYS = new String[]{"uid", "sessionToken", "keyFetchToken"};
    protected static final String[] LOGIN_RESPONSE_REQUIRED_BOOLEAN_FIELDS = new String[]{"verified"};

    public FxAccountClient20(String string2, Executor executor) {
        if (string2 == null) {
            throw new IllegalArgumentException("Must provide a server URI.");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Must provide a non-null executor.");
        }
        String string3 = this.serverURI = string2.endsWith("/") ? string2 : string2 + "/";
        if (!this.serverURI.endsWith("/")) {
            throw new IllegalArgumentException("Constructed serverURI must end with a trailing slash: " + this.serverURI);
        }
        this.executor = executor;
    }

    protected BaseResource getBaseResource(String string2, Map<String, String> map) throws UnsupportedEncodingException, URISyntaxException {
        if (map == null || map.isEmpty()) {
            return this.getBaseResource(string2, new String[0]);
        }
        String[] stringArray = new String[2 * map.size()];
        int n = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            stringArray[n++] = entry.getKey();
            stringArray[n++] = entry.getValue();
        }
        return this.getBaseResource(string2, stringArray);
    }

    protected BaseResource getBaseResource(String string2, String ... stringArray) throws URISyntaxException, UnsupportedEncodingException {
        StringBuilder stringBuilder = new StringBuilder(this.serverURI);
        stringBuilder.append(string2);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                stringBuilder.append(n > 0 ? "&" : "?");
                String string3 = stringArray[n++];
                String string4 = stringArray[n++];
                stringBuilder.append(URLEncoder.encode(string3, "UTF-8"));
                stringBuilder.append("=");
                stringBuilder.append(URLEncoder.encode(string4, "UTF-8"));
            }
        }
        return new BaseResource(new URI(stringBuilder.toString()));
    }

    protected <T> void invokeHandleError(final RequestDelegate<T> requestDelegate, final Exception exception) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                requestDelegate.handleError(exception);
            }
        });
    }

    protected <T> void post(BaseResource baseResource, ExtendedJSONObject extendedJSONObject, RequestDelegate<T> requestDelegate) {
        if (extendedJSONObject == null) {
            baseResource.post((HttpEntity)null);
        } else {
            baseResource.post(extendedJSONObject);
        }
    }

    public long now() {
        return System.currentTimeMillis();
    }

    public static int validateResponse(HttpResponse httpResponse) throws FxAccountClientException.FxAccountClientRemoteException {
        String string2;
        String string3;
        String string4;
        int n;
        int n2;
        ExtendedJSONObject extendedJSONObject;
        int n3 = httpResponse.getStatusLine().getStatusCode();
        if (n3 == 200) {
            return n3;
        }
        try {
            extendedJSONObject = new SyncStorageResponse(httpResponse).jsonObjectBody();
            extendedJSONObject.throwIfFieldsMissingOrMisTyped(requiredErrorStringFields, String.class);
            extendedJSONObject.throwIfFieldsMissingOrMisTyped(requiredErrorLongFields, Long.class);
            n2 = extendedJSONObject.getLong(JSON_KEY_CODE).intValue();
            n = extendedJSONObject.getLong(JSON_KEY_ERRNO).intValue();
            string4 = extendedJSONObject.getString(JSON_KEY_ERROR);
            string3 = extendedJSONObject.getString(JSON_KEY_MESSAGE);
            string2 = extendedJSONObject.getString(JSON_KEY_INFO);
        }
        catch (Exception exception) {
            throw new FxAccountClientException.FxAccountClientMalformedResponseException(httpResponse);
        }
        throw new FxAccountClientException.FxAccountClientRemoteException(httpResponse, n2, n, string4, string3, string2, extendedJSONObject);
    }

    protected void unbundleBytes(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] ... byArray4) throws InvalidKeyException, NoSuchAlgorithmException, FxAccountClientException {
        byte[] byArray52;
        if (byArray.length < 32) {
            throw new IllegalArgumentException("input bundle must include HMAC");
        }
        int n = byArray3.length;
        if (byArray.length != n + 32) {
            throw new IllegalArgumentException("input bundle and XOR key with HMAC have different lengths");
        }
        int n2 = n;
        for (byte[] byArray52 : byArray4) {
            n2 -= byArray52.length;
        }
        if (n2 != 0) {
            throw new IllegalArgumentException("XOR key and total output arrays have different lengths");
        }
        byte[] byArray6 = new byte[n];
        byte[] byArray7 = new byte[32];
        System.arraycopy(byArray, 0, byArray6, 0, n);
        System.arraycopy(byArray, n, byArray7, 0, 32);
        Mac mac = HKDF.makeHMACHasher(byArray2);
        byArray52 = mac.doFinal(byArray6);
        if (!Arrays.equals(byArray52, byArray7)) {
            throw new FxAccountClientException("Bad message HMAC");
        }
        int n3 = 0;
        for (byte[] byArray8 : byArray4) {
            for (int i = 0; i < byArray8.length; ++i) {
                byArray8[i] = (byte)(byArray3[n3 + i] ^ byArray6[n3 + i]);
            }
            n3 += byArray8.length;
        }
    }

    protected void unbundleBody(ExtendedJSONObject extendedJSONObject, byte[] byArray, byte[] byArray2, byte[] ... byArray3) throws Exception {
        byte[] byArray42;
        int n = 0;
        for (byte[] byArray42 : byArray3) {
            n += byArray42.length;
        }
        if (extendedJSONObject == null) {
            throw new FxAccountClientException("body must be non-null");
        }
        String string2 = extendedJSONObject.getString("bundle");
        if (string2 == null) {
            throw new FxAccountClientException("bundle must be a non-null string");
        }
        byte[] byArray5 = Utils.hex2Byte(string2);
        byte[] byArray6 = new byte[32];
        byArray42 = new byte[n];
        HKDF.deriveMany(byArray, new byte[0], byArray2, byArray6, byArray42);
        this.unbundleBytes(byArray5, byArray6, byArray42, byArray3);
    }

    @Override
    public void keys(byte[] byArray, RequestDelegate<TwoKeys> requestDelegate) {
        BaseResource baseResource;
        byte[] byArray2 = new byte[32];
        byte[] byArray3 = new byte[32];
        final byte[] byArray4 = new byte[32];
        try {
            HKDF.deriveMany(byArray, new byte[0], FxAccountUtils.KW(JSON_KEY_KEYFETCHTOKEN), byArray2, byArray3, byArray4);
        }
        catch (Exception exception) {
            this.invokeHandleError(requestDelegate, exception);
            return;
        }
        try {
            baseResource = this.getBaseResource("account/keys", new String[0]);
        }
        catch (UnsupportedEncodingException | URISyntaxException exception) {
            this.invokeHandleError(requestDelegate, exception);
            return;
        }
        baseResource.delegate = new ResourceDelegate<TwoKeys>((Resource)baseResource, requestDelegate, byArray2, byArray3){

            @Override
            public void handleSuccess(int n, HttpResponse httpResponse, ExtendedJSONObject extendedJSONObject) {
                try {
                    byte[] byArray = new byte[32];
                    byte[] byArray2 = new byte[32];
                    FxAccountClient20.this.unbundleBody(extendedJSONObject, byArray4, FxAccountUtils.KW("account/keys"), byArray, byArray2);
                    this.delegate.handleSuccess(new TwoKeys(byArray, byArray2));
                    return;
                }
                catch (Exception exception) {
                    this.delegate.handleError(exception);
                    return;
                }
            }
        };
        baseResource.get();
    }

    @Override
    public void status(byte[] byArray, RequestDelegate<StatusResponse> requestDelegate) {
        BaseResource baseResource;
        byte[] byArray2 = new byte[32];
        byte[] byArray3 = new byte[32];
        byte[] byArray4 = new byte[32];
        try {
            HKDF.deriveMany(byArray, new byte[0], FxAccountUtils.KW(JSON_KEY_SESSIONTOKEN), byArray2, byArray3, byArray4);
        }
        catch (Exception exception) {
            this.invokeHandleError(requestDelegate, exception);
            return;
        }
        try {
            baseResource = this.getBaseResource("recovery_email/status", new String[0]);
        }
        catch (UnsupportedEncodingException | URISyntaxException exception) {
            this.invokeHandleError(requestDelegate, exception);
            return;
        }
        baseResource.delegate = new ResourceDelegate<StatusResponse>((Resource)baseResource, requestDelegate, byArray2, byArray3){

            @Override
            public void handleSuccess(int n, HttpResponse httpResponse, ExtendedJSONObject extendedJSONObject) {
                try {
                    String[] stringArray = new String[]{FxAccountClient20.JSON_KEY_EMAIL};
                    extendedJSONObject.throwIfFieldsMissingOrMisTyped(stringArray, String.class);
                    String string2 = extendedJSONObject.getString(FxAccountClient20.JSON_KEY_EMAIL);
                    Boolean bl = extendedJSONObject.getBoolean(FxAccountClient20.JSON_KEY_VERIFIED);
                    this.delegate.handleSuccess(new StatusResponse(string2, bl));
                    return;
                }
                catch (Exception exception) {
                    this.delegate.handleError(exception);
                    return;
                }
            }
        };
        baseResource.get();
    }

    @Override
    public void sign(byte[] byArray, ExtendedJSONObject extendedJSONObject, long l, RequestDelegate<String> requestDelegate) {
        BaseResource baseResource;
        ExtendedJSONObject extendedJSONObject2 = new ExtendedJSONObject();
        extendedJSONObject2.put("publicKey", extendedJSONObject);
        extendedJSONObject2.put("duration", l);
        byte[] byArray2 = new byte[32];
        byte[] byArray3 = new byte[32];
        try {
            HKDF.deriveMany(byArray, new byte[0], FxAccountUtils.KW(JSON_KEY_SESSIONTOKEN), byArray2, byArray3);
        }
        catch (Exception exception) {
            this.invokeHandleError(requestDelegate, exception);
            return;
        }
        try {
            baseResource = this.getBaseResource("certificate/sign", new String[0]);
        }
        catch (UnsupportedEncodingException | URISyntaxException exception) {
            this.invokeHandleError(requestDelegate, exception);
            return;
        }
        baseResource.delegate = new ResourceDelegate<String>((Resource)baseResource, requestDelegate, byArray2, byArray3){

            @Override
            public void handleSuccess(int n, HttpResponse httpResponse, ExtendedJSONObject extendedJSONObject) {
                String string2 = extendedJSONObject.getString("cert");
                if (string2 == null) {
                    this.delegate.handleError(new FxAccountClientException("cert must be a non-null string"));
                    return;
                }
                this.delegate.handleSuccess(string2);
            }
        };
        this.post(baseResource, extendedJSONObject2, requestDelegate);
    }

    public void login(final byte[] byArray, byte[] byArray2, final boolean bl, Map<String, String> map, RequestDelegate<LoginResponse> requestDelegate) {
        ExtendedJSONObject extendedJSONObject;
        BaseResource baseResource;
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (map != null) {
                hashMap.putAll(map);
            }
            if (bl) {
                hashMap.put("keys", "true");
            }
            baseResource = this.getBaseResource("account/login", hashMap);
            extendedJSONObject = new FxAccount20LoginDelegate(byArray, byArray2).getCreateBody();
        }
        catch (Exception exception) {
            this.invokeHandleError(requestDelegate, exception);
            return;
        }
        baseResource.delegate = new ResourceDelegate<LoginResponse>((Resource)baseResource, requestDelegate){

            @Override
            public void handleSuccess(int n, HttpResponse httpResponse, ExtendedJSONObject extendedJSONObject) {
                try {
                    String[] stringArray = bl ? LOGIN_RESPONSE_REQUIRED_STRING_FIELDS_KEYS : LOGIN_RESPONSE_REQUIRED_STRING_FIELDS;
                    extendedJSONObject.throwIfFieldsMissingOrMisTyped(stringArray, String.class);
                    String[] stringArray2 = LOGIN_RESPONSE_REQUIRED_BOOLEAN_FIELDS;
                    extendedJSONObject.throwIfFieldsMissingOrMisTyped(stringArray2, Boolean.class);
                    String string2 = extendedJSONObject.getString(FxAccountClient20.JSON_KEY_UID);
                    boolean bl2 = extendedJSONObject.getBoolean(FxAccountClient20.JSON_KEY_VERIFIED);
                    byte[] byArray3 = Utils.hex2Byte(extendedJSONObject.getString(FxAccountClient20.JSON_KEY_SESSIONTOKEN));
                    byte[] byArray2 = null;
                    if (bl) {
                        byArray2 = Utils.hex2Byte(extendedJSONObject.getString(FxAccountClient20.JSON_KEY_KEYFETCHTOKEN));
                    }
                    LoginResponse loginResponse = new LoginResponse(new String(byArray, "UTF-8"), string2, bl2, byArray3, byArray2);
                    this.delegate.handleSuccess(loginResponse);
                    return;
                }
                catch (Exception exception) {
                    this.delegate.handleError(exception);
                    return;
                }
            }
        };
        this.post(baseResource, extendedJSONObject, requestDelegate);
    }

    public void createAccount(final byte[] byArray, byte[] byArray2, final boolean bl, boolean bl2, Map<String, String> map, RequestDelegate<LoginResponse> requestDelegate) {
        ExtendedJSONObject extendedJSONObject;
        BaseResource baseResource;
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (map != null) {
                hashMap.putAll(map);
            }
            if (bl) {
                hashMap.put("keys", "true");
            }
            baseResource = this.getBaseResource("account/create", hashMap);
            extendedJSONObject = new FxAccount20CreateDelegate(byArray, byArray2, bl2).getCreateBody();
        }
        catch (Exception exception) {
            this.invokeHandleError(requestDelegate, exception);
            return;
        }
        baseResource.delegate = new ResourceDelegate<LoginResponse>((Resource)baseResource, requestDelegate){

            @Override
            public void handleSuccess(int n, HttpResponse httpResponse, ExtendedJSONObject extendedJSONObject) {
                try {
                    String[] stringArray = bl ? LOGIN_RESPONSE_REQUIRED_STRING_FIELDS_KEYS : LOGIN_RESPONSE_REQUIRED_STRING_FIELDS;
                    extendedJSONObject.throwIfFieldsMissingOrMisTyped(stringArray, String.class);
                    String string2 = extendedJSONObject.getString(FxAccountClient20.JSON_KEY_UID);
                    boolean bl3 = false;
                    Boolean bl2 = extendedJSONObject.getBoolean(FxAccountClient20.JSON_KEY_VERIFIED);
                    if (bl2 != null) {
                        bl3 = bl2;
                    }
                    byte[] byArray3 = Utils.hex2Byte(extendedJSONObject.getString(FxAccountClient20.JSON_KEY_SESSIONTOKEN));
                    byte[] byArray2 = null;
                    if (bl) {
                        byArray2 = Utils.hex2Byte(extendedJSONObject.getString(FxAccountClient20.JSON_KEY_KEYFETCHTOKEN));
                    }
                    LoginResponse loginResponse = new LoginResponse(new String(byArray, "UTF-8"), string2, bl3, byArray3, byArray2);
                    this.delegate.handleSuccess(loginResponse);
                }
                catch (Exception exception) {
                    this.delegate.handleError(exception);
                }
            }
        };
        this.post(baseResource, extendedJSONObject, requestDelegate);
    }

    public void login(byte[] byArray, final PasswordStretcher passwordStretcher, final boolean bl, final Map<String, String> map, final RequestDelegate<LoginResponse> requestDelegate) {
        byte[] byArray2;
        try {
            FxAccountUtils.pii(LOG_TAG, "Trying user provided email: '" + new String(byArray, "UTF-8") + "'");
            byArray2 = passwordStretcher.getQuickStretchedPW(byArray);
        }
        catch (Exception exception) {
            requestDelegate.handleError(exception);
            return;
        }
        this.login(byArray, byArray2, bl, map, new RequestDelegate<LoginResponse>(){

            @Override
            public void handleSuccess(LoginResponse loginResponse) {
                requestDelegate.handleSuccess(loginResponse);
            }

            @Override
            public void handleError(Exception exception) {
                requestDelegate.handleError(exception);
            }

            @Override
            public void handleFailure(FxAccountClientException.FxAccountClientRemoteException fxAccountClientRemoteException) {
                String string2 = fxAccountClientRemoteException.body.getString(FxAccountClient20.JSON_KEY_EMAIL);
                if (!fxAccountClientRemoteException.isBadEmailCase() || string2 == null) {
                    requestDelegate.handleFailure(fxAccountClientRemoteException);
                    return;
                }
                Logger.info(LOG_TAG, "Server returned alternate email; retrying login with provided email.");
                FxAccountUtils.pii(LOG_TAG, "Trying server provided email: '" + string2 + "'");
                try {
                    byte[] byArray = string2.getBytes("UTF-8");
                    byte[] byArray2 = passwordStretcher.getQuickStretchedPW(byArray);
                    FxAccountClient20.this.login(byArray, byArray2, bl, (Map<String, String>)map, (RequestDelegate<LoginResponse>)requestDelegate);
                }
                catch (Exception exception) {
                    requestDelegate.handleError(exception);
                    return;
                }
            }
        });
    }

    public static class LoginResponse {
        public final String remoteEmail;
        public final String uid;
        public final byte[] sessionToken;
        public final boolean verified;
        public final byte[] keyFetchToken;

        public LoginResponse(String string2, String string3, boolean bl, byte[] byArray, byte[] byArray2) {
            this.remoteEmail = string2;
            this.uid = string3;
            this.verified = bl;
            this.sessionToken = byArray;
            this.keyFetchToken = byArray2;
        }
    }

    public static class StatusResponse {
        public final String email;
        public final boolean verified;

        public StatusResponse(String string2, boolean bl) {
            this.email = string2;
            this.verified = bl;
        }
    }

    protected abstract class ResourceDelegate<T>
    extends BaseResourceDelegate {
        protected final RequestDelegate<T> delegate;
        protected final byte[] tokenId;
        protected final byte[] reqHMACKey;
        protected final SkewHandler skewHandler;

        protected abstract void handleSuccess(int var1, HttpResponse var2, ExtendedJSONObject var3);

        public ResourceDelegate(Resource resource, RequestDelegate<T> requestDelegate) {
            this(resource, requestDelegate, null, null);
        }

        public ResourceDelegate(Resource resource, RequestDelegate<T> requestDelegate, byte[] byArray, byte[] byArray2) {
            super(resource);
            this.delegate = requestDelegate;
            this.reqHMACKey = byArray2;
            this.tokenId = byArray;
            this.skewHandler = SkewHandler.getSkewHandlerForResource(resource);
        }

        @Override
        public AuthHeaderProvider getAuthHeaderProvider() {
            if (this.tokenId != null && this.reqHMACKey != null) {
                return new HawkAuthHeaderProvider(Utils.byte2Hex(this.tokenId), this.reqHMACKey, true, this.skewHandler.getSkewInSeconds());
            }
            return super.getAuthHeaderProvider();
        }

        @Override
        public String getUserAgent() {
            return "Firefox-Android-FxAccounts/49.0a1 (Firefox)";
        }

        @Override
        public void handleHttpResponse(HttpResponse httpResponse) {
            try {
                int n = FxAccountClient20.validateResponse(httpResponse);
                this.skewHandler.updateSkew(httpResponse, FxAccountClient20.this.now());
                this.invokeHandleSuccess(n, httpResponse);
            }
            catch (FxAccountClientException.FxAccountClientRemoteException fxAccountClientRemoteException) {
                if (!this.skewHandler.updateSkew(httpResponse, FxAccountClient20.this.now())) {
                    this.skewHandler.resetSkew();
                }
                this.invokeHandleFailure(fxAccountClientRemoteException);
            }
        }

        protected void invokeHandleFailure(final FxAccountClientException.FxAccountClientRemoteException fxAccountClientRemoteException) {
            FxAccountClient20.this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ResourceDelegate.this.delegate.handleFailure(fxAccountClientRemoteException);
                }
            });
        }

        protected void invokeHandleSuccess(final int n, final HttpResponse httpResponse) {
            FxAccountClient20.this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        ExtendedJSONObject extendedJSONObject = new SyncResponse(httpResponse).jsonObjectBody();
                        ResourceDelegate.this.handleSuccess(n, httpResponse, extendedJSONObject);
                    }
                    catch (Exception exception) {
                        ResourceDelegate.this.delegate.handleError(exception);
                    }
                }
            });
        }

        @Override
        public void handleHttpProtocolException(ClientProtocolException clientProtocolException) {
            FxAccountClient20.this.invokeHandleError(this.delegate, (Exception)((Object)clientProtocolException));
        }

        @Override
        public void handleHttpIOException(IOException iOException) {
            FxAccountClient20.this.invokeHandleError(this.delegate, iOException);
        }

        @Override
        public void handleTransportException(GeneralSecurityException generalSecurityException) {
            FxAccountClient20.this.invokeHandleError(this.delegate, generalSecurityException);
        }

        @Override
        public void addHeaders(HttpRequestBase httpRequestBase, DefaultHttpClient defaultHttpClient) {
            super.addHeaders(httpRequestBase, defaultHttpClient);
            Locale locale = Locale.getDefault();
            httpRequestBase.addHeader("Accept-Language", Locales.getLanguageTag((Locale)locale));
            httpRequestBase.addHeader("Accept", FxAccountClient20.ACCEPT_HEADER);
        }
    }

    public static class TwoKeys {
        public final byte[] kA;
        public final byte[] wrapkB;

        public TwoKeys(byte[] byArray, byte[] byArray2) {
            this.kA = byArray;
            this.wrapkB = byArray2;
        }
    }

    public static interface RequestDelegate<T> {
        public void handleError(Exception var1);

        public void handleFailure(FxAccountClientException.FxAccountClientRemoteException var1);

        public void handleSuccess(T var1);
    }
}

