/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.browserid.verifier;

import ch.boye.httpclientandroidlib.HttpEntity;
import ch.boye.httpclientandroidlib.NameValuePair;
import ch.boye.httpclientandroidlib.client.entity.UrlEncodedFormEntity;
import ch.boye.httpclientandroidlib.message.BasicNameValuePair;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import org.mozilla.gecko.browserid.verifier.AbstractBrowserIDRemoteVerifierClient;
import org.mozilla.gecko.browserid.verifier.BrowserIDVerifierDelegate;
import org.mozilla.gecko.sync.net.BaseResource;

public class BrowserIDRemoteVerifierClient10
extends AbstractBrowserIDRemoteVerifierClient {
    public static final String LOG_TAG = BrowserIDRemoteVerifierClient10.class.getSimpleName();
    public static final String DEFAULT_VERIFIER_URL = "https://verifier.login.persona.org/verify";

    public BrowserIDRemoteVerifierClient10() throws URISyntaxException {
        super(new URI(DEFAULT_VERIFIER_URL));
    }

    public BrowserIDRemoteVerifierClient10(URI uRI) {
        super(uRI);
    }

    @Override
    public void verify(String string, String string2, BrowserIDVerifierDelegate browserIDVerifierDelegate) {
        if (string == null) {
            throw new IllegalArgumentException("audience cannot be null.");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("assertion cannot be null.");
        }
        if (browserIDVerifierDelegate == null) {
            throw new IllegalArgumentException("delegate cannot be null.");
        }
        BaseResource baseResource = new BaseResource(this.verifierUri);
        baseResource.delegate = new AbstractBrowserIDRemoteVerifierClient.RemoteVerifierResourceDelegate(baseResource, browserIDVerifierDelegate);
        List<NameValuePair> list = Arrays.asList(new BasicNameValuePair("audience", string), new BasicNameValuePair("assertion", string2));
        try {
            baseResource.post((HttpEntity)new UrlEncodedFormEntity(list, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            browserIDVerifierDelegate.handleError(unsupportedEncodingException);
        }
    }
}

