/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.repositories.android;

import android.content.ContentProviderClient;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.db.BrowserContract;
import org.mozilla.gecko.sync.repositories.InactiveSessionException;
import org.mozilla.gecko.sync.repositories.NoContentProviderException;
import org.mozilla.gecko.sync.repositories.NoStoreDelegateException;
import org.mozilla.gecko.sync.repositories.NullCursorException;
import org.mozilla.gecko.sync.repositories.RecordFilter;
import org.mozilla.gecko.sync.repositories.Repository;
import org.mozilla.gecko.sync.repositories.RepositorySession;
import org.mozilla.gecko.sync.repositories.StoreTrackingRepositorySession;
import org.mozilla.gecko.sync.repositories.android.BrowserContractHelpers;
import org.mozilla.gecko.sync.repositories.android.RepoUtils;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionCreationDelegate;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionFetchRecordsDelegate;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionFinishDelegate;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionGuidsSinceDelegate;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionWipeDelegate;
import org.mozilla.gecko.sync.repositories.domain.FormHistoryRecord;
import org.mozilla.gecko.sync.repositories.domain.Record;

public class FormHistoryRepositorySession
extends StoreTrackingRepositorySession {
    public static final String LOG_TAG = "FormHistoryRepoSess";
    public static final int INSERT_ITEM_THRESHOLD = 200;
    private static final Uri FORM_HISTORY_CONTENT_URI = BrowserContractHelpers.FORM_HISTORY_CONTENT_URI;
    private static final Uri DELETED_FORM_HISTORY_CONTENT_URI = BrowserContractHelpers.DELETED_FORM_HISTORY_CONTENT_URI;
    protected final ContentProviderClient formsProvider;
    protected final RepoUtils.QueryHelper regularHelper;
    protected final RepoUtils.QueryHelper deletedHelper;
    protected static final String[] GUID_COLUMNS = new String[]{"guid"};
    protected static final String GUID_IS = "guid = ?";
    protected final Object recordsBufferMonitor = new Object();
    protected ArrayList<ContentValues> recordsBuffer = new ArrayList();

    public static ContentProviderClient acquireContentProvider(Context context) throws NoContentProviderException {
        Uri uri = BrowserContract.FORM_HISTORY_AUTHORITY_URI;
        ContentProviderClient contentProviderClient = context.getContentResolver().acquireContentProviderClient(uri);
        if (contentProviderClient == null) {
            throw new NoContentProviderException(uri);
        }
        return contentProviderClient;
    }

    protected void releaseProviders() {
        try {
            if (this.formsProvider != null) {
                this.formsProvider.release();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ContentProviderClient getFormsProvider() {
        return this.formsProvider;
    }

    public FormHistoryRepositorySession(Repository repository, Context context) throws NoContentProviderException {
        super(repository);
        this.formsProvider = FormHistoryRepositorySession.acquireContentProvider(context);
        this.regularHelper = new RepoUtils.QueryHelper(context, BrowserContractHelpers.FORM_HISTORY_CONTENT_URI, LOG_TAG);
        this.deletedHelper = new RepoUtils.QueryHelper(context, BrowserContractHelpers.DELETED_FORM_HISTORY_CONTENT_URI, LOG_TAG);
    }

    @Override
    public void abort() {
        this.releaseProviders();
        super.abort();
    }

    @Override
    public void finish(RepositorySessionFinishDelegate repositorySessionFinishDelegate) throws InactiveSessionException {
        this.releaseProviders();
        super.finish(repositorySessionFinishDelegate);
    }

    @Override
    public void guidsSince(final long l, final RepositorySessionGuidsSinceDelegate repositorySessionGuidsSinceDelegate) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!FormHistoryRepositorySession.this.isActive()) {
                    repositorySessionGuidsSinceDelegate.onGuidsSinceFailed(new InactiveSessionException(null));
                    return;
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                long l2 = RepositorySession.now();
                try (Cursor cursor = null;){
                    cursor = FormHistoryRepositorySession.this.regularHelper.safeQuery(FormHistoryRepositorySession.this.formsProvider, "", GUID_COLUMNS, FormHistoryRepositorySession.regularBetween(l, l2), null, null);
                    cursor.moveToFirst();
                    while (!cursor.isAfterLast()) {
                        arrayList.add(cursor.getString(0));
                        cursor.moveToNext();
                    }
                }
                try {
                    cursor = FormHistoryRepositorySession.this.deletedHelper.safeQuery(FormHistoryRepositorySession.this.formsProvider, "", GUID_COLUMNS, FormHistoryRepositorySession.deletedBetween(l, l2), null, null);
                    cursor.moveToFirst();
                    while (!cursor.isAfterLast()) {
                        arrayList.add(cursor.getString(0));
                        cursor.moveToNext();
                    }
                }
                catch (RemoteException | NullCursorException throwable) {
                    repositorySessionGuidsSinceDelegate.onGuidsSinceFailed((Exception)throwable);
                    return;
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
                repositorySessionGuidsSinceDelegate.onGuidsSinceSucceeded(stringArray);
            }
        };
        this.delegateQueue.execute(runnable);
    }

    protected static FormHistoryRecord retrieveDuringFetch(Cursor cursor) {
        if (cursor.getColumnCount() == BrowserContractHelpers.FormHistoryColumns.length) {
            return FormHistoryRepositorySession.formHistoryRecordFromCursor(cursor);
        }
        return FormHistoryRepositorySession.deletedFormHistoryRecordFromCursor(cursor);
    }

    protected static FormHistoryRecord formHistoryRecordFromCursor(Cursor cursor) {
        String string2 = RepoUtils.getStringFromCursor(cursor, "guid");
        String string3 = "forms";
        FormHistoryRecord formHistoryRecord = new FormHistoryRecord(string2, string3, 0L, false);
        formHistoryRecord.fieldName = RepoUtils.getStringFromCursor(cursor, "fieldname");
        formHistoryRecord.fieldValue = RepoUtils.getStringFromCursor(cursor, "value");
        formHistoryRecord.androidID = RepoUtils.getLongFromCursor(cursor, "id");
        formHistoryRecord.lastModified = RepoUtils.getLongFromCursor(cursor, "firstUsed") / 1000L;
        formHistoryRecord.deleted = false;
        formHistoryRecord.log(LOG_TAG);
        return formHistoryRecord;
    }

    protected static FormHistoryRecord deletedFormHistoryRecordFromCursor(Cursor cursor) {
        String string2 = RepoUtils.getStringFromCursor(cursor, "guid");
        String string3 = "forms";
        FormHistoryRecord formHistoryRecord = new FormHistoryRecord(string2, string3, 0L, false);
        formHistoryRecord.guid = RepoUtils.getStringFromCursor(cursor, "guid");
        formHistoryRecord.androidID = RepoUtils.getLongFromCursor(cursor, "id");
        formHistoryRecord.lastModified = RepoUtils.getLongFromCursor(cursor, "timeDeleted");
        formHistoryRecord.deleted = true;
        formHistoryRecord.log(LOG_TAG);
        return formHistoryRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void fetchFromCursor(Cursor cursor, RecordFilter recordFilter, RepositorySessionFetchRecordsDelegate repositorySessionFetchRecordsDelegate) throws NullCursorException {
        Logger.debug(LOG_TAG, "Fetch from cursor");
        if (cursor == null) {
            throw new NullCursorException(null);
        }
        try {
            if (!cursor.moveToFirst()) {
                return;
            }
            while (!cursor.isAfterLast()) {
                FormHistoryRecord formHistoryRecord = FormHistoryRepositorySession.retrieveDuringFetch(cursor);
                if (formHistoryRecord != null) {
                    if (recordFilter == null || !recordFilter.excludeRecord(formHistoryRecord)) {
                        Logger.trace(LOG_TAG, "Processing record " + formHistoryRecord.guid);
                        repositorySessionFetchRecordsDelegate.onFetchedRecord(formHistoryRecord);
                    } else {
                        Logger.debug(LOG_TAG, "Skipping filtered record " + formHistoryRecord.guid);
                    }
                }
                cursor.moveToNext();
            }
        }
        finally {
            Logger.trace(LOG_TAG, "Closing cursor after fetch.");
            cursor.close();
        }
    }

    protected void fetchHelper(final RepositorySessionFetchRecordsDelegate repositorySessionFetchRecordsDelegate, final long l, final List<Callable<Cursor>> list) {
        if (this.storeTracker == null) {
            throw new IllegalStateException("Store tracker not yet initialized!");
        }
        final RecordFilter recordFilter = this.storeTracker.getFilter();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!FormHistoryRepositorySession.this.isActive()) {
                    repositorySessionFetchRecordsDelegate.onFetchFailed(new InactiveSessionException(null), null);
                    return;
                }
                for (Callable callable : list) {
                    Cursor cursor = null;
                    try {
                        cursor = (Cursor)callable.call();
                        FormHistoryRepositorySession.fetchFromCursor(cursor, recordFilter, repositorySessionFetchRecordsDelegate);
                    }
                    catch (Exception exception) {
                        Logger.warn(FormHistoryRepositorySession.LOG_TAG, "Exception during fetchHelper", exception);
                        repositorySessionFetchRecordsDelegate.onFetchFailed(exception, null);
                        return;
                    }
                }
                repositorySessionFetchRecordsDelegate.onFetchCompleted(l);
            }
        };
        this.delegateQueue.execute(runnable);
    }

    protected static String regularBetween(long l, long l2) {
        return "firstUsed >= " + Long.toString(1000L * l) + " AND " + "firstUsed" + " <= " + Long.toString(1000L * l2);
    }

    protected static String deletedBetween(long l, long l2) {
        return "timeDeleted >= " + Long.toString(l) + " AND " + "timeDeleted" + " <= " + Long.toString(l2);
    }

    @Override
    public void fetchSince(final long l, RepositorySessionFetchRecordsDelegate repositorySessionFetchRecordsDelegate) {
        Logger.trace(LOG_TAG, "Running fetchSince(" + l + ").");
        final long l2 = FormHistoryRepositorySession.now();
        Callable<Cursor> callable = new Callable<Cursor>(){

            @Override
            public Cursor call() throws Exception {
                return FormHistoryRepositorySession.this.regularHelper.safeQuery(FormHistoryRepositorySession.this.formsProvider, ".fetchSince(regular)", null, FormHistoryRepositorySession.regularBetween(l, l2), null, null);
            }
        };
        Callable<Cursor> callable2 = new Callable<Cursor>(){

            @Override
            public Cursor call() throws Exception {
                return FormHistoryRepositorySession.this.deletedHelper.safeQuery(FormHistoryRepositorySession.this.formsProvider, ".fetchSince(deleted)", null, FormHistoryRepositorySession.deletedBetween(l, l2), null, null);
            }
        };
        List<Callable<Cursor>> list = Arrays.asList(callable, callable2);
        this.fetchHelper(repositorySessionFetchRecordsDelegate, l2, list);
    }

    @Override
    public void fetchAll(RepositorySessionFetchRecordsDelegate repositorySessionFetchRecordsDelegate) {
        Logger.trace(LOG_TAG, "Running fetchAll.");
        this.fetchSince(0L, repositorySessionFetchRecordsDelegate);
    }

    @Override
    public void fetch(final String[] stringArray, RepositorySessionFetchRecordsDelegate repositorySessionFetchRecordsDelegate) {
        Logger.trace(LOG_TAG, "Running fetch.");
        final long l = FormHistoryRepositorySession.now();
        final String string2 = RepoUtils.computeSQLInClause(stringArray.length, "guid");
        Callable<Cursor> callable = new Callable<Cursor>(){

            @Override
            public Cursor call() throws Exception {
                String string22 = string2 + " AND " + "firstUsed" + " <= " + Long.toString(1000L * l);
                return FormHistoryRepositorySession.this.regularHelper.safeQuery(FormHistoryRepositorySession.this.formsProvider, ".fetch(regular)", null, string22, stringArray, null);
            }
        };
        Callable<Cursor> callable2 = new Callable<Cursor>(){

            @Override
            public Cursor call() throws Exception {
                String string22 = string2 + " AND " + "timeDeleted" + " <= " + Long.toString(l);
                return FormHistoryRepositorySession.this.deletedHelper.safeQuery(FormHistoryRepositorySession.this.formsProvider, ".fetch(deleted)", null, string22, stringArray, null);
            }
        };
        List<Callable<Cursor>> list = Arrays.asList(callable, callable2);
        this.fetchHelper(repositorySessionFetchRecordsDelegate, l, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Record findExistingRecordByGuid(String string2) throws RemoteException, NullCursorException {
        try (Cursor cursor = null;){
            cursor = this.regularHelper.safeQuery(this.formsProvider, ".findExistingRecordByGuid(regular)", null, GUID_IS, new String[]{string2}, null);
            if (cursor.moveToFirst()) {
                FormHistoryRecord formHistoryRecord = FormHistoryRepositorySession.formHistoryRecordFromCursor(cursor);
                return formHistoryRecord;
            }
        }
        try {
            cursor = this.deletedHelper.safeQuery(this.formsProvider, ".findExistingRecordByGuid(deleted)", null, GUID_IS, new String[]{string2}, null);
            if (cursor.moveToFirst()) {
                FormHistoryRecord formHistoryRecord = FormHistoryRepositorySession.deletedFormHistoryRecordFromCursor(cursor);
                return formHistoryRecord;
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Record findExistingRecordByPayload(Record record) throws RemoteException, NullCursorException {
        if (!record.deleted) {
            FormHistoryRecord formHistoryRecord = (FormHistoryRecord)record;
            try (Cursor cursor = null;){
                String string2 = "fieldname = ? AND value = ?";
                cursor = this.regularHelper.safeQuery(this.formsProvider, ".findExistingRecordByPayload", null, string2, new String[]{formHistoryRecord.fieldName, formHistoryRecord.fieldValue}, null);
                if (cursor.moveToFirst()) {
                    FormHistoryRecord formHistoryRecord2 = FormHistoryRepositorySession.formHistoryRecordFromCursor(cursor);
                    return formHistoryRecord2;
                }
            }
        }
        return null;
    }

    protected void deleteExistingRecord(Record record) throws RemoteException {
        if (record.deleted) {
            this.formsProvider.delete(DELETED_FORM_HISTORY_CONTENT_URI, GUID_IS, new String[]{record.guid});
            return;
        }
        this.formsProvider.delete(FORM_HISTORY_CONTENT_URI, GUID_IS, new String[]{record.guid});
    }

    protected static ContentValues contentValuesForRegularRecord(Record record) {
        if (record.deleted) {
            throw new IllegalArgumentException("Deleted record passed to insertNewRegularRecord.");
        }
        FormHistoryRecord formHistoryRecord = (FormHistoryRecord)record;
        ContentValues contentValues = new ContentValues();
        contentValues.put("guid", formHistoryRecord.guid);
        contentValues.put("fieldname", formHistoryRecord.fieldName);
        contentValues.put("value", formHistoryRecord.fieldValue);
        contentValues.put("firstUsed", Long.valueOf(1000L * formHistoryRecord.lastModified));
        return contentValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enqueueRegularRecord(Record record) {
        Object object = this.recordsBufferMonitor;
        synchronized (object) {
            if (this.recordsBuffer.size() >= 200) {
                try {
                    this.flushInsertQueue();
                }
                catch (Exception exception) {
                    this.delegate.onRecordStoreFailed(exception, record.guid);
                    return;
                }
            }
            this.recordsBuffer.add(FormHistoryRepositorySession.contentValuesForRegularRecord(record));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushInsertQueue() throws RemoteException {
        Object object = this.recordsBufferMonitor;
        synchronized (object) {
            if (this.recordsBuffer.size() > 0) {
                ContentValues[] contentValuesArray = this.recordsBuffer.toArray(new ContentValues[this.recordsBuffer.size()]);
                this.recordsBuffer = new ArrayList();
                if (contentValuesArray == null || contentValuesArray.length == 0) {
                    Logger.debug(LOG_TAG, "No form history items to insert; returning immediately.");
                    return;
                }
                long l = System.currentTimeMillis();
                this.formsProvider.bulkInsert(FORM_HISTORY_CONTENT_URI, contentValuesArray);
                long l2 = System.currentTimeMillis();
                Logger.debug(LOG_TAG, "Inserted " + contentValuesArray.length + " form history items in (" + (l2 - l) + " milliseconds).");
            }
        }
    }

    @Override
    public void storeDone() {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Logger.debug(FormHistoryRepositorySession.LOG_TAG, "Checking for residual form history items to insert.");
                try {
                    Object object = FormHistoryRepositorySession.this.recordsBufferMonitor;
                    synchronized (object) {
                        FormHistoryRepositorySession.this.flushInsertQueue();
                    }
                    FormHistoryRepositorySession.this.storeDone(RepositorySession.now());
                }
                catch (Exception exception) {
                    FormHistoryRepositorySession.this.delegate.onRecordStoreFailed(exception, null);
                }
            }
        };
        this.storeWorkQueue.execute(runnable);
    }

    protected void insertNewRegularRecord(Record record) throws RemoteException {
        this.enqueueRegularRecord(record);
    }

    protected void replaceExistingRecordWithRegularRecord(Record record, Record record2) throws RemoteException {
        if (record2.deleted) {
            this.deleteExistingRecord(record2);
            this.insertNewRegularRecord(record);
            return;
        }
        ContentValues contentValues = FormHistoryRepositorySession.contentValuesForRegularRecord(record);
        int n = this.formsProvider.update(FORM_HISTORY_CONTENT_URI, contentValues, GUID_IS, new String[]{record2.guid});
        if (n != 1) {
            Logger.warn(LOG_TAG, "Expected to update 1 record with guid " + record2.guid + " but updated " + n + " records.");
        }
    }

    @Override
    public void store(Record record) throws NoStoreDelegateException {
        if (this.delegate == null) {
            Logger.warn(LOG_TAG, "No store delegate.");
            throw new NoStoreDelegateException();
        }
        if (record == null) {
            Logger.error(LOG_TAG, "Record sent to store was null");
            throw new IllegalArgumentException("Null record passed to FormHistoryRepositorySession.store().");
        }
        if (!(record instanceof FormHistoryRecord)) {
            Logger.error(LOG_TAG, "Can't store anything but a FormHistoryRecord");
            throw new IllegalArgumentException("Non-FormHistoryRecord passed to FormHistoryRepositorySession.store().");
        }
        final FormHistoryRecord formHistoryRecord = (FormHistoryRecord)record;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!FormHistoryRepositorySession.this.isActive()) {
                    Logger.warn(FormHistoryRepositorySession.LOG_TAG, "FormHistoryRepositorySession is inactive. Store failing.");
                    FormHistoryRepositorySession.this.delegate.onRecordStoreFailed(new InactiveSessionException(null), formHistoryRecord.guid);
                    return;
                }
                long l = 0L;
                long l2 = 0L;
                boolean bl = formHistoryRecord.lastModified > l2;
                try {
                    boolean bl2;
                    Record record = FormHistoryRepositorySession.this.findExistingRecordByGuid(formHistoryRecord.guid);
                    if (formHistoryRecord.deleted) {
                        boolean bl3;
                        if (record == null) {
                            Logger.trace(FormHistoryRepositorySession.LOG_TAG, "Incoming record " + formHistoryRecord.guid + " is deleted, and no local version. Bye!");
                            return;
                        }
                        if (record.deleted) {
                            Logger.trace(FormHistoryRepositorySession.LOG_TAG, "Local record already deleted. Purging local.");
                            FormHistoryRepositorySession.this.deleteExistingRecord(record);
                            return;
                        }
                        if (!bl) {
                            Logger.trace(FormHistoryRepositorySession.LOG_TAG, "Ignoring deleted record from the past.");
                            return;
                        }
                        boolean bl4 = bl3 = record.lastModified > l;
                        if (!bl3) {
                            Logger.trace(FormHistoryRepositorySession.LOG_TAG, "Remote modified, local not. Deleting.");
                            FormHistoryRepositorySession.this.deleteExistingRecord(record);
                            FormHistoryRepositorySession.this.trackRecord(formHistoryRecord);
                            FormHistoryRepositorySession.this.delegate.onRecordStoreSucceeded(formHistoryRecord.guid);
                            return;
                        }
                        Logger.trace(FormHistoryRepositorySession.LOG_TAG, "Both local and remote records have been modified.");
                        if (formHistoryRecord.lastModified > record.lastModified) {
                            Logger.trace(FormHistoryRepositorySession.LOG_TAG, "Remote is newer, and deleted. Purging local.");
                            FormHistoryRepositorySession.this.deleteExistingRecord(record);
                            FormHistoryRepositorySession.this.trackRecord(formHistoryRecord);
                            FormHistoryRepositorySession.this.delegate.onRecordStoreSucceeded(formHistoryRecord.guid);
                            return;
                        }
                        Logger.trace(FormHistoryRepositorySession.LOG_TAG, "Remote is older, local is not deleted. Ignoring.");
                        if (!bl3) {
                            Logger.warn(FormHistoryRepositorySession.LOG_TAG, "Inconsistency: old remote record is deleted, but local record not modified!");
                        }
                        return;
                    }
                    if (record == null) {
                        Logger.trace(FormHistoryRepositorySession.LOG_TAG, "Looking up match for record " + formHistoryRecord.guid);
                        record = FormHistoryRepositorySession.this.findExistingRecordByPayload(formHistoryRecord);
                    }
                    if (record == null) {
                        Logger.trace(FormHistoryRepositorySession.LOG_TAG, "No match. Inserting.");
                        FormHistoryRepositorySession.this.insertNewRegularRecord(formHistoryRecord);
                        FormHistoryRepositorySession.this.trackRecord(formHistoryRecord);
                        FormHistoryRepositorySession.this.delegate.onRecordStoreSucceeded(formHistoryRecord.guid);
                        return;
                    }
                    Logger.trace(FormHistoryRepositorySession.LOG_TAG, "Incoming record " + formHistoryRecord.guid + " dupes to local record " + record.guid);
                    if (!RepoUtils.stringsEqual(formHistoryRecord.guid, record.guid)) {
                        Logger.trace(FormHistoryRepositorySession.LOG_TAG, "Remote guid different from local guid. Storing to keep remote guid.");
                        FormHistoryRepositorySession.this.replaceExistingRecordWithRegularRecord(formHistoryRecord, record);
                        FormHistoryRepositorySession.this.trackRecord(formHistoryRecord);
                        FormHistoryRepositorySession.this.delegate.onRecordStoreSucceeded(formHistoryRecord.guid);
                        return;
                    }
                    boolean bl5 = bl2 = record.lastModified > l;
                    if (!bl2) {
                        Logger.trace(FormHistoryRepositorySession.LOG_TAG, "Remote modified, local not. Storing.");
                        FormHistoryRepositorySession.this.replaceExistingRecordWithRegularRecord(formHistoryRecord, record);
                        FormHistoryRepositorySession.this.trackRecord(formHistoryRecord);
                        FormHistoryRepositorySession.this.delegate.onRecordStoreSucceeded(formHistoryRecord.guid);
                        return;
                    }
                    Logger.trace(FormHistoryRepositorySession.LOG_TAG, "Both local and remote records have been modified.");
                    if (formHistoryRecord.lastModified > record.lastModified) {
                        Logger.trace(FormHistoryRepositorySession.LOG_TAG, "Remote is newer, and not deleted. Storing.");
                        FormHistoryRepositorySession.this.replaceExistingRecordWithRegularRecord(formHistoryRecord, record);
                        FormHistoryRepositorySession.this.trackRecord(formHistoryRecord);
                        FormHistoryRepositorySession.this.delegate.onRecordStoreSucceeded(formHistoryRecord.guid);
                        return;
                    }
                    Logger.trace(FormHistoryRepositorySession.LOG_TAG, "Remote is older, local is not deleted. Ignoring.");
                    if (!bl2) {
                        Logger.warn(FormHistoryRepositorySession.LOG_TAG, "Inconsistency: old remote record is not deleted, but local record not modified!");
                    }
                    return;
                }
                catch (Exception exception) {
                    Logger.error(FormHistoryRepositorySession.LOG_TAG, "Store failed for " + formHistoryRecord.guid, exception);
                    FormHistoryRepositorySession.this.delegate.onRecordStoreFailed(exception, formHistoryRecord.guid);
                    return;
                }
            }
        };
        this.storeWorkQueue.execute(runnable);
    }

    public static void purgeDatabases(ContentProviderClient contentProviderClient) throws RemoteException {
        contentProviderClient.delete(FORM_HISTORY_CONTENT_URI, null, null);
        contentProviderClient.delete(DELETED_FORM_HISTORY_CONTENT_URI, null, null);
    }

    @Override
    public void wipe(final RepositorySessionWipeDelegate repositorySessionWipeDelegate) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!FormHistoryRepositorySession.this.isActive()) {
                    repositorySessionWipeDelegate.onWipeFailed(new InactiveSessionException(null));
                    return;
                }
                try {
                    Logger.debug(FormHistoryRepositorySession.LOG_TAG, "Wiping form history and deleted form history...");
                    FormHistoryRepositorySession.purgeDatabases(FormHistoryRepositorySession.this.formsProvider);
                    Logger.debug(FormHistoryRepositorySession.LOG_TAG, "Wiping form history and deleted form history... DONE");
                }
                catch (Exception exception) {
                    repositorySessionWipeDelegate.onWipeFailed(exception);
                    return;
                }
                repositorySessionWipeDelegate.onWipeSucceeded();
            }
        };
        this.storeWorkQueue.execute(runnable);
    }

    public static class FormHistoryRepository
    extends Repository {
        @Override
        public void createSession(RepositorySessionCreationDelegate repositorySessionCreationDelegate, Context context) {
            try {
                FormHistoryRepositorySession formHistoryRepositorySession = new FormHistoryRepositorySession(this, context);
                repositorySessionCreationDelegate.onSessionCreated(formHistoryRepositorySession);
            }
            catch (Exception exception) {
                repositorySessionCreationDelegate.onSessionCreateFailed(exception);
            }
        }
    }
}

