/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.stage;

import java.net.URISyntaxException;
import org.mozilla.gecko.sync.MetaGlobalException;
import org.mozilla.gecko.sync.repositories.ConstrainedServer11Repository;
import org.mozilla.gecko.sync.repositories.RecordFactory;
import org.mozilla.gecko.sync.repositories.Repository;
import org.mozilla.gecko.sync.repositories.android.AndroidBrowserHistoryRepository;
import org.mozilla.gecko.sync.repositories.domain.HistoryRecordFactory;
import org.mozilla.gecko.sync.stage.ServerSyncStage;

public class AndroidBrowserHistoryServerSyncStage
extends ServerSyncStage {
    protected static final String LOG_TAG = "HistoryStage";
    private static final String HISTORY_SORT = "index";
    private static final long HISTORY_REQUEST_LIMIT = 250L;

    @Override
    protected String getCollection() {
        return "history";
    }

    @Override
    protected String getEngineName() {
        return "history";
    }

    @Override
    public Integer getStorageVersion() {
        return 1;
    }

    @Override
    protected Repository getLocalRepository() {
        return new AndroidBrowserHistoryRepository();
    }

    @Override
    protected Repository getRemoteRepository() throws URISyntaxException {
        String string = this.getCollection();
        return new ConstrainedServer11Repository(string, this.session.config.storageURL(), this.session.getAuthHeaderProvider(), this.session.config.infoCollections, 250L, HISTORY_SORT);
    }

    @Override
    protected RecordFactory getRecordFactory() {
        return new HistoryRecordFactory();
    }

    @Override
    protected boolean isEnabled() throws MetaGlobalException {
        if (this.session == null || this.session.getContext() == null) {
            return false;
        }
        return super.isEnabled();
    }
}

