/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.mozglue;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.os.Process;
import android.os.UserManager;
import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.annotation.JNITarget;
import org.mozilla.gecko.annotation.RobocopTarget;
import org.mozilla.gecko.mozglue.SafeIntentUtils;

public final class GeckoLoader {
    private static final String LOGTAG = "GeckoLoader";
    private static volatile SafeIntentUtils.SafeIntent sIntent;
    private static File sCacheFile;
    private static File sGREDir;
    private static boolean sSQLiteLibsLoaded;
    private static boolean sNSSLibsLoaded;
    private static boolean sMozGlueLoaded;

    private GeckoLoader() {
    }

    public static File getCacheDir(Context context) {
        if (sCacheFile == null) {
            sCacheFile = context.getCacheDir();
        }
        return sCacheFile;
    }

    public static File getGREDir(Context context) {
        if (sGREDir == null) {
            sGREDir = new File(context.getApplicationInfo().dataDir);
        }
        return sGREDir;
    }

    private static void setupPluginEnvironment(Context context, String[] stringArray) {
        try {
            if (stringArray == null) {
                GeckoLoader.putenv("MOZ_PLUGINS_BLOCKED=1");
                GeckoLoader.putenv("MOZ_PLUGIN_PATH=");
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuilder.append(stringArray[i]);
                stringBuilder.append(":");
            }
            GeckoLoader.putenv("MOZ_PLUGIN_PATH=" + stringBuilder);
            File file = context.getDir("plugins", 0);
            GeckoLoader.putenv("ANDROID_PLUGIN_DATADIR=" + file.getPath());
            File file2 = context.getDir("plugins_private", 0);
            GeckoLoader.putenv("ANDROID_PLUGIN_DATADIR_PRIVATE=" + file2.getPath());
        }
        catch (Exception exception) {
            Log.w((String)LOGTAG, (String)"Caught exception getting plugin dirs.", (Throwable)exception);
        }
    }

    private static void setupDownloadEnvironment(Context context) {
        try {
            File file = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS);
            File file2 = context.getExternalFilesDir(Environment.DIRECTORY_DOWNLOADS);
            if (file == null) {
                file = new File(Environment.getExternalStorageDirectory().getPath(), "download");
            }
            if (file2 == null) {
                file2 = file;
            }
            GeckoLoader.putenv("DOWNLOADS_DIRECTORY=" + file.getPath());
            GeckoLoader.putenv("UPDATES_DIRECTORY=" + file2.getPath());
        }
        catch (Exception exception) {
            Log.w((String)LOGTAG, (String)"No download directory found.", (Throwable)exception);
        }
    }

    private static void delTree(File file) {
        if (file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                GeckoLoader.delTree(file2);
            }
        }
        file.delete();
    }

    private static File getTmpDir(Context context) {
        File file = context.getDir("tmpdir", 0);
        File file2 = new File(file.getParentFile(), "app_tmp");
        if (file2.exists()) {
            GeckoLoader.delTree(file2);
        }
        return file;
    }

    public static void setLastIntent(SafeIntentUtils.SafeIntent safeIntent) {
        sIntent = safeIntent;
    }

    public static void setupGeckoEnvironment(Context context, String[] stringArray, String string) {
        Object object;
        SafeIntentUtils.SafeIntent safeIntent = sIntent;
        if (safeIntent != null) {
            object = safeIntent.getStringExtra("env0");
            Log.d((String)LOGTAG, (String)("Gecko environment env0: " + (String)object));
            int n = 1;
            while (object != null) {
                GeckoLoader.putenv((String)object);
                object = safeIntent.getStringExtra("env" + n);
                Log.d((String)LOGTAG, (String)("env" + n + ": " + (String)object));
                ++n;
            }
        }
        GeckoLoader.putenv("MOZ_ANDROID_PACKAGE_NAME=" + context.getPackageName());
        GeckoLoader.setupPluginEnvironment(context, stringArray);
        GeckoLoader.setupDownloadEnvironment(context);
        GeckoLoader.putenv("HOME=" + string);
        object = GeckoLoader.getTmpDir(context);
        if (!((File)object).exists()) {
            ((File)object).mkdirs();
        }
        GeckoLoader.putenv("TMPDIR=" + ((File)object).getPath());
        object = Environment.getDownloadCacheDirectory();
        GeckoLoader.putenv("EXTERNAL_STORAGE=" + ((File)object).getPath());
        object = context.getCacheDir();
        GeckoLoader.putenv("CACHE_DIRECTORY=" + ((File)object).getPath());
        if (AppConstants.Versions.feature17Plus) {
            UserManager userManager = (UserManager)context.getSystemService("user");
            if (userManager != null) {
                GeckoLoader.putenv("MOZ_ANDROID_USER_SERIAL_NUMBER=" + userManager.getSerialNumberForUser(Process.myUserHandle()));
            } else {
                Log.d((String)LOGTAG, (String)("Unable to obtain user manager service on a device with SDK version " + Build.VERSION.SDK_INT));
            }
        }
        GeckoLoader.setupLocaleEnvironment();
        sIntent = null;
    }

    private static void loadLibsSetupLocked(Context context) {
        String string;
        File file = GeckoLoader.getCacheDir(context);
        GeckoLoader.putenv("GRE_HOME=" + GeckoLoader.getGREDir(context).getPath());
        String string2 = System.getenv("MOZ_LINKER_CACHE");
        if (string2 == null) {
            string2 = file.getPath();
            GeckoLoader.putenv("MOZ_LINKER_CACHE=" + string2);
        }
        if ((string = System.getenv("MOZ_LINKER_ONDEMAND")) == null && "HTC".equals(Build.MANUFACTURER) && "HTC Vision".equals(Build.MODEL)) {
            GeckoLoader.putenv("MOZ_LINKER_ONDEMAND=0");
        }
    }

    @RobocopTarget
    public static synchronized void loadSQLiteLibs(Context context, String string) {
        if (sSQLiteLibsLoaded) {
            return;
        }
        GeckoLoader.loadMozGlue(context);
        GeckoLoader.loadLibsSetupLocked(context);
        GeckoLoader.loadSQLiteLibsNative(string);
        sSQLiteLibsLoaded = true;
    }

    public static synchronized void loadNSSLibs(Context context, String string) {
        if (sNSSLibsLoaded) {
            return;
        }
        GeckoLoader.loadMozGlue(context);
        GeckoLoader.loadLibsSetupLocked(context);
        GeckoLoader.loadNSSLibsNative(string);
        sNSSLibsLoaded = true;
    }

    private static final String getCPUABI() {
        return Build.CPU_ABI;
    }

    private static boolean extractLibrary(Context context, String string, String string2) {
        String string3 = context.getApplicationInfo().sourceDir;
        if (!string3.endsWith(".apk")) {
            Log.w((String)LOGTAG, (String)"sourceDir is not an APK.");
            return false;
        }
        File file = new File(string2);
        if (!file.isDirectory() && !file.mkdirs()) {
            Log.e((String)LOGTAG, (String)("Couldn't create " + string2));
            return false;
        }
        if (AppConstants.Versions.feature21Plus) {
            String[] stringArray;
            for (String string4 : stringArray = Build.SUPPORTED_ABIS) {
                if (!GeckoLoader.tryLoadWithABI(string, string2, string3, string4)) continue;
                return true;
            }
            return false;
        }
        String string5 = GeckoLoader.getCPUABI();
        return GeckoLoader.tryLoadWithABI(string, string2, string3, string5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private static boolean tryLoadWithABI(String string, String string2, String string3, String string4) {
        try (ZipFile zipFile = new ZipFile(new File(string3));){
            boolean bl;
            String string5 = "lib/" + string4 + "/lib" + string + ".so";
            ZipEntry zipEntry = zipFile.getEntry(string5);
            if (zipEntry == null) {
                Log.w((String)LOGTAG, (String)(string5 + " not found in APK " + string3));
                boolean bl2 = false;
                return bl2;
            }
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            try {
                String string6 = string2 + "/lib" + string + ".so";
                FileOutputStream fileOutputStream = new FileOutputStream(string6);
                byte[] byArray = new byte[1024];
                Log.d((String)LOGTAG, (String)("Copying " + string5 + " to " + string6));
                boolean bl3 = false;
                try {
                    int n;
                    while ((n = inputStream.read(byArray, 0, 1024)) != -1) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                }
                catch (Exception exception) {
                    Log.w((String)LOGTAG, (String)"Failing library copy.", (Throwable)exception);
                    bl3 = true;
                }
                finally {
                    fileOutputStream.close();
                }
                if (bl3) {
                    new File(string6).delete();
                } else {
                    Log.d((String)LOGTAG, (String)("Marking " + string6 + " as executable."));
                    new File(string6).setExecutable(true);
                }
                bl = !bl3;
            }
            catch (Throwable throwable) {
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
            return bl;
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"Failed to extract lib from APK.", (Throwable)exception);
            return false;
        }
    }

    private static String getLoadDiagnostics(Context context, String string) {
        boolean bl;
        String string2;
        String string3 = context.getPackageName();
        StringBuilder stringBuilder = new StringBuilder("LOAD ");
        stringBuilder.append(string);
        stringBuilder.append(": ABI: x86-gcc3, " + GeckoLoader.getCPUABI());
        stringBuilder.append(": Data: " + context.getApplicationInfo().dataDir);
        try {
            boolean bl2 = new File("/data/app-lib/" + string3 + "/lib" + string + ".so").exists();
            boolean bl3 = new File("/data/data/" + string3 + "/lib/lib" + string + ".so").exists();
            stringBuilder.append(", ax=" + bl2);
            stringBuilder.append(", ddx=" + bl3);
        }
        catch (Throwable throwable) {
            stringBuilder.append(": ax/ddx fail, ");
        }
        try {
            string2 = "/data/data/" + string3 + "-1";
            String string4 = "/data/data/" + string3 + "-2";
            bl = new File(string2).exists();
            boolean bl4 = new File(string4).exists();
            stringBuilder.append(", -1x=" + bl);
            stringBuilder.append(", -2x=" + bl4);
        }
        catch (Throwable throwable) {
            stringBuilder.append(", dash fail, ");
        }
        try {
            if (Build.VERSION.SDK_INT >= 9) {
                string2 = context.getApplicationInfo().nativeLibraryDir;
                boolean bl5 = new File(string2).exists();
                bl = new File(string2 + "/lib" + string + ".so").exists();
                stringBuilder.append(", nativeLib: " + string2);
                stringBuilder.append(", dirx=" + bl5);
                stringBuilder.append(", libx=" + bl);
            } else {
                stringBuilder.append(", <pre-9>");
            }
        }
        catch (Throwable throwable) {
            stringBuilder.append(", nativeLib fail.");
        }
        return stringBuilder.toString();
    }

    private static final boolean attemptLoad(String string) {
        try {
            System.load(string);
            return true;
        }
        catch (Throwable throwable) {
            Log.wtf((String)LOGTAG, (String)("Couldn't load " + string + ": " + throwable));
            return false;
        }
    }

    private static final Throwable doLoadLibraryExpected(Context context, String string) {
        try {
            System.loadLibrary(string);
            return null;
        }
        catch (Throwable throwable) {
            Log.wtf((String)LOGTAG, (String)("Couldn't load " + string + ". Trying native library dir."));
            if (Build.VERSION.SDK_INT < 9) {
                return throwable;
            }
            String string2 = context.getApplicationInfo().nativeLibraryDir;
            String string3 = string2 + "/lib" + string + ".so";
            if (new File(string3).exists()) {
                if (GeckoLoader.attemptLoad(string3)) {
                    return null;
                }
                Log.wtf((String)LOGTAG, (String)"Library exists but couldn't load!");
            } else {
                Log.wtf((String)LOGTAG, (String)"Library doesn't exist when it should.");
            }
            return throwable;
        }
    }

    public static void doLoadLibrary(Context context, String string) {
        String string2;
        Throwable throwable = GeckoLoader.doLoadLibraryExpected(context, string);
        if (throwable == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 9 && (string2 = context.getApplicationInfo().nativeLibraryDir).contains("mismatched_uid")) {
            throw new RuntimeException("Fatal: mismatched UID: cannot load.");
        }
        string2 = context.getApplicationInfo().dataDir + "/lib/lib" + string + ".so";
        if (GeckoLoader.attemptLoad(string2)) {
            return;
        }
        String string3 = context.getPackageName();
        if (GeckoLoader.attemptLoad("/data/app-lib/" + string3 + "/lib" + string + ".so")) {
            return;
        }
        if (GeckoLoader.attemptLoad("/data/data/" + string3 + "/lib/lib" + string + ".so")) {
            return;
        }
        String string4 = context.getFilesDir() + "/lib";
        String string5 = string4 + "/lib" + string + ".so";
        if (new File(string5).exists() ? GeckoLoader.attemptLoad(string5) : GeckoLoader.extractLibrary(context, string, string4) && GeckoLoader.attemptLoad(string5)) {
            return;
        }
        String string6 = GeckoLoader.getLoadDiagnostics(context, string);
        Log.e((String)LOGTAG, (String)("Load diagnostics: " + string6));
        throw new RuntimeException(string6, throwable);
    }

    public static synchronized void loadMozGlue(Context context) {
        if (sMozGlueLoaded) {
            return;
        }
        GeckoLoader.doLoadLibrary(context, "mozglue");
        sMozGlueLoaded = true;
    }

    public static synchronized void loadGeckoLibs(Context context, String string) {
        GeckoLoader.loadLibsSetupLocked(context);
        GeckoLoader.loadGeckoLibsNative(string);
    }

    private static void setupLocaleEnvironment() {
        GeckoLoader.putenv("LANG=" + Locale.getDefault().toString());
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            DecimalFormat decimalFormat = (DecimalFormat)numberFormat;
            DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
            GeckoLoader.putenv("LOCALE_DECIMAL_POINT=" + decimalFormatSymbols.getDecimalSeparator());
            GeckoLoader.putenv("LOCALE_THOUSANDS_SEP=" + decimalFormatSymbols.getGroupingSeparator());
            GeckoLoader.putenv("LOCALE_GROUPING=" + (char)decimalFormat.getGroupingSize());
        }
    }

    @JNITarget
    public static void abort(String string) {
        Thread thread = Thread.currentThread();
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = thread.getUncaughtExceptionHandler();
        if (uncaughtExceptionHandler != null) {
            uncaughtExceptionHandler.uncaughtException(thread, new AbortException(string));
        }
    }

    private static native void putenv(String var0);

    public static native void nativeRun(String var0);

    private static native void loadGeckoLibsNative(String var0);

    private static native void loadSQLiteLibsNative(String var0);

    private static native void loadNSSLibsNative(String var0);

    public static class AbortException
    extends Exception {
        public AbortException(String string) {
            super(string);
        }
    }
}

