/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.mozglue;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;

public class SafeIntentUtils {
    private static final String LOGTAG = "GeckoContextUtils";

    public static Bundle getBundleExtra(Intent intent, String string) {
        return new SafeIntent(intent).getBundleExtra(string);
    }

    public static String getStringExtra(Intent intent, String string) {
        return new SafeIntent(intent).getStringExtra(string);
    }

    public static boolean getBooleanExtra(Intent intent, String string, boolean bl) {
        return new SafeIntent(intent).getBooleanExtra(string, bl);
    }

    public static class SafeIntent {
        private final Intent intent;

        public SafeIntent(Intent intent) {
            this.intent = intent;
        }

        public boolean getBooleanExtra(String string, boolean bl) {
            try {
                return this.intent.getBooleanExtra(string, bl);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                Log.w((String)SafeIntentUtils.LOGTAG, (String)"Couldn't get intent extras: OOM. Malformed?");
                return bl;
            }
            catch (RuntimeException runtimeException) {
                Log.w((String)SafeIntentUtils.LOGTAG, (String)"Couldn't get intent extras.", (Throwable)runtimeException);
                return bl;
            }
        }

        public String getStringExtra(String string) {
            try {
                return this.intent.getStringExtra(string);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                Log.w((String)SafeIntentUtils.LOGTAG, (String)"Couldn't get intent extras: OOM. Malformed?");
                return null;
            }
            catch (RuntimeException runtimeException) {
                Log.w((String)SafeIntentUtils.LOGTAG, (String)"Couldn't get intent extras.", (Throwable)runtimeException);
                return null;
            }
        }

        public Bundle getBundleExtra(String string) {
            try {
                return this.intent.getBundleExtra(string);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                Log.w((String)SafeIntentUtils.LOGTAG, (String)"Couldn't get intent extras: OOM. Malformed?");
                return null;
            }
            catch (RuntimeException runtimeException) {
                Log.w((String)SafeIntentUtils.LOGTAG, (String)"Couldn't get intent extras.", (Throwable)runtimeException);
                return null;
            }
        }

        public String getAction() {
            return this.intent.getAction();
        }

        public String getDataString() {
            try {
                return this.intent.getDataString();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                Log.w((String)SafeIntentUtils.LOGTAG, (String)"Couldn't get intent data string: OOM. Malformed?");
                return null;
            }
            catch (RuntimeException runtimeException) {
                Log.w((String)SafeIntentUtils.LOGTAG, (String)"Couldn't get intent data string.", (Throwable)runtimeException);
                return null;
            }
        }

        public Uri getData() {
            try {
                return this.intent.getData();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                Log.w((String)SafeIntentUtils.LOGTAG, (String)"Couldn't get intent data: OOM. Malformed?");
                return null;
            }
            catch (RuntimeException runtimeException) {
                Log.w((String)SafeIntentUtils.LOGTAG, (String)"Couldn't get intent data.", (Throwable)runtimeException);
                return null;
            }
        }

        public Intent getUnsafe() {
            return this.intent;
        }
    }
}

