/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.MenuItem;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.ActionModeCompat;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.TextSelectionHandle;
import org.mozilla.gecko.gfx.BitmapUtils;
import org.mozilla.gecko.gfx.ImmutableViewportMetrics;
import org.mozilla.gecko.gfx.Layer;
import org.mozilla.gecko.gfx.LayerView;
import org.mozilla.gecko.menu.GeckoMenu;
import org.mozilla.gecko.menu.GeckoMenuItem;
import org.mozilla.gecko.text.TextSelection;
import org.mozilla.gecko.util.FloatUtils;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.ThreadUtils;

class ActionBarTextSelection
extends Layer
implements TextSelection,
GeckoEventListener,
LayerView.DynamicToolbarListener {
    private static final String LOGTAG = "GeckoTextSelection";
    private static final int SHUTDOWN_DELAY_MS = 250;
    private final TextSelectionHandle anchorHandle;
    private final TextSelectionHandle caretHandle;
    private final TextSelectionHandle focusHandle;
    private final LayerView.DrawListener mDrawListener;
    private boolean mDraggingHandles;
    private String selectionID;
    private float mViewLeft;
    private float mViewTop;
    private float mViewZoom;
    private boolean mForceReposition;
    private String mCurrentItems;
    private TextSelectionActionModeCallback mCallback;
    private final Timer mActionModeTimer = new Timer("actionMode");
    private ActionModeTimerTask mActionModeTimerTask;

    ActionBarTextSelection(TextSelectionHandle textSelectionHandle, TextSelectionHandle textSelectionHandle2, TextSelectionHandle textSelectionHandle3) {
        this.anchorHandle = textSelectionHandle;
        this.caretHandle = textSelectionHandle2;
        this.focusHandle = textSelectionHandle3;
        this.mDrawListener = new LayerView.DrawListener(){

            @Override
            public void drawFinished() {
                if (!ActionBarTextSelection.this.mDraggingHandles) {
                    GeckoAppShell.notifyObservers("TextSelection:LayerReflow", "");
                }
            }
        };
    }

    @Override
    public void create() {
        if (this.anchorHandle == null || this.caretHandle == null || this.focusHandle == null) {
            Log.e((String)LOGTAG, (String)"Failed to initialize text selection because at least one handle is null");
        } else {
            EventDispatcher.getInstance().registerGeckoThreadListener(this, "TextSelection:ActionbarInit", "TextSelection:ActionbarStatus", "TextSelection:ActionbarUninit", "TextSelection:ShowHandles", "TextSelection:HideHandles", "TextSelection:PositionHandles", "TextSelection:Update", "TextSelection:DraggingHandle");
        }
    }

    @Override
    public boolean dismiss() {
        return false;
    }

    @Override
    public void destroy() {
        EventDispatcher.getInstance().unregisterGeckoThreadListener(this, "TextSelection:ActionbarInit", "TextSelection:ActionbarStatus", "TextSelection:ActionbarUninit", "TextSelection:ShowHandles", "TextSelection:HideHandles", "TextSelection:PositionHandles", "TextSelection:Update", "TextSelection:DraggingHandle");
    }

    private TextSelectionHandle getHandle(String string2) {
        switch (TextSelectionHandle.HandleType.valueOf(string2)) {
            case ANCHOR: {
                return this.anchorHandle;
            }
            case CARET: {
                return this.caretHandle;
            }
            case FOCUS: {
                return this.focusHandle;
            }
        }
        throw new IllegalArgumentException("TextSelectionHandle is invalid type.");
    }

    public void handleMessage(final String string2, final JSONObject jSONObject) {
        if ("TextSelection:DraggingHandle".equals(string2)) {
            this.mDraggingHandles = jSONObject.optBoolean("dragging", false);
            return;
        }
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    if (string2.equals("TextSelection:ShowHandles")) {
                        Telemetry.sendUIEvent(TelemetryContract.Event.SHOW, TelemetryContract.Method.CONTENT, "text_selection");
                        ActionBarTextSelection.this.selectionID = jSONObject.getString("selectionID");
                        JSONArray jSONArray = jSONObject.getJSONArray("handles");
                        for (int i = 0; i < jSONArray.length(); ++i) {
                            String string22 = jSONArray.getString(i);
                            ActionBarTextSelection.this.getHandle(string22).setVisibility(0);
                        }
                        ActionBarTextSelection.this.mViewLeft = 0.0f;
                        ActionBarTextSelection.this.mViewTop = 0.0f;
                        ActionBarTextSelection.this.mViewZoom = 0.0f;
                        LayerView layerView = GeckoAppShell.getLayerView();
                        if (layerView != null) {
                            layerView.addDrawListener(ActionBarTextSelection.this.mDrawListener);
                            layerView.addLayer(ActionBarTextSelection.this);
                            layerView.getDynamicToolbarAnimator().addTranslationListener(ActionBarTextSelection.this);
                        }
                        if (jSONArray.length() > 1) {
                            GeckoAppShell.performHapticFeedback(true);
                        }
                    } else if (string2.equals("TextSelection:Update")) {
                        if (ActionBarTextSelection.this.mActionModeTimerTask != null) {
                            ActionBarTextSelection.this.mActionModeTimerTask.cancel();
                        }
                        ActionBarTextSelection.this.showActionMode(jSONObject.getJSONArray("actions"));
                    } else if (string2.equals("TextSelection:HideHandles")) {
                        LayerView layerView = GeckoAppShell.getLayerView();
                        if (layerView != null) {
                            layerView.removeDrawListener(ActionBarTextSelection.this.mDrawListener);
                            layerView.removeLayer(ActionBarTextSelection.this);
                            layerView.getDynamicToolbarAnimator().removeTranslationListener(ActionBarTextSelection.this);
                        }
                        ActionBarTextSelection.this.mActionModeTimerTask = new ActionModeTimerTask();
                        ActionBarTextSelection.this.mActionModeTimer.schedule((TimerTask)ActionBarTextSelection.this.mActionModeTimerTask, 250L);
                        ActionBarTextSelection.this.anchorHandle.setVisibility(8);
                        ActionBarTextSelection.this.caretHandle.setVisibility(8);
                        ActionBarTextSelection.this.focusHandle.setVisibility(8);
                    } else if (string2.equals("TextSelection:PositionHandles")) {
                        JSONArray jSONArray = jSONObject.getJSONArray("positions");
                        for (int i = 0; i < jSONArray.length(); ++i) {
                            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                            int n = jSONObject2.getInt("left");
                            int n2 = jSONObject2.getInt("top");
                            boolean bl = jSONObject2.getBoolean("rtl");
                            TextSelectionHandle textSelectionHandle = ActionBarTextSelection.this.getHandle(jSONObject2.getString("handle"));
                            textSelectionHandle.setVisibility(jSONObject2.getBoolean("hidden") ? 8 : 0);
                            textSelectionHandle.positionFromGecko(n, n2, bl);
                        }
                    } else if (string2.equals("TextSelection:ActionbarInit")) {
                        Telemetry.sendUIEvent(TelemetryContract.Event.SHOW, TelemetryContract.Method.CONTENT, "text_selection");
                        ActionBarTextSelection.this.selectionID = jSONObject.getString("selectionID");
                        ActionBarTextSelection.this.mCurrentItems = null;
                        if (ActionBarTextSelection.this.mActionModeTimerTask != null) {
                            ActionBarTextSelection.this.mActionModeTimerTask.cancel();
                        }
                    } else if (string2.equals("TextSelection:ActionbarStatus")) {
                        if (ActionBarTextSelection.this.selectionID != jSONObject.optString("selectionID")) {
                            return;
                        }
                        ActionBarTextSelection.this.showActionMode(jSONObject.getJSONArray("actions"));
                    } else if (string2.equals("TextSelection:ActionbarUninit")) {
                        ActionBarTextSelection.this.mCurrentItems = null;
                        ActionBarTextSelection.this.mActionModeTimerTask = new ActionModeTimerTask();
                        ActionBarTextSelection.this.mActionModeTimer.schedule((TimerTask)ActionBarTextSelection.this.mActionModeTimerTask, 250L);
                    }
                }
                catch (JSONException jSONException) {
                    Log.e((String)ActionBarTextSelection.LOGTAG, (String)"JSON exception", (Throwable)jSONException);
                }
            }
        });
    }

    private void showActionMode(JSONArray jSONArray) {
        String string2 = jSONArray.toString();
        if (string2.equals(this.mCurrentItems)) {
            return;
        }
        this.mCurrentItems = string2;
        if (this.mCallback != null) {
            this.mCallback.updateItems(jSONArray);
            return;
        }
        Context context = this.anchorHandle.getContext();
        if (context instanceof ActionModeCompat.Presenter) {
            ActionModeCompat.Presenter presenter = (ActionModeCompat.Presenter)context;
            this.mCallback = new TextSelectionActionModeCallback(jSONArray);
            presenter.startActionModeCompat(this.mCallback);
            this.mCallback.animateIn();
        }
    }

    private void endActionMode() {
        Context context = this.anchorHandle.getContext();
        if (context instanceof ActionModeCompat.Presenter) {
            ActionModeCompat.Presenter presenter = (ActionModeCompat.Presenter)context;
            presenter.endActionModeCompat();
        }
        this.mCurrentItems = null;
    }

    @Override
    public void draw(Layer.RenderContext renderContext) {
        final float f = renderContext.viewport.left;
        final float f2 = renderContext.viewport.top;
        final float f3 = renderContext.zoomFactor;
        if (!this.mForceReposition && FloatUtils.fuzzyEquals((float)this.mViewLeft, (float)f) && FloatUtils.fuzzyEquals((float)this.mViewTop, (float)f2) && FloatUtils.fuzzyEquals((float)this.mViewZoom, (float)f3)) {
            return;
        }
        this.mForceReposition = false;
        this.mViewLeft = f;
        this.mViewTop = f2;
        this.mViewZoom = f3;
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ActionBarTextSelection.this.anchorHandle.repositionWithViewport(f, f2, f3);
                ActionBarTextSelection.this.caretHandle.repositionWithViewport(f, f2, f3);
                ActionBarTextSelection.this.focusHandle.repositionWithViewport(f, f2, f3);
            }
        });
    }

    @Override
    public void onTranslationChanged(float f, float f2) {
        this.mForceReposition = true;
    }

    @Override
    public void onPanZoomStopped() {
    }

    @Override
    public void onMetricsChanged(ImmutableViewportMetrics immutableViewportMetrics) {
        this.mForceReposition = true;
    }

    private class TextSelectionActionModeCallback
    implements ActionModeCompat.Callback {
        private JSONArray mItems;
        private ActionModeCompat mActionMode;

        public TextSelectionActionModeCallback(JSONArray jSONArray) {
            this.mItems = jSONArray;
        }

        public void updateItems(JSONArray jSONArray) {
            this.mItems = jSONArray;
            if (this.mActionMode != null) {
                this.mActionMode.invalidate();
            }
        }

        public void animateIn() {
            if (this.mActionMode != null) {
                this.mActionMode.animateIn();
            }
        }

        @Override
        public boolean onPrepareActionMode(ActionModeCompat actionModeCompat, GeckoMenu geckoMenu) {
            geckoMenu.clear();
            int n = this.mItems.length();
            for (int i = 0; i < n; ++i) {
                try {
                    JSONObject jSONObject = this.mItems.getJSONObject(i);
                    final GeckoMenuItem geckoMenuItem = (GeckoMenuItem)geckoMenu.add(0, i, 0, jSONObject.optString("label"));
                    int n2 = jSONObject.optBoolean("showAsAction") ? 2 : 0;
                    geckoMenuItem.setShowAsAction(n2, R.attr.menuItemActionModeStyle);
                    String string2 = jSONObject.optString("icon");
                    BitmapUtils.getDrawable(ActionBarTextSelection.this.anchorHandle.getContext(), string2, new BitmapUtils.BitmapLoader(){

                        @Override
                        public void onBitmapFound(Drawable drawable2) {
                            if (drawable2 != null) {
                                geckoMenuItem.setIcon(drawable2);
                            }
                        }
                    });
                    continue;
                }
                catch (Exception exception) {
                    Log.i((String)ActionBarTextSelection.LOGTAG, (String)"Exception building menu", (Throwable)exception);
                }
            }
            return true;
        }

        @Override
        public boolean onCreateActionMode(ActionModeCompat actionModeCompat, GeckoMenu geckoMenu) {
            this.mActionMode = actionModeCompat;
            return true;
        }

        @Override
        public boolean onActionItemClicked(ActionModeCompat actionModeCompat, MenuItem menuItem) {
            try {
                JSONObject jSONObject = this.mItems.getJSONObject(menuItem.getItemId());
                GeckoAppShell.notifyObservers("TextSelection:Action", jSONObject.optString("id"));
                return true;
            }
            catch (Exception exception) {
                Log.i((String)ActionBarTextSelection.LOGTAG, (String)"Exception calling action", (Throwable)exception);
                return false;
            }
        }

        @Override
        public void onDestroyActionMode(ActionModeCompat actionModeCompat) {
            this.mActionMode = null;
            ActionBarTextSelection.this.mCallback = null;
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("selectionID", (Object)ActionBarTextSelection.this.selectionID);
            }
            catch (JSONException jSONException) {
                Log.e((String)ActionBarTextSelection.LOGTAG, (String)"Error building JSON arguments for TextSelection:End", (Throwable)jSONException);
                return;
            }
            GeckoAppShell.notifyObservers("TextSelection:End", jSONObject.toString());
        }
    }

    private class ActionModeTimerTask
    extends TimerTask {
        private ActionModeTimerTask() {
        }

        @Override
        public void run() {
            ThreadUtils.postToUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ActionBarTextSelection.this.endActionMode();
                }
            });
        }
    }
}

