/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoProfileDirectories;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.GeckoThread;
import org.mozilla.gecko.GuestSession;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.annotation.RobocopTarget;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.db.LocalBrowserDB;
import org.mozilla.gecko.db.StubBrowserDB;
import org.mozilla.gecko.distribution.Distribution;
import org.mozilla.gecko.mozglue.SafeIntentUtils;
import org.mozilla.gecko.preferences.DistroSharedPrefsImport;
import org.mozilla.gecko.util.ContextUtils;
import org.mozilla.gecko.util.FileUtils;
import org.mozilla.gecko.util.INIParser;
import org.mozilla.gecko.util.INISection;

public final class GeckoProfile {
    private static final String LOGTAG = "GeckoProfile";
    private static final String CLIENT_ID_FILE_PATH = "datareporting/state.json";
    private static final String FHR_CLIENT_ID_FILE_PATH = "healthreport/state.json";
    private static final String CLIENT_ID_JSON_ATTR = "clientID";
    private static final String TIMES_PATH = "times.json";
    private static final String PROFILE_CREATION_DATE_JSON_ATTR = "created";
    private static volatile boolean sAcceptDirectoryChanges = true;
    public static final String DEFAULT_PROFILE = "default";
    public static final String CUSTOM_PROFILE = "";
    public static final String GUEST_PROFILE_DIR = "guest";
    private static final String SESSION_FILE = "sessionstore.js";
    private static final String SESSION_FILE_BACKUP = "sessionstore.bak";
    private static final long MAX_BACKUP_FILE_AGE = 86400000L;
    private boolean mOldSessionDataProcessed = false;
    private static final HashMap<String, GeckoProfile> sProfileCache = new HashMap();
    private static String sDefaultProfileName;
    private final String mName;
    private final File mMozillaDir;
    private final Context mApplicationContext;
    private final BrowserDB mDB;
    private File mProfileDir;
    private Boolean mInGuestMode;
    private static volatile BrowserDB.Factory sDBFactory;

    @RobocopTarget
    public static void enableDirectoryChanges() {
        Log.w((String)LOGTAG, (String)"Directory changes should only be enabled for tests. And even then it's a bad idea.");
        sAcceptDirectoryChanges = true;
    }

    public static GeckoProfile initFromArgs(Context context, String string2) {
        Pattern pattern;
        Matcher matcher;
        Object object;
        if (GuestSession.shouldUse(context)) {
            object = GeckoProfile.getGuestProfile(context);
            if (object != null) {
                return object;
            }
            GuestSession.leave(context);
        }
        if (GeckoProfile.getGuestDir(context).isDirectory() && (object = GeckoProfile.getGuestProfile(context)) != null) {
            GeckoProfile.removeProfile(context, (GeckoProfile)object);
        }
        object = null;
        String string3 = null;
        if (string2 != null && string2.contains("-P") && (matcher = (pattern = Pattern.compile("(?:-P\\s*)(\\w*)(\\s*)")).matcher(string2)).find()) {
            object = matcher.group(1);
        }
        if (string2 != null && string2.contains("-profile") && (matcher = (pattern = Pattern.compile("(?:-profile\\s*)(\\S*)(\\s*)")).matcher(string2)).find()) {
            string3 = matcher.group(1);
        }
        if (object == null && string3 == null) {
            return GeckoProfile.getDefaultProfile(context);
        }
        return GeckoProfile.get(context, (String)object, string3);
    }

    private static GeckoProfile getDefaultProfile(Context context) {
        try {
            return GeckoProfile.get(context, GeckoProfile.getDefaultProfileName(context));
        }
        catch (GeckoProfileDirectories.NoMozillaDirectoryException noMozillaDirectoryException) {
            Log.wtf((String)LOGTAG, (String)"Unable to get default profile name.", (Throwable)noMozillaDirectoryException);
            throw new RuntimeException(noMozillaDirectoryException);
        }
    }

    public static GeckoProfile get(Context context) {
        return GeckoProfile.get(context, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GeckoProfile get(Context context, String string2) {
        HashMap<String, GeckoProfile> hashMap = sProfileCache;
        synchronized (hashMap) {
            GeckoProfile geckoProfile = sProfileCache.get(string2);
            if (geckoProfile != null) {
                return geckoProfile;
            }
        }
        return GeckoProfile.get(context, string2, (File)null);
    }

    @RobocopTarget
    public static GeckoProfile get(Context context, String string2, String string3) {
        File file = null;
        if (!(TextUtils.isEmpty((CharSequence)string3) || (file = new File(string3)).exists() && file.isDirectory())) {
            Log.w((String)LOGTAG, (String)("requested profile directory missing: " + string3));
        }
        return GeckoProfile.get(context, string2, file);
    }

    public static void setBrowserDBFactory(BrowserDB.Factory factory) {
        sDBFactory = factory;
    }

    @RobocopTarget
    public static GeckoProfile get(Context context, String string2, File file) {
        if (sDBFactory == null) {
            Log.d((String)LOGTAG, (String)"Defaulting to StubBrowserDB.");
            sDBFactory = StubBrowserDB.getFactory();
        }
        return GeckoProfile.get(context, string2, file, sDBFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GeckoProfile get(Context context, String string2, File file, BrowserDB.Factory factory) {
        if (context == null) {
            throw new IllegalArgumentException("context must be non-null");
        }
        if (string2 == null && file == null) {
            GeckoProfile geckoProfile = GeckoThread.getActiveProfile();
            if (geckoProfile != null) {
                return geckoProfile;
            }
            String string3 = context instanceof Activity ? SafeIntentUtils.getStringExtra((Intent)((Activity)context).getIntent(), (String)"args") : null;
            return GeckoProfile.initFromArgs(context, string3);
        }
        if (string2 == null) {
            string2 = CUSTOM_PROFILE;
        }
        HashMap<String, GeckoProfile> hashMap = sProfileCache;
        synchronized (hashMap) {
            boolean bl = file != null && file.mkdirs();
            GeckoProfile geckoProfile = sProfileCache.get(string2);
            if (geckoProfile == null) {
                try {
                    geckoProfile = new GeckoProfile(context, string2, file, factory);
                }
                catch (GeckoProfileDirectories.NoMozillaDirectoryException noMozillaDirectoryException) {
                    throw new RuntimeException(noMozillaDirectoryException);
                }
                sProfileCache.put(string2, geckoProfile);
            } else if (file != null) {
                boolean bl2 = false;
                try {
                    bl2 = geckoProfile.getDir().getCanonicalPath().equals(file.getCanonicalPath());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!bl2) {
                    if (!sAcceptDirectoryChanges || !file.isDirectory()) {
                        throw new IllegalStateException("Refusing to reuse profile with a different directory.");
                    }
                    geckoProfile.setDir(file);
                }
            }
            if (bl) {
                geckoProfile.enqueueInitialization(file);
            }
            return geckoProfile;
        }
    }

    @RobocopTarget
    public static boolean removeProfile(Context context, GeckoProfile geckoProfile) {
        boolean bl = geckoProfile.remove();
        if (bl) {
            GeckoSharedPrefs.forProfileName(context, geckoProfile.getName()).edit().clear().apply();
        }
        return bl;
    }

    private static File getGuestDir(Context context) {
        return context.getFileStreamPath(GUEST_PROFILE_DIR);
    }

    @RobocopTarget
    public static GeckoProfile getGuestProfile(Context context) {
        return GeckoProfile.get(context, CUSTOM_PROFILE, GeckoProfile.getGuestDir(context));
    }

    public static boolean isGuestProfile(Context context, String string2, File file) {
        if (file == null || !CUSTOM_PROFILE.equals(string2)) {
            return false;
        }
        try {
            return file.getCanonicalPath().equals(GeckoProfile.getGuestDir(context).getCanonicalPath());
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private GeckoProfile(Context context, String string2, File file, BrowserDB.Factory factory) throws GeckoProfileDirectories.NoMozillaDirectoryException {
        if (string2 == null) {
            throw new IllegalArgumentException("Unable to create GeckoProfile for empty profile name.");
        }
        if (CUSTOM_PROFILE.equals(string2) && file == null) {
            throw new IllegalArgumentException("Custom profile must have a directory");
        }
        this.mApplicationContext = context.getApplicationContext();
        this.mName = string2;
        this.mMozillaDir = GeckoProfileDirectories.getMozillaDirectory(context);
        this.mProfileDir = file;
        if (file != null && !file.isDirectory()) {
            throw new IllegalArgumentException("Profile directory must exist if specified.");
        }
        this.mDB = factory.get(string2, this.mProfileDir);
    }

    @RobocopTarget
    public BrowserDB getDB() {
        return this.mDB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDir(File file) {
        if (file != null && file.exists() && file.isDirectory()) {
            GeckoProfile geckoProfile = this;
            synchronized (geckoProfile) {
                this.mProfileDir = file;
                this.mInGuestMode = null;
            }
        }
    }

    @RobocopTarget
    public String getName() {
        return this.mName;
    }

    public boolean isCustomProfile() {
        return CUSTOM_PROFILE.equals(this.mName);
    }

    @RobocopTarget
    public boolean inGuestMode() {
        if (this.mInGuestMode == null) {
            this.mInGuestMode = GeckoProfile.isGuestProfile(GeckoAppShell.getApplicationContext(), this.mName, this.mProfileDir);
        }
        return this.mInGuestMode;
    }

    @RobocopTarget
    public synchronized File getDir() {
        this.forceCreate();
        return this.mProfileDir;
    }

    private synchronized GeckoProfile forceCreate() {
        if (this.mProfileDir != null) {
            return this;
        }
        try {
            try {
                this.mProfileDir = this.findProfileDir();
                Log.d((String)LOGTAG, (String)"Found profile dir.");
            }
            catch (GeckoProfileDirectories.NoSuchProfileException noSuchProfileException) {
                this.mProfileDir = this.createProfileDir();
            }
        }
        catch (IOException iOException) {
            Log.e((String)LOGTAG, (String)"Error getting profile dir", (Throwable)iOException);
        }
        return this;
    }

    public File getFile(String string2) {
        File file = this.getDir();
        if (file == null) {
            return null;
        }
        return new File(file, string2);
    }

    @WorkerThread
    public String getClientId() throws IOException {
        try {
            return this.getValidClientIdFromDisk(CLIENT_ID_FILE_PATH);
        }
        catch (IOException iOException) {
            String string2;
            Log.d((String)LOGTAG, (String)("Could not get client ID - attempting to migrate ID from FHR: " + iOException.getLocalizedMessage()));
            try {
                string2 = this.getValidClientIdFromDisk(FHR_CLIENT_ID_FILE_PATH);
            }
            catch (IOException iOException2) {
                Log.d((String)LOGTAG, (String)("Could not migrate client ID from FHR \u2013 creating a new one: " + iOException2.getLocalizedMessage()));
                string2 = GeckoProfile.generateNewClientId();
            }
            this.persistClientId(string2);
            return this.getValidClientIdFromDisk(CLIENT_ID_FILE_PATH);
        }
    }

    protected static String generateNewClientId() {
        return UUID.randomUUID().toString();
    }

    @WorkerThread
    private String getValidClientIdFromDisk(String string2) throws IOException {
        JSONObject jSONObject = this.readJSONObjectFromFile(string2);
        String string3 = jSONObject.optString(CLIENT_ID_JSON_ATTR);
        if (GeckoProfile.isClientIdValid(string3)) {
            return string3;
        }
        throw new IOException("Received client ID is invalid: " + string3);
    }

    @WorkerThread
    private void persistClientId(String string2) throws IOException {
        if (!this.ensureParentDirs(CLIENT_ID_FILE_PATH)) {
            throw new IOException("Could not create client ID parent directories");
        }
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put(CLIENT_ID_JSON_ATTR, (Object)string2);
        }
        catch (JSONException jSONException) {
            throw new IOException("Could not create client ID JSON object", jSONException);
        }
        Log.d((String)LOGTAG, (String)"Attempting to write new client ID");
        this.writeFile(CLIENT_ID_FILE_PATH, jSONObject.toString());
    }

    public static boolean isClientIdValid(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        return string2.matches("(?i:[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})");
    }

    @WorkerThread
    public long getAndPersistProfileCreationDate(Context context) {
        try {
            return this.getProfileCreationDateFromTimesFile();
        }
        catch (IOException iOException) {
            Log.d((String)LOGTAG, (String)"Unable to retrieve profile creation date from times.json. Getting from system...");
            long l = ContextUtils.getCurrentPackageInfo((Context)context).firstInstallTime;
            try {
                this.persistProfileCreationDateToTimesFile(l);
            }
            catch (IOException iOException2) {
                Log.w((String)LOGTAG, (String)"Unable to persist profile creation date - returning -1");
                return -1L;
            }
            return l;
        }
    }

    @WorkerThread
    private long getProfileCreationDateFromTimesFile() throws IOException {
        JSONObject jSONObject = this.readJSONObjectFromFile(TIMES_PATH);
        try {
            return jSONObject.getLong(PROFILE_CREATION_DATE_JSON_ATTR);
        }
        catch (JSONException jSONException) {
            throw new IOException("Profile creation does not exist in JSONObject");
        }
    }

    @WorkerThread
    private void persistProfileCreationDateToTimesFile(long l) throws IOException {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put(PROFILE_CREATION_DATE_JSON_ATTR, l);
        }
        catch (JSONException jSONException) {
            throw new IOException("Unable to persist profile creation date to times file");
        }
        Log.d((String)LOGTAG, (String)"Attempting to write new profile creation date");
        this.writeFile(TIMES_PATH, jSONObject.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSessionFile(boolean bl) {
        Object object;
        File file = this.getFile(SESSION_FILE_BACKUP);
        if (!bl) {
            object = this.getFile(SESSION_FILE);
            if (object != null && ((File)object).exists()) {
                ((File)object).renameTo(file);
            }
        } else if (file != null && file.exists() && System.currentTimeMillis() - file.lastModified() > 86400000L) {
            file.delete();
        }
        object = this;
        synchronized (object) {
            this.mOldSessionDataProcessed = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForOldSessionDataProcessing() {
        GeckoProfile geckoProfile = this;
        synchronized (geckoProfile) {
            while (!this.mOldSessionDataProcessed) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public String readSessionFile(boolean bl) {
        File file = this.getFile(bl ? SESSION_FILE_BACKUP : SESSION_FILE);
        try {
            if (file != null && file.exists()) {
                return this.readFile(file);
            }
        }
        catch (IOException iOException) {
            Log.e((String)LOGTAG, (String)"Unable to read session file", (Throwable)iOException);
        }
        return null;
    }

    @WorkerThread
    protected boolean ensureParentDirs(String string2) {
        File file = new File(this.getDir(), string2);
        File file2 = file.getParentFile();
        return file2.mkdirs() || file2.isDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFile(String string2, String string3) {
        File file = new File(this.getDir(), string2);
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(file, false));
            bufferedWriter.write(string3);
        }
        catch (IOException iOException) {
            Log.e((String)LOGTAG, (String)"Unable to write to file", (Throwable)iOException);
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (IOException iOException) {
                Log.e((String)LOGTAG, (String)"Error closing writer while writing to file", (Throwable)iOException);
            }
        }
    }

    @WorkerThread
    public JSONObject readJSONObjectFromFile(String string2) throws IOException {
        String string3;
        try {
            string3 = this.readFile(string2);
        }
        catch (IOException iOException) {
            throw new IOException("Could not access given file to retrieve JSONObject");
        }
        try {
            return new JSONObject(string3);
        }
        catch (JSONException jSONException) {
            throw new IOException("Could not parse JSON to retrieve JSONObject");
        }
    }

    public JSONArray readJSONArrayFromFile(String string2) {
        JSONArray jSONArray;
        String string3;
        try {
            string3 = this.readFile(string2);
        }
        catch (IOException iOException) {
            return new JSONArray();
        }
        try {
            jSONArray = new JSONArray(string3);
        }
        catch (JSONException jSONException) {
            jSONArray = new JSONArray();
        }
        return jSONArray;
    }

    public String readFile(String string2) throws IOException {
        File file = this.getDir();
        if (file == null) {
            throw new IOException("No profile directory found");
        }
        File file2 = new File(file, string2);
        return this.readFile(file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(File file) throws IOException {
        try (FileReader fileReader = new FileReader(file);){
            StringBuilder stringBuilder = new StringBuilder();
            char[] cArray = new char[8192];
            int n = fileReader.read(cArray);
            while (n >= 0) {
                stringBuilder.append(cArray, 0, n);
                n = fileReader.read(cArray);
            }
            String string2 = stringBuilder.toString();
            return string2;
        }
    }

    public boolean deleteFileFromProfileDir(String string2) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("Filename cannot be empty.");
        }
        File file = new File(this.getDir(), string2);
        return file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean remove() {
        try {
            GeckoProfile geckoProfile = this;
            synchronized (geckoProfile) {
                if (this.mProfileDir != null && this.mProfileDir.exists()) {
                    FileUtils.delete((File)this.mProfileDir);
                }
                if (this.isCustomProfile()) {
                    return true;
                }
                try {
                    this.findProfileDir();
                    this.mProfileDir = null;
                }
                catch (GeckoProfileDirectories.NoSuchProfileException noSuchProfileException) {
                    return true;
                }
            }
            geckoProfile = GeckoProfileDirectories.getProfilesINI(this.mMozillaDir);
            Hashtable hashtable = geckoProfile.getSections();
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                INISection iNISection = (INISection)enumeration.nextElement();
                String string2 = iNISection.getStringProperty("Name");
                if (string2 == null || !string2.equals(this.mName)) continue;
                if (iNISection.getName().startsWith("Profile")) {
                    try {
                        int n = Integer.parseInt(iNISection.getName().substring("Profile".length()));
                        String string3 = "Profile" + n;
                        String string4 = "Profile" + (n + 1);
                        hashtable.remove(string3);
                        while (hashtable.containsKey(string4)) {
                            geckoProfile.renameSection(string4, string3);
                            string3 = string4;
                            string4 = "Profile" + (++n + 1);
                        }
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        Log.e((String)LOGTAG, (String)("Malformed section name in profiles.ini: " + iNISection.getName()));
                        return false;
                    }
                }
                geckoProfile.removeSection(this.mName);
                break;
            }
            geckoProfile.write();
            return true;
        }
        catch (IOException iOException) {
            Log.w((String)LOGTAG, (String)"Failed to remove profile.", (Throwable)iOException);
            return false;
        }
    }

    public static String getDefaultProfileName(Context context) throws GeckoProfileDirectories.NoMozillaDirectoryException {
        if (sDefaultProfileName != null) {
            return sDefaultProfileName;
        }
        String string2 = GeckoProfileDirectories.findDefaultProfileName(context);
        if (string2 == null) {
            sDefaultProfileName = DEFAULT_PROFILE;
            return DEFAULT_PROFILE;
        }
        sDefaultProfileName = string2;
        return sDefaultProfileName;
    }

    private File findProfileDir() throws GeckoProfileDirectories.NoSuchProfileException {
        if (this.isCustomProfile()) {
            return this.mProfileDir;
        }
        return GeckoProfileDirectories.findProfileDir(this.mMozillaDir, this.mName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private File createProfileDir() throws IOException {
        Object object;
        INISection iNISection;
        if (this.isCustomProfile()) {
            return this.mProfileDir;
        }
        INIParser iNIParser = GeckoProfileDirectories.getProfilesINI(this.mMozillaDir);
        String string2 = GeckoProfileDirectories.saltProfileName(this.mName);
        File file = new File(this.mMozillaDir, string2);
        while (file.exists()) {
            string2 = GeckoProfileDirectories.saltProfileName(this.mName);
            file = new File(this.mMozillaDir, string2);
        }
        if (!file.mkdirs()) {
            throw new IOException("Unable to create profile.");
        }
        Log.d((String)LOGTAG, (String)"Created new profile dir.");
        int n = 0;
        boolean bl = false;
        while ((iNISection = iNIParser.getSection("Profile" + n)) != null) {
            ++n;
            if (iNISection.getProperty("Default") == null) continue;
            bl = true;
        }
        iNISection = new INISection("Profile" + n);
        iNISection.setProperty("Name", (Object)this.mName);
        iNISection.setProperty("IsRelative", (Object)1);
        iNISection.setProperty("Path", (Object)string2);
        if (iNIParser.getSection("General") == null) {
            object = new INISection("General");
            object.setProperty("StartWithLastProfile", (Object)1);
            iNIParser.addSection(object);
        }
        if (!bl) {
            iNISection.setProperty("Default", (Object)1);
            Telemetry.startUISession(TelemetryContract.Session.FIRSTRUN);
        }
        iNIParser.addSection(iNISection);
        iNIParser.write();
        this.enqueueInitialization(file);
        try {
            object = new FileOutputStream(file.getAbsolutePath() + File.separator + TIMES_PATH);
            try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)object, Charset.forName("UTF-8"));){
                outputStreamWriter.append("{\"created\": " + System.currentTimeMillis() + "}\n");
            }
        }
        catch (Exception exception) {
            Log.w((String)LOGTAG, (String)"Couldn't write times.json", (Throwable)exception);
        }
        this.persistClientId(GeckoProfile.generateNewClientId());
        object = GeckoSharedPrefs.forProfile(this.mApplicationContext);
        object.edit().putBoolean("startpane_enabled", true).apply();
        return file;
    }

    @RobocopTarget
    public void enqueueInitialization(final File file) {
        Log.i((String)LOGTAG, (String)"Enqueuing profile init.");
        final Context context = this.mApplicationContext;
        Distribution distribution = Distribution.getInstance(context);
        distribution.addOnDistributionReadyCallback(new Distribution.ReadyCallback(){

            @Override
            public void distributionNotFound() {
                this.distributionFound(null);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void distributionFound(Distribution distribution) {
                Log.d((String)GeckoProfile.LOGTAG, (String)"Running post-distribution task: bookmarks.");
                ContentResolver contentResolver = context.getContentResolver();
                GeckoProfile geckoProfile = GeckoProfile.this;
                synchronized (geckoProfile) {
                    if (!file.exists()) {
                        return;
                    }
                    LocalBrowserDB localBrowserDB = new LocalBrowserDB(GeckoProfile.this.getName());
                    int n = distribution == null ? 0 : localBrowserDB.addDistributionBookmarks(contentResolver, distribution, 0);
                    localBrowserDB.addDefaultBookmarks(context, contentResolver, n);
                    Log.d((String)GeckoProfile.LOGTAG, (String)"Running post-distribution task: android preferences.");
                    DistroSharedPrefsImport.importPreferences(context, distribution);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void distributionArrivedLate(Distribution distribution) {
                Log.d((String)GeckoProfile.LOGTAG, (String)"Running late distribution task: bookmarks.");
                GeckoProfile geckoProfile = GeckoProfile.this;
                synchronized (geckoProfile) {
                    if (!file.exists()) {
                        return;
                    }
                    LocalBrowserDB localBrowserDB = new LocalBrowserDB(GeckoProfile.this.getName());
                    ContentResolver contentResolver = context.getContentResolver();
                    int n = localBrowserDB.getCount(contentResolver, "bookmarks");
                    localBrowserDB.addDistributionBookmarks(contentResolver, distribution, n);
                    Log.d((String)GeckoProfile.LOGTAG, (String)"Running late distribution task: android preferences.");
                    DistroSharedPrefsImport.importPreferences(context, distribution);
                }
            }
        });
    }
}

