/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.MimeTypeMap;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.ActivityHandlerHelper;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.R;
import org.mozilla.gecko.util.ActivityResultHandler;
import org.mozilla.gecko.util.EventCallback;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.JSONUtils;
import org.mozilla.gecko.util.NativeEventListener;
import org.mozilla.gecko.util.NativeJSObject;
import org.mozilla.gecko.util.WebActivityMapper;
import org.mozilla.gecko.widget.ExternalIntentDuringPrivateBrowsingPromptFragment;

public final class IntentHelper
implements GeckoEventListener,
NativeEventListener {
    private static final String LOGTAG = "GeckoIntentHelper";
    private static final String[] EVENTS = new String[]{"Intent:GetHandlers", "Intent:Open", "Intent:OpenForResult", "WebActivity:Open"};
    private static final String[] NATIVE_EVENTS = new String[]{"Intent:OpenNoHandler"};
    private static String MARKET_INTENT_URI_PACKAGE_PREFIX = "market://details?id=";
    private static String EXTRA_BROWSER_FALLBACK_URL = "browser_fallback_url";
    private static String UNKNOWN_PROTOCOL_URI_PREFIX = "about:neterror?e=unknownProtocolFound&u=";
    private static IntentHelper instance;
    private final FragmentActivity activity;

    private IntentHelper(FragmentActivity fragmentActivity) {
        this.activity = fragmentActivity;
        EventDispatcher.getInstance().registerGeckoThreadListener(this, EVENTS);
        EventDispatcher.getInstance().registerGeckoThreadListener(this, NATIVE_EVENTS);
    }

    public static IntentHelper init(FragmentActivity fragmentActivity) {
        if (instance == null) {
            instance = new IntentHelper(fragmentActivity);
        } else {
            Log.w((String)LOGTAG, (String)"IntentHelper.init() called twice, ignoring.");
        }
        return instance;
    }

    public static void destroy() {
        if (instance != null) {
            EventDispatcher.getInstance().unregisterGeckoThreadListener(instance, EVENTS);
            EventDispatcher.getInstance().unregisterGeckoThreadListener(instance, NATIVE_EVENTS);
            instance = null;
        }
    }

    public static boolean openUriExternal(String string2, String string3, String string4, String string5, String string6, String string7, boolean bl) {
        GeckoAppShell.GeckoInterface geckoInterface = GeckoAppShell.getGeckoInterface();
        Activity activity = geckoInterface != null ? geckoInterface.getActivity() : null;
        Object object = activity != null ? activity : GeckoAppShell.getApplicationContext();
        Intent intent = IntentHelper.getOpenURIIntent((Context)object, string2, string3, string6, string7);
        if (intent == null) {
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)string5)) {
            if (!TextUtils.isEmpty((CharSequence)string4)) {
                intent.setClassName(string4, string5);
            } else {
                intent.setClassName((Context)object, string5);
            }
        }
        if (!bl || activity == null) {
            if (activity == null) {
                intent.addFlags(0x10000000);
            }
            return ActivityHandlerHelper.startIntentAndCatch(LOGTAG, (Context)object, intent);
        }
        FragmentActivity fragmentActivity = (FragmentActivity)activity;
        return ExternalIntentDuringPrivateBrowsingPromptFragment.showDialogOrAndroidChooser((Context)object, fragmentActivity.getSupportFragmentManager(), intent);
    }

    public static boolean hasHandlersForIntent(Intent intent) {
        try {
            return !GeckoAppShell.queryIntentActivities(intent).isEmpty();
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"Exception in hasHandlersForIntent");
            return false;
        }
    }

    public static String[] getHandlersForIntent(Intent intent) {
        PackageManager packageManager = GeckoAppShell.getApplicationContext().getPackageManager();
        try {
            List<ResolveInfo> list = GeckoAppShell.queryIntentActivities(intent);
            int n = 4;
            String[] stringArray = new String[list.size() * n];
            for (int i = 0; i < list.size(); ++i) {
                ResolveInfo resolveInfo = list.get(i);
                stringArray[i * n] = resolveInfo.loadLabel(packageManager).toString();
                stringArray[i * n + 1] = resolveInfo.isDefault ? "default" : "";
                stringArray[i * n + 2] = resolveInfo.activityInfo.applicationInfo.packageName;
                stringArray[i * n + 3] = resolveInfo.activityInfo.name;
            }
            return stringArray;
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"Exception in getHandlersForIntent");
            return new String[0];
        }
    }

    public static Intent getIntentForActionString(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return new Intent("android.intent.action.VIEW");
        }
        return new Intent(string2);
    }

    public static Intent getShareIntent(Context context, String string2, String string3, String string4) {
        Intent intent = IntentHelper.getIntentForActionString("android.intent.action.SEND");
        intent.putExtra("android.intent.extra.TEXT", string2);
        intent.putExtra("android.intent.extra.SUBJECT", string4);
        intent.putExtra("org.mozilla.fennec.intent.extra.DEVICES_ONLY", true);
        intent.putExtra("android.intent.extra.TITLE", string4);
        if (string3 != null && string3.length() > 0) {
            intent.setType(string3);
        }
        return intent;
    }

    static Intent getOpenURIIntent(Context context, String string2, String string3, String string4, String string5) {
        Intent intent = IntentHelper.getOpenURIIntentInner(context, string2, string3, string4, string5);
        if (intent != null) {
            intent.putExtra("com.android.browser.application_id", "org.mozilla.fennec");
        }
        return intent;
    }

    private static Intent getOpenURIIntentInner(Context context, String string2, String string3, String string4, String string5) {
        String string6;
        if (string4.equalsIgnoreCase("android.intent.action.SEND")) {
            Intent intent = IntentHelper.getShareIntent(context, string2, string3, string5);
            return Intent.createChooser((Intent)intent, (CharSequence)context.getResources().getString(R.string.share_title));
        }
        Uri uri = IntentHelper.normalizeUriScheme(string2.indexOf(58) >= 0 ? Uri.parse((String)string2) : new Uri.Builder().scheme(string2).build());
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            Intent intent = IntentHelper.getIntentForActionString(string4);
            intent.setDataAndType(uri, string3);
            return intent;
        }
        if (!GeckoAppShell.isUriSafeForScheme(uri)) {
            return null;
        }
        String string7 = uri.getScheme();
        if ("intent".equals(string7) || "android-app".equals(string7)) {
            Intent intent;
            try {
                intent = Intent.parseUri((String)string2, (int)0);
            }
            catch (URISyntaxException uRISyntaxException) {
                Log.e((String)LOGTAG, (String)("Unable to parse URI - " + uRISyntaxException));
                return null;
            }
            intent.addCategory("android.intent.category.BROWSABLE");
            intent.setComponent(null);
            IntentHelper.nullIntentSelector(intent);
            return intent;
        }
        String string8 = MimeTypeMap.getFileExtensionFromUrl((String)string2);
        Intent intent = IntentHelper.getIntentForActionString(string4);
        intent.setData(uri);
        if ("file".equals(string7)) {
            String string9 = GeckoAppShell.getMimeTypeFromExtension(string8);
            intent.setType(string9);
            return intent;
        }
        if (!("sms".equals(string7) || "smsto".equals(string7) || "mms".equals(string7) || "mmsto".equals(string7))) {
            return intent;
        }
        String string10 = uri.getEncodedQuery();
        if (TextUtils.isEmpty((CharSequence)string10)) {
            return intent;
        }
        String string11 = uri.toString();
        if (!string11.contains(string6 = string7 + "://")) {
            uri = Uri.parse((String)string11.replaceFirst(string7 + ":", string6));
        }
        String[] stringArray = string10.split("&");
        boolean bl = false;
        String string12 = "";
        for (String string9 : stringArray) {
            String string13;
            if (string9.startsWith("body=")) {
                string13 = Uri.decode((String)string9.substring(5));
                intent.putExtra("sms_body", string13);
                bl = true;
                continue;
            }
            if (string9.startsWith("subject=")) {
                string13 = Uri.decode((String)string9.substring(8));
                intent.putExtra("subject", string13);
                bl = true;
                continue;
            }
            if (string9.startsWith("cc=")) {
                string13 = Uri.decode((String)string9.substring(3));
                String string14 = uri.getAuthority();
                if (string14 != null) {
                    uri = uri.buildUpon().encodedAuthority(string14 + ";" + string13).build();
                }
                bl = true;
                continue;
            }
            string12 = string12.concat(string12.length() > 0 ? "&" + string9 : string9);
        }
        if (!bl) {
            return intent;
        }
        String string15 = string12.length() > 0 ? "?" + string12 : "";
        Uri uri2 = uri.buildUpon().encodedQuery(string15).build();
        intent.setData(uri2);
        return intent;
    }

    @TargetApi(value=15)
    private static void nullIntentSelector(Intent intent) {
        if (!AppConstants.Versions.feature15Plus) {
            return;
        }
        intent.setSelector(null);
    }

    private static Uri normalizeUriScheme(Uri uri) {
        String string2 = uri.getScheme();
        String string3 = string2.toLowerCase(Locale.US);
        if (string3.equals(string2)) {
            return uri;
        }
        return uri.buildUpon().scheme(string3).build();
    }

    public void handleMessage(String string2, NativeJSObject nativeJSObject, EventCallback eventCallback) {
        if (string2.equals("Intent:OpenNoHandler")) {
            this.openNoHandler(nativeJSObject, eventCallback);
        }
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        try {
            if (string2.equals("Intent:GetHandlers")) {
                this.getHandlers(jSONObject);
            } else if (string2.equals("Intent:Open")) {
                this.open(jSONObject);
            } else if (string2.equals("Intent:OpenForResult")) {
                this.openForResult(jSONObject);
            } else if (string2.equals("WebActivity:Open")) {
                this.openWebActivity(jSONObject);
            }
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)("Exception handling message \"" + string2 + "\":"), (Throwable)jSONException);
        }
    }

    private void getHandlers(JSONObject jSONObject) throws JSONException {
        Intent intent = IntentHelper.getOpenURIIntent((Context)this.activity, jSONObject.optString("url"), jSONObject.optString("mime"), jSONObject.optString("action"), jSONObject.optString("title"));
        List<String> list = Arrays.asList(IntentHelper.getHandlersForIntent(intent));
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put("apps", (Object)new JSONArray(list));
        EventDispatcher.sendResponse(jSONObject, jSONObject2);
    }

    private void open(JSONObject jSONObject) throws JSONException {
        IntentHelper.openUriExternal(jSONObject.optString("url"), jSONObject.optString("mime"), jSONObject.optString("packageName"), jSONObject.optString("className"), jSONObject.optString("action"), jSONObject.optString("title"), false);
    }

    private void openForResult(JSONObject jSONObject) throws JSONException {
        Intent intent = IntentHelper.getOpenURIIntent((Context)this.activity, jSONObject.optString("url"), jSONObject.optString("mime"), jSONObject.optString("action"), jSONObject.optString("title"));
        intent.setClassName(jSONObject.optString("packageName"), jSONObject.optString("className"));
        intent.setFlags(0x4000000);
        ResultHandler resultHandler = new ResultHandler(jSONObject);
        try {
            ActivityHandlerHelper.startIntentForActivity((Activity)this.activity, intent, resultHandler);
        }
        catch (SecurityException securityException) {
            Log.w((String)LOGTAG, (String)"Forbidden to launch activity.", (Throwable)securityException);
        }
    }

    private void openNoHandler(NativeJSObject nativeJSObject, EventCallback eventCallback) {
        Intent intent;
        String string2 = nativeJSObject.getString("uri");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            Log.w((String)LOGTAG, (String)"Received empty URL - loading about:neterror");
            eventCallback.sendError((Object)this.getUnknownProtocolErrorPageUri(""));
            return;
        }
        try {
            intent = Intent.parseUri((String)string2, (int)0);
        }
        catch (URISyntaxException uRISyntaxException) {
            String string3;
            try {
                string3 = this.getUnknownProtocolErrorPageUri(URLEncoder.encode(string2, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string3 = this.getUnknownProtocolErrorPageUri("");
            }
            Log.w((String)LOGTAG, (String)"Unable to parse Intent URI - loading about:neterror");
            eventCallback.sendError((Object)string3);
            return;
        }
        String string4 = intent.getStringExtra(EXTRA_BROWSER_FALLBACK_URL);
        if (IntentHelper.isFallbackUrlValid(string4)) {
            eventCallback.sendError((Object)string4);
        } else if (intent.getPackage() != null) {
            String string5 = MARKET_INTENT_URI_PACKAGE_PREFIX + intent.getPackage();
            Intent intent2 = new Intent("android.intent.action.VIEW", Uri.parse((String)string5));
            intent2.addCategory("android.intent.category.BROWSABLE");
            intent2.addFlags(0x10000000);
            ExternalIntentDuringPrivateBrowsingPromptFragment.showDialogOrAndroidChooser((Context)this.activity, this.activity.getSupportFragmentManager(), intent2);
            eventCallback.sendSuccess(null);
        } else {
            Log.w((String)LOGTAG, (String)"Unable to open URI - ignoring click");
            eventCallback.sendSuccess(null);
        }
    }

    private static boolean isFallbackUrlValid(@Nullable String string2) {
        if (string2 == null) {
            return false;
        }
        try {
            String string3;
            String string4 = new URI(string2).getScheme();
            String string5 = string3 = string4 == null ? null : string4.toLowerCase(Locale.US);
            if ("http".equals(string3) || "https".equals(string3)) {
                return true;
            }
            Log.w((String)LOGTAG, (String)("Fallback URI uses unsupported scheme: " + string3 + ". Try http or https."));
        }
        catch (URISyntaxException uRISyntaxException) {
            Log.w((String)LOGTAG, (String)"URISyntaxException parsing fallback URI");
        }
        return false;
    }

    private String getUnknownProtocolErrorPageUri(String string2) {
        return UNKNOWN_PROTOCOL_URI_PREFIX + string2;
    }

    private void openWebActivity(JSONObject jSONObject) throws JSONException {
        Intent intent = WebActivityMapper.getIntentForWebActivity((JSONObject)jSONObject.getJSONObject("activity"));
        ActivityHandlerHelper.startIntentForActivity((Activity)this.activity, intent, new ResultHandler(jSONObject));
    }

    private static class ResultHandler
    implements ActivityResultHandler {
        private final JSONObject message;

        public ResultHandler(JSONObject jSONObject) {
            this.message = jSONObject;
        }

        public void onActivityResult(int n, Intent intent) {
            JSONObject jSONObject = new JSONObject();
            try {
                if (intent != null) {
                    jSONObject.put("extras", (Object)JSONUtils.bundleToJSON((Bundle)intent.getExtras()));
                    jSONObject.put("uri", (Object)intent.getData().toString());
                }
                jSONObject.put("resultCode", n);
            }
            catch (JSONException jSONException) {
                Log.w((String)IntentHelper.LOGTAG, (String)"Error building JSON response.", (Throwable)jSONException);
            }
            EventDispatcher.sendResponse(this.message, jSONObject);
        }
    }
}

