/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.OvershootInterpolator;
import android.view.animation.ScaleAnimation;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.PrefsHelper;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.gfx.ImmutableViewportMetrics;
import org.mozilla.gecko.gfx.LayerView;
import org.mozilla.gecko.gfx.PanZoomController;
import org.mozilla.gecko.gfx.PointUtils;
import org.mozilla.gecko.mozglue.DirectBufferAllocator;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.ThreadUtils;

public class ZoomedView
extends FrameLayout
implements LayerView.DynamicToolbarListener,
LayerView.ZoomedViewListener,
GeckoEventListener {
    private static final String LOGTAG = "Gecko" + ZoomedView.class.getSimpleName();
    private static final float[] ZOOM_FACTORS_LIST = new float[]{2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f, 1.5f};
    private static final int W_CAPTURED_VIEW_IN_PERCENT = 50;
    private static final int H_CAPTURED_VIEW_IN_PERCENT = 50;
    private static final int MINIMUM_DELAY_BETWEEN_TWO_RENDER_CALLS_NS = 1000000;
    private static final int DELAY_BEFORE_NEXT_RENDER_REQUEST_MS = 2000;
    private static final int OPENING_ANIMATION_DURATION_MS = 250;
    private static final int CLOSING_ANIMATION_DURATION_MS = 150;
    private static final float OVERSHOOT_INTERPOLATOR_TENSION = 1.5f;
    private float zoomFactor;
    private int currentZoomFactorIndex;
    private boolean isSimplifiedUI = true;
    private int defaultZoomFactor;
    private PrefsHelper.PrefHandler prefObserver;
    private ImageView zoomedImageView;
    private LayerView layerView;
    private int viewWidth;
    private int viewHeight;
    private int viewContainerWidth;
    private int viewContainerHeight;
    private int containterSize;
    private Point lastPosition;
    private boolean shouldSetVisibleOnUpdate;
    private boolean isBlockedFromAppearing = false;
    private PointF returnValue;
    private final PointF animationStart;
    private ImageView closeButton;
    private TextView changeZoomFactorButton;
    private boolean toolbarOnTop;
    private float offsetDueToToolBarPosition;
    private int toolbarHeight;
    private int cornerRadius;
    private float dynamicToolbarOverlap;
    private boolean stopUpdateView;
    private int lastOrientation;
    private ByteBuffer buffer;
    private Runnable requestRenderRunnable;
    private long startTimeReRender;
    private long lastStartTimeReRender;
    private ZoomedViewTouchListener touchListener;

    public ZoomedView(Context context) {
        this(context, null, 0);
    }

    public ZoomedView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public ZoomedView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.getPrefs();
        this.currentZoomFactorIndex = 0;
        this.returnValue = new PointF();
        this.animationStart = new PointF();
        this.requestRenderRunnable = new Runnable(){

            @Override
            public void run() {
                ZoomedView.this.requestZoomedViewRender();
            }
        };
        this.touchListener = new ZoomedViewTouchListener();
        EventDispatcher.getInstance().registerGeckoThreadListener(this, "Gesture:clusteredLinksClicked", "Window:Resize", "Content:LocationChange", "Gesture:CloseZoomedView", "Browser:ZoomToPageWidth", "Browser:ZoomToRect", "FormAssist:AutoComplete", "FormAssist:Hide");
    }

    void destroy() {
        if (this.prefObserver != null) {
            PrefsHelper.removeObserver(this.prefObserver);
            this.prefObserver = null;
        }
        ThreadUtils.removeCallbacksFromUiThread((Runnable)this.requestRenderRunnable);
        EventDispatcher.getInstance().unregisterGeckoThreadListener(this, "Gesture:clusteredLinksClicked", "Window:Resize", "Content:LocationChange", "Gesture:CloseZoomedView", "Browser:ZoomToPageWidth", "Browser:ZoomToRect", "FormAssist:AutoComplete", "FormAssist:Hide");
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.closeButton = (ImageView)this.findViewById(R.id.dialog_close);
        this.changeZoomFactorButton = (TextView)this.findViewById(R.id.change_zoom_factor);
        this.zoomedImageView = (ImageView)this.findViewById(R.id.zoomed_image_view);
        this.updateUI();
        this.toolbarHeight = this.getResources().getDimensionPixelSize(R.dimen.zoomed_view_toolbar_height);
        this.containterSize = this.getResources().getDimensionPixelSize(R.dimen.drawable_dropshadow_size);
        this.cornerRadius = this.getResources().getDimensionPixelSize(R.dimen.standard_corner_radius);
        this.moveToolbar(true);
    }

    private void setListeners() {
        this.closeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ZoomedView.this.stopZoomDisplay(true);
            }
        });
        this.changeZoomFactorButton.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                if (motionEvent.getAction() == 1) {
                    if (motionEvent.getX() >= (float)(ZoomedView.this.changeZoomFactorButton.getLeft() + ZoomedView.this.changeZoomFactorButton.getWidth() / 2)) {
                        ZoomedView.this.changeZoomFactor(true);
                    } else {
                        ZoomedView.this.changeZoomFactor(false);
                    }
                }
                return true;
            }
        });
        this.setOnTouchListener(this.touchListener);
    }

    private void removeListeners() {
        this.closeButton.setOnClickListener(null);
        this.changeZoomFactorButton.setOnTouchListener(null);
        this.setOnTouchListener(null);
    }

    private PointF getUnzoomedPositionFromPointInZoomedView(float f, float f2) {
        ImmutableViewportMetrics immutableViewportMetrics = this.layerView.getViewportMetrics();
        float f3 = immutableViewportMetrics.getWidth();
        float f4 = immutableViewportMetrics.getHeight();
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.getLayoutParams();
        float f5 = (float)this.viewWidth / this.zoomFactor;
        float f6 = f3 - f5;
        float f7 = f3 - (float)this.viewContainerWidth;
        float f8 = (float)layoutParams.leftMargin * f6 / f7;
        this.returnValue.x = (int)(f8 + f / this.zoomFactor);
        f5 = (float)this.viewHeight / this.zoomFactor;
        f6 = f4 - f5;
        f7 = f4 - (float)(this.viewContainerHeight - this.toolbarHeight);
        float f9 = (float)layoutParams.topMargin + this.offsetDueToToolBarPosition - this.layerView.getSurfaceTranslation();
        f8 = f9 * f6 / f7;
        this.returnValue.y = (int)(f8 + (f2 - this.offsetDueToToolBarPosition) / this.zoomFactor);
        return this.returnValue;
    }

    private PointF getZoomedViewTopLeftPositionFromTouchPosition(float f, float f2) {
        ImmutableViewportMetrics immutableViewportMetrics = this.layerView.getViewportMetrics();
        float f3 = immutableViewportMetrics.getWidth();
        float f4 = immutableViewportMetrics.getHeight();
        float f5 = (float)this.viewWidth / this.zoomFactor;
        float f6 = f3 - f5;
        float f7 = f3 - (float)this.viewContainerWidth;
        float f8 = f - f5 / 2.0f;
        this.returnValue.x = (int)(f8 * (f7 / f6));
        f5 = (float)this.viewHeight / this.zoomFactor;
        f6 = f4 - f5;
        f7 = f4 - (float)(this.viewContainerHeight - this.toolbarHeight);
        f8 = f2 - f5 / 2.0f;
        float f9 = this.layerView.getSurfaceTranslation() - this.offsetDueToToolBarPosition;
        this.returnValue.y = (int)(f8 * (f7 / f6) + f9);
        return this.returnValue;
    }

    private void moveZoomedView(ImmutableViewportMetrics immutableViewportMetrics, float f, float f2, StartPointUpdate startPointUpdate) {
        PointF pointF;
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.getLayoutParams();
        layoutParams.leftMargin = (int)f;
        layoutParams.topMargin = (int)f2;
        int n = (int)(this.layerView.getSurfaceTranslation() + this.dynamicToolbarOverlap);
        int n2 = this.layerView.getHeight() - this.viewContainerHeight;
        int n3 = 0;
        int n4 = this.layerView.getWidth() - this.viewContainerWidth;
        if (f2 < (float)n) {
            layoutParams.topMargin = n;
        } else if (f2 > (float)n2) {
            layoutParams.topMargin = n2;
        }
        if (f < (float)n3) {
            layoutParams.leftMargin = n3;
        } else if (f > (float)n4) {
            layoutParams.leftMargin = n4;
        }
        if (layoutParams.topMargin < n + 1) {
            this.moveToolbar(false);
        } else if (layoutParams.topMargin > n2 - 1) {
            this.moveToolbar(true);
        }
        if (startPointUpdate == StartPointUpdate.GECKO_POSITION) {
            this.animationStart.x -= (float)layoutParams.leftMargin;
            this.animationStart.y -= (float)layoutParams.topMargin;
        } else if (startPointUpdate == StartPointUpdate.CENTER) {
            pointF = this.getUnzoomedPositionFromPointInZoomedView(this.viewContainerWidth / 2, this.viewContainerHeight / 2);
            this.animationStart.x = pointF.x - (float)layoutParams.leftMargin;
            this.animationStart.y = pointF.y - (float)layoutParams.topMargin;
        }
        this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        pointF = this.getUnzoomedPositionFromPointInZoomedView(0.0f, this.offsetDueToToolBarPosition);
        this.lastPosition = PointUtils.round(pointF);
        this.requestZoomedViewRender();
    }

    private void moveToolbar(boolean bl) {
        if (this.toolbarOnTop == bl) {
            return;
        }
        this.toolbarOnTop = bl;
        this.offsetDueToToolBarPosition = this.toolbarOnTop ? (float)this.toolbarHeight : 0.0f;
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.zoomedImageView.getLayoutParams();
        RelativeLayout.LayoutParams layoutParams2 = (RelativeLayout.LayoutParams)this.changeZoomFactorButton.getLayoutParams();
        RelativeLayout.LayoutParams layoutParams3 = (RelativeLayout.LayoutParams)this.closeButton.getLayoutParams();
        if (bl) {
            layoutParams.addRule(3, R.id.change_zoom_factor);
            layoutParams2.addRule(3, 0);
            layoutParams3.addRule(3, 0);
        } else {
            layoutParams.addRule(3, 0);
            layoutParams2.addRule(3, R.id.zoomed_image_view);
            layoutParams3.addRule(3, R.id.zoomed_image_view);
        }
        layoutParams2.addRule(5, R.id.zoomed_image_view);
        layoutParams3.addRule(7, R.id.zoomed_image_view);
        this.zoomedImageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.changeZoomFactorButton.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
        this.closeButton.setLayoutParams((ViewGroup.LayoutParams)layoutParams3);
    }

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        if (this.lastOrientation != configuration.orientation) {
            this.shouldBlockUpdate(true);
            this.lastOrientation = configuration.orientation;
        }
    }

    private void refreshZoomedViewSize(ImmutableViewportMetrics immutableViewportMetrics) {
        if (this.layerView == null) {
            return;
        }
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.getLayoutParams();
        this.setCapturedSize(immutableViewportMetrics);
        this.moveZoomedView(immutableViewportMetrics, layoutParams.leftMargin, layoutParams.topMargin, StartPointUpdate.NO_CHANGE);
    }

    private void setCapturedSize(ImmutableViewportMetrics immutableViewportMetrics) {
        float f = Math.min(immutableViewportMetrics.getWidth(), immutableViewportMetrics.getHeight());
        this.viewWidth = (int)((double)(f * 50.0f) / ((double)this.zoomFactor * 100.0) * (double)this.zoomFactor);
        this.viewHeight = (int)((double)(f * 50.0f) / ((double)this.zoomFactor * 100.0) * (double)this.zoomFactor);
        this.viewContainerHeight = this.viewHeight + this.toolbarHeight + 2 * this.containterSize;
        this.viewContainerWidth = this.viewWidth + 2 * this.containterSize;
        this.viewWidth &= 0xFFFFFFFE;
    }

    private void shouldBlockUpdate(boolean bl) {
        this.stopUpdateView = bl;
    }

    private Bitmap.Config getBitmapConfig() {
        return GeckoAppShell.getScreenDepth() == 24 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
    }

    private void updateUI() {
        if (this.changeZoomFactorButton == null) {
            return;
        }
        if (this.isSimplifiedUI) {
            this.changeZoomFactorButton.setVisibility(4);
        } else {
            this.setTextInZoomFactorButton(this.zoomFactor);
            this.changeZoomFactorButton.setVisibility(0);
        }
    }

    private void getPrefs() {
        this.prefObserver = new PrefsHelper.PrefHandlerBase(){

            @Override
            public void prefValue(String string2, boolean bl) {
                ZoomedView.this.isSimplifiedUI = bl;
                if (bl) {
                    ZoomedView.this.zoomFactor = ZoomedView.this.defaultZoomFactor;
                } else {
                    ZoomedView.this.zoomFactor = ZOOM_FACTORS_LIST[ZoomedView.this.currentZoomFactorIndex];
                }
                ZoomedView.this.updateUI();
            }

            @Override
            public void prefValue(String string2, int n) {
                ZoomedView.this.defaultZoomFactor = n;
                if (ZoomedView.this.isSimplifiedUI) {
                    ZoomedView.this.zoomFactor = ZoomedView.this.defaultZoomFactor;
                } else {
                    ZoomedView.this.zoomFactor = ZOOM_FACTORS_LIST[ZoomedView.this.currentZoomFactorIndex];
                }
                ZoomedView.this.updateUI();
            }
        };
        PrefsHelper.addObserver(new String[]{"ui.zoomedview.simplified", "ui.zoomedview.defaultZoomFactor"}, this.prefObserver);
    }

    private void startZoomDisplay(LayerView layerView, int n, int n2) {
        ImmutableViewportMetrics immutableViewportMetrics;
        if (this.isBlockedFromAppearing) {
            return;
        }
        if (this.layerView == null) {
            this.layerView = layerView;
            this.layerView.addZoomedViewListener(this);
            this.layerView.getDynamicToolbarAnimator().addTranslationListener(this);
            immutableViewportMetrics = this.layerView.getViewportMetrics();
            this.setCapturedSize(immutableViewportMetrics);
        }
        this.startTimeReRender = 0L;
        this.shouldSetVisibleOnUpdate = true;
        immutableViewportMetrics = this.layerView.getViewportMetrics();
        this.animationStart.x = (float)n * immutableViewportMetrics.zoomFactor;
        this.animationStart.y = (float)n2 * immutableViewportMetrics.zoomFactor + this.layerView.getSurfaceTranslation();
        this.moveUsingGeckoPosition(n, n2);
    }

    public void stopZoomDisplay(boolean bl) {
        this.shouldSetVisibleOnUpdate = false;
        if (this.getVisibility() == 0) {
            this.hideZoomedView(bl);
            ThreadUtils.removeCallbacksFromUiThread((Runnable)this.requestRenderRunnable);
            if (this.layerView != null) {
                this.layerView.getDynamicToolbarAnimator().removeTranslationListener(this);
                this.layerView.removeZoomedViewListener(this);
                this.layerView = null;
            }
        }
    }

    private void changeZoomFactor(boolean bl) {
        this.currentZoomFactorIndex = bl && this.currentZoomFactorIndex < ZOOM_FACTORS_LIST.length - 1 ? ++this.currentZoomFactorIndex : (bl && this.currentZoomFactorIndex >= ZOOM_FACTORS_LIST.length - 1 ? 0 : (!bl && this.currentZoomFactorIndex > 0 ? --this.currentZoomFactorIndex : ZOOM_FACTORS_LIST.length - 1));
        this.zoomFactor = ZOOM_FACTORS_LIST[this.currentZoomFactorIndex];
        ImmutableViewportMetrics immutableViewportMetrics = this.layerView.getViewportMetrics();
        this.refreshZoomedViewSize(immutableViewportMetrics);
        this.setTextInZoomFactorButton(this.zoomFactor);
    }

    private void setTextInZoomFactorButton(float f) {
        String string2 = Integer.toString((int)(100.0f * f));
        this.changeZoomFactorButton.setText((CharSequence)("- " + this.getResources().getString(R.string.percent, new Object[]{string2}) + " +"));
    }

    public void handleMessage(final String string2, final JSONObject jSONObject) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    if (string2.equals("Gesture:clusteredLinksClicked")) {
                        JSONObject jSONObject2 = jSONObject.getJSONObject("clickPosition");
                        int n = jSONObject2.getInt("x");
                        int n2 = jSONObject2.getInt("y");
                        LayerView layerView = GeckoAppShell.getLayerView();
                        if (layerView != null) {
                            ZoomedView.this.startZoomDisplay(layerView, n, n2);
                        }
                    } else if (string2.equals("Window:Resize")) {
                        ImmutableViewportMetrics immutableViewportMetrics = ZoomedView.this.layerView.getViewportMetrics();
                        ZoomedView.this.refreshZoomedViewSize(immutableViewportMetrics);
                    } else if (string2.equals("Content:LocationChange")) {
                        ZoomedView.this.stopZoomDisplay(false);
                    } else if (string2.equals("Gesture:CloseZoomedView") || string2.equals("Browser:ZoomToPageWidth") || string2.equals("Browser:ZoomToRect")) {
                        ZoomedView.this.stopZoomDisplay(true);
                    } else if (string2.equals("FormAssist:AutoComplete")) {
                        ZoomedView.this.isBlockedFromAppearing = true;
                        ZoomedView.this.stopZoomDisplay(true);
                    } else if (string2.equals("FormAssist:Hide")) {
                        ZoomedView.this.isBlockedFromAppearing = false;
                    }
                }
                catch (JSONException jSONException) {
                    Log.e((String)LOGTAG, (String)"JSON exception", (Throwable)jSONException);
                }
            }
        });
    }

    private void moveUsingGeckoPosition(int n, int n2) {
        ImmutableViewportMetrics immutableViewportMetrics = this.layerView.getViewportMetrics();
        float f = immutableViewportMetrics.getHeight();
        this.moveToolbar((float)n2 * immutableViewportMetrics.zoomFactor > f / 2.0f);
        PointF pointF = this.getZoomedViewTopLeftPositionFromTouchPosition((float)n * immutableViewportMetrics.zoomFactor, (float)n2 * immutableViewportMetrics.zoomFactor);
        this.moveZoomedView(immutableViewportMetrics, pointF.x, pointF.y, StartPointUpdate.GECKO_POSITION);
    }

    @Override
    public void onTranslationChanged(float f, float f2) {
        ThreadUtils.assertOnUiThread();
        if (this.layerView != null) {
            this.dynamicToolbarOverlap = f2 - f;
            this.refreshZoomedViewSize(this.layerView.getViewportMetrics());
        }
    }

    @Override
    public void onMetricsChanged(final ImmutableViewportMetrics immutableViewportMetrics) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ZoomedView.this.shouldBlockUpdate(false);
                ZoomedView.this.refreshZoomedViewSize(immutableViewportMetrics);
            }
        });
    }

    @Override
    public void onPanZoomStopped() {
    }

    @Override
    public void updateView(ByteBuffer byteBuffer) {
        Bitmap bitmap = Bitmap.createBitmap((int)this.viewWidth, (int)this.viewHeight, (Bitmap.Config)this.getBitmapConfig());
        if (bitmap != null) {
            byteBuffer.rewind();
            try {
                bitmap.copyPixelsFromBuffer((Buffer)byteBuffer);
            }
            catch (Exception exception) {
                Log.w((String)LOGTAG, (String)exception.toString());
            }
            if (this.zoomedImageView != null) {
                RoundedBitmapDrawable roundedBitmapDrawable = new RoundedBitmapDrawable(this.getResources(), bitmap, this.toolbarOnTop, this.cornerRadius);
                this.zoomedImageView.setImageDrawable((Drawable)roundedBitmapDrawable);
            }
        }
        if (this.shouldSetVisibleOnUpdate) {
            this.showZoomedView();
        }
        this.lastStartTimeReRender = this.startTimeReRender;
        this.startTimeReRender = 0L;
    }

    private void showZoomedView() {
        if (this.getVisibility() != 0) {
            ScaleAnimation scaleAnimation = new ScaleAnimation(0.0f, 1.0f, 0.0f, 1.0f, 0, this.animationStart.x, 0, this.animationStart.y);
            scaleAnimation.setFillAfter(true);
            scaleAnimation.setDuration(250L);
            scaleAnimation.setInterpolator((Interpolator)new OvershootInterpolator(1.5f));
            scaleAnimation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationEnd(Animation animation) {
                    ZoomedView.this.setListeners();
                }

                public void onAnimationRepeat(Animation animation) {
                }

                public void onAnimationStart(Animation animation) {
                    ZoomedView.this.removeListeners();
                }
            });
            this.setAnimation((Animation)scaleAnimation);
        }
        this.setVisibility(0);
        this.shouldSetVisibleOnUpdate = false;
    }

    private void hideZoomedView(boolean bl) {
        if (bl) {
            ScaleAnimation scaleAnimation = new ScaleAnimation(1.0f, 0.0f, 1.0f, 0.0f, 0, this.animationStart.x, 0, this.animationStart.y);
            scaleAnimation.setFillAfter(true);
            scaleAnimation.setDuration(150L);
            scaleAnimation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationEnd(Animation animation) {
                }

                public void onAnimationRepeat(Animation animation) {
                }

                public void onAnimationStart(Animation animation) {
                    ZoomedView.this.removeListeners();
                }
            });
            this.setAnimation((Animation)scaleAnimation);
        } else {
            this.removeListeners();
            this.setAnimation(null);
        }
        this.setVisibility(8);
        this.shouldSetVisibleOnUpdate = false;
    }

    private void updateBufferSize() {
        int n = GeckoAppShell.getScreenDepth() == 24 ? 4 : 2;
        int n2 = this.viewWidth * this.viewHeight * n;
        if (this.buffer == null || this.buffer.capacity() != n2) {
            this.buffer = DirectBufferAllocator.free((ByteBuffer)this.buffer);
            this.buffer = DirectBufferAllocator.allocate((int)n2);
        }
    }

    private boolean isRendering() {
        return this.startTimeReRender != 0L;
    }

    private boolean renderFrequencyTooHigh() {
        return System.nanoTime() - this.lastStartTimeReRender < 1000000L;
    }

    @Override
    public void requestZoomedViewRender() {
        if (this.stopUpdateView) {
            return;
        }
        ThreadUtils.removeCallbacksFromUiThread((Runnable)this.requestRenderRunnable);
        if (this.isRendering()) {
            ThreadUtils.postDelayedToUiThread((Runnable)this.requestRenderRunnable, (long)2000L);
            return;
        }
        if (this.renderFrequencyTooHigh()) {
            ThreadUtils.postDelayedToUiThread((Runnable)this.requestRenderRunnable, (long)2000L);
            return;
        }
        this.startTimeReRender = System.nanoTime();
        this.updateBufferSize();
        int n = Tabs.getInstance().getSelectedTab().getId();
        ImmutableViewportMetrics immutableViewportMetrics = this.layerView.getViewportMetrics();
        PointF pointF = immutableViewportMetrics.getOrigin();
        int n2 = (int)pointF.x + this.lastPosition.x;
        int n3 = (int)pointF.y + this.lastPosition.y;
        GeckoEvent geckoEvent = GeckoEvent.createZoomedViewEvent(n, n2, n3, this.viewWidth, this.viewHeight, this.zoomFactor * immutableViewportMetrics.zoomFactor, this.buffer);
        GeckoAppShell.sendEventToGecko(geckoEvent);
    }

    private class ZoomedViewTouchListener
    implements View.OnTouchListener {
        private float originRawX;
        private float originRawY;
        private boolean dragged;
        private MotionEvent actionDownEvent;

        private ZoomedViewTouchListener() {
        }

        public boolean onTouch(View view, MotionEvent motionEvent) {
            if (ZoomedView.this.layerView == null) {
                return false;
            }
            switch (motionEvent.getAction()) {
                case 2: {
                    if (!this.moveZoomedView(motionEvent)) break;
                    this.dragged = true;
                    break;
                }
                case 1: {
                    if (this.dragged) {
                        this.dragged = false;
                        break;
                    }
                    if (!this.isClickInZoomedView(motionEvent.getY())) break;
                    GeckoAppShell.notifyObservers("Gesture:ClickInZoomedView", "");
                    ZoomedView.this.layerView.dispatchTouchEvent(this.actionDownEvent);
                    this.actionDownEvent.recycle();
                    PointF pointF = ZoomedView.this.getUnzoomedPositionFromPointInZoomedView(motionEvent.getX(), motionEvent.getY());
                    pointF.y += ZoomedView.this.layerView.getSurfaceTranslation();
                    MotionEvent motionEvent2 = MotionEvent.obtain((long)motionEvent.getDownTime(), (long)motionEvent.getEventTime(), (int)1, (float)pointF.x, (float)pointF.y, (int)motionEvent.getMetaState());
                    ZoomedView.this.layerView.dispatchTouchEvent(motionEvent2);
                    motionEvent2.recycle();
                    break;
                }
                case 0: {
                    this.dragged = false;
                    this.originRawX = motionEvent.getRawX();
                    this.originRawY = motionEvent.getRawY();
                    PointF pointF = ZoomedView.this.getUnzoomedPositionFromPointInZoomedView(motionEvent.getX(), motionEvent.getY());
                    pointF.y += ZoomedView.this.layerView.getSurfaceTranslation();
                    this.actionDownEvent = MotionEvent.obtain((long)motionEvent.getDownTime(), (long)motionEvent.getEventTime(), (int)0, (float)pointF.x, (float)pointF.y, (int)motionEvent.getMetaState());
                }
            }
            return true;
        }

        private boolean isClickInZoomedView(float f) {
            return ZoomedView.this.toolbarOnTop && f > (float)ZoomedView.this.toolbarHeight || !ZoomedView.this.toolbarOnTop && f < (float)ZoomedView.this.viewHeight;
        }

        private boolean moveZoomedView(MotionEvent motionEvent) {
            RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)ZoomedView.this.getLayoutParams();
            if (!this.dragged && (float)Math.abs((int)(motionEvent.getRawX() - this.originRawX)) < PanZoomController.CLICK_THRESHOLD && (float)Math.abs((int)(motionEvent.getRawY() - this.originRawY)) < PanZoomController.CLICK_THRESHOLD) {
                return false;
            }
            float f = (float)layoutParams.leftMargin + motionEvent.getRawX() - this.originRawX;
            float f2 = (float)layoutParams.topMargin + motionEvent.getRawY() - this.originRawY;
            ImmutableViewportMetrics immutableViewportMetrics = ZoomedView.this.layerView.getViewportMetrics();
            ZoomedView.this.moveZoomedView(immutableViewportMetrics, f, f2, StartPointUpdate.CENTER);
            this.originRawX = motionEvent.getRawX();
            this.originRawY = motionEvent.getRawY();
            return true;
        }
    }

    private class RoundedBitmapDrawable
    extends BitmapDrawable {
        private Paint paint;
        final float cornerRadius;
        final boolean squareOnTopOfDrawable;

        RoundedBitmapDrawable(Resources resources, Bitmap bitmap, boolean bl, int n) {
            super(resources, bitmap);
            this.paint = new Paint(6);
            this.squareOnTopOfDrawable = bl;
            BitmapShader bitmapShader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
            this.paint.setAntiAlias(true);
            this.paint.setShader((Shader)bitmapShader);
            this.cornerRadius = n;
        }

        public void draw(Canvas canvas) {
            int n = this.getBounds().height();
            int n2 = this.getBounds().width();
            RectF rectF = new RectF(0.0f, 0.0f, (float)n2, (float)n);
            canvas.drawRoundRect(rectF, this.cornerRadius, this.cornerRadius, this.paint);
            if (this.squareOnTopOfDrawable) {
                canvas.drawRect(0.0f, 0.0f, this.cornerRadius, this.cornerRadius, this.paint);
                canvas.drawRect((float)n2 - this.cornerRadius, 0.0f, (float)n2, this.cornerRadius, this.paint);
            } else {
                canvas.drawRect(0.0f, (float)n - this.cornerRadius, this.cornerRadius, (float)n, this.paint);
                canvas.drawRect((float)n2 - this.cornerRadius, (float)n - this.cornerRadius, (float)n2, (float)n, this.paint);
            }
        }
    }

    private static enum StartPointUpdate {
        GECKO_POSITION,
        CENTER,
        NO_CHANGE;

    }
}

