/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.delegates;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import android.view.View;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.AboutPages;
import org.mozilla.gecko.BrowserApp;
import org.mozilla.gecko.EditBookmarkDialog;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.R;
import org.mozilla.gecko.SnackbarHelper;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.delegates.BrowserAppDelegateWithReference;
import org.mozilla.gecko.home.HomeConfig;
import org.mozilla.gecko.promotion.SimpleHelperUI;
import org.mozilla.gecko.prompts.Prompt;
import org.mozilla.gecko.prompts.PromptListItem;
import org.mozilla.gecko.util.DrawableUtil;
import org.mozilla.gecko.util.ThreadUtils;

public class BookmarkStateChangeDelegate
extends BrowserAppDelegateWithReference
implements Tabs.OnTabsChangedListener {
    private static final String LOGTAG = "BookmarkDelegate";

    @Override
    public void onResume(BrowserApp browserApp) {
        Tabs.registerOnTabsChangedListener(this);
    }

    @Override
    public void onPause(BrowserApp browserApp) {
        Tabs.unregisterOnTabsChangedListener(this);
    }

    @Override
    public void onTabChanged(Tab tab, Tabs.TabEvents tabEvents, String string2) {
        switch (tabEvents) {
            case BOOKMARK_ADDED: {
                if (!AboutPages.isAboutReader(tab.getURL())) {
                    this.showBookmarkAddedSnackbar();
                    break;
                }
                if (this.promoteReaderViewBookmarkAdded()) break;
                this.showReaderModeBookmarkAddedSnackbar();
                break;
            }
            case BOOKMARK_REMOVED: {
                this.showBookmarkRemovedSnackbar();
            }
        }
    }

    @Override
    public void onActivityResult(BrowserApp browserApp, int n, int n2, Intent intent) {
        if (n == 3001) {
            if (n2 == 3002) {
                browserApp.openUrlAndStopEditing("about:home?panel=" + HomeConfig.getIdForBuiltinPanelType(HomeConfig.PanelType.BOOKMARKS));
            } else if (n2 == 3003) {
                this.showReaderModeBookmarkAddedSnackbar();
            }
        }
    }

    private boolean promoteReaderViewBookmarkAdded() {
        BrowserApp browserApp = this.getBrowserApp();
        if (browserApp == null) {
            return false;
        }
        SharedPreferences sharedPreferences = GeckoSharedPrefs.forProfile((Context)browserApp);
        boolean bl = sharedPreferences.getBoolean("first_reader_view_bookmark_prompt_shown", false);
        if (bl) {
            return false;
        }
        SimpleHelperUI.show((Activity)browserApp, "first_readerview_bookmark_prompt", 3001, R.string.helper_first_offline_bookmark_title, R.string.helper_first_offline_bookmark_message, R.drawable.helper_readerview_bookmark, R.string.helper_first_offline_bookmark_button, 3002, 3003);
        GeckoSharedPrefs.forProfile((Context)browserApp).edit().putBoolean("first_reader_view_bookmark_prompt_shown", true).apply();
        return true;
    }

    private void showBookmarkAddedSnackbar() {
        final BrowserApp browserApp = this.getBrowserApp();
        if (browserApp == null) {
            return;
        }
        SnackbarHelper.SnackbarCallback snackbarCallback = new SnackbarHelper.SnackbarCallback(){

            public void onClick(View view) {
                Telemetry.sendUIEvent(TelemetryContract.Event.SHOW, TelemetryContract.Method.TOAST, "bookmark_options");
                BookmarkStateChangeDelegate.showBookmarkDialog(browserApp);
            }
        };
        SnackbarHelper.showSnackbarWithAction((Activity)browserApp, browserApp.getResources().getString(R.string.bookmark_added), 0, browserApp.getResources().getString(R.string.bookmark_options), snackbarCallback);
    }

    private void showBookmarkRemovedSnackbar() {
        BrowserApp browserApp = this.getBrowserApp();
        if (browserApp == null) {
            return;
        }
        SnackbarHelper.showSnackbar((Activity)browserApp, browserApp.getResources().getString(R.string.bookmark_removed), 0);
    }

    private static void showBookmarkDialog(final BrowserApp browserApp) {
        final Resources resources = browserApp.getResources();
        final Tab tab = Tabs.getInstance().getSelectedTab();
        Prompt prompt = new Prompt((Context)browserApp, new Prompt.PromptCallback(){

            @Override
            public void onPromptFinished(String string2) {
                int n = -1;
                try {
                    n = new JSONObject(string2).getInt("button");
                }
                catch (JSONException jSONException) {
                    Log.e((String)BookmarkStateChangeDelegate.LOGTAG, (String)"Exception reading bookmark prompt result", (Throwable)jSONException);
                }
                if (tab == null) {
                    return;
                }
                if (n == 0) {
                    String string3 = resources.getResourceEntryName(R.string.contextmenu_edit_bookmark);
                    Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.DIALOG, string3);
                    new EditBookmarkDialog((Context)browserApp).show(tab.getURL());
                } else if (n == 1) {
                    String string4 = resources.getResourceEntryName(R.string.contextmenu_add_to_launcher);
                    Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.DIALOG, string4);
                    final String string5 = tab.getURL();
                    final String string6 = tab.getDisplayTitle();
                    if (string5 != null && string6 != null) {
                        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                GeckoAppShell.createShortcut(string6, string5);
                            }
                        });
                    }
                }
            }
        });
        PromptListItem[] promptListItemArray = new PromptListItem[]{new PromptListItem(resources.getString(R.string.contextmenu_edit_bookmark)), new PromptListItem(resources.getString(R.string.contextmenu_add_to_launcher))};
        prompt.show("", "", promptListItemArray, 0);
    }

    private void showReaderModeBookmarkAddedSnackbar() {
        final BrowserApp browserApp = this.getBrowserApp();
        if (browserApp == null) {
            return;
        }
        Drawable drawable2 = DrawableUtil.tintDrawable((Context)browserApp, (int)R.drawable.status_icon_readercache, (int)-1);
        SnackbarHelper.SnackbarCallback snackbarCallback = new SnackbarHelper.SnackbarCallback(){

            public void onClick(View view) {
                browserApp.openUrlAndStopEditing("about:home?panel=" + HomeConfig.getIdForBuiltinPanelType(HomeConfig.PanelType.BOOKMARKS));
            }
        };
        SnackbarHelper.showSnackbarWithActionAndColors((Activity)browserApp, browserApp.getResources().getString(R.string.reader_saved_offline), 0, browserApp.getResources().getString(R.string.reader_switch_to_bookmarks), snackbarCallback, drawable2, ContextCompat.getColor((Context)browserApp, (int)R.color.link_blue), -1);
    }
}

