/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.dlc;

import android.content.Context;
import android.net.Uri;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.dlc.BaseAction;
import org.mozilla.gecko.dlc.DownloadContentService;
import org.mozilla.gecko.dlc.catalog.DownloadContent;
import org.mozilla.gecko.dlc.catalog.DownloadContentBuilder;
import org.mozilla.gecko.dlc.catalog.DownloadContentCatalog;
import org.mozilla.gecko.util.Experiments;
import org.mozilla.gecko.util.IOUtils;

public class SyncAction
extends BaseAction {
    private static final String LOGTAG = "DLCSyncAction";
    private static final String KINTO_KEY_ID = "id";
    private static final String KINTO_KEY_DELETED = "deleted";
    private static final String KINTO_KEY_DATA = "data";
    private static final String KINTO_PARAMETER_SINCE = "_since";
    private static final String KINTO_PARAMETER_FIELDS = "_fields";
    private static final String KINTO_PARAMETER_SORT = "_sort";
    private static final String CATALOG_ENDPOINT = "https://firefox.settings.services.mozilla.com/v1/buckets/fennec/collections/catalog/records";

    @Override
    public void perform(Context context, DownloadContentCatalog downloadContentCatalog) {
        Log.d((String)LOGTAG, (String)"Synchronizing catalog.");
        if (!this.isSyncEnabledForClient(context)) {
            Log.d((String)LOGTAG, (String)"Sync is not enabled for client. Skipping.");
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        try {
            long l = downloadContentCatalog.getLastModified();
            JSONArray jSONArray = this.fetchRawCatalog(l);
            Log.d((String)LOGTAG, (String)("Server returned " + jSONArray.length() + " records (since " + l + ")"));
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject = jSONArray.getJSONObject(i);
                String string2 = jSONObject.getString(KINTO_KEY_ID);
                boolean bl3 = jSONObject.optBoolean(KINTO_KEY_DELETED, false);
                DownloadContent downloadContent = downloadContentCatalog.getContentById(string2);
                if (bl3) {
                    bl |= this.deleteContent(downloadContentCatalog, string2);
                    continue;
                }
                if (downloadContent != null) {
                    bl2 |= this.updateContent(downloadContentCatalog, jSONObject, downloadContent);
                    continue;
                }
                bl2 |= this.createContent(downloadContentCatalog, jSONObject);
            }
        }
        catch (BaseAction.UnrecoverableDownloadContentException unrecoverableDownloadContentException) {
            Log.e((String)LOGTAG, (String)"UnrecoverableDownloadContentException", (Throwable)unrecoverableDownloadContentException);
        }
        catch (BaseAction.RecoverableDownloadContentException recoverableDownloadContentException) {
            Log.e((String)LOGTAG, (String)"RecoverableDownloadContentException");
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"JSONException", (Throwable)jSONException);
        }
        if (bl2) {
            this.startStudyAction(context);
        }
        if (bl) {
            this.startCleanupAction(context);
        }
        Log.v((String)LOGTAG, (String)"Done");
    }

    protected void startStudyAction(Context context) {
        DownloadContentService.startStudy(context);
    }

    protected void startCleanupAction(Context context) {
        DownloadContentService.startCleanup(context);
    }

    protected JSONArray fetchRawCatalog(long l) throws BaseAction.RecoverableDownloadContentException, BaseAction.UnrecoverableDownloadContentException {
        HttpURLConnection httpURLConnection = null;
        try {
            Uri.Builder builder = Uri.parse((String)CATALOG_ENDPOINT).buildUpon();
            if (l > 0L) {
                builder.appendQueryParameter(KINTO_PARAMETER_SINCE, String.valueOf(l));
            }
            builder.appendQueryParameter(KINTO_PARAMETER_FIELDS, "attachment.location,original.filename,original.hash,attachment.hash,type,kind,original.size,match");
            builder.appendQueryParameter(KINTO_PARAMETER_SORT, "last_modified");
            httpURLConnection = this.buildHttpURLConnection(builder.build().toString());
            int n = httpURLConnection.getResponseCode();
            if (n != 200) {
                if (n >= 500) {
                    throw new BaseAction.RecoverableDownloadContentException(3, "Server error (" + n + ")");
                }
                if (n == 410) {
                    throw new BaseAction.UnrecoverableDownloadContentException("Server is gone (410)");
                }
                if (n >= 400) {
                    this.logErrorResponse(httpURLConnection);
                    throw new BaseAction.UnrecoverableDownloadContentException("(Unrecoverable) Catalog sync failed. Status code: " + n);
                }
                if (n < 200) {
                    this.logErrorResponse(httpURLConnection);
                    throw new BaseAction.RecoverableDownloadContentException(3, "Response code: " + n);
                }
                throw new BaseAction.UnrecoverableDownloadContentException("(Unrecoverable) Download failed. Response code: " + n);
            }
            JSONArray jSONArray = this.fetchJSONResponse(httpURLConnection).getJSONArray(KINTO_KEY_DATA);
            return jSONArray;
        }
        catch (IOException | JSONException throwable) {
            throw new BaseAction.RecoverableDownloadContentException(4, throwable);
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject fetchJSONResponse(HttpURLConnection httpURLConnection) throws IOException, JSONException {
        JSONObject jSONObject;
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(httpURLConnection.getInputStream());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)bufferedInputStream, (OutputStream)byteArrayOutputStream);
            jSONObject = new JSONObject(byteArrayOutputStream.toString("UTF-8"));
        }
        catch (Throwable throwable) {
            IOUtils.safeStreamClose(bufferedInputStream);
            throw throwable;
        }
        IOUtils.safeStreamClose((Closeable)bufferedInputStream);
        return jSONObject;
    }

    protected boolean updateContent(DownloadContentCatalog downloadContentCatalog, JSONObject jSONObject, DownloadContent downloadContent) throws JSONException {
        DownloadContent downloadContent2 = downloadContent.buildUpon().updateFromKinto(jSONObject).build();
        if (downloadContent.getLastModified() >= downloadContent2.getLastModified()) {
            Log.d((String)LOGTAG, (String)("Item has not changed: " + downloadContent2));
            return false;
        }
        downloadContentCatalog.update(downloadContent2);
        return true;
    }

    protected boolean createContent(DownloadContentCatalog downloadContentCatalog, JSONObject jSONObject) throws JSONException {
        DownloadContent downloadContent = new DownloadContentBuilder().updateFromKinto(jSONObject).build();
        downloadContentCatalog.add(downloadContent);
        return true;
    }

    protected boolean deleteContent(DownloadContentCatalog downloadContentCatalog, String string2) {
        DownloadContent downloadContent = downloadContentCatalog.getContentById(string2);
        if (downloadContent == null) {
            return false;
        }
        downloadContentCatalog.markAsDeleted(downloadContent);
        return true;
    }

    protected boolean isSyncEnabledForClient(Context context) {
        return Experiments.isInExperimentLocal(context, "download-content-catalog-sync");
    }

    private void logErrorResponse(HttpURLConnection httpURLConnection) {
        try {
            JSONObject jSONObject = this.fetchJSONResponse(httpURLConnection);
            Log.w((String)LOGTAG, (String)"Server returned error response:");
            Log.w((String)LOGTAG, (String)("- Code:    " + jSONObject.getInt("code")));
            Log.w((String)LOGTAG, (String)("- Errno:   " + jSONObject.getInt("errno")));
            Log.w((String)LOGTAG, (String)("- Error:   " + jSONObject.optString("error", "-")));
            Log.w((String)LOGTAG, (String)("- Message: " + jSONObject.optString("message", "-")));
            Log.w((String)LOGTAG, (String)("- Info:    " + jSONObject.optString("info", "-")));
        }
        catch (IOException | JSONException throwable) {
            Log.w((String)LOGTAG, (String)"Could not fetch error response", (Throwable)throwable);
        }
    }
}

