/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.feeds;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.NotificationManagerCompat;
import java.util.ArrayList;
import org.mozilla.gecko.BrowserApp;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.delegates.BrowserAppDelegate;
import org.mozilla.gecko.feeds.FeedService;

public class ContentNotificationsDelegate
extends BrowserAppDelegate {
    public static final String ACTION_CONTENT_NOTIFICATION = "org.mozilla.fennec.action.CONTENT_NOTIFICATION";
    public static final String EXTRA_READ_BUTTON = "read_button";
    public static final String EXTRA_URLS = "urls";
    private static final String TELEMETRY_EXTRA_CONTENT_UPDATE = "content_update";
    private static final String TELEMETRY_EXTRA_READ_NOW_BUTTON = "content_update_read_now";

    @Override
    public void onCreate(BrowserApp browserApp, Bundle bundle) {
        Intent intent = browserApp.getIntent();
        if (bundle != null) {
            return;
        }
        if (intent != null && ACTION_CONTENT_NOTIFICATION.equals(intent.getAction())) {
            this.openURLsFromIntent(browserApp, intent);
        }
    }

    @Override
    public void onNewIntent(BrowserApp browserApp, Intent intent) {
        if (intent != null && ACTION_CONTENT_NOTIFICATION.equals(intent.getAction())) {
            this.openURLsFromIntent(browserApp, intent);
        }
    }

    private void openURLsFromIntent(BrowserApp browserApp, Intent intent) {
        ArrayList arrayList = intent.getStringArrayListExtra(EXTRA_URLS);
        if (arrayList != null) {
            browserApp.openUrls(arrayList);
        }
        Telemetry.startUISession(TelemetryContract.Session.EXPERIMENT, FeedService.getEnabledExperiment((Context)browserApp));
        Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.INTENT, TELEMETRY_EXTRA_CONTENT_UPDATE);
        if (intent.getBooleanExtra(EXTRA_READ_BUTTON, false)) {
            Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.NOTIFICATION, TELEMETRY_EXTRA_READ_NOW_BUTTON);
            NotificationManagerCompat.from((Context)browserApp).cancel(R.id.websiteContentNotification);
        } else {
            Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.NOTIFICATION, TELEMETRY_EXTRA_CONTENT_UPDATE);
        }
        Telemetry.stopUISession(TelemetryContract.Session.EXPERIMENT, FeedService.getEnabledExperiment((Context)browserApp));
    }
}

