/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.opengl.GLES20;
import android.os.SystemClock;
import android.util.Log;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.microedition.khronos.egl.EGLConfig;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.annotation.WrapForJNI;
import org.mozilla.gecko.gfx.BitmapUtils;
import org.mozilla.gecko.gfx.ImmutableViewportMetrics;
import org.mozilla.gecko.gfx.IntSize;
import org.mozilla.gecko.gfx.Layer;
import org.mozilla.gecko.gfx.LayerView;
import org.mozilla.gecko.gfx.PanningPerfAPI;
import org.mozilla.gecko.gfx.RectUtils;
import org.mozilla.gecko.gfx.RenderTask;
import org.mozilla.gecko.gfx.ScrollbarLayer;
import org.mozilla.gecko.gfx.TextureGenerator;
import org.mozilla.gecko.gfx.TextureReaper;
import org.mozilla.gecko.mozglue.DirectBufferAllocator;
import org.mozilla.gecko.util.ThreadUtils;

public class LayerRenderer
implements Tabs.OnTabsChangedListener {
    private static final String LOGTAG = "GeckoLayerRenderer";
    private static final String PROFTAG = "GeckoLayerRendererProf";
    private static final int MAX_FRAME_TIME = 16;
    private static final int FRAME_RATE_METER_WIDTH = 128;
    private static final int FRAME_RATE_METER_HEIGHT = 32;
    private static final long NANOS_PER_MS = 1000000L;
    private static final int NANOS_PER_SECOND = 1000000000;
    private static final int MAX_SCROLL_SPEED_TO_REQUEST_ZOOM_RENDER = 5;
    private final LayerView mView;
    private final ScrollbarLayer mHorizScrollLayer;
    private final ScrollbarLayer mVertScrollLayer;
    private final FadeRunnable mFadeRunnable;
    private ByteBuffer mCoordByteBuffer;
    private FloatBuffer mCoordBuffer;
    private Layer.RenderContext mLastPageContext;
    private int mMaxTextureSize;
    private int mBackgroundColor;
    private long mLastFrameTime;
    private final CopyOnWriteArrayList<RenderTask> mTasks;
    private final CopyOnWriteArrayList<Layer> mExtraLayers = new CopyOnWriteArrayList();
    private final int[] mFrameTimings;
    private int mCurrentFrame;
    private int mFrameTimingsSum;
    private int mDroppedFrames;
    private int mFramesRendered;
    private float mCompleteFramesRendered;
    private boolean mProfileRender;
    private long mProfileOutputTime;
    private IntBuffer mPixelBuffer;
    private int mProgram;
    private int mPositionHandle;
    private int mTextureHandle;
    private int mSampleHandle;
    private int mTMatrixHandle;
    private List<LayerView.ZoomedViewListener> mZoomedViewListeners;
    private float mLastViewLeft;
    private float mLastViewTop;
    public static final float[] DEFAULT_TEXTURE_MATRIX = new float[]{2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 2.0f, 0.0f, -1.0f, -1.0f, 0.0f, 1.0f};
    private static final int COORD_BUFFER_SIZE = 20;
    public static final String DEFAULT_VERTEX_SHADER = "uniform mat4 uTMatrix;\nattribute vec4 vPosition;\nattribute vec2 aTexCoord;\nvarying vec2 vTexCoord;\nvoid main() {\n    gl_Position = uTMatrix * vPosition;\n    vTexCoord.x = aTexCoord.x;\n    vTexCoord.y = 1.0 - aTexCoord.y;\n}\n";
    public static final String DEFAULT_FRAGMENT_SHADER = "precision highp float;\nvarying vec2 vTexCoord;\nuniform sampler2D sTexture;\nvoid main() {\n    gl_FragColor = texture2D(sTexture, vTexCoord);\n}\n";

    public LayerRenderer(LayerView layerView) {
        this.mView = layerView;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inScaled = false;
        Bitmap bitmap = BitmapUtils.decodeResource(layerView.getContext(), R.drawable.scrollbar, options);
        IntSize intSize = new IntSize(bitmap.getWidth(), bitmap.getHeight());
        bitmap = this.expandCanvasToPowerOfTwo(bitmap, intSize);
        this.mTasks = new CopyOnWriteArrayList();
        this.mLastFrameTime = System.nanoTime();
        this.mVertScrollLayer = null;
        this.mHorizScrollLayer = null;
        this.mFadeRunnable = null;
        this.mFrameTimings = new int[60];
        this.mDroppedFrames = 0;
        this.mFrameTimingsSum = 0;
        this.mCurrentFrame = 0;
        Tabs.registerOnTabsChangedListener(this);
        this.mZoomedViewListeners = new ArrayList<LayerView.ZoomedViewListener>();
    }

    private Bitmap expandCanvasToPowerOfTwo(Bitmap bitmap, IntSize intSize) {
        IntSize intSize2 = intSize.nextPowerOfTwo();
        if (intSize.equals(intSize2)) {
            return bitmap;
        }
        Bitmap bitmap2 = Bitmap.createBitmap((int)intSize2.width, (int)intSize2.height, (Bitmap.Config)bitmap.getConfig());
        new Canvas(bitmap2).drawBitmap(bitmap, new Matrix(), null);
        return bitmap2;
    }

    private Bitmap diagonalFlip(Bitmap bitmap) {
        Matrix matrix = new Matrix();
        matrix.setValues(new float[]{0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f});
        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        return bitmap2;
    }

    public void destroy() {
        if (this.mCoordByteBuffer != null) {
            DirectBufferAllocator.free((ByteBuffer)this.mCoordByteBuffer);
            this.mCoordByteBuffer = null;
            this.mCoordBuffer = null;
        }
        Tabs.unregisterOnTabsChangedListener(this);
        this.mZoomedViewListeners.clear();
    }

    void onSurfaceCreated(EGLConfig eGLConfig) {
        this.checkMonitoringEnabled();
        this.createDefaultProgram();
        this.activateDefaultProgram();
    }

    public void createDefaultProgram() {
        int n = LayerRenderer.loadShader(35633, DEFAULT_VERTEX_SHADER);
        int n2 = LayerRenderer.loadShader(35632, DEFAULT_FRAGMENT_SHADER);
        this.mProgram = GLES20.glCreateProgram();
        GLES20.glAttachShader((int)this.mProgram, (int)n);
        GLES20.glAttachShader((int)this.mProgram, (int)n2);
        GLES20.glLinkProgram((int)this.mProgram);
        this.mPositionHandle = GLES20.glGetAttribLocation((int)this.mProgram, (String)"vPosition");
        this.mTextureHandle = GLES20.glGetAttribLocation((int)this.mProgram, (String)"aTexCoord");
        this.mSampleHandle = GLES20.glGetUniformLocation((int)this.mProgram, (String)"sTexture");
        this.mTMatrixHandle = GLES20.glGetUniformLocation((int)this.mProgram, (String)"uTMatrix");
        int[] nArray = new int[1];
        GLES20.glGetIntegerv((int)3379, (int[])nArray, (int)0);
        this.mMaxTextureSize = nArray[0];
    }

    public void activateDefaultProgram() {
        GLES20.glUseProgram((int)this.mProgram);
        GLES20.glUniformMatrix4fv((int)this.mTMatrixHandle, (int)1, (boolean)false, (float[])DEFAULT_TEXTURE_MATRIX, (int)0);
        GLES20.glEnableVertexAttribArray((int)this.mPositionHandle);
        GLES20.glEnableVertexAttribArray((int)this.mTextureHandle);
        GLES20.glUniform1i((int)this.mSampleHandle, (int)0);
    }

    public void deactivateDefaultProgram() {
        GLES20.glDisableVertexAttribArray((int)this.mTextureHandle);
        GLES20.glDisableVertexAttribArray((int)this.mPositionHandle);
        GLES20.glUseProgram((int)0);
    }

    void restoreState(boolean bl, int n, int n2, int n3, int n4) {
        GLES20.glScissor((int)n, (int)n2, (int)n3, (int)n4);
        if (bl) {
            GLES20.glEnable((int)3089);
        } else {
            GLES20.glDisable((int)3089);
        }
    }

    public int getMaxTextureSize() {
        return this.mMaxTextureSize;
    }

    public void postRenderTask(RenderTask renderTask) {
        this.mTasks.add(renderTask);
        this.mView.requestRender();
    }

    public void removeRenderTask(RenderTask renderTask) {
        this.mTasks.remove(renderTask);
    }

    private void runRenderTasks(CopyOnWriteArrayList<RenderTask> copyOnWriteArrayList, boolean bl, long l) {
        for (RenderTask renderTask : copyOnWriteArrayList) {
            boolean bl2;
            if (renderTask.runAfter != bl || (bl2 = renderTask.run(l - this.mLastFrameTime, l))) continue;
            copyOnWriteArrayList.remove(renderTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLayer(Layer layer) {
        CopyOnWriteArrayList<Layer> copyOnWriteArrayList = this.mExtraLayers;
        synchronized (copyOnWriteArrayList) {
            if (this.mExtraLayers.contains(layer)) {
                this.mExtraLayers.remove(layer);
            }
            this.mExtraLayers.add(layer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLayer(Layer layer) {
        CopyOnWriteArrayList<Layer> copyOnWriteArrayList = this.mExtraLayers;
        synchronized (copyOnWriteArrayList) {
            this.mExtraLayers.remove(layer);
        }
    }

    private void printCheckerboardStats() {
        Log.d((String)PROFTAG, (String)("Frames rendered over last 1000ms: " + this.mCompleteFramesRendered + "/" + this.mFramesRendered));
        this.mFramesRendered = 0;
        this.mCompleteFramesRendered = 0.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IntBuffer getPixels() {
        IntBuffer intBuffer;
        IntBuffer intBuffer2 = intBuffer = IntBuffer.allocate(this.mView.getWidth() * this.mView.getHeight());
        synchronized (intBuffer2) {
            this.mPixelBuffer = intBuffer;
            this.mView.requestRender();
            try {
                intBuffer.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.mPixelBuffer = null;
        }
        return intBuffer;
    }

    private Layer.RenderContext createScreenContext(ImmutableViewportMetrics immutableViewportMetrics) {
        RectF rectF = new RectF(0.0f, 0.0f, immutableViewportMetrics.getWidth(), immutableViewportMetrics.getHeight());
        RectF rectF2 = immutableViewportMetrics.getPageRect();
        return this.createContext(rectF, rectF2, 1.0f);
    }

    private Layer.RenderContext createPageContext(ImmutableViewportMetrics immutableViewportMetrics) {
        RectF rectF = immutableViewportMetrics.getViewport();
        RectF rectF2 = immutableViewportMetrics.getPageRect();
        float f = immutableViewportMetrics.zoomFactor;
        return this.createContext(new RectF(RectUtils.round(rectF)), rectF2, f);
    }

    private Layer.RenderContext createContext(RectF rectF, RectF rectF2, float f) {
        if (this.mCoordBuffer == null) {
            this.mCoordByteBuffer = DirectBufferAllocator.allocate((int)80);
            this.mCoordByteBuffer.order(ByteOrder.nativeOrder());
            this.mCoordBuffer = this.mCoordByteBuffer.asFloatBuffer();
            if (this.mCoordBuffer == null) {
                throw new IllegalStateException();
            }
        }
        return new Layer.RenderContext(rectF, rectF2, f, this.mPositionHandle, this.mTextureHandle, this.mCoordBuffer);
    }

    private void updateDroppedFrames(long l) {
        int n = (int)((System.nanoTime() - l) / 1000000L);
        this.mFrameTimingsSum -= this.mFrameTimings[this.mCurrentFrame];
        this.mFrameTimingsSum += n;
        this.mDroppedFrames -= (this.mFrameTimings[this.mCurrentFrame] + 1) / 16;
        this.mDroppedFrames += (n + 1) / 16;
        this.mFrameTimings[this.mCurrentFrame] = n;
        this.mCurrentFrame = (this.mCurrentFrame + 1) % this.mFrameTimings.length;
        int n2 = this.mFrameTimingsSum / this.mFrameTimings.length;
    }

    void checkMonitoringEnabled() {
        this.mProfileRender = Log.isLoggable((String)PROFTAG, (int)3);
    }

    public static int loadShader(int n, String string2) {
        int n2 = GLES20.glCreateShader((int)n);
        GLES20.glShaderSource((int)n2, (String)string2);
        GLES20.glCompileShader((int)n2);
        return n2;
    }

    public Frame createFrame(ImmutableViewportMetrics immutableViewportMetrics) {
        return new Frame(immutableViewportMetrics);
    }

    @Override
    public void onTabChanged(Tab tab, Tabs.TabEvents tabEvents, String string2) {
        if (tabEvents == Tabs.TabEvents.SELECTED && this.mView != null) {
            this.mView.setSurfaceBackgroundColor(tab.getBackgroundColor());
            this.mView.setPaintState(0);
        }
    }

    public void updateZoomedView(final ByteBuffer byteBuffer) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (LayerView.ZoomedViewListener zoomedViewListener : LayerRenderer.this.mZoomedViewListeners) {
                    byteBuffer.position(0);
                    zoomedViewListener.updateView(byteBuffer);
                }
            }
        });
    }

    public void addZoomedViewListener(LayerView.ZoomedViewListener zoomedViewListener) {
        ThreadUtils.assertOnUiThread();
        this.mZoomedViewListeners.add(zoomedViewListener);
    }

    public void removeZoomedViewListener(LayerView.ZoomedViewListener zoomedViewListener) {
        ThreadUtils.assertOnUiThread();
        this.mZoomedViewListeners.remove(zoomedViewListener);
    }

    public class Frame {
        private long mFrameStartTime;
        private final ImmutableViewportMetrics mFrameMetrics;
        private final Layer.RenderContext mPageContext;
        private final Layer.RenderContext mScreenContext;
        private boolean mUpdated;
        private final Rect mPageRect;
        private final Rect mAbsolutePageRect;

        public Frame(ImmutableViewportMetrics immutableViewportMetrics) {
            this.mFrameMetrics = immutableViewportMetrics;
            Layer layer = LayerRenderer.this.mView.getLayerClient().getRoot();
            this.mPageContext = LayerRenderer.this.createPageContext(immutableViewportMetrics);
            this.mScreenContext = LayerRenderer.this.createScreenContext(immutableViewportMetrics);
            RectF rectF = this.mFrameMetrics.getPageRect();
            this.mAbsolutePageRect = RectUtils.round(rectF);
            PointF pointF = this.mFrameMetrics.getOrigin();
            rectF.offset(-pointF.x, -pointF.y);
            this.mPageRect = RectUtils.round(rectF);
        }

        @WrapForJNI(allowMultithread=true)
        public void beginDrawing() {
            this.mFrameStartTime = System.nanoTime();
            TextureReaper.get().reap();
            TextureGenerator.get().fill();
            this.mUpdated = true;
            Layer layer = LayerRenderer.this.mView.getLayerClient().getRoot();
            LayerRenderer.this.runRenderTasks(LayerRenderer.this.mTasks, false, this.mFrameStartTime);
            if (layer != null) {
                this.mUpdated &= layer.update(this.mPageContext);
            }
            for (Layer layer2 : LayerRenderer.this.mExtraLayers) {
                this.mUpdated &= layer2.update(this.mPageContext);
            }
        }

        private void clear(int n) {
            GLES20.glClearColor((float)((float)(n >> 16 & 0xFF) / 255.0f), (float)((float)(n >> 8 & 0xFF) / 255.0f), (float)((float)(n & 0xFF) / 255.0f), (float)0.0f);
            GLES20.glClear((int)16640);
        }

        @WrapForJNI(allowMultithread=true)
        public void drawBackground() {
            GLES20.glDisable((int)3089);
            LayerRenderer.this.mBackgroundColor = LayerRenderer.this.mView.getBackgroundColor();
            this.clear(LayerRenderer.this.mBackgroundColor);
        }

        @WrapForJNI(allowMultithread=true)
        public void drawForeground() {
            Object object;
            if (LayerRenderer.this.mExtraLayers.size() > 0) {
                object = LayerRenderer.this.mExtraLayers.iterator();
                while (object.hasNext()) {
                    Layer layer = (Layer)object.next();
                    layer.draw(this.mPageContext);
                }
            }
            if ((object = LayerRenderer.this.mView.getLayerClient().getRoot()) != null && (LayerRenderer.this.mProfileRender || PanningPerfAPI.isRecordingCheckerboard())) {
                float f = 1.0f - GeckoAppShell.computeRenderIntegrity();
                PanningPerfAPI.recordCheckerboard(f);
                if (f < 0.0f || f > 1.0f) {
                    Log.e((String)LayerRenderer.LOGTAG, (String)("Checkerboard value out of bounds: " + f));
                }
                LayerRenderer.this.mCompleteFramesRendered += 1.0f - f;
                LayerRenderer.this.mFramesRendered++;
                if (this.mFrameStartTime - LayerRenderer.this.mProfileOutputTime > 1000000000L) {
                    LayerRenderer.this.mProfileOutputTime = this.mFrameStartTime;
                    LayerRenderer.this.printCheckerboardStats();
                }
            }
            LayerRenderer.this.runRenderTasks(LayerRenderer.this.mTasks, true, this.mFrameStartTime);
        }

        private void maybeRequestZoomedViewRender(Layer.RenderContext renderContext) {
            if (LayerRenderer.this.mZoomedViewListeners.size() == 0) {
                return;
            }
            float f = renderContext.viewport.left;
            float f2 = renderContext.viewport.top;
            boolean bl = false;
            if (Math.abs(LayerRenderer.this.mLastViewLeft - f) > 5.0f || Math.abs(LayerRenderer.this.mLastViewTop - f2) > 5.0f) {
                bl = true;
            }
            LayerRenderer.this.mLastViewLeft = f;
            LayerRenderer.this.mLastViewTop = f2;
            if (bl) {
                return;
            }
            ThreadUtils.postToUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    for (LayerView.ZoomedViewListener zoomedViewListener : LayerRenderer.this.mZoomedViewListeners) {
                        zoomedViewListener.requestZoomedViewRender();
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WrapForJNI(allowMultithread=true)
        public void endDrawing() {
            if (!this.mUpdated) {
                LayerRenderer.this.mView.requestRender();
            }
            PanningPerfAPI.recordFrameTime();
            this.maybeRequestZoomedViewRender(this.mPageContext);
            IntBuffer intBuffer = LayerRenderer.this.mPixelBuffer;
            if (this.mUpdated && intBuffer != null) {
                IntBuffer intBuffer2 = intBuffer;
                synchronized (intBuffer2) {
                    intBuffer.position(0);
                    GLES20.glReadPixels((int)0, (int)0, (int)((int)this.mScreenContext.viewport.width()), (int)((int)this.mScreenContext.viewport.height()), (int)6408, (int)5121, (Buffer)intBuffer);
                    intBuffer.notify();
                }
            }
            if (LayerRenderer.this.mView.getPaintState() == 1) {
                LayerRenderer.this.mView.post(new Runnable(){

                    @Override
                    public void run() {
                        LayerRenderer.this.mView.setSurfaceBackgroundColor(0);
                    }
                });
                LayerRenderer.this.mView.setPaintState(2);
            }
            LayerRenderer.this.mLastFrameTime = this.mFrameStartTime;
        }
    }

    class FadeRunnable
    implements Runnable {
        private boolean mStarted;
        long mRunAt;

        FadeRunnable() {
        }

        void scheduleStartFade(long l) {
            this.mRunAt = SystemClock.elapsedRealtime() + l;
            if (!this.mStarted) {
                LayerRenderer.this.mView.postDelayed(this, l);
                this.mStarted = true;
            }
        }

        void scheduleNextFadeFrame() {
            if (this.mStarted) {
                Log.e((String)LayerRenderer.LOGTAG, (String)"scheduleNextFadeFrame() called while scheduled for starting fade");
            }
            LayerRenderer.this.mView.postDelayed(this, 16L);
        }

        boolean timeToFade() {
            return !this.mStarted;
        }

        @Override
        public void run() {
            long l = this.mRunAt - SystemClock.elapsedRealtime();
            if (l > 0L) {
                LayerRenderer.this.mView.postDelayed(this, l);
            } else {
                this.mStarted = false;
                LayerRenderer.this.mView.requestRender();
            }
        }
    }
}

