/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import android.os.SystemClock;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.gecko.annotation.RobocopTarget;

public class PanningPerfAPI {
    private static final String LOGTAG = "GeckoPanningPerfAPI";
    private static final int EXPECTED_FRAME_COUNT = 2048;
    private static boolean mRecordingFrames;
    private static List<Long> mFrameTimes;
    private static long mFrameStartTime;
    private static boolean mRecordingCheckerboard;
    private static List<Float> mCheckerboardAmounts;
    private static long mCheckerboardStartTime;

    private static void initialiseRecordingArrays() {
        if (mFrameTimes == null) {
            mFrameTimes = new ArrayList<Long>(2048);
        } else {
            mFrameTimes.clear();
        }
        if (mCheckerboardAmounts == null) {
            mCheckerboardAmounts = new ArrayList<Float>(2048);
        } else {
            mCheckerboardAmounts.clear();
        }
    }

    @RobocopTarget
    public static void startFrameTimeRecording() {
        if (mRecordingFrames || mRecordingCheckerboard) {
            Log.e((String)LOGTAG, (String)"Error: startFrameTimeRecording() called while already recording!");
            return;
        }
        mRecordingFrames = true;
        PanningPerfAPI.initialiseRecordingArrays();
        mFrameStartTime = SystemClock.uptimeMillis();
    }

    @RobocopTarget
    public static List<Long> stopFrameTimeRecording() {
        if (!mRecordingFrames) {
            Log.e((String)LOGTAG, (String)"Error: stopFrameTimeRecording() called when not recording!");
            return null;
        }
        mRecordingFrames = false;
        return mFrameTimes;
    }

    public static void recordFrameTime() {
        if (mRecordingFrames) {
            mFrameTimes.add(SystemClock.uptimeMillis() - mFrameStartTime);
        }
    }

    public static boolean isRecordingCheckerboard() {
        return mRecordingCheckerboard;
    }

    @RobocopTarget
    public static void startCheckerboardRecording() {
        if (mRecordingCheckerboard || mRecordingFrames) {
            Log.e((String)LOGTAG, (String)"Error: startCheckerboardRecording() called while already recording!");
            return;
        }
        mRecordingCheckerboard = true;
        PanningPerfAPI.initialiseRecordingArrays();
        mCheckerboardStartTime = SystemClock.uptimeMillis();
    }

    @RobocopTarget
    public static List<Float> stopCheckerboardRecording() {
        if (!mRecordingCheckerboard) {
            Log.e((String)LOGTAG, (String)"Error: stopCheckerboardRecording() called when not recording!");
            return null;
        }
        mRecordingCheckerboard = false;
        int n = mCheckerboardAmounts.size();
        if (n == 0) {
            Log.w((String)LOGTAG, (String)"stopCheckerboardRecording() found no checkerboard amounts!");
            return mCheckerboardAmounts;
        }
        long l = 0L;
        float f = mFrameTimes.get(n - 1).longValue();
        for (int i = 0; i < n; ++i) {
            long l2 = mFrameTimes.get(i) - l;
            mCheckerboardAmounts.set(i, Float.valueOf(mCheckerboardAmounts.get(i).floatValue() * (float)l2 / f));
            l += l2;
        }
        return mCheckerboardAmounts;
    }

    public static void recordCheckerboard(float f) {
        if (mRecordingCheckerboard) {
            mFrameTimes.add(SystemClock.uptimeMillis() - mCheckerboardStartTime);
            mCheckerboardAmounts.add(Float.valueOf(f));
        }
    }
}

