/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.LinearLayout;
import android.widget.TextView;
import org.mozilla.gecko.R;
import org.mozilla.gecko.home.TabMenuStrip;

class TabMenuStripLayout
extends LinearLayout
implements View.OnFocusChangeListener {
    private TabMenuStrip.OnTitleClickListener onTitleClickListener;
    private Drawable strip;
    private TextView selectedView;
    private View toTab;
    private View fromTab;
    private int fromPosition;
    private int toPosition;
    private float progress;
    private float prevProgress;
    private int tabContentStart;
    private boolean titlebarFill;
    private int activeTextColor;
    private ColorStateList inactiveTextColor;

    TabMenuStripLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.TabMenuStrip);
        int n = typedArray.getResourceId(R.styleable.TabMenuStrip_strip, -1);
        this.titlebarFill = typedArray.getBoolean(R.styleable.TabMenuStrip_titlebarFill, false);
        this.tabContentStart = typedArray.getDimensionPixelSize(R.styleable.TabMenuStrip_tabsMarginLeft, 0);
        this.activeTextColor = typedArray.getColor(R.styleable.TabMenuStrip_activeTextColor, R.color.text_and_tabs_tray_grey);
        this.inactiveTextColor = typedArray.getColorStateList(R.styleable.TabMenuStrip_inactiveTextColor);
        typedArray.recycle();
        if (n != -1) {
            this.strip = this.getResources().getDrawable(n);
        }
        this.setWillNotDraw(false);
    }

    void onAddPagerView(String string2) {
        TextView textView = (TextView)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.tab_menu_strip, (ViewGroup)this, false);
        textView.setText((CharSequence)string2.toUpperCase());
        textView.setTextColor(this.inactiveTextColor);
        if (this.titlebarFill) {
            textView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
        } else {
            textView.setLayoutParams(new ViewGroup.LayoutParams(-2, -1));
        }
        if (this.getChildCount() == 0) {
            textView.setPadding(textView.getPaddingLeft() + this.tabContentStart, textView.getPaddingTop(), textView.getPaddingRight(), textView.getPaddingBottom());
        }
        this.addView((View)textView);
        textView.setOnClickListener((View.OnClickListener)new ViewClickListener(this.getChildCount() - 1));
        textView.setOnFocusChangeListener((View.OnFocusChangeListener)this);
    }

    void onPageSelected(final int n) {
        if (this.selectedView != null) {
            this.selectedView.setTextColor(this.inactiveTextColor);
        }
        this.selectedView = (TextView)this.getChildAt(n);
        this.selectedView.setTextColor(this.activeTextColor);
        ViewTreeObserver viewTreeObserver = this.selectedView.getViewTreeObserver();
        if (viewTreeObserver.isAlive()) {
            viewTreeObserver.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    TabMenuStripLayout.this.selectedView.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    if (TabMenuStripLayout.this.strip != null) {
                        TabMenuStripLayout.this.strip.setBounds(TabMenuStripLayout.this.selectedView.getLeft() + (n == 0 ? TabMenuStripLayout.this.tabContentStart : 0), TabMenuStripLayout.this.selectedView.getTop(), TabMenuStripLayout.this.selectedView.getRight(), TabMenuStripLayout.this.selectedView.getBottom());
                    }
                    TabMenuStripLayout.this.prevProgress = n;
                }
            });
        }
    }

    void onPageScrolled(int n, float f, int n2) {
        if (this.strip == null) {
            return;
        }
        this.setScrollingData(n, f);
        if (this.fromTab == null || this.toTab == null) {
            return;
        }
        int n3 = this.fromTab.getLeft();
        int n4 = this.fromTab.getRight();
        int n5 = this.toTab.getLeft();
        int n6 = this.toTab.getRight();
        int n7 = this.fromPosition == 0 && this.toPosition == 1 ? (int)((float)this.tabContentStart * (1.0f - this.progress)) : (this.fromPosition == 1 && this.toPosition == 0 ? (int)((float)this.tabContentStart * this.progress) : 0);
        this.strip.setBounds((int)((float)n3 + (float)(n5 - n3) * this.progress) + n7, 0, (int)((float)n4 + (float)(n6 - n4) * this.progress), this.getHeight());
        this.invalidate();
    }

    void setScrollingData(int n, float f) {
        if (n >= this.getChildCount() - 1) {
            return;
        }
        float f2 = (float)n + f;
        if (this.prevProgress > f2) {
            this.toPosition = n;
            this.fromPosition = n + 1;
            this.progress = 1.0f - f;
        } else {
            this.toPosition = n + 1;
            this.fromPosition = n;
            this.progress = f;
        }
        this.toTab = this.getChildAt(this.toPosition);
        this.fromTab = this.getChildAt(this.fromPosition);
        this.prevProgress = f2;
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.strip != null) {
            this.strip.draw(canvas);
        }
    }

    public void onFocusChange(View view, boolean bl) {
        if (view == this && bl && this.getChildCount() > 0) {
            this.selectedView.requestFocus();
            return;
        }
        if (!bl) {
            return;
        }
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            View view2 = this.getChildAt(i);
            if (view2 != view) continue;
            view2.requestFocus();
            if (!this.isShown()) break;
            this.sendAccessibilityEvent(8);
            break;
        }
    }

    void setOnTitleClickListener(TabMenuStrip.OnTitleClickListener onTitleClickListener) {
        this.onTitleClickListener = onTitleClickListener;
    }

    private class ViewClickListener
    implements View.OnClickListener {
        private final int mIndex;

        public ViewClickListener(int n) {
            this.mIndex = n;
        }

        public void onClick(View view) {
            if (TabMenuStripLayout.this.onTitleClickListener != null) {
                TabMenuStripLayout.this.onTitleClickListener.onTitleClicked(this.mIndex);
            }
        }
    }
}

