/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.mdns;

import android.support.annotation.UiThread;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.util.NativeEventListener;
import org.mozilla.gecko.util.ThreadUtils;

class MulticastDNSEventManager {
    private NativeEventListener mListener = null;
    private boolean mEventsRegistered = false;

    MulticastDNSEventManager(NativeEventListener nativeEventListener) {
        this.mListener = nativeEventListener;
    }

    @UiThread
    public void init() {
        ThreadUtils.assertOnUiThread();
        if (this.mEventsRegistered || this.mListener == null) {
            return;
        }
        this.registerEvents();
        this.mEventsRegistered = true;
    }

    @UiThread
    public void tearDown() {
        ThreadUtils.assertOnUiThread();
        if (!this.mEventsRegistered || this.mListener == null) {
            return;
        }
        this.unregisterEvents();
        this.mEventsRegistered = false;
    }

    private void registerEvents() {
        EventDispatcher.getInstance().registerGeckoThreadListener(this.mListener, "NsdManager:DiscoverServices", "NsdManager:StopServiceDiscovery", "NsdManager:RegisterService", "NsdManager:UnregisterService", "NsdManager:ResolveService");
    }

    private void unregisterEvents() {
        EventDispatcher.getInstance().unregisterGeckoThreadListener(this.mListener, "NsdManager:DiscoverServices", "NsdManager:StopServiceDiscovery", "NsdManager:RegisterService", "NsdManager:UnregisterService", "NsdManager:ResolveService");
    }
}

